/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.etl;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class RecordFile {
    static byte[] signature = "VOLA".getBytes();
    private final MappedByteBuffer buffer;
    byte[] signBytes = new byte[signature.length];
    RandomAccessFile raf;
    long size;

    public RecordFile(String fileName) throws IOException {
        this.raf = new RandomAccessFile(fileName, "rw");
        this.buffer = this.raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, Integer.MAX_VALUE);
    }

    public long writeRecord(byte[] bytes) throws IOException {
        long start = this.size;
        this.raf.seek(this.size);
        this.raf.writeInt(bytes.length);
        this.raf.write(bytes);
        this.size += (long)(bytes.length + 4);
        return start;
    }

    public byte[] readRecord(long index) throws IOException {
        this.raf.seek(index);
        int size = this.raf.readInt();
        byte[] bytes = new byte[size];
        this.raf.read(bytes);
        return bytes;
    }

    public void close() throws IOException {
        this.raf.close();
    }
}

