/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.etl;

import com.tplus.transform.runtime.etl.AbstractDataObjectCache;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class RecordMemMapFile
extends AbstractDataObjectCache {
    private static final long CACHE_SIZE = 8192L;
    RandomAccessFile memoryMappedFile;
    private ByteBuffer writerBuffer;
    private ByteBuffer readerBuffer;
    long size;
    private long readStart;
    private long readSize;
    private String fileName;

    public RecordMemMapFile(String fileName) throws IOException {
        this.fileName = fileName;
        this.memoryMappedFile = new RandomAccessFile(fileName, "rw");
        this.allocateWriteBuffer(0L);
        this.allocateReadBuffer(0L);
    }

    public String getFileName() {
        return this.fileName;
    }

    public long writeRecord(byte[] bytes) throws IOException {
        if (this.writerBuffer.remaining() < bytes.length + 4) {
            this.allocateWriteBuffer(this.size);
        }
        long start = this.size;
        this.writerBuffer.putInt(bytes.length);
        this.writerBuffer.put(bytes);
        this.size += (long)(bytes.length + 4);
        return start;
    }

    public byte[] readRecord(long index) throws IOException {
        if (this.readStart >= index || index + 4L >= this.readStart + this.readSize) {
            this.allocateReadBuffer(index);
        }
        this.readerBuffer.position((int)(index - this.readStart));
        int size = this.readerBuffer.getInt();
        if (this.readStart >= index + 4L || index + 4L + (long)size >= this.readStart + this.readSize) {
            this.allocateReadBuffer(index + 4L);
        }
        this.readerBuffer.position((int)(index + 4L - this.readStart));
        byte[] bytes = new byte[size];
        this.readerBuffer.get(bytes);
        return bytes;
    }

    public void close() throws IOException {
        this.memoryMappedFile.close();
    }

    private void allocateWriteBuffer(long pos) throws RuntimeException {
        try {
            FileChannel channel = this.memoryMappedFile.getChannel();
            this.writerBuffer = channel.map(FileChannel.MapMode.READ_WRITE, pos, 8192L);
            this.writerBuffer.order(ByteOrder.nativeOrder());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void allocateReadBuffer(long pos) throws RuntimeException {
        try {
            FileChannel channel = this.memoryMappedFile.getChannel();
            this.readerBuffer = channel.map(FileChannel.MapMode.READ_ONLY, pos, 8192L);
            this.readStart = pos;
            this.readSize = 8192L;
            this.readerBuffer.order(ByteOrder.nativeOrder());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long writeData(byte[] data) throws IOException {
        return this.writeRecord(data);
    }

    public byte[] readData(long position) throws IOException {
        return this.readRecord(position);
    }

    public String getReference() {
        return this.fileName;
    }
}

