/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.etl;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectBase;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.FieldTypeMismatchException;

public class SimpleJoinDataObject
extends DataObjectBase {
    private static final long serialVersionUID = 1L;
    private final DataObject[] objects;
    private final int[] fieldCounts;
    private DataObjectMetaInfo metaInfo;

    public SimpleJoinDataObject(DataObject[] objects, int[] fieldCounts, DataObjectMetaInfo metaInfo) {
        this.objects = objects;
        this.fieldCounts = fieldCounts;
        this.metaInfo = metaInfo;
    }

    public DataObjectMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public DataObjectSection getParentSection() {
        return null;
    }

    public void setParentSection(DataObjectSection sec) {
    }

    public DataObject getRootDataObject() {
        return null;
    }

    public String getQualifiedName(int index) throws FieldNotFoundException {
        return this.getFieldName(index);
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.objects.length; ++i) {
            DataObject object = this.objects[i];
            if (object == null || object.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isNull(int index) throws FieldNotFoundException {
        for (int i = 0; i < this.fieldCounts.length; ++i) {
            int fieldCount = this.fieldCounts[i];
            if (index < fieldCount) {
                DataObject object = this.objects[i];
                if (object != null) {
                    return object.isNull(index);
                }
                return true;
            }
            index -= fieldCount;
        }
        return true;
    }

    public void setNull(int index) throws FieldNotFoundException {
    }

    public boolean isNull(String fieldName) throws FieldNotFoundException {
        return this.isNull(this.getFieldIndex(fieldName));
    }

    public Object getField(int index) throws FieldNotFoundException {
        for (int i = 0; i < this.fieldCounts.length; ++i) {
            int fieldCount = this.fieldCounts[i];
            if (index < fieldCount) {
                DataObject object = this.objects[i];
                if (object != null) {
                    return object.getField(index);
                }
                return null;
            }
            index -= fieldCount;
        }
        return null;
    }

    public void setField(int index, Object value) throws FieldNotFoundException, FieldTypeMismatchException {
        for (int i = 0; i < this.fieldCounts.length; ++i) {
            int fieldCount = this.fieldCounts[i];
            if (index < fieldCount) {
                DataObject object = this.objects[i];
                if (object == null) break;
                object.setField(index, value);
                break;
            }
            index -= fieldCount;
        }
    }
}

