/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.etl;

import java.util.Comparator;

public class Sorter {
    private Comparator comparator;

    public void quicksort(Object[] objects, int[] index, Comparator comparator) {
        this.comparator = comparator;
        this.quicksort(objects, index, 0, index.length - 1);
    }

    void quicksort(Object[] objects, int[] index, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = this.partition(objects, index, left, right);
        this.quicksort(objects, index, left, i - 1);
        this.quicksort(objects, index, i + 1, right);
    }

    private int partition(Object[] objects, int[] index, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (this.less(objects[++i], objects[right])) {
                continue;
            }
            while (this.less(objects[right], objects[--j]) && j != left) {
            }
            if (i >= j) break;
            this.exch(objects, index, i, j);
        }
        this.exch(objects, index, i, right);
        return i;
    }

    private boolean less(Object x, Object y) {
        return this.comparator.compare(x, y) < 0;
    }

    private void exch(Object[] a, int[] index, int i, int j) {
        Object swap = a[i];
        a[i] = a[j];
        a[j] = swap;
        int b = index[i];
        index[i] = index[j];
        index[j] = b;
    }
}

