/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.etl;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.etl.JoinCondition;
import com.tplus.transform.runtime.etl.JoinOut;
import com.tplus.transform.runtime.etl.JoinSource;
import com.tplus.transform.runtime.etl.Joiner;
import java.util.Comparator;

public class TwoWayJoiner
extends Joiner {
    int[] input1Index;
    int[] input2Index;

    TwoWayJoiner(JoinCondition joinCondition) {
        super(joinCondition);
    }

    void sortMergeJoin(JoinOut joiner) throws TransformException {
        JoinCondition.JoinType joinType = this.joinCondition.getJoinType();
        JoinSource input1Source = this.joinCondition.getJoinSource1();
        JoinSource input2Source = this.joinCondition.getJoinSource2();
        DataObjectSection firstInput = input1Source.getInput();
        this.input1Index = TwoWayJoiner.createArray(firstInput.size());
        DataObjectSection input1Sorted = TwoWayJoiner.createIndex(firstInput, this.input1Index, this.joinCondition.getInput1Fields());
        boolean[] firstMatched = new boolean[firstInput.size()];
        DataObjectSection secondInput = input2Source.getInput();
        this.input2Index = TwoWayJoiner.createArray(secondInput.size());
        DataObjectSection input2Sorted = TwoWayJoiner.createIndex(secondInput, this.input2Index, this.joinCondition.getInput2Fields());
        boolean[] secondMatched = new boolean[secondInput.size()];
        Joiner.Itr input1Iterator = new Joiner.Itr(input1Sorted);
        Joiner.Itr input2Iterator = new Joiner.Itr(input2Sorted);
        DataObject first = TwoWayJoiner.next(input1Iterator);
        DataObject second = TwoWayJoiner.next(input2Iterator);
        while (true) {
            if (first == null || second == null) {
                if (first == null) {
                    while (second != null) {
                        if (joinType == JoinCondition.JoinType.RightOuter || joinType == JoinCondition.JoinType.FullOuter) {
                            this.join(null, -1, second, input2Iterator.index(), joiner, this.objectsFieldComparator);
                        } else {
                            this.addReject(input2Source, second);
                        }
                        second = TwoWayJoiner.next(input2Iterator);
                    }
                } else {
                    if (second != null) break;
                    while (first != null) {
                        if (joinType == JoinCondition.JoinType.LeftOuter || joinType == JoinCondition.JoinType.FullOuter) {
                            this.join(first, input1Iterator.index(), null, -1, joiner, this.objectsFieldComparator);
                        } else {
                            this.addReject(input1Source, first);
                        }
                        first = TwoWayJoiner.next(input1Iterator);
                    }
                }
                break;
            }
            int cmpResult = this.objectsFieldComparator.compare(first, second);
            if (cmpResult > 0) {
                if (!secondMatched[input2Iterator.index()]) {
                    if (joinType == JoinCondition.JoinType.RightOuter || joinType == JoinCondition.JoinType.FullOuter) {
                        this.join(null, -1, second, input2Iterator.index(), joiner, this.objectsFieldComparator);
                    } else {
                        this.addReject(input2Source, second);
                    }
                }
                second = TwoWayJoiner.next(input2Iterator);
                continue;
            }
            if (cmpResult < 0) {
                if (!firstMatched[input1Iterator.index()]) {
                    if (joinType == JoinCondition.JoinType.LeftOuter || joinType == JoinCondition.JoinType.FullOuter) {
                        this.join(first, input1Iterator.index(), null, -1, joiner, this.objectsFieldComparator);
                    } else {
                        this.addReject(input1Source, first);
                    }
                }
                first = TwoWayJoiner.next(input1Iterator);
                continue;
            }
            this.join(first, input1Iterator.index(), second, input2Iterator.index(), joiner, this.objectsFieldComparator);
            TwoWayJoiner.markAsMatched(firstMatched, input1Iterator);
            TwoWayJoiner.markAsMatched(secondMatched, input2Iterator);
            Joiner.Itr input2IteratorCloned = (Joiner.Itr)input2Iterator.clone();
            DataObject secondPrime = TwoWayJoiner.next(input2IteratorCloned);
            while (secondPrime != null && this.objectsFieldComparator.compare(first, secondPrime) == 0) {
                this.join(first, input1Iterator.index(), secondPrime, input2IteratorCloned.index(), joiner, this.objectsFieldComparator);
                TwoWayJoiner.markAsMatched(secondMatched, input2IteratorCloned);
                secondPrime = TwoWayJoiner.next(input2IteratorCloned);
            }
            Joiner.Itr input1IteratorCloned = (Joiner.Itr)input1Iterator.clone();
            DataObject firstPrime = TwoWayJoiner.next(input1IteratorCloned);
            while (firstPrime != null && this.objectsFieldComparator.compare(firstPrime, second) == 0) {
                this.join(firstPrime, input1IteratorCloned.index(), second, input2Iterator.index(), joiner, this.objectsFieldComparator);
                TwoWayJoiner.markAsMatched(firstMatched, input1IteratorCloned);
                firstPrime = TwoWayJoiner.next(input1IteratorCloned);
            }
            first = TwoWayJoiner.next(input1Iterator);
            second = TwoWayJoiner.next(input2Iterator);
        }
    }

    private void addReject(JoinSource input2Source, DataObject second) {
    }

    void nestLoopJoin(JoinOut joiner) throws TransformException {
        int i;
        JoinSource input1Source = this.joinCondition.getJoinSource1();
        JoinSource input2Source = this.joinCondition.getJoinSource2();
        DataObjectSection firstSection = input1Source.getInput();
        DataObjectSection secondSection = input2Source.getInput();
        boolean[] firstMatched = new boolean[firstSection.size()];
        boolean[] secondMatched = new boolean[secondSection.size()];
        for (int i2 = 0; i2 < firstSection.size(); ++i2) {
            DataObject first = firstSection.getElement(i2);
            for (int j = 0; j < secondSection.size(); ++j) {
                DataObject second = secondSection.getElement(j);
                int compare = this.objectsFieldComparator.compare(first, second);
                if (compare != 0) continue;
                this.join(first, i2, second, j, joiner, this.objectsFieldComparator);
                firstMatched[i2] = true;
                secondMatched[j] = true;
            }
        }
        JoinCondition.JoinType joinType = this.joinCondition.getJoinType();
        for (i = 0; i < firstSection.size(); ++i) {
            if (firstMatched[i]) continue;
            DataObject first = (DataObject)firstSection.get(i);
            if (joinType == JoinCondition.JoinType.LeftOuter || joinType == JoinCondition.JoinType.FullOuter) {
                this.join(first, i, null, -1, joiner, this.objectsFieldComparator);
                continue;
            }
            this.addReject(input1Source, first);
        }
        for (i = 0; i < secondSection.size(); ++i) {
            if (secondMatched[i]) continue;
            DataObject second = (DataObject)secondSection.get(i);
            if (joinType == JoinCondition.JoinType.RightOuter || joinType == JoinCondition.JoinType.FullOuter) {
                this.join(null, -1, second, i, joiner, this.objectsFieldComparator);
                continue;
            }
            this.addReject(input2Source, second);
        }
    }

    private static void markAsMatched(boolean[] firstMatched, Joiner.Itr input1Iterator) {
        firstMatched[input1Iterator.index()] = true;
    }

    protected void join(DataObject first, int firstIndex, DataObject second, int secondIndex, JoinOut joiner, Comparator comparator) throws TransformException {
        int firstActualIndex = this.input1Index != null && firstIndex != -1 ? this.input1Index[firstIndex] : firstIndex;
        int secondActualIndex = this.input2Index != null && secondIndex != -1 ? this.input2Index[secondIndex] : secondIndex;
        joiner.joinOutput(first, firstActualIndex, second, secondActualIndex);
    }
}

