/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.FieldParsingException;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.formula.InitializationException;
import com.tplus.transform.runtime.formula.SectionHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class AggregateFunctions
extends SectionHelper {
    public static double secAvg(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        double sum = AggregateFunctions.secSumDouble(sec, fieldName);
        if (sum == 0.0) {
            return 0.0;
        }
        return sum / (double)AggregateFunctions.fieldCount(sec, fieldName);
    }

    public static double secAvg(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        double sum = AggregateFunctions.secSumDouble(sec, fieldName);
        if (sum == 0.0) {
            return 0.0;
        }
        return sum / (double)AggregateFunctions.fieldCount(sec, fieldName);
    }

    public static int secSum(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        return (int)AggregateFunctions.secSumDouble(sec, fieldName);
    }

    public static int secSum(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        return (int)AggregateFunctions.secSumDouble(sec, fieldName);
    }

    public static double secSumDouble(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        double sum = 0.0;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            sum = AggregateFunctions.simpleSecSumDouble(sec, fieldName);
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            for (int i = 0; i < sec.getElementCount(); ++i) {
                DataObject obj = sec.getElement(i);
                try {
                    DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                    if (dataObjectSection == null) continue;
                    sum += AggregateFunctions.secSumDouble(dataObjectSection, innerFieldName);
                    continue;
                }
                catch (Exception e) {
                    AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
                }
            }
        }
        return sum;
    }

    public static double secSumDouble(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        double sum = 0.0;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            sum = AggregateFunctions.simpleSecSumDouble(sec, fieldName);
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            try {
                DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
                if (dataObjectSection != null) {
                    sum += AggregateFunctions.secSumDouble(dataObjectSection, innerFieldName);
                }
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
            }
        }
        return sum;
    }

    private static double simpleSecSumDouble(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        double sum = 0.0;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                Number number = (Number)AggregateFunctions.toNumber(obj.getField(fieldIndex));
                if (number == null) continue;
                sum += number.doubleValue();
                continue;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
            }
        }
        return sum;
    }

    private static double simpleSecSumDouble(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        double sum = 0.0;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        try {
            Number number = (Number)AggregateFunctions.toNumber(sec.getField(fieldIndex));
            if (number != null) {
                sum += number.doubleValue();
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
        }
        return sum;
    }

    public static BigDecimal secSumBigDecimal(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        BigDecimal sum = Wrapper.ZERO_BIG_DECIMAL;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            sum = AggregateFunctions.simpleSecSumBigDecimal(sec, fieldName);
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            for (int i = 0; i < sec.getElementCount(); ++i) {
                DataObject obj = sec.getElement(i);
                try {
                    DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                    if (dataObjectSection == null) continue;
                    sum = sum.add(AggregateFunctions.secSumBigDecimal(dataObjectSection, innerFieldName));
                    continue;
                }
                catch (Exception e) {
                    AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
                }
            }
        }
        return sum;
    }

    public static BigDecimal secSumBigDecimal(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        BigDecimal sum = Wrapper.ZERO_BIG_DECIMAL;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            sum = AggregateFunctions.simpleSecSumBigDecimal(sec, fieldName);
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            try {
                DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
                if (dataObjectSection != null) {
                    sum = sum.add(AggregateFunctions.secSumBigDecimal(dataObjectSection, innerFieldName));
                }
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
            }
        }
        return sum;
    }

    private static BigDecimal simpleSecSumBigDecimal(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        BigDecimal sum = Wrapper.ZERO_BIG_DECIMAL;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                BigDecimal number = (BigDecimal)AggregateFunctions.toBigDecimal(obj.getField(fieldIndex));
                if (number == null) continue;
                sum = sum.add(number);
                continue;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
            }
        }
        return sum;
    }

    private static BigDecimal simpleSecSumBigDecimal(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        BigDecimal sum = Wrapper.ZERO_BIG_DECIMAL;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        try {
            BigDecimal number = (BigDecimal)AggregateFunctions.toBigDecimal(sec.getField(fieldIndex));
            if (number != null) {
                sum.add(number);
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
        }
        return sum;
    }

    public static int secMax(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        int max = AggregateFunctions.secMax0(sec, fieldName);
        if (max == Integer.MIN_VALUE) {
            max = 0;
        }
        return max;
    }

    public static int secMax(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        int max = AggregateFunctions.secMax0(sec, fieldName);
        if (max == Integer.MIN_VALUE) {
            max = 0;
        }
        return max;
    }

    private static int secMax0(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        int max = Integer.MIN_VALUE;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            max = AggregateFunctions.simpleSecMax0(sec, fieldName);
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            for (int i = 0; i < sec.getElementCount(); ++i) {
                DataObject obj = sec.getElement(i);
                try {
                    DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                    if (dataObjectSection == null) continue;
                    max = Math.max(max, AggregateFunctions.secMax0(dataObjectSection, innerFieldName));
                    continue;
                }
                catch (Exception e) {
                    AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
                }
            }
        }
        return max;
    }

    private static int secMax0(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        int max = Integer.MIN_VALUE;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            max = AggregateFunctions.simpleSecMax0(sec, fieldName);
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            try {
                DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
                if (dataObjectSection != null) {
                    max = Math.max(max, AggregateFunctions.secMax0(dataObjectSection, innerFieldName));
                }
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
            }
        }
        return max;
    }

    private static int simpleSecMax0(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        int max = Integer.MIN_VALUE;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                Number number = (Number)AggregateFunctions.toNumber(obj.getField(fieldIndex));
                if (number == null) continue;
                max = Math.max(max, number.intValue());
                continue;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
            }
        }
        return max;
    }

    private static Object toBigDecimal(Object field) throws FieldParsingException {
        if (field instanceof BigDecimal) {
            return field;
        }
        if (field instanceof Long) {
            return new BigDecimal((Long)field);
        }
        if (field instanceof Number) {
            return new BigDecimal(((Number)field).doubleValue());
        }
        if (field instanceof String) {
            return Parsing.toBigDecimal((String)field);
        }
        return field;
    }

    private static Object toNumber(Object field) throws FieldParsingException {
        if (field instanceof Number) {
            return field;
        }
        if (field instanceof String) {
            return Parsing.toBigDecimal((String)field);
        }
        return field;
    }

    private static int simpleSecMax0(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        int max = Integer.MIN_VALUE;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        try {
            Number number = (Number)AggregateFunctions.toNumber(sec.getField(fieldIndex));
            if (number != null) {
                max = Math.max(max, number.intValue());
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
        }
        return max;
    }

    public static double secMaxDouble(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        double max = 0.0;
        try {
            max = AggregateFunctions.secMaxDouble0(sec, fieldName);
        }
        catch (InitializationException e) {
            // empty catch block
        }
        return max;
    }

    public static double secMaxDouble(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        double max = 0.0;
        try {
            max = AggregateFunctions.secMaxDouble0(sec, fieldName);
        }
        catch (InitializationException e) {
            // empty catch block
        }
        return max;
    }

    private static double secMaxDouble0(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException, InitializationException {
        double max = 0.0;
        boolean initialized = false;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            try {
                max = AggregateFunctions.simpleSecMaxDouble0(sec, fieldName);
                initialized = true;
            }
            catch (InitializationException e) {}
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            for (int i = 0; i < sec.getElementCount(); ++i) {
                DataObject obj = sec.getElement(i);
                try {
                    DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                    if (dataObjectSection == null) continue;
                    if (!initialized) {
                        try {
                            max = AggregateFunctions.secMaxDouble0(dataObjectSection, innerFieldName);
                            initialized = true;
                        }
                        catch (InitializationException e) {}
                        continue;
                    }
                    try {
                        max = Math.max(max, AggregateFunctions.secMaxDouble0(dataObjectSection, innerFieldName));
                    }
                    catch (InitializationException e) {}
                    continue;
                }
                catch (Exception e) {
                    AggregateFunctions.handleFieldAccessException(obj, sectionName, e);
                }
            }
        }
        if (!initialized) {
            throw InitializationException.createFormatted("SRT586");
        }
        return max;
    }

    private static double secMaxDouble0(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException, InitializationException {
        double max = 0.0;
        boolean initialized = false;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            try {
                max = AggregateFunctions.simpleSecMaxDouble0(sec, fieldName);
                initialized = true;
            }
            catch (InitializationException e) {}
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            try {
                DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
                if (dataObjectSection != null) {
                    if (!initialized) {
                        try {
                            max = AggregateFunctions.secMaxDouble0(dataObjectSection, innerFieldName);
                            initialized = true;
                        }
                        catch (InitializationException e) {}
                    } else {
                        try {
                            max = Math.max(max, AggregateFunctions.secMaxDouble0(dataObjectSection, innerFieldName));
                        }
                        catch (InitializationException e) {}
                    }
                }
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(sec, sectionName, e);
            }
        }
        if (!initialized) {
            throw InitializationException.createFormatted("SRT586");
        }
        return max;
    }

    private static double simpleSecMaxDouble0(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException, InitializationException {
        double max = 0.0;
        boolean initialized = false;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                Number number = (Number)obj.getField(fieldIndex);
                if (number == null) continue;
                if (!initialized) {
                    max = number.doubleValue();
                    initialized = true;
                    continue;
                }
                max = Math.max(max, number.doubleValue());
                continue;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
            }
        }
        if (!initialized) {
            throw InitializationException.createFormatted("SRT586");
        }
        return max;
    }

    private static double simpleSecMaxDouble0(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException, InitializationException {
        double max = 0.0;
        boolean initialized = false;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        try {
            Number number = (Number)sec.getField(fieldIndex);
            if (number != null) {
                if (!initialized) {
                    max = number.doubleValue();
                    initialized = true;
                } else {
                    max = Math.max(max, number.doubleValue());
                }
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
        }
        if (!initialized) {
            throw InitializationException.createFormatted("SRT586");
        }
        return max;
    }

    public static int secMin(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        int min = AggregateFunctions.secMin0(sec, fieldName);
        if (min == Integer.MAX_VALUE) {
            min = 0;
        }
        return min;
    }

    public static int secMin(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        int min = AggregateFunctions.secMin0(sec, fieldName);
        if (min == Integer.MAX_VALUE) {
            min = 0;
        }
        return min;
    }

    private static int secMin0(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        int min = Integer.MAX_VALUE;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            min = AggregateFunctions.simpleSecMin0(sec, fieldName);
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            for (int i = 0; i < sec.getElementCount(); ++i) {
                DataObject obj = sec.getElement(i);
                try {
                    DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                    if (dataObjectSection == null) continue;
                    min = Math.min(min, AggregateFunctions.secMin0(dataObjectSection, innerFieldName));
                    continue;
                }
                catch (Exception e) {
                    AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
                }
            }
        }
        return min;
    }

    private static int secMin0(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        int min = Integer.MAX_VALUE;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            min = AggregateFunctions.simpleSecMin0(sec, fieldName);
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            try {
                DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
                if (dataObjectSection != null) {
                    min = Math.min(min, AggregateFunctions.secMin0(dataObjectSection, innerFieldName));
                }
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
            }
        }
        return min;
    }

    private static int simpleSecMin0(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        int min = Integer.MAX_VALUE;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                Number number = (Number)obj.getField(fieldIndex);
                if (number == null) continue;
                min = Math.min(min, number.intValue());
                continue;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
            }
        }
        return min;
    }

    private static int simpleSecMin0(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        int min = Integer.MAX_VALUE;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        try {
            Number number = (Number)sec.getField(fieldIndex);
            if (number != null) {
                min = Math.min(min, number.intValue());
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
        }
        return min;
    }

    public static double secMinDouble(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        double min = 0.0;
        try {
            min = AggregateFunctions.secMinDouble0(sec, fieldName);
        }
        catch (InitializationException e) {
            // empty catch block
        }
        return min;
    }

    public static double secMinDouble(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException {
        double min = 0.0;
        try {
            min = AggregateFunctions.secMinDouble0(sec, fieldName);
        }
        catch (InitializationException e) {
            // empty catch block
        }
        return min;
    }

    private static double secMinDouble0(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException, InitializationException {
        double min = 0.0;
        boolean intialized = false;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            try {
                min = AggregateFunctions.simpleSecMinDouble0(sec, fieldName);
                intialized = true;
            }
            catch (InitializationException e) {}
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            for (int i = 0; i < sec.getElementCount(); ++i) {
                DataObject obj = sec.getElement(i);
                try {
                    DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                    if (dataObjectSection == null) continue;
                    if (!intialized) {
                        try {
                            min = AggregateFunctions.secMinDouble0(dataObjectSection, innerFieldName);
                            intialized = true;
                        }
                        catch (InitializationException e) {}
                        continue;
                    }
                    try {
                        min = Math.min(min, AggregateFunctions.secMinDouble0(dataObjectSection, innerFieldName));
                    }
                    catch (InitializationException e) {}
                    continue;
                }
                catch (Exception e) {
                    AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
                }
            }
        }
        if (!intialized) {
            throw InitializationException.createFormatted("SRT587");
        }
        return min;
    }

    private static double secMinDouble0(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException, InitializationException {
        double min = 0.0;
        boolean intialized = false;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            try {
                min = AggregateFunctions.simpleSecMinDouble0(sec, fieldName);
                intialized = true;
            }
            catch (InitializationException e) {}
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            try {
                DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
                if (dataObjectSection != null) {
                    if (!intialized) {
                        try {
                            min = AggregateFunctions.secMinDouble0(dataObjectSection, innerFieldName);
                            intialized = true;
                        }
                        catch (InitializationException e) {}
                    } else {
                        try {
                            min = Math.min(min, AggregateFunctions.secMinDouble0(dataObjectSection, innerFieldName));
                        }
                        catch (InitializationException e) {}
                    }
                }
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
            }
        }
        if (!intialized) {
            throw InitializationException.createFormatted("SRT587");
        }
        return min;
    }

    private static double simpleSecMinDouble0(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException, InitializationException {
        double min = 0.0;
        boolean intialized = false;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                Number number = (Number)obj.getField(fieldIndex);
                if (number == null) continue;
                if (!intialized) {
                    min = number.doubleValue();
                    intialized = true;
                    continue;
                }
                min = Math.min(min, number.doubleValue());
                continue;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
            }
        }
        if (!intialized) {
            throw InitializationException.createFormatted("SRT587");
        }
        return min;
    }

    private static double simpleSecMinDouble0(DataObject sec, String fieldName) throws TransformRuntimeException, TransformException, InitializationException {
        double min = 0.0;
        boolean intialized = false;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        try {
            Number number = (Number)sec.getField(fieldIndex);
            if (number != null) {
                if (!intialized) {
                    min = number.doubleValue();
                    intialized = true;
                } else {
                    min = Math.min(min, number.doubleValue());
                }
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
        }
        if (!intialized) {
            throw InitializationException.createFormatted("SRT587");
        }
        return min;
    }

    public static DataObject secElm(DataObjectSection sec, int index) throws TransformException {
        return sec.getElement(index);
    }

    public static int secCount(DataObjectSection sec) {
        return sec.getElementCount();
    }

    public static int secCount(DataObject sec, String secName) throws TransformException {
        int count = 0;
        int dotIndex = secName.indexOf(46);
        if (dotIndex == -1) {
            count = AggregateFunctions.simpleSecCount(sec, secName);
        } else {
            String sectionName = secName.substring(0, dotIndex);
            String innerSectionName = secName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            if (sectionIndex != -1) {
                try {
                    DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
                    if (dataObjectSection != null) {
                        count += AggregateFunctions.secCount(dataObjectSection, innerSectionName);
                    }
                }
                catch (Exception e) {
                    AggregateFunctions.handleFieldAccessException(sec, sectionName, e);
                }
            }
        }
        return count;
    }

    public static int secCount(DataObjectSection sec, String secName) throws TransformException {
        int count = 0;
        int dotIndex = secName.indexOf(46);
        if (dotIndex == -1) {
            count = AggregateFunctions.simpleSecCount(sec, secName);
        } else {
            String sectionName = secName.substring(0, dotIndex);
            String innerSectionName = secName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            if (sectionIndex != -1) {
                int elementCount = sec.getElementCount();
                for (int i = 0; i < elementCount; ++i) {
                    DataObject obj = sec.getElement(i);
                    try {
                        DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                        if (dataObjectSection == null) continue;
                        count += AggregateFunctions.secCount(dataObjectSection, innerSectionName);
                        continue;
                    }
                    catch (Exception e) {
                        AggregateFunctions.handleFieldAccessException(obj, sectionName, e);
                    }
                }
            }
        }
        return count;
    }

    private static int simpleSecCount(DataObject sec, String secName) throws TransformException {
        if (sec == null) {
            return 0;
        }
        int secIndex = AggregateFunctions.getFieldIndex(sec, secName);
        if (secIndex == -1) {
            return 0;
        }
        int count = 0;
        try {
            DataObjectSection dataObjectSection = sec.getSection(secIndex);
            if (dataObjectSection != null) {
                count += AggregateFunctions.secCount(dataObjectSection);
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, secName, e);
        }
        return count;
    }

    private static int simpleSecCount(DataObjectSection sec, String secName) throws TransformException {
        if (sec == null) {
            return 0;
        }
        int secIndex = AggregateFunctions.getFieldIndex(sec, secName);
        if (secIndex == -1) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                DataObjectSection dataObjectSection = obj.getSection(secIndex);
                if (dataObjectSection == null) continue;
                count += AggregateFunctions.secCount(dataObjectSection);
                continue;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, secName, e);
            }
        }
        return count;
    }

    public static boolean secExistsInOne(DataObjectSection sec, String sectionName) throws TransformException {
        return AggregateFunctions.secCount(sec, sectionName) == 1;
    }

    public static boolean secExistsInOne(DataObject sec, String sectionName) throws TransformException {
        return AggregateFunctions.secCount(sec, sectionName) == 1;
    }

    public static boolean secExistsInAtMostOne(DataObjectSection sec, String sectionName) throws TransformException {
        return AggregateFunctions.secCount(sec, sectionName) <= 1;
    }

    public static boolean secExistsInAtMostOne(DataObject sec, String sectionName) throws TransformException {
        return AggregateFunctions.secCount(sec, sectionName) <= 1;
    }

    public static boolean secExistsInAtLeastOne(DataObjectSection sec, String sectionName) throws TransformException {
        return AggregateFunctions.secCount(sec, sectionName) >= 1;
    }

    public static boolean secExistsInAtLeastOne(DataObject sec, String sectionName) throws TransformException {
        return AggregateFunctions.secCount(sec, sectionName) >= 1;
    }

    public static boolean secExistsInAll(DataObjectSection sec, String secName) throws TransformException {
        return AggregateFunctions.checkSecExistenceInAll(sec, secName);
    }

    public static boolean secExistsInAll(DataObject sec, String secName) throws TransformException {
        return AggregateFunctions.checkSecExistenceInAll(sec, secName);
    }

    public static boolean secExistsInAll(DataObjectSection sec, String secName, String inSecName) throws TransformException {
        if (!inSecName.trim().equals("")) {
            int dotIndex = inSecName.indexOf(".");
            String firstOfInSecName = "";
            String restOfInSecName = "";
            if (dotIndex == -1) {
                firstOfInSecName = inSecName;
            } else {
                firstOfInSecName = inSecName.substring(0, dotIndex);
                restOfInSecName = inSecName.substring(dotIndex + 1);
            }
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstOfInSecName);
            for (int i = 0; i < sec.getElementCount(); ++i) {
                DataObject obj = sec.getElement(i);
                try {
                    boolean result;
                    DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                    if (dataObjectSection == null || (result = AggregateFunctions.secExistsInAll(dataObjectSection, secName.substring(secName.indexOf(".") + 1), restOfInSecName))) continue;
                    return false;
                }
                catch (Exception e) {
                    AggregateFunctions.handleFieldAccessException(obj, firstOfInSecName, e);
                }
            }
            return true;
        }
        return AggregateFunctions.checkSecExistenceInAll(sec, secName);
    }

    public static boolean secExistsInAll(DataObject sec, String secName, String inSecName) throws TransformException {
        if (!inSecName.trim().equals("")) {
            int dotIndex = inSecName.indexOf(".");
            String firstOfInSecName = "";
            String restOfInSecName = "";
            if (dotIndex == -1) {
                firstOfInSecName = inSecName;
            } else {
                firstOfInSecName = inSecName.substring(0, dotIndex);
                restOfInSecName = inSecName.substring(dotIndex + 1);
            }
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstOfInSecName);
            try {
                boolean result;
                DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
                if (dataObjectSection != null && !(result = AggregateFunctions.secExistsInAll(dataObjectSection, secName.substring(secName.indexOf(".") + 1), restOfInSecName))) {
                    return false;
                }
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(sec, firstOfInSecName, e);
            }
            return true;
        }
        return AggregateFunctions.checkSecExistenceInAll(sec, secName);
    }

    private static boolean checkSecExistenceInAll(DataObjectSection sec, String secName) throws TransformException {
        int dotIndex = secName.indexOf(".");
        if (dotIndex == -1) {
            return AggregateFunctions.simpleCheckSecExistenceInAll(sec, secName);
        }
        String firstSecName = secName.substring(0, dotIndex);
        String restSecName = secName.substring(dotIndex + 1);
        int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                if (dataObjectSection != null && dataObjectSection.getElementCount() > 0) {
                    boolean result = AggregateFunctions.checkSecExistenceInAll(dataObjectSection, restSecName);
                    if (result) continue;
                    return false;
                }
                return false;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, firstSecName, e);
            }
        }
        return true;
    }

    private static boolean checkSecExistenceInAll(DataObject sec, String secName) throws TransformException {
        block5: {
            int dotIndex = secName.indexOf(".");
            if (dotIndex == -1) {
                return AggregateFunctions.simpleCheckSecExistenceInAll(sec, secName);
            }
            String firstSecName = secName.substring(0, dotIndex);
            String restSecName = secName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
            try {
                DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
                if (dataObjectSection != null && dataObjectSection.getElementCount() > 0) {
                    boolean result = AggregateFunctions.checkSecExistenceInAll(dataObjectSection, restSecName);
                    if (!result) {
                        return false;
                    }
                    break block5;
                }
                return false;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(sec, firstSecName, e);
            }
        }
        return true;
    }

    private static boolean checkSecExistence(DataObjectSection sec, String secName) throws TransformException {
        int dotIndex = secName.indexOf(".");
        if (dotIndex == -1) {
            return AggregateFunctions.simpleCheckSecExistence(sec, secName);
        }
        String firstSecName = secName.substring(0, dotIndex);
        String restSecName = secName.substring(dotIndex + 1);
        int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                boolean result;
                DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                if (dataObjectSection == null || dataObjectSection.getElementCount() <= 0 || !(result = AggregateFunctions.checkSecExistence(dataObjectSection, restSecName))) continue;
                return true;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, firstSecName, e);
            }
        }
        return false;
    }

    private static boolean checkSecExistence(DataObject sec, String secName) throws TransformException {
        int dotIndex = secName.indexOf(".");
        if (dotIndex == -1) {
            return AggregateFunctions.simpleCheckSecExistence(sec, secName);
        }
        String firstSecName = secName.substring(0, dotIndex);
        String restSecName = secName.substring(dotIndex + 1);
        int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
        try {
            boolean result;
            DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
            if (dataObjectSection != null && dataObjectSection.getElementCount() > 0 && (result = AggregateFunctions.checkSecExistence(dataObjectSection, restSecName))) {
                return true;
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, firstSecName, e);
        }
        return false;
    }

    private static boolean simpleCheckSecExistenceInAll(DataObjectSection sec, String secName) throws TransformException {
        int secIndex = AggregateFunctions.getFieldIndex(sec, secName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                DataObjectSection dataObjectSection = obj.getSection(secIndex);
                if (dataObjectSection != null && dataObjectSection.getElementCount() != 0) continue;
                return false;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, secName, e);
            }
        }
        return true;
    }

    private static boolean simpleCheckSecExistenceInAll(DataObject sec, String secName) throws TransformException {
        int secIndex = AggregateFunctions.getFieldIndex(sec, secName);
        try {
            DataObjectSection dataObjectSection = sec.getSection(secIndex);
            if (dataObjectSection == null || dataObjectSection.getElementCount() == 0) {
                return false;
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, secName, e);
        }
        return true;
    }

    private static boolean simpleCheckSecExistence(DataObjectSection sec, String secName) throws TransformException {
        int secIndex = AggregateFunctions.getFieldIndex(sec, secName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                DataObjectSection dataObjectSection = obj.getSection(secIndex);
                if (dataObjectSection == null || dataObjectSection.getElementCount() <= 0) continue;
                return true;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, secName, e);
            }
        }
        return false;
    }

    private static boolean simpleCheckSecExistence(DataObject sec, String secName) throws TransformException {
        int secIndex = AggregateFunctions.getFieldIndex(sec, secName);
        try {
            DataObjectSection dataObjectSection = sec.getSection(secIndex);
            if (dataObjectSection != null && dataObjectSection.getElementCount() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, secName, e);
        }
        return false;
    }

    public static int fieldCount(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        int count = 0;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            count = AggregateFunctions.simpleFieldCount(sec, fieldName);
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            for (int i = 0; i < sec.getElementCount(); ++i) {
                DataObject obj = sec.getElement(i);
                try {
                    DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                    if (dataObjectSection == null) continue;
                    count += AggregateFunctions.fieldCount(dataObjectSection, innerFieldName);
                    continue;
                }
                catch (Exception e) {
                    AggregateFunctions.handleFieldAccessException(obj, sectionName, e);
                }
            }
        }
        return count;
    }

    public static int fieldCount(DataObject obj, String fieldName) throws TransformRuntimeException, TransformException {
        int count = 0;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            count = AggregateFunctions.simpleFieldCount(obj, fieldName);
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(obj, sectionName);
            try {
                DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                if (dataObjectSection != null) {
                    count += AggregateFunctions.fieldCount(dataObjectSection, innerFieldName);
                }
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, sectionName, e);
            }
        }
        return count;
    }

    private static int simpleFieldCount(DataObjectSection sec, String fieldName) throws TransformRuntimeException, TransformException {
        int count = 0;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                Object fldVal = obj.getField(fieldIndex);
                if (fldVal == null) continue;
                ++count;
                continue;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
            }
        }
        return count;
    }

    private static int simpleFieldCount(DataObject obj, String fieldName) throws TransformRuntimeException, TransformException {
        int count = 0;
        int fieldIndex = AggregateFunctions.getFieldIndex(obj, fieldName);
        try {
            Object fldVal = obj.getField(fieldIndex);
            if (fldVal != null) {
                ++count;
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
        }
        return count;
    }

    public static boolean fieldExistsInOne(DataObjectSection sec, String fieldName) throws TransformException {
        return AggregateFunctions.fieldCount(sec, fieldName) == 1;
    }

    public static boolean fieldExistsInOne(DataObject sec, String fieldName) throws TransformException {
        return AggregateFunctions.fieldCount(sec, fieldName) == 1;
    }

    public static boolean fieldExistsInAtMostOne(DataObjectSection sec, String fieldName) throws TransformException {
        return AggregateFunctions.fieldCount(sec, fieldName) <= 1;
    }

    public static boolean fieldExistsInAtMostOne(DataObject sec, String fieldName) throws TransformException {
        return AggregateFunctions.fieldCount(sec, fieldName) <= 1;
    }

    public static boolean fieldExistsInAtLeastOne(DataObjectSection sec, String fieldName) throws TransformException {
        return AggregateFunctions.fieldCount(sec, fieldName) >= 1;
    }

    public static boolean fieldExistsInAtLeastOne(DataObject sec, String fieldName) throws TransformException {
        return AggregateFunctions.fieldCount(sec, fieldName) >= 1;
    }

    public static boolean fieldExistsInAll(DataObjectSection sec, String fieldName) throws TransformException {
        return AggregateFunctions.checkFieldExistenceInAll(sec, fieldName);
    }

    public static boolean fieldExistsInAll(DataObject sec, String fieldName) throws TransformException {
        return AggregateFunctions.checkFieldExistenceInAll(sec, fieldName);
    }

    public static boolean fieldExistsInAll(DataObjectSection sec, String fieldName, String inSecName) throws TransformException {
        if (!inSecName.trim().equals("")) {
            int dotIndex = inSecName.indexOf(".");
            String firstOfInSecName = "";
            String restOfInSecName = "";
            if (dotIndex == -1) {
                firstOfInSecName = inSecName;
            } else {
                firstOfInSecName = inSecName.substring(0, dotIndex);
                restOfInSecName = inSecName.substring(dotIndex + 1);
            }
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstOfInSecName);
            for (int i = 0; i < sec.getElementCount(); ++i) {
                DataObject obj = sec.getElement(i);
                try {
                    boolean result;
                    DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                    if (dataObjectSection == null || (result = AggregateFunctions.fieldExistsInAll(dataObjectSection, fieldName.substring(fieldName.indexOf(".") + 1), restOfInSecName))) continue;
                    return false;
                }
                catch (Exception e) {
                    AggregateFunctions.handleFieldAccessException(obj, firstOfInSecName, e);
                }
            }
            return true;
        }
        return AggregateFunctions.checkFieldExistenceInAll(sec, fieldName);
    }

    public static boolean fieldExistsInAll(DataObject sec, String fieldName, String inSecName) throws TransformException {
        if (!inSecName.trim().equals("")) {
            int dotIndex = inSecName.indexOf(".");
            String firstOfInSecName = "";
            String restOfInSecName = "";
            if (dotIndex == -1) {
                firstOfInSecName = inSecName;
            } else {
                firstOfInSecName = inSecName.substring(0, dotIndex);
                restOfInSecName = inSecName.substring(dotIndex + 1);
            }
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstOfInSecName);
            try {
                boolean result;
                DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
                if (dataObjectSection != null && !(result = AggregateFunctions.fieldExistsInAll(dataObjectSection, fieldName.substring(fieldName.indexOf(".") + 1), restOfInSecName))) {
                    return false;
                }
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(sec, firstOfInSecName, e);
            }
            return true;
        }
        return AggregateFunctions.checkFieldExistenceInAll(sec, fieldName);
    }

    private static boolean checkFieldExistenceInAll(DataObjectSection sec, String fieldName) throws TransformException {
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            return AggregateFunctions.simpleCheckFieldExistenceInAll(sec, fieldName);
        }
        String firstSecName = fieldName.substring(0, dotIndex);
        String restFieldName = fieldName.substring(dotIndex + 1);
        int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                if (dataObjectSection != null && dataObjectSection.getElementCount() > 0) {
                    boolean result = AggregateFunctions.checkFieldExistenceInAll(dataObjectSection, restFieldName);
                    if (result) continue;
                    return false;
                }
                return false;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, firstSecName, e);
            }
        }
        return true;
    }

    private static boolean checkFieldExistenceInAll(DataObject sec, String fieldName) throws TransformException {
        block5: {
            int dotIndex = fieldName.indexOf(".");
            if (dotIndex == -1) {
                return AggregateFunctions.simpleCheckFieldExistenceInAll(sec, fieldName);
            }
            String firstSecName = fieldName.substring(0, dotIndex);
            String restFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
            try {
                DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
                if (dataObjectSection != null && dataObjectSection.getElementCount() > 0) {
                    boolean result = AggregateFunctions.checkFieldExistenceInAll(dataObjectSection, restFieldName);
                    if (!result) {
                        return false;
                    }
                    break block5;
                }
                return false;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(sec, firstSecName, e);
            }
        }
        return true;
    }

    private static boolean checkFieldExistence(DataObjectSection sec, String fieldName) throws TransformException {
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            return AggregateFunctions.simpleCheckFieldExistence(sec, fieldName);
        }
        String firstSecName = fieldName.substring(0, dotIndex);
        String restFieldName = fieldName.substring(dotIndex + 1);
        int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                boolean result;
                DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                if (dataObjectSection == null || dataObjectSection.getElementCount() <= 0 || !(result = AggregateFunctions.checkFieldExistence(dataObjectSection, restFieldName))) continue;
                return true;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, firstSecName, e);
            }
        }
        return false;
    }

    private static boolean checkFieldExistence(DataObject sec, String fieldName) throws TransformException {
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            return AggregateFunctions.simpleCheckFieldExistence(sec, fieldName);
        }
        String firstSecName = fieldName.substring(0, dotIndex);
        String restFieldName = fieldName.substring(dotIndex + 1);
        int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
        try {
            boolean result;
            DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
            if (dataObjectSection != null && dataObjectSection.getElementCount() > 0 && (result = AggregateFunctions.checkFieldExistence(dataObjectSection, restFieldName))) {
                return true;
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, firstSecName, e);
        }
        return false;
    }

    private static boolean simpleCheckFieldExistenceInAll(DataObjectSection sec, String fieldName) throws TransformException {
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                Object field = obj.getField(fieldIndex);
                if (field != null) continue;
                return false;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
            }
        }
        return true;
    }

    private static boolean simpleCheckFieldExistenceInAll(DataObject sec, String fieldName) throws TransformException {
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        try {
            Object field = sec.getField(fieldIndex);
            if (field == null) {
                return false;
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
        }
        return true;
    }

    private static boolean simpleCheckFieldExistence(DataObjectSection sec, String fieldName) throws TransformException {
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                Object field = obj.getField(fieldIndex);
                if (field == null) continue;
                return true;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
            }
        }
        return false;
    }

    private static boolean simpleCheckFieldExistence(DataObject sec, String fieldName) throws TransformException {
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        try {
            Object field = sec.getField(fieldIndex);
            if (field != null) {
                return true;
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
        }
        return false;
    }

    public static boolean fieldValueExistsInAll(DataObjectSection sec, String fieldName, String fieldValue) throws TransformException {
        return AggregateFunctions.checkFieldValueExistenceInAll(sec, fieldName, fieldValue);
    }

    public static boolean fieldValueExistsInAll(DataObject sec, String fieldName, String fieldValue) throws TransformException {
        return AggregateFunctions.checkFieldValueExistenceInAll(sec, fieldName, fieldValue);
    }

    private static boolean checkFieldValueExistenceInAll(DataObjectSection sec, String fieldName, String fieldValue) throws TransformException {
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            return AggregateFunctions.simpleCheckFieldValueExistenceInAll(sec, fieldName, fieldValue);
        }
        String firstSecName = fieldName.substring(0, dotIndex);
        String restFieldName = fieldName.substring(dotIndex + 1);
        int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                if (dataObjectSection != null && dataObjectSection.getElementCount() > 0) {
                    boolean result = AggregateFunctions.checkFieldValueExistence(dataObjectSection, restFieldName, fieldValue);
                    if (result) continue;
                    return false;
                }
                return false;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, firstSecName, e);
            }
        }
        return true;
    }

    private static boolean checkFieldValueExistenceInAll(DataObject sec, String fieldName, String fieldValue) throws TransformException {
        block5: {
            int dotIndex = fieldName.indexOf(".");
            if (dotIndex == -1) {
                return AggregateFunctions.simpleCheckFieldValueExistenceInAll(sec, fieldName, fieldValue);
            }
            String firstSecName = fieldName.substring(0, dotIndex);
            String restFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
            try {
                DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
                if (dataObjectSection != null && dataObjectSection.getElementCount() > 0) {
                    boolean result = AggregateFunctions.checkFieldValueExistence(dataObjectSection, restFieldName, fieldValue);
                    if (!result) {
                        return false;
                    }
                    break block5;
                }
                return false;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(sec, firstSecName, e);
            }
        }
        return true;
    }

    private static boolean checkFieldValueExistence(DataObjectSection sec, String fieldName, String fieldValue) throws TransformException {
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            return AggregateFunctions.simpleCheckFieldValueExistence(sec, fieldName, fieldValue);
        }
        String firstSecName = fieldName.substring(0, dotIndex);
        String restFieldName = fieldName.substring(dotIndex + 1);
        int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                boolean result;
                DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                if (dataObjectSection == null || dataObjectSection.getElementCount() <= 0 || !(result = AggregateFunctions.checkFieldValueExistence(dataObjectSection, restFieldName, fieldValue))) continue;
                return true;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, firstSecName, e);
            }
        }
        return false;
    }

    private static boolean checkFieldValueExistence(DataObject sec, String fieldName, String fieldValue) throws TransformException {
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            return AggregateFunctions.simpleCheckFieldValueExistence(sec, fieldName, fieldValue);
        }
        String firstSecName = fieldName.substring(0, dotIndex);
        String restFieldName = fieldName.substring(dotIndex + 1);
        int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
        try {
            boolean result;
            DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
            if (dataObjectSection != null && dataObjectSection.getElementCount() > 0 && (result = AggregateFunctions.checkFieldValueExistence(dataObjectSection, restFieldName, fieldValue))) {
                return true;
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, firstSecName, e);
        }
        return false;
    }

    private static boolean simpleCheckFieldValueExistenceInAll(DataObjectSection sec, String fieldName, String fieldValue) throws TransformException {
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                if (AggregateFunctions.isValueMatch(fieldValue, obj, fieldIndex)) continue;
                return false;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
            }
        }
        return true;
    }

    private static boolean simpleCheckFieldValueExistenceInAll(DataObject sec, String fieldName, String fieldValue) throws TransformException {
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        try {
            if (!AggregateFunctions.isValueMatch(fieldValue, sec, fieldIndex)) {
                return false;
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
        }
        return true;
    }

    private static boolean simpleCheckFieldValueExistence(DataObjectSection sec, String fieldName, String fieldValue) throws TransformException {
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                if (!AggregateFunctions.isValueMatch(fieldValue, obj, fieldIndex)) continue;
                return true;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
            }
        }
        return false;
    }

    private static boolean simpleCheckFieldValueExistence(DataObject sec, String fieldName, String fieldValue) throws TransformException {
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        try {
            if (AggregateFunctions.isValueMatch(fieldValue, sec, fieldIndex)) {
                return true;
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
        }
        return false;
    }

    static boolean isValueMatch(String fieldValue, DataObject obj, int fieldIndex) throws TransformException {
        Object fldVal = obj.getField(fieldIndex);
        if (fldVal != null) {
            if (fldVal instanceof String) {
                if (fldVal.equals(fieldValue)) {
                    return true;
                }
            } else {
                DesignerType type = obj.getFieldDesignerType(fieldIndex);
                Object matchValue = type.parse(fieldValue);
                if (fldVal instanceof byte[] && matchValue instanceof byte[] && new BigInteger((byte[])fldVal).equals(new BigInteger((byte[])matchValue))) {
                    return true;
                }
                if (fldVal.equals(matchValue)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean fieldValueExistsInAtLeastOne(DataObjectSection sec, String fieldName, String fieldValue) throws TransformException {
        return AggregateFunctions.fieldValueCount(sec, fieldName, fieldValue) >= 1;
    }

    public static boolean fieldValueExistsInAtLeastOne(DataObject sec, String fieldName, String fieldValue) throws TransformException {
        return AggregateFunctions.fieldValueCount(sec, fieldName, fieldValue) >= 1;
    }

    public static int fieldValueCount(DataObjectSection sec, String fieldName, String fieldValue) throws TransformRuntimeException, TransformException {
        int count = 0;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            count = AggregateFunctions.simpleFieldValueCount(sec, fieldName, fieldValue);
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            for (int i = 0; i < sec.getElementCount(); ++i) {
                DataObject obj = sec.getElement(i);
                try {
                    DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                    if (dataObjectSection == null) continue;
                    count += AggregateFunctions.fieldValueCount(dataObjectSection, innerFieldName, fieldValue);
                    continue;
                }
                catch (Exception e) {
                    AggregateFunctions.handleFieldAccessException(obj, sectionName, e);
                }
            }
        }
        return count;
    }

    public static int fieldValueCount(DataObject sec, String fieldName, String fieldValue) throws TransformRuntimeException, TransformException {
        int count = 0;
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            count = AggregateFunctions.simpleFieldValueCount(sec, fieldName, fieldValue);
        } else {
            String sectionName = fieldName.substring(0, dotIndex);
            String innerFieldName = fieldName.substring(dotIndex + 1);
            int sectionIndex = AggregateFunctions.getFieldIndex(sec, sectionName);
            try {
                DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
                if (dataObjectSection != null) {
                    count += AggregateFunctions.fieldValueCount(dataObjectSection, innerFieldName, fieldValue);
                }
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(sec, sectionName, e);
            }
        }
        return count;
    }

    private static int simpleFieldValueCount(DataObjectSection sec, String fieldName, String fieldValue) throws TransformRuntimeException, TransformException {
        int count = 0;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                if (!AggregateFunctions.isValueMatch(fieldValue, obj, fieldIndex)) continue;
                ++count;
                continue;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
            }
        }
        return count;
    }

    private static int simpleFieldValueCount(DataObject sec, String fieldName, String fieldValue) throws TransformRuntimeException, TransformException {
        int count = 0;
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        try {
            if (AggregateFunctions.isValueMatch(fieldValue, sec, fieldIndex)) {
                ++count;
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
        }
        return count;
    }

    public static boolean isFieldValueUnique(DataObjectSection sec, String fieldName) throws TransformException {
        List values = AggregateFunctions.getFieldValues(sec, fieldName);
        HashSet valueSet = new HashSet();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (value == null) continue;
            if (value instanceof byte[]) {
                value = Arrays.hashCode((byte[])value);
            }
            if (valueSet.add(value)) continue;
            return false;
        }
        return valueSet.size() > 0;
    }

    public static boolean isFieldValueUnique(DataObject sec, String fieldName) throws TransformException {
        List values = AggregateFunctions.getFieldValues(sec, fieldName);
        HashSet valueSet = new HashSet();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            if (value == null) continue;
            if (value instanceof byte[]) {
                value = Arrays.hashCode((byte[])value);
            }
            if (valueSet.add(value)) continue;
            return false;
        }
        return valueSet.size() > 0;
    }

    private static List getFieldValues(DataObjectSection sec, String fieldName) throws TransformException {
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            return AggregateFunctions.getSimpleFieldValues(sec, fieldName);
        }
        String firstSecName = fieldName.substring(0, dotIndex);
        String restFieldName = fieldName.substring(dotIndex + 1);
        int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
        ArrayList masterList = new ArrayList();
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                DataObjectSection dataObjectSection = obj.getSection(sectionIndex);
                if (dataObjectSection == null || dataObjectSection.getElementCount() <= 0) continue;
                List result = AggregateFunctions.getFieldValues(dataObjectSection, restFieldName);
                masterList.addAll(result);
                continue;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, firstSecName, e);
            }
        }
        return masterList;
    }

    private static List getFieldValues(DataObject sec, String fieldName) throws TransformException {
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex == -1) {
            return AggregateFunctions.getSimpleFieldValues(sec, fieldName);
        }
        String firstSecName = fieldName.substring(0, dotIndex);
        String restFieldName = fieldName.substring(dotIndex + 1);
        int sectionIndex = AggregateFunctions.getFieldIndex(sec, firstSecName);
        ArrayList masterList = new ArrayList();
        try {
            DataObjectSection dataObjectSection = sec.getSection(sectionIndex);
            if (dataObjectSection != null && dataObjectSection.getElementCount() > 0) {
                List result = AggregateFunctions.getFieldValues(dataObjectSection, restFieldName);
                masterList.addAll(result);
            }
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, firstSecName, e);
        }
        return masterList;
    }

    private static List getSimpleFieldValues(DataObjectSection sec, String fieldName) throws TransformException {
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            try {
                Object fldVal = obj.getField(fieldIndex);
                values.add(fldVal);
                continue;
            }
            catch (Exception e) {
                AggregateFunctions.handleFieldAccessException(obj, fieldName, e);
            }
        }
        return values;
    }

    private static List getSimpleFieldValues(DataObject sec, String fieldName) throws TransformException {
        int fieldIndex = AggregateFunctions.getFieldIndex(sec, fieldName);
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            Object fldVal = sec.getField(fieldIndex);
            values.add(fldVal);
        }
        catch (Exception e) {
            AggregateFunctions.handleFieldAccessException(sec, fieldName, e);
        }
        return values;
    }
}

