/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.lang.CharBinaryBuffer;
import com.tplus.transform.runtime.FieldParsingException;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.collection.StringList;
import java.io.UnsupportedEncodingException;

public class BinaryFunctions {
    static final byte[] ZERO_BYTES = new byte[0];

    public static boolean byteEquals(byte[] bytes1, byte[] bytes2) {
        if (bytes1 == null || bytes2 == null) {
            return bytes1 == bytes2;
        }
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean notEqual(byte[] val1, byte[] val2) {
        return !BinaryFunctions.byteEquals(val1, val2);
    }

    public static byte[] plus(byte[] v1, byte[] v2) {
        byte[] toRet = new byte[v1.length + v2.length];
        System.arraycopy(v1, 0, toRet, 0, v1.length);
        System.arraycopy(v2, 0, toRet, v1.length, v2.length);
        return toRet;
    }

    public static byte[] sub(byte[] v1, int offset, int size) {
        return BinaryFunctions.mid(v1, offset, size);
    }

    public static int length(byte[] v1) {
        return v1.length;
    }

    public static int byteAt(byte[] v1, int index) {
        if (index < v1.length) {
            return v1[index];
        }
        throw TransformRuntimeException.createFormatted("SRT591", new Object[]{String.valueOf(index), String.valueOf(v1.length)});
    }

    public static byte[] left(byte[] str, int num_chars) {
        return BinaryFunctions.mid(str, 0, num_chars);
    }

    public static byte[] right(byte[] str, int num_chars) {
        return BinaryFunctions.mid(str, str.length - num_chars, num_chars);
    }

    public static byte[] mid(byte[] v1, int start_index, int num_chars) {
        if (start_index < 0) {
            start_index = 0;
        }
        if (num_chars < 0) {
            return ZERO_BYTES;
        }
        int strLength = v1.length;
        if (start_index >= strLength) {
            return ZERO_BYTES;
        }
        num_chars = Math.min(num_chars, strLength - start_index);
        byte[] toRet = new byte[num_chars];
        System.arraycopy(v1, start_index, toRet, 0, num_chars);
        return toRet;
    }

    public static int findFirst(byte[] str1, char charToFind) {
        return BinaryFunctions.findFirst(str1, charToFind, 0);
    }

    public static int findFirst(byte[] str1, char charToFind, int start_index) {
        if (str1 == null) {
            return -1;
        }
        return BinaryFunctions.indexOf(str1, charToFind, start_index);
    }

    public static int findFirst(byte[] str1, String toFind) throws TransformException {
        return BinaryFunctions.findFirst(str1, toFind, 0);
    }

    public static int findFirst(byte[] str1, String toFind, int start_index) throws TransformException {
        if (str1 == null) {
            return -1;
        }
        byte[] sequence = toFind.getBytes();
        return BinaryFunctions.indexOf(str1, sequence, start_index);
    }

    public static int findFirst(byte[] str1, StringList toFind) throws TransformException {
        return BinaryFunctions.findFirst(str1, toFind, 0);
    }

    public static int findFirst(byte[] str1, StringList toFind, int start_index) throws TransformException {
        if (str1 == null) {
            return -1;
        }
        try {
            byte[][] sequences = BinaryFunctions.prepareByteSequences(toFind, null);
            return BinaryFunctions.indexOf(str1, sequences, start_index);
        }
        catch (UnsupportedEncodingException e) {
            TransformException tre = TransformException.createFormatted("SRT593", (String)null);
            tre.setDetail(e);
            throw tre;
        }
    }

    private static byte[][] prepareByteSequences(StringList toFind, String encoding) throws UnsupportedEncodingException {
        byte[][] sequences = new byte[toFind.size()][];
        for (int i = 0; i < toFind.size(); ++i) {
            String s = toFind.getValue(i);
            byte[] sequence = CharBinaryBuffer.stringToBytes(s, encoding);
            sequences[i] = sequence;
        }
        return sequences;
    }

    private static int indexOf(byte[] str1, byte[] sequence, int start_index) {
        if (sequence.length > 0) {
            for (int i = start_index = Math.max(start_index, 0); i < str1.length; ++i) {
                byte b = str1[i];
                if (b != sequence[0] || !BinaryFunctions.isSequenceMatch(str1, i, sequence)) continue;
                return i;
            }
        }
        return -1;
    }

    private static int indexOf(byte[] str1, byte[][] sequences, int start_index) throws TransformException {
        int length = str1.length;
        for (int i = start_index = Math.max(start_index, 0); i < length; ++i) {
            byte b = str1[i];
            for (int j = 0; j < sequences.length; ++j) {
                byte[] sequence = sequences[j];
                if (sequence.length <= 0 || b != sequence[0] || !BinaryFunctions.isSequenceMatch(str1, i, sequence)) continue;
                return i;
            }
        }
        return -1;
    }

    private static boolean isSequenceMatch(byte[] str1, int index, byte[] sequence) {
        int length = str1.length;
        for (int i = index; i < index + sequence.length; ++i) {
            if (i < length) {
                if (str1[i] == sequence[i - index]) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static int getLength(byte[] str1) {
        return str1 == null ? 0 : str1.length;
    }

    public static int findLast(byte[] str1, char charToFind) {
        if (str1 == null) {
            return -1;
        }
        return BinaryFunctions.lastIndexOf(str1, charToFind, str1.length);
    }

    public static int findLast(byte[] str1, char charToFind, int start_index) {
        if (str1 == null) {
            return -1;
        }
        return BinaryFunctions.lastIndexOf(str1, charToFind, start_index);
    }

    private static int indexOf(byte[] str1, int charToFind, int start_index) {
        int length = BinaryFunctions.getLength(str1);
        for (int i = start_index; i < length; ++i) {
            byte b = str1[i];
            if (b != charToFind) continue;
            return i;
        }
        return -1;
    }

    private static int lastIndexOf(byte[] str1, int charToFind, int start_index) {
        for (int i = start_index = Math.min(start_index, str1.length - 1); i >= 0; --i) {
            byte b = str1[i];
            if (b != charToFind) continue;
            return i;
        }
        return -1;
    }

    public static byte[] toBinary(int value) throws TransformException {
        return BinaryFunctions.toBinary(value, 4, true, true);
    }

    public static byte[] toBinary(long value) throws TransformException {
        return BinaryFunctions.toBinary(value, 8, true, true);
    }

    public byte[] toBinary(float value) throws TransformException {
        return this.toBinary(value, true);
    }

    public byte[] toBinary(float value, boolean bigEndian) throws TransformException {
        return BinaryFunctions.toBinary(Float.floatToIntBits(value), 4, true, bigEndian);
    }

    public byte[] toBinary(double value) throws TransformException {
        return this.toBinary(value, true);
    }

    public byte[] toBinary(double value, boolean bigEndian) throws TransformException {
        return BinaryFunctions.toBinary(Double.doubleToLongBits(value), 8, true, bigEndian);
    }

    public static byte[] toBinary(int value, int length, boolean signed, boolean bigEndian) throws TransformException {
        byte[] toRet = new byte[length];
        BinaryFunctions.setBinaryInt(toRet, value, 0, length, signed, bigEndian);
        return toRet;
    }

    public static byte[] toBinary(long value, int length, boolean signed, boolean bigEndian) throws TransformException {
        byte[] toRet = new byte[length];
        BinaryFunctions.setBinaryLong(toRet, value, 0, length, signed, bigEndian);
        return toRet;
    }

    public static void setBinaryInt(byte[] bytes, int value, boolean signed, boolean bigEndian) throws TransformException {
        BinaryFunctions.setBinaryInt(bytes, value, 0, bytes.length, signed, bigEndian);
    }

    public static void setBinaryInt(byte[] bytes, int value, int offset, int length, boolean signed, boolean bigEndian) throws TransformException {
        if (offset < 0 || offset + length > bytes.length) {
            throw new TransformException("Illegal offset/length in setBinaryInt");
        }
        switch (length) {
            case 1: {
                BinaryFunctions.setBinaryInt1(bytes, value, offset, bigEndian, signed);
                return;
            }
            case 2: {
                BinaryFunctions.setBinaryInt2(bytes, value, offset, bigEndian, signed);
                return;
            }
            case 4: {
                if (signed) {
                    BinaryFunctions.setBinaryInt4(bytes, value, offset, bigEndian);
                } else {
                    BinaryFunctions.setBinaryInt4Unsigned(bytes, value, offset, bigEndian);
                }
                return;
            }
            case 8: {
                BinaryFunctions.setBinaryInt8(bytes, value, offset, bigEndian);
                return;
            }
        }
        throw TransformException.createFormatted("SRT592", String.valueOf(length));
    }

    public static void setBinaryLong(byte[] bytes, long value, int offset, int length, boolean signed, boolean bigEndian) throws TransformException {
        if (offset < 0 || offset + length > bytes.length) {
            throw new TransformException("Illegal offset/length in setBinaryLong");
        }
        switch (length) {
            case 1: {
                BinaryFunctions.setBinaryInt1(bytes, (int)value, offset, bigEndian, signed);
                return;
            }
            case 2: {
                BinaryFunctions.setBinaryInt2(bytes, (int)value, offset, bigEndian, signed);
                return;
            }
            case 4: {
                if (signed) {
                    BinaryFunctions.setBinaryInt4(bytes, (int)value, offset, bigEndian);
                } else {
                    BinaryFunctions.setBinaryInt4Unsigned(bytes, value, offset, bigEndian);
                }
                return;
            }
            case 8: {
                BinaryFunctions.setBinaryInt8(bytes, value, offset, bigEndian);
                return;
            }
        }
        throw TransformException.createFormatted("SRT592", String.valueOf(length));
    }

    private static void setBinaryInt1(byte[] bytes, int value, int offset, boolean bigEndian, boolean signed) throws TransformException {
        bytes[offset] = (byte)value;
    }

    private static void setBinaryInt2(byte[] bytes, int value, int offset, boolean bigEndian, boolean signed) throws TransformException {
        if (bigEndian) {
            bytes[offset + 0] = (byte)(value >> 8 & 0xFF);
            bytes[offset + 1] = (byte)(value & 0xFF);
        } else {
            bytes[offset + 0] = (byte)(value & 0xFF);
            bytes[offset + 1] = (byte)(value >> 8 & 0xFF);
        }
    }

    private static void setBinaryInt4(byte[] bytes, int value, int offset, boolean bigEndian) throws TransformException {
        BinaryFunctions.setBinaryInt4Private(bytes, value, offset, bigEndian);
    }

    private static void setBinaryInt4Unsigned(byte[] bytes, long value, int offset, boolean bigEndian) throws TransformException {
        BinaryFunctions.setBinaryLong4Private(bytes, value, offset, bigEndian);
    }

    private static void setBinaryInt4Private(byte[] bytes, int value, int offset, boolean bigEndian) throws TransformException {
        int ch1 = value >> 24 & 0xFF;
        int ch2 = value >> 16 & 0xFF;
        int ch3 = value >> 8 & 0xFF;
        int ch4 = value >> 0 & 0xFF;
        if (bigEndian) {
            bytes[offset] = (byte)ch1;
            bytes[offset + 1] = (byte)ch2;
            bytes[offset + 2] = (byte)ch3;
            bytes[offset + 3] = (byte)ch4;
        } else {
            bytes[offset + 3] = (byte)ch1;
            bytes[offset + 2] = (byte)ch2;
            bytes[offset + 1] = (byte)ch3;
            bytes[offset] = (byte)ch4;
        }
    }

    private static void setBinaryLong4Private(byte[] bytes, long value, int offset, boolean bigEndian) throws TransformException {
        long ch1 = value >> 24 & 0xFFL;
        long ch2 = value >> 16 & 0xFFL;
        long ch3 = value >> 8 & 0xFFL;
        long ch4 = value >> 0 & 0xFFL;
        if (bigEndian) {
            bytes[offset] = (byte)ch1;
            bytes[offset + 1] = (byte)ch2;
            bytes[offset + 2] = (byte)ch3;
            bytes[offset + 3] = (byte)ch4;
        } else {
            bytes[offset + 3] = (byte)ch1;
            bytes[offset + 2] = (byte)ch2;
            bytes[offset + 1] = (byte)ch3;
            bytes[offset] = (byte)ch4;
        }
    }

    private static void setBinaryInt8(byte[] bytes, long value, int offset, boolean bigEndian) throws TransformException {
        long l2;
        long l1;
        if (bigEndian) {
            l1 = value >> 32 & 0xFFFFFFFFL;
            l2 = value & 0xFFFFFFFFL;
        } else {
            l1 = value & 0xFFFFFFFFL;
            l2 = value >> 32 & 0xFFFFFFFFL;
        }
        BinaryFunctions.setBinaryLong4Private(bytes, l1, offset, bigEndian);
        BinaryFunctions.setBinaryLong4Private(bytes, l2, offset + 4, bigEndian);
    }

    public static int getBinaryInt(byte[] bytes, boolean signed, boolean bigEndian) throws TransformException {
        return BinaryFunctions.getBinaryInt(bytes, 0, bytes.length, signed, bigEndian);
    }

    public static int getBinaryInt(byte[] bytes, int offset, int length, boolean signed, boolean bigEndian) throws TransformException {
        switch (length) {
            case 1: {
                return BinaryFunctions.getBinaryInt1(bytes, offset, bigEndian, signed);
            }
            case 2: {
                return BinaryFunctions.getBinaryInt2(bytes, offset, bigEndian, signed);
            }
            case 4: {
                if (signed) {
                    return BinaryFunctions.getBinaryInt4(bytes, offset, bigEndian);
                }
                return (int)BinaryFunctions.getBinaryInt4Unsigned(bytes, offset, bigEndian);
            }
            case 8: {
                return (int)BinaryFunctions.getBinaryInt8(bytes, offset, bigEndian);
            }
        }
        throw TransformException.createFormatted("SRT592", String.valueOf(length));
    }

    public static long getBinaryLong(byte[] bytes, boolean signed, boolean bigEndian) throws TransformException {
        return BinaryFunctions.getBinaryLong(bytes, 0, bytes.length, signed, bigEndian);
    }

    public static long getBinaryLong(byte[] bytes, int offset, int length, boolean signed, boolean bigEndian) throws TransformException {
        switch (length) {
            case 1: {
                return BinaryFunctions.getBinaryInt1(bytes, offset, bigEndian, signed);
            }
            case 2: {
                return BinaryFunctions.getBinaryInt2(bytes, offset, bigEndian, signed);
            }
            case 4: {
                if (signed) {
                    return BinaryFunctions.getBinaryInt4(bytes, offset, bigEndian);
                }
                return BinaryFunctions.getBinaryInt4Unsigned(bytes, offset, bigEndian);
            }
            case 8: {
                return BinaryFunctions.getBinaryInt8(bytes, offset, bigEndian);
            }
        }
        throw TransformException.createFormatted("SRT592", String.valueOf(length));
    }

    private static int getBinaryInt1(byte[] bytes, int offset, boolean bigEndian, boolean signed) throws TransformException {
        int value = bytes[offset + 0] & 0xFF;
        if (signed) {
            return (byte)value;
        }
        return value;
    }

    private static int getBinaryInt2(byte[] bytes, int offset, boolean bigEndian, boolean signed) throws TransformException {
        int ch1 = bytes[offset + 0] & 0xFF;
        int ch2 = bytes[offset + 1] & 0xFF;
        int value = bigEndian ? (ch1 << 8) + (ch2 << 0) : (ch2 << 8) + (ch1 << 0);
        if (signed) {
            return (short)value;
        }
        return value;
    }

    private static int getBinaryInt4(byte[] bytes, int offset, boolean bigEndian) throws TransformException {
        return BinaryFunctions.getBinaryInt4Private(bytes, offset, bigEndian);
    }

    private static long getBinaryInt4Unsigned(byte[] bytes, int offset, boolean bigEndian) throws TransformException {
        return BinaryFunctions.getBinaryLong4Private(bytes, offset, bigEndian);
    }

    private static int getBinaryInt4Private(byte[] bytes, int offset, boolean bigEndian) throws TransformException {
        int ch1 = bytes[offset + 0] & 0xFF;
        int ch2 = bytes[offset + 1] & 0xFF;
        int ch3 = bytes[offset + 2] & 0xFF;
        int ch4 = bytes[offset + 3] & 0xFF;
        if (bigEndian) {
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    private static long getBinaryLong4Private(byte[] bytes, int offset, boolean bigEndian) throws TransformException {
        long ch1 = bytes[offset] & 0xFF;
        long ch2 = bytes[offset + 1] & 0xFF;
        long ch3 = bytes[offset + 2] & 0xFF;
        long ch4 = bytes[offset + 3] & 0xFF;
        if (bigEndian) {
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    private static long getBinaryInt8(byte[] bytes, int offset, boolean bigEndian) throws TransformException {
        int i1 = BinaryFunctions.getBinaryInt4Private(bytes, offset, bigEndian);
        int i2 = BinaryFunctions.getBinaryInt4Private(bytes, offset + 4, bigEndian);
        if (bigEndian) {
            return ((long)i1 << 32) + ((long)i2 & 0xFFFFFFFFL);
        }
        return ((long)i2 << 32) + ((long)i1 & 0xFFFFFFFFL);
    }

    public static String toHexString(byte[] val) {
        return Parsing.binaryToHexString(val);
    }

    public static byte[] toHexBinary(String val) throws FieldParsingException {
        return Parsing.hexStringToBinary(val);
    }

    public static String toBase64String(byte[] val) {
        return Parsing.binaryToBase64String(val);
    }

    public static byte[] toBase64Binary(String val) throws FieldParsingException {
        return Parsing.base64StringToBinary(val);
    }

    public static String toASCIIString(byte[] val) {
        return new String(val, 0);
    }

    public static byte[] toASCIIBinary(String str) {
        try {
            return CharBinaryBuffer.stringToBytes(str, "ascii");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public static String binaryToString(byte[] val) throws TransformRuntimeException {
        return BinaryFunctions.binaryToString(val, null);
    }

    public static String binaryToString(byte[] val, String encoding) throws TransformRuntimeException {
        try {
            if (encoding != null) {
                return new String(val, 0, val.length, encoding);
            }
            return new String(val, 0, val.length);
        }
        catch (UnsupportedEncodingException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT593", encoding);
            tre.setDetail(e);
            throw tre;
        }
    }

    public static byte[] stringToBinary(String str) throws TransformRuntimeException {
        return BinaryFunctions.stringToBinary(str, null);
    }

    public static byte[] stringToBinary(String str, String encoding) throws TransformRuntimeException {
        try {
            return CharBinaryBuffer.stringToBytes(str, encoding);
        }
        catch (UnsupportedEncodingException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT593", encoding);
            tre.setDetail(e);
            throw tre;
        }
    }

    public static void cmtmain(String[] args) throws TransformException {
        BinaryFunctions.toBinary(10);
    }
}

