/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

public class BitFunctions {
    public static int leftShift(int value, int shiftBy) {
        return value << shiftBy;
    }

    public static int rightShift(int value, int shiftBy) {
        return value >> shiftBy;
    }

    public static int unsignedRightShift(int value, int shiftBy) {
        return value >>> shiftBy;
    }

    public static boolean isBitSet(int value, int at) {
        return (value & 1 << at) != 0;
    }

    public static int setBit(int value, int at) {
        return value | 1 << at;
    }

    public static int clearBit(int value, int at) {
        return value & ~(1 << at);
    }

    public static int flipBit(int value, int at) {
        return BitFunctions.isBitSet(value, at) ? BitFunctions.clearBit(value, at) : BitFunctions.setBit(value, at);
    }

    public static int bitAnd(int value1, int value2) {
        return value1 & value2;
    }

    public static int bitOr(int value1, int value2) {
        return value1 | value2;
    }

    public static int bitXOR(int value1, int value2) {
        return value1 ^ value2;
    }

    public static int bitNot(int value) {
        return ~value;
    }

    public static long leftShift(long value, int shiftBy) {
        return value << shiftBy;
    }

    public static long rightShift(long value, int shiftBy) {
        return value >> shiftBy;
    }

    public static long unsignedRightShift(long value, int shiftBy) {
        return value >>> shiftBy;
    }

    public static boolean isBitSet(long value, int at) {
        return (value & 1L << at) != 0L;
    }

    public static long setBit(long value, int at) {
        return value | 1L << at;
    }

    public static long clearBit(long value, int at) {
        return value & (1L << at ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long flipBit(long value, int at) {
        return BitFunctions.isBitSet(value, at) ? BitFunctions.clearBit(value, at) : BitFunctions.setBit(value, at);
    }

    public static long bitAnd(long value1, long value2) {
        return value1 & value2;
    }

    public static long bitOr(long value1, long value2) {
        return value1 | value2;
    }

    public static long bitXOR(long value1, long value2) {
        return value1 ^ value2;
    }

    public static long bitNot(long value) {
        return value ^ 0xFFFFFFFFFFFFFFFFL;
    }
}

