/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.runtime.CaselessDataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectCollectionImpl;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldMetaInfoImpl;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.FieldTypeMismatchException;
import com.tplus.transform.runtime.FieldValueException;
import com.tplus.transform.runtime.ICacheble;
import com.tplus.transform.runtime.IDisposableCache;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.SimpleGenericDataObject;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.Variant;
import com.tplus.transform.runtime.VariantHolderInOut;
import com.tplus.transform.runtime.VariantHolderOut;
import com.tplus.transform.runtime.formula.DatabaseFunctions;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DBSecQueryFunction
implements ICacheble,
DesignerTypes {
    private IDisposableCache cache;
    private DataObjectSection dataObjectCollection;
    public static final Map designer2SqlTypeMap = new HashMap();
    public static final int ORACLE_CURSOR_TYPE = -10;
    public static final Map sql2DesignerTypeMap;

    public void setCacheContext(IDisposableCache cache) {
        this.cache = cache;
    }

    public void dispose() {
    }

    private static Object[] translateParams(Object[] params, int[] paramTransformIndexes) throws TransformException {
        if (params == null) {
            params = new Object[]{};
        }
        int paramCount = paramTransformIndexes.length;
        Object[] transformedParams = new Object[paramTransformIndexes.length];
        for (int i = 0; i < paramTransformIndexes.length; ++i) {
            Object paramValue = params[paramTransformIndexes[i]];
            transformedParams[i] = paramValue = DBSecQueryFunction.toSQLParam(paramValue);
        }
        return transformedParams;
    }

    private static Object toSQLParam(Object paramValue) {
        if (paramValue instanceof Character) {
            paramValue = paramValue.toString();
        }
        if (paramValue instanceof java.util.Date) {
            paramValue = new Date(((java.util.Date)paramValue).getTime());
        }
        return paramValue;
    }

    public DataObjectSection dbcSecQuery(String dataSource, String sql) throws TransformException {
        String cacheKey = "dbSecQuery$" + dataSource + sql;
        DBSecQueryFunction cachedData = this.getFromCache(cacheKey);
        if (cachedData != null) {
            return cachedData.dataObjectCollection;
        }
        this.dataObjectCollection = DBSecQueryFunction.dbSecQuery(dataSource, sql);
        this.putInCache(cacheKey);
        return this.dataObjectCollection;
    }

    public DataObjectSection dbcSecQuery(String dataSource, String sql, Object[] params, int[] paramTransformIndexes) throws TransformException {
        String cacheKey = "dbSecQuery$" + dataSource + sql;
        for (int i = 0; i < params.length; ++i) {
            cacheKey = cacheKey + params[i] + ",";
        }
        DBSecQueryFunction cachedData = this.getFromCache(cacheKey);
        if (cachedData != null) {
            return cachedData.dataObjectCollection;
        }
        this.dataObjectCollection = DBSecQueryFunction.dbSecQuery(dataSource, sql, params, paramTransformIndexes);
        this.putInCache(cacheKey);
        return this.dataObjectCollection;
    }

    public static DataObjectSection dbSecQuery(String dataSource, String sql, Object[] params, int[] paramTransformIndexes) throws TransformException {
        DatabaseFunctions dbFunction = new DatabaseFunctions();
        PreparedStatement stmt = dbFunction.createPreparedStatement(dataSource, sql, false);
        params = DBSecQueryFunction.translateParams(params, paramTransformIndexes);
        try {
            for (int i = 0; i < params.length; ++i) {
                stmt.setObject(i + 1, params[i]);
            }
            ResultSet rs = stmt.executeQuery();
            DataObjectSection dataObjectSection = DBSecQueryFunction.resultSet2Collection(rs);
            return dataObjectSection;
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted("SRT554", sql);
            te.setDetail(e);
            throw te;
        }
        finally {
            dbFunction.dispose();
        }
    }

    private static void closeStatement(PreparedStatement stmt) throws SQLException {
        stmt.close();
    }

    public static DataObjectSection dbSecQuery(String dataSource, String sql) throws TransformException {
        DatabaseFunctions dbFunction = new DatabaseFunctions();
        Statement stmt = dbFunction.createStatement(dataSource, false);
        try {
            ResultSet rs = stmt.executeQuery(sql);
            DataObjectSection dataObjectSection = DBSecQueryFunction.resultSet2Collection(rs);
            return dataObjectSection;
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted("SRT554", sql);
            te.setDetail(e);
            throw te;
        }
        finally {
            dbFunction.dispose();
        }
    }

    public static DataObjectSection dbSecQuery(String dataSource, String sql, Object[] params) throws TransformException {
        DatabaseFunctions dbFunction = new DatabaseFunctions();
        PreparedStatement stmt = dbFunction.createPreparedStatement(dataSource, sql, false);
        try {
            DatabaseFunctions.populateStatement(stmt, params);
            ResultSet rs = stmt.executeQuery();
            DataObjectSection dataObjectSection = DBSecQueryFunction.resultSet2Collection(rs);
            return dataObjectSection;
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted("SRT554", sql);
            te.setDetail(e);
            throw te;
        }
        finally {
            dbFunction.dispose();
        }
    }

    public static void dbExecStoredProc(String dataSource, String sql, Object[] params) throws TransformException {
        DatabaseFunctions dbFunction = new DatabaseFunctions();
        try {
            List allParams = DBSecQueryFunction.prepareVariantParams(params);
            CallableStatement callableStatement = dbFunction.createCallableStatement(dataSource, sql, false);
            DBSecQueryFunction.fillCallableStatement(callableStatement, allParams);
            boolean execute = callableStatement.execute();
            DBSecQueryFunction.extractOutputVariant(callableStatement, allParams);
            if (execute) {
                // empty if block
            }
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted("SRT554", sql);
            te.setDetail(e);
            throw te;
        }
        finally {
            dbFunction.dispose();
        }
    }

    private static void extractOutputVariant(CallableStatement callableStatement, List allParams) throws SQLException, FieldValueException {
        for (int i = 0; i < allParams.size(); ++i) {
            Variant param = (Variant)allParams.get(i);
            if (!(param instanceof VariantHolderOut) && !(param instanceof VariantHolderInOut)) continue;
            Object value = callableStatement.getObject(i + 1);
            if (value instanceof ResultSet) {
                ResultSet resultSet = (ResultSet)value;
                DataObjectSection dataObjectSection = DBSecQueryFunction.resultSet2Collection(resultSet);
                param.setValue(dataObjectSection);
                continue;
            }
            param.setValue(DBSecQueryFunction.sqlObjectToRuntimeObject(value, param.getType()));
        }
    }

    private static void fillCallableStatement(CallableStatement callableStatement, List allParams) throws SQLException {
        for (int i = 0; i < allParams.size(); ++i) {
            Object sqlParam;
            Variant param = (Variant)allParams.get(i);
            if (param instanceof VariantHolderOut) {
                callableStatement.registerOutParameter(i + 1, DBSecQueryFunction.getSQLType(param.getType()));
                continue;
            }
            if (param instanceof VariantHolderInOut) {
                callableStatement.registerOutParameter(i + 1, DBSecQueryFunction.getSQLType(param.getType()));
                sqlParam = DatabaseFunctions.designerToSQLType(param.getValue());
                callableStatement.setObject(i + 1, sqlParam);
                continue;
            }
            sqlParam = DatabaseFunctions.designerToSQLType(param.getValue());
            callableStatement.setObject(i + 1, sqlParam);
        }
    }

    private static List prepareVariantParams(Object[] params) {
        ArrayList<Object> allParams = new ArrayList<Object>();
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param instanceof Variant) {
                allParams.add(param);
                continue;
            }
            allParams.add(Parsing.toVariant(param));
        }
        return allParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataObjectSection resultSet2Collection(ResultSet rs) throws SQLException {
        try {
            DataObjectCollectionImpl dataObjectCollection = new DataObjectCollectionImpl();
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            int columnCount = resultSetMetaData.getColumnCount();
            FieldMetaInfo[] fieldInfos = new FieldMetaInfo[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                String name = resultSetMetaData.getColumnName(i);
                int sqlType = resultSetMetaData.getColumnType(i);
                DesignerType type = DBSecQueryFunction.getDesignerType(sqlType);
                if (type == null) {
                    log.debug("Missing type mapping for SQLType = " + sqlType);
                    type = STRING_TYPE;
                }
                fieldInfos[i - 1] = new FieldMetaInfoImpl(name, type, true, false);
            }
            CaselessDataObjectMetaInfo dataObjectMetaInfo = new CaselessDataObjectMetaInfo("QueryInfo", fieldInfos);
            while (rs.next()) {
                SimpleGenericDataObject dataObject = new SimpleGenericDataObject(null, dataObjectMetaInfo);
                for (int i = 1; i <= columnCount; ++i) {
                    try {
                        Object columnValue = rs.getObject(i);
                        FieldMetaInfo info = fieldInfos[i - i];
                        columnValue = DBSecQueryFunction.sqlObjectToRuntimeObject(columnValue, info.getDesignerType());
                        dataObject.setField(i - 1, columnValue);
                        continue;
                    }
                    catch (FieldNotFoundException e) {
                        continue;
                    }
                    catch (FieldTypeMismatchException e) {
                        // empty catch block
                    }
                }
                dataObjectCollection.addElement(dataObject);
            }
            DataObjectCollectionImpl dataObjectCollectionImpl = dataObjectCollection;
            return dataObjectCollectionImpl;
        }
        finally {
            rs.close();
        }
    }

    private static Object sqlObjectToRuntimeObject(Object columnValue, DesignerType type) throws SQLException {
        long length;
        Object blob;
        if (type == BINARY_TYPE && columnValue instanceof Blob) {
            blob = (Blob)columnValue;
            length = blob.length();
            columnValue = blob.getBytes(0L, (int)length);
        }
        if (type == STRING_TYPE && columnValue instanceof Clob) {
            blob = (Clob)columnValue;
            length = blob.length();
            columnValue = blob.getSubString(0L, (int)length);
        }
        if (type == BOOLEAN_TYPE && columnValue instanceof Number) {
            Number number = (Number)columnValue;
            columnValue = number.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        return columnValue;
    }

    private DBSecQueryFunction getFromCache(String cacheKey) {
        if (this.cache != null) {
            DBSecQueryFunction cachedData = (DBSecQueryFunction)this.cache.get(cacheKey);
            return cachedData;
        }
        return null;
    }

    private void putInCache(String cacheKey) {
        if (this.cache != null) {
            this.cache.add(cacheKey, this);
        }
    }

    private static int getSQLType(DesignerType type) {
        Integer integer = (Integer)designer2SqlTypeMap.get(type);
        if (integer != null) {
            return integer;
        }
        return 12;
    }

    private static DesignerType getDesignerType(int sqlType) {
        return (DesignerType)sql2DesignerTypeMap.get(new Integer(sqlType));
    }

    void f() {
        DataObjectMetaInfoImpl dataObjectMetaInfo = new DataObjectMetaInfoImpl("", new FieldMetaInfo[]{new FieldMetaInfoImpl("a", DesignerType.DESIGNER_STRING_TYPE)});
    }

    static {
        designer2SqlTypeMap.put(INT_TYPE, new Integer(4));
        designer2SqlTypeMap.put(FLOAT_TYPE, new Integer(6));
        designer2SqlTypeMap.put(DOUBLE_TYPE, new Integer(2));
        designer2SqlTypeMap.put(LONG_TYPE, new Integer(-5));
        designer2SqlTypeMap.put(CHAR_TYPE, new Integer(1));
        designer2SqlTypeMap.put(DATE_ONLY_TYPE, new Integer(91));
        designer2SqlTypeMap.put(TIME_ONLY_TYPE, new Integer(92));
        designer2SqlTypeMap.put(DATE_TIME_TYPE, new Integer(93));
        designer2SqlTypeMap.put(STRING_TYPE, new Integer(12));
        designer2SqlTypeMap.put(BOOLEAN_TYPE, new Integer(16));
        designer2SqlTypeMap.put(BINARY_TYPE, new Integer(-3));
        designer2SqlTypeMap.put(SECTION_TYPE, new Integer(-10));
        sql2DesignerTypeMap = new HashMap();
        sql2DesignerTypeMap.put(new Integer(4), INT_TYPE);
        sql2DesignerTypeMap.put(new Integer(5), INT_TYPE);
        sql2DesignerTypeMap.put(new Integer(-6), INT_TYPE);
        sql2DesignerTypeMap.put(new Integer(6), FLOAT_TYPE);
        sql2DesignerTypeMap.put(new Integer(8), DOUBLE_TYPE);
        sql2DesignerTypeMap.put(new Integer(3), DOUBLE_TYPE);
        sql2DesignerTypeMap.put(new Integer(2), DOUBLE_TYPE);
        sql2DesignerTypeMap.put(new Integer(-5), LONG_TYPE);
        sql2DesignerTypeMap.put(new Integer(1), CHAR_TYPE);
        sql2DesignerTypeMap.put(new Integer(91), DATE_ONLY_TYPE);
        sql2DesignerTypeMap.put(new Integer(92), TIME_ONLY_TYPE);
        sql2DesignerTypeMap.put(new Integer(93), DATE_TIME_TYPE);
        sql2DesignerTypeMap.put(new Integer(12), STRING_TYPE);
        sql2DesignerTypeMap.put(new Integer(2005), STRING_TYPE);
        sql2DesignerTypeMap.put(new Integer(-1), STRING_TYPE);
        sql2DesignerTypeMap.put(new Integer(-7), BOOLEAN_TYPE);
        sql2DesignerTypeMap.put(new Integer(16), BOOLEAN_TYPE);
        sql2DesignerTypeMap.put(new Integer(-3), BINARY_TYPE);
        sql2DesignerTypeMap.put(new Integer(-4), BINARY_TYPE);
        sql2DesignerTypeMap.put(new Integer(2004), BINARY_TYPE);
    }
}

