/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.CommentInfo;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DataObjectXML;
import com.tplus.transform.runtime.ExceptionObject;
import com.tplus.transform.runtime.FieldId;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.FieldNullException;
import com.tplus.transform.runtime.LocationInfo;
import com.tplus.transform.runtime.Locator;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.Variant;
import com.tplus.transform.runtime.collection.StringList;
import com.tplus.transform.runtime.formula.DataObjectXPathUtil;
import com.tplus.transform.runtime.formula.MessageFunctions;
import com.tplus.transform.runtime.formula.SectionHelper;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DataObjectFunctions
extends SectionHelper {
    public static boolean objIsNull(DataObject obj, String fieldName) throws TransformException {
        return obj.isNull(fieldName);
    }

    public static boolean objIsNull(DataObject obj, int fieldIndex) throws TransformException {
        return obj.isNull(fieldIndex);
    }

    public static boolean objIsNotNull(DataObject obj, String fieldName) throws TransformException {
        return !obj.isNull(fieldName);
    }

    public static boolean objIsNotNull(DataObject obj, int fieldIndex) throws TransformException {
        return !obj.isNull(fieldIndex);
    }

    public static void objsetNull(DataObject obj, String fieldName) throws TransformException {
        obj.setNull(fieldName);
    }

    public static void objsetNull(DataObject obj, int fieldIndex) throws TransformException {
        obj.setNull(fieldIndex);
    }

    public static int objGetInt(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetInt(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static int objGetInt(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return DataObjectFunctions.toInt(value, obj, fieldIndex);
    }

    Object getNestedFieldValue(DataObject root, String fieldName) {
        DataObject currObj = root;
        FieldId fieldId = new FieldId(fieldName);
        int levels = fieldId.getFieldLevels();
        for (int i = 0; i < levels; ++i) {
            DataObjectSection sec;
            String fieldNameAt = fieldId.getFieldNameAt(i);
            int index = currObj.getFieldIndex(fieldNameAt);
            Object value = currObj.getField(index);
            int sectionIndex = fieldId.getFieldIndexAt(i);
            if (i < levels - 1) {
                if (!(value instanceof DataObjectSection)) {
                    throw new IllegalArgumentException("");
                }
            } else {
                if (fieldId.isIndexSpecifiedAt(index) && value instanceof DataObjectSection) {
                    sec = (DataObjectSection)value;
                    currObj = sec.getElement(sectionIndex);
                    return currObj;
                }
                return value;
            }
            sec = (DataObjectSection)value;
            currObj = sec.getElement(sectionIndex);
        }
        return null;
    }

    public static int objGetField(DataObject obj, int fieldIndex, int defaultValue) throws TransformException {
        Object value = obj.getField(fieldIndex);
        if (value == null) {
            return defaultValue;
        }
        return DataObjectFunctions.toInt(value, obj, fieldIndex);
    }

    private static int toInt(Object value, DataObject obj, int fieldIndex) throws TransformException {
        try {
            return ((Number)value).intValue();
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return 0;
        }
    }

    public static void objSetInt(DataObject obj, String fieldName, int value) throws TransformException {
        obj.setField(fieldName, (Object)Wrapper.box(value));
    }

    public static void objSetInt(DataObject obj, int fieldIndex, int value) throws TransformException {
        obj.setField(fieldIndex, (Object)Wrapper.box(value));
    }

    public static float objGetFloat(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetFloat(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static float objGetFloat(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return DataObjectFunctions.toFloat(value, obj, fieldIndex);
    }

    private static float toFloat(Object value, DataObject obj, int fieldIndex) throws TransformException {
        try {
            return ((Number)value).floatValue();
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return 0.0f;
        }
    }

    public static void objSetFloat(DataObject obj, String fieldName, float value) throws TransformException {
        obj.setField(fieldName, (Object)new Float(value));
    }

    public static void objSetFloat(DataObject obj, int fieldIndex, float value) throws TransformException {
        obj.setField(fieldIndex, (Object)new Float(value));
    }

    public static double objGetDouble(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetDouble(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static double objGetDouble(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return DataObjectFunctions.toDouble(value, obj, fieldIndex);
    }

    private static double toDouble(Object value, DataObject obj, int fieldIndex) throws TransformException {
        try {
            return ((Number)value).doubleValue();
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return 0.0;
        }
    }

    public static void objSetDouble(DataObject obj, String fieldName, double value) throws TransformException {
        obj.setField(fieldName, (Object)new Double(value));
    }

    public static void objSetDouble(DataObject obj, int fieldIndex, double value) throws TransformException {
        obj.setField(fieldIndex, (Object)new Double(value));
    }

    public static long objGetLong(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetLong(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static long objGetLong(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return DataObjectFunctions.toLong(value, obj, fieldIndex);
    }

    private static long toLong(Object value, DataObject obj, int fieldIndex) throws TransformException {
        try {
            return ((Number)value).longValue();
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return 0L;
        }
    }

    public static void objSetLong(DataObject obj, String fieldName, long value) throws TransformException {
        obj.setField(fieldName, (Object)new Long(value));
    }

    public static void objSetLong(DataObject obj, int fieldIndex, long value) throws TransformException {
        obj.setField(fieldIndex, (Object)new Long(value));
    }

    public static String objGetString(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetString(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static String objGetString(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return DataObjectFunctions.toString(value, obj, fieldIndex);
    }

    private static String toString(Object value, DataObject obj, int fieldIndex) throws TransformException {
        try {
            return (String)value;
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return null;
        }
    }

    public static void objSetString(DataObject obj, String fieldName, String value) throws TransformException {
        obj.setField(fieldName, (Object)value);
    }

    public static void objSetString(DataObject obj, int fieldIndex, String value) throws TransformException {
        obj.setField(fieldIndex, (Object)value);
    }

    public static DataObjectSection objGetSection(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetSection(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static DataObjectSection objGetSection(Variant val) {
        return val.getSection();
    }

    public static DataObjectSection objGetSection(DataObject obj, int fieldIndex) throws TransformException {
        try {
            return obj.getSection(fieldIndex);
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return null;
        }
    }

    public static DataObjectSection objGetParentSection(DataObject obj) throws TransformException {
        if (obj != null) {
            return obj.getParentSection();
        }
        return null;
    }

    public static DataObjectSection objGetParentSection(DataObjectSection sec) throws TransformException {
        DataObject parent;
        if (sec != null && (parent = sec.getParent()) != null) {
            return parent.getParentSection();
        }
        return null;
    }

    public static DataObject objGetParentObject(DataObjectSection sec) throws TransformException {
        if (sec != null) {
            return sec.getParent();
        }
        return null;
    }

    public static DataObject objGetParentObject(DataObject obj) throws TransformException {
        if (obj != null) {
            return DataObjectFunctions.objGetParentObject(obj.getParentSection());
        }
        return null;
    }

    public static DataObject objGetObject(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetObject(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static DataObject objGetObject(DataObject obj, int fieldIndex) throws TransformException {
        try {
            return (DataObject)obj.getField(fieldIndex);
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return null;
        }
    }

    public static Date objGetDate(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetDate(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static Date objGetDate(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return DataObjectFunctions.toDate(value, obj, fieldIndex);
    }

    private static Date toDate(Object value, DataObject obj, int fieldIndex) throws TransformException {
        try {
            return (Date)value;
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return null;
        }
    }

    public static void objSetDate(DataObject obj, String fieldName, Date value) throws TransformException {
        obj.setField(fieldName, (Object)value);
    }

    public static void objSetDate(DataObject obj, int fieldIndex, Date value) throws TransformException {
        obj.setField(fieldIndex, (Object)value);
    }

    public static Calendar objGetISODate(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetISODate(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static Calendar objGetISODate(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return DataObjectFunctions.toISODate(value, obj, fieldIndex);
    }

    private static Calendar toISODate(Object value, DataObject obj, int fieldIndex) throws TransformException {
        try {
            return (Calendar)value;
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return null;
        }
    }

    public static void objSetISODate(DataObject obj, String fieldName, Calendar value) throws TransformException {
        obj.setField(fieldName, (Object)value);
    }

    public static void objSetISODate(DataObject obj, int fieldIndex, Calendar value) throws TransformException {
        obj.setField(fieldIndex, (Object)value);
    }

    public static Variant objGetVariant(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetVariant(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static BigDecimal objGetBigDecimal(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetBigDecimal(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static Variant objGetVariant(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return Parsing.toVariant(value, obj.getFieldDesignerType(fieldIndex));
    }

    public static BigDecimal objGetBigDecimal(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return DataObjectFunctions.toBigDecimal(value, obj, fieldIndex);
    }

    private static BigDecimal toBigDecimal(Object value, DataObject obj, int fieldIndex) throws TransformException {
        try {
            return (BigDecimal)value;
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return null;
        }
    }

    public static void objSetVariant(DataObject obj, int fieldIndex, Variant value) throws TransformException {
        obj.setField(fieldIndex, value.getValue());
    }

    public static void objSetVariant(DataObject obj, String fieldName, Variant value) throws TransformException {
        obj.setField(fieldName, value.getValue());
    }

    public static void objSetBigDecimal(DataObject obj, String fieldName, BigDecimal value) throws TransformException {
        obj.setField(fieldName, (Object)value);
    }

    public static void objSetBigDecimal(DataObject obj, int fieldIndex, BigDecimal value) throws TransformException {
        obj.setField(fieldIndex, (Object)value);
    }

    public static ScaledDecimal objGetScaledDecimal(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetScaledDecimal(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static ScaledDecimal objGetScaledDecimal(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return DataObjectFunctions.toScaledDecimal(value, obj, fieldIndex);
    }

    private static ScaledDecimal toScaledDecimal(Object value, DataObject obj, int fieldIndex) throws TransformException {
        try {
            return (ScaledDecimal)value;
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return null;
        }
    }

    public static void objSetScaledDecimal(DataObject obj, String fieldName, ScaledDecimal value) throws TransformException {
        obj.setField(fieldName, (Object)value);
    }

    public static void objSetScaledDecimal(DataObject obj, int fieldIndex, ScaledDecimal value) throws TransformException {
        obj.setField(fieldIndex, (Object)value);
    }

    public static BigInteger objGetBigInteger(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetBigInteger(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static BigInteger objGetBigInteger(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return DataObjectFunctions.toBigInteger(value, obj, fieldIndex);
    }

    private static BigInteger toBigInteger(Object value, DataObject obj, int fieldIndex) throws TransformException {
        try {
            return (BigInteger)value;
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return null;
        }
    }

    public static void objSetBigInteger(DataObject obj, String fieldName, BigInteger value) throws TransformException {
        obj.setField(fieldName, (Object)value);
    }

    public static void objSetBigInteger(DataObject obj, int fieldIndex, BigInteger value) throws TransformException {
        obj.setField(fieldIndex, (Object)value);
    }

    public static byte[] objGetBinary(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetBinary(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static byte[] objGetBinary(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return DataObjectFunctions.toBinary(value, obj, fieldIndex);
    }

    private static byte[] toBinary(Object value, DataObject obj, int fieldIndex) throws TransformException {
        try {
            return (byte[])value;
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return null;
        }
    }

    public static void objSetBinary(DataObject obj, String fieldName, byte[] value) throws TransformException {
        obj.setField(fieldName, (Object)value);
    }

    public static void objSetBinary(DataObject obj, int fieldIndex, byte[] value) throws TransformException {
        obj.setField(fieldIndex, (Object)value);
    }

    public static boolean objGetBoolean(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetBoolean(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static boolean objGetBoolean(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return DataObjectFunctions.toBoolean(value, obj, fieldIndex);
    }

    private static boolean toBoolean(Object value, DataObject obj, int fieldIndex) throws TransformException {
        try {
            return (Boolean)value;
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return false;
        }
    }

    public static void objSetBoolean(DataObject obj, String fieldName, boolean value) throws TransformException {
        obj.setField(fieldName, (Object)Wrapper.box(value));
    }

    public static void objSetBoolean(DataObject obj, int fieldIndex, boolean value) throws TransformException {
        obj.setField(fieldIndex, (Object)Wrapper.box(value));
    }

    public static char objGetCharacter(DataObject obj, String fieldName) throws TransformException {
        return DataObjectFunctions.objGetCharacter(obj, DataObjectFunctions.getFieldIndex(obj, fieldName));
    }

    public static char objGetCharacter(DataObject obj, int fieldIndex) throws TransformException {
        Object value = obj.getField(fieldIndex);
        return DataObjectFunctions.toCharacter(value, obj, fieldIndex);
    }

    private static char toCharacter(Object value, DataObject obj, int fieldIndex) throws TransformException {
        try {
            return ((Character)value).charValue();
        }
        catch (Exception e) {
            DataObjectFunctions.handleFieldAccessException(obj, fieldIndex, e);
            return '\u0000';
        }
    }

    public static void objSetCharacter(DataObject obj, String fieldName, char value) throws TransformException {
        obj.setField(fieldName, (Object)new Character(value));
    }

    public static void objSetCharacter(DataObject obj, int fieldIndex, char value) throws TransformException {
        obj.setField(fieldIndex, (Object)new Character(value));
    }

    public static int objGetFieldCount(DataObject obj) throws TransformException {
        return obj.getFieldCount();
    }

    public static DataObjectMetaInfo objGetMetaData(DataObject obj) throws TransformException {
        return obj.getMetaInfo();
    }

    public static DataObjectMetaInfo objGetSectionMetaData(DataObject obj, int index) throws TransformException {
        FieldMetaInfo fieldMetaInfo = obj.getMetaInfo().getFieldMetaInfo(index);
        return DataObjectFunctions.objGetSectionMetaData(fieldMetaInfo);
    }

    public static DataObjectMetaInfo objGetSectionMetaData(DataObjectMetaInfo obj, int index) throws TransformException {
        FieldMetaInfo fieldMetaInfo = obj.getFieldMetaInfo(index);
        return DataObjectFunctions.objGetSectionMetaData(fieldMetaInfo);
    }

    public static DataObjectMetaInfo objGetSectionMetaData(DataObjectMetaInfo obj, String fieldName) throws TransformException {
        FieldMetaInfo fieldMetaInfo = obj.getFieldMetaInfo(fieldName);
        return DataObjectFunctions.objGetSectionMetaData(fieldMetaInfo);
    }

    public static DataObjectMetaInfo objGetSectionMetaData(DataObject obj, String fieldName) throws TransformException {
        FieldMetaInfo fieldMetaInfo = obj.getMetaInfo().getFieldMetaInfo(fieldName);
        return DataObjectFunctions.objGetSectionMetaData(fieldMetaInfo);
    }

    private static DataObjectMetaInfo objGetSectionMetaData(FieldMetaInfo fieldMetaInfo) {
        if (fieldMetaInfo instanceof SectionMetaInfo) {
            SectionMetaInfo sectionMetaInfo = (SectionMetaInfo)fieldMetaInfo;
            DataObjectMetaInfo dataObjectMetaInfo = sectionMetaInfo.getDataObjectMetaInfo();
            return dataObjectMetaInfo;
        }
        return null;
    }

    public static int objGetFieldCount(DataObjectMetaInfo obj) throws TransformException {
        return obj.getFieldCount();
    }

    public static int objGetFieldIndex(DataObject obj, String fieldName) throws TransformException {
        return obj.getMetaInfo().getFieldIndexIfExists(fieldName);
    }

    public static int objGetFieldIndex(DataObjectMetaInfo obj, String fieldName) throws TransformException {
        return obj.getFieldIndexIfExists(fieldName);
    }

    public static String objGetFieldName(DataObject obj, int fieldIndex) throws TransformException {
        try {
            return obj.getFieldName(fieldIndex);
        }
        catch (FieldNotFoundException e) {
            return "";
        }
    }

    public static String objGetFieldName(DataObjectMetaInfo obj, int fieldIndex) throws TransformException {
        try {
            return obj.getFieldName(fieldIndex);
        }
        catch (FieldNotFoundException e) {
            return "";
        }
    }

    public static String objGetFieldType(DataObject obj, int fieldIndex) throws TransformException {
        try {
            return obj.getFieldType(fieldIndex);
        }
        catch (FieldNotFoundException e) {
            return "";
        }
    }

    public static boolean objIsFieldOptional(DataObject obj, int fieldIndex) throws TransformException {
        try {
            return obj.getMetaInfo().getFieldMetaInfo(fieldIndex).isOptional();
        }
        catch (FieldNotFoundException e) {
            return false;
        }
    }

    public static String objGetFieldType(DataObject obj, String fieldIndex) throws TransformException {
        try {
            return obj.getFieldType(fieldIndex);
        }
        catch (FieldNotFoundException e) {
            return "";
        }
    }

    public static String objGetFieldType(DataObjectMetaInfo obj, int fieldIndex) throws TransformException {
        try {
            return obj.getFieldType(fieldIndex);
        }
        catch (FieldNotFoundException e) {
            return "";
        }
    }

    public static String objGetFieldId(DataObject obj, int fieldIndex) throws TransformException {
        try {
            return obj.getFieldID(fieldIndex);
        }
        catch (FieldNotFoundException e) {
            return "";
        }
    }

    public static String objGetFieldId(DataObject obj, String name) throws TransformException {
        try {
            return obj.getFieldID(obj.getMetaInfo().getFieldIndex(name));
        }
        catch (FieldNotFoundException e) {
            return "";
        }
    }

    public static String objGetFieldId(DataObject obj) throws TransformException {
        try {
            return obj.getID();
        }
        catch (FieldNotFoundException e) {
            return "";
        }
    }

    public static String objGetFieldId(DataObjectSection obj) throws TransformException {
        try {
            return obj.getID();
        }
        catch (FieldNotFoundException e) {
            return "";
        }
    }

    public static String toText(DataObject obj) throws TransformException {
        if (obj != null) {
            return obj.toXMLString();
        }
        return "null";
    }

    public static String toText(DataObjectSection sec) throws TransformException {
        if (sec != null) {
            return sec.toXMLString();
        }
        return "null";
    }

    public static void fromText(DataObject obj, String text) throws TransformException {
        if (obj != null) {
            DataObjectXML.fromXML(obj, new StringReader(text));
        }
    }

    private static void handleException(Throwable e) throws TransformException {
        Throwable targetException;
        if (e instanceof InvocationTargetException && (targetException = ((InvocationTargetException)e).getTargetException()) instanceof TransformException) {
            throw (TransformException)targetException;
        }
        throw new TransformException("Unexpected error", e);
    }

    public static String toJSON(DataObject obj) throws TransformException {
        if (obj != null) {
            return JSONFunctions.serialize(obj);
        }
        return "null";
    }

    public static String toJSON(DataObjectSection obj) throws TransformException {
        if (obj != null) {
            return JSONFunctions.serialize(obj);
        }
        return "null";
    }

    public static void fromJSON(DataObject obj, String jsonText) throws TransformException {
        if (obj != null) {
            JSONFunctions.parse(obj, jsonText);
        }
    }

    public static void fromJSON(DataObjectSection obj, String jsonText) throws TransformException {
        if (obj != null) {
            JSONFunctions.parse(obj, jsonText);
        }
    }

    public static boolean equal(DataObject obj1, DataObject obj2) {
        return obj1 == obj2;
    }

    public static boolean notEqual(DataObject obj1, DataObject obj2) {
        return obj1 != obj2;
    }

    public static void addComment(DataObject obj, int fieldIndex, String comment) {
        LocationInfo locationInfo = obj.getLocationInfo();
        locationInfo.addComment(fieldIndex, comment);
    }

    public static void addComment(DataObject obj, String fieldName, String comment) {
        LocationInfo locationInfo = obj.getLocationInfo();
        locationInfo.addComment(obj.getFieldIndex(fieldName), comment);
    }

    public static void addComment(DataObject obj, String comment) {
        LocationInfo locationInfo = obj.getLocationInfo();
        locationInfo.addComment(comment);
    }

    public static StringList getComments(DataObject obj, int fieldIndex) {
        LocationInfo locationInfo = obj.getLocationInfo();
        CommentInfo fieldComment = locationInfo.getComment(fieldIndex);
        if (fieldComment != null) {
            List comments = fieldComment.getComments();
            return new StringList(comments.toArray(new String[comments.size()]));
        }
        return new StringList();
    }

    public static StringList getComments(DataObject obj, String fieldIndex) {
        LocationInfo locationInfo = obj.getLocationInfo();
        CommentInfo fieldComment = locationInfo.getComment(fieldIndex);
        if (fieldComment != null) {
            List comments = fieldComment.getComments();
            return new StringList(comments.toArray(new String[comments.size()]));
        }
        return new StringList();
    }

    public static StringList getComments(DataObject obj) {
        LocationInfo locationInfo = obj.getLocationInfo();
        CommentInfo fieldComment = locationInfo.getComment();
        if (fieldComment != null) {
            List comments = fieldComment.getComments();
            return new StringList(comments.toArray(new String[comments.size()]));
        }
        return new StringList();
    }

    public static int getStartLine(DataObject obj) {
        Locator location;
        LocationInfo locationInfo = obj.getLocationInfo();
        if (locationInfo != null && (location = locationInfo.getLocation()) != null) {
            return location.getLine();
        }
        return -1;
    }

    public static int getStartColumn(DataObject obj) {
        Locator location;
        LocationInfo locationInfo = obj.getLocationInfo();
        if (locationInfo != null && (location = locationInfo.getLocation()) != null) {
            return location.getColumn();
        }
        return -1;
    }

    public static int getEndLine(DataObject obj) {
        Locator location;
        LocationInfo locationInfo = obj.getLocationInfo();
        if (locationInfo != null && (location = locationInfo.getLocation()) != null) {
            return location.getEndLine();
        }
        return -1;
    }

    public static int getEndColumn(DataObject obj) {
        Locator location;
        LocationInfo locationInfo = obj.getLocationInfo();
        if (locationInfo != null && (location = locationInfo.getLocation()) != null) {
            return location.getEndColumn();
        }
        return -1;
    }

    public static int getStartLine(DataObject obj, int fieldIndexOrName) {
        Locator location;
        LocationInfo locationInfo = obj.getLocationInfo();
        if (locationInfo != null && (location = locationInfo.getFieldLocation(fieldIndexOrName)) != null) {
            return location.getLine();
        }
        return -1;
    }

    public static int getStartLine(DataObject obj, String fieldIndexOrName) {
        Locator location;
        LocationInfo locationInfo = obj.getLocationInfo();
        if (locationInfo != null && (location = locationInfo.getFieldLocation(fieldIndexOrName)) != null) {
            return location.getLine();
        }
        return -1;
    }

    public static String getFieldAt(DataObject obj, int line, int column) {
        String fieldId = DataObjectFunctions.getFieldAt0(obj, line, column);
        if (fieldId == null) {
            fieldId = "";
        }
        return fieldId;
    }

    private static String getFieldAt0(DataObject obj, int line, int column) {
        int fieldCount = obj.getFieldCount();
        LocationInfo locationInfo = obj.getLocationInfo();
        DataObjectMetaInfo dataObjectMetaInfo = obj.getMetaInfo();
        for (int i = 0; i < fieldCount; ++i) {
            Locator locator;
            if (dataObjectMetaInfo.isSection(i)) {
                DataObject subObj;
                String fieldId;
                Object fieldObj = obj.getField(i);
                if (fieldObj instanceof DataObjectSection) {
                    DataObjectSection sec = (DataObjectSection)fieldObj;
                    for (int j = 0; j < sec.getElementCount(); ++j) {
                        DataObject subObj2 = sec.getElement(j);
                        String fieldId2 = DataObjectFunctions.getFieldAt0(subObj2, line, column);
                        if (fieldId2 == null) continue;
                        return fieldId2;
                    }
                }
                if (fieldObj instanceof DataObject && (fieldId = DataObjectFunctions.getFieldAt0(subObj = (DataObject)fieldObj, line, column)) != null) {
                    return fieldId;
                }
            }
            if ((locator = locationInfo.getFieldLocation(i)) == null || !DataObjectFunctions.contains(locator, line, column)) continue;
            return obj.getFieldID(i);
        }
        return null;
    }

    private static boolean contains(Locator locator, int line, int column) {
        if (DataObjectFunctions.after(locator, line, column)) {
            if (DataObjectFunctions.before(locator, line, column)) {
                return true;
            }
            if (locator.getEndLine() == -1 && locator.getLine() == line) {
                return true;
            }
        }
        return false;
    }

    static boolean after(Locator locator, int line, int column) {
        if (locator.getLine() < line) {
            return true;
        }
        if (locator.getLine() == line) {
            return locator.getColumn() == -1 || locator.getColumn() <= column;
        }
        return false;
    }

    static boolean before(Locator locator, int line, int column) {
        if (locator.getEndLine() > line) {
            return true;
        }
        if (locator.getEndLine() == line) {
            return locator.getEndColumn() == -1 || locator.getEndColumn() > column;
        }
        return false;
    }

    public static String fieldIdToFieldName(String fieldId) {
        return new FieldId(fieldId).getQualifiedFieldName();
    }

    public static int length(String fieldId) {
        return new FieldId(fieldId).length();
    }

    public static boolean fieldIdEquals(String fieldId1, String fieldId2) {
        return new FieldId(fieldId1).equals(new FieldId(fieldId2));
    }

    public static String getCanonicalFieldId(String fieldId) {
        return new FieldId(fieldId).getFieldId();
    }

    public static String getParent(String fieldId1) {
        return new FieldId(fieldId1).getParentFieldId().toString();
    }

    public static String getComponentName(String fieldId, int index) {
        return new FieldId(fieldId).getFieldNameAt(index).toString();
    }

    public static int getComponentIndex(String fieldId, int index) {
        return new FieldId(fieldId).getFieldIndexAt(index);
    }

    public static void setExceptionProperty(DataObject obj, String name, String value) {
        ExceptionObject ex = (ExceptionObject)obj;
        ex.setContextProperty(name, value);
    }

    public static String getExceptionProperty(DataObject obj, String name) {
        ExceptionObject ex = (ExceptionObject)obj;
        Object value = ex.getContextProperty(name);
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    public static TransformException getBatchException(DataObject record) {
        if (record != null) {
            TransformException toRet = (TransformException)record.getProperty("cascaded-exceptions");
            return toRet;
        }
        return null;
    }

    public static DataObject getBatchObject(DataObject record) {
        DataObject toRet = (DataObject)record.getProperty("batch-object");
        return toRet;
    }

    public static String getBatchSection(DataObject record) {
        String toRet = (String)record.getProperty("batch-section");
        return toRet;
    }

    public static String getBatchCallbackType(DataObject record) {
        String toRet = (String)record.getProperty("event-type");
        return toRet;
    }

    public static DataObjectSection getCascadedExceptions(DataObject obj) {
        TransformException transformException = DataObjectFunctions.toTransformException(obj);
        return transformException.getExceptions();
    }

    public static void addCascadedExceptions(DataObject obj, DataObject toAdd) {
        TransformException e = DataObjectFunctions.toTransformException(obj);
        if (toAdd instanceof TransformException) {
            TransformException e2 = (TransformException)toAdd;
            e.addAll(e2);
            return;
        }
        if (toAdd instanceof ExceptionObject) {
            e.addExceptionObject((ExceptionObject)toAdd);
        }
        throw TransformRuntimeException.createFormatted("SRT594");
    }

    public static void removeCascadedExceptions(DataObject obj, DataObject toAdd) {
        TransformException e = DataObjectFunctions.toTransformException(obj);
        if (toAdd instanceof TransformException) {
            TransformException e2 = (TransformException)toAdd;
            e.removeAll(e2);
            return;
        }
        if (toAdd instanceof ExceptionObject) {
            e.removeExceptionObject((ExceptionObject)toAdd);
        }
        throw TransformRuntimeException.createFormatted("SRT594");
    }

    private static TransformException toTransformException(DataObject obj) {
        if (obj instanceof ExceptionObject && !(obj instanceof TransformException)) {
            return new TransformException((ExceptionObject)obj);
        }
        if (obj instanceof TransformException) {
            return (TransformException)obj;
        }
        throw TransformRuntimeException.createFormatted("SRT594");
    }

    public static TransformException createException(String message) {
        TransformException transformException = new TransformException(message);
        return transformException;
    }

    public static void throwException(DataObject e) throws TransformException {
        throw DataObjectFunctions.toTransformException(e);
    }

    public static String fieldIdToXPath(DataObject root, String fieldIdName) {
        return DataObjectXPathUtil.fieldIdToXPath(root, fieldIdName);
    }

    public static String fieldIdToXPath(DataObject root, String fieldIdName, int options) {
        return DataObjectXPathUtil.fieldIdToXPath(root, fieldIdName, options);
    }

    public static void cmtmain(String[] args) throws FieldNullException {
        TransformException ex = new TransformException("XXXX");
        TransformException exNO = new TransformException("XXXX");
        ex.setFieldID("F");
        DataObjectSection inputExceptions = DataObjectFunctions.getCascadedExceptions(ex);
        DataObjectSection noExceptions = DataObjectFunctions.getCascadedExceptions(exNO);
        for (int i = 0; i < noExceptions.getElementCount(); ++i) {
            DataObject exElm = noExceptions.getElement(i);
            if (!exElm.isNull(6)) continue;
            String fieldId = (String)exElm.getFieldCheckNull(6);
            System.out.println(fieldId);
            DataObject inEx = inputExceptions.getElement(i);
            if (inEx.isNull(6)) continue;
            String _tmpCustom2Code0000inFieldId = (String)inEx.getFieldCheckNull(6);
        }
    }

    static class JSONFunctions {
        static Class jsonClass;

        JSONFunctions() {
        }

        public static String serialize(DataObject obj) throws TransformException {
            try {
                Class cls = JSONFunctions.getJSONClass();
                Method serialize = cls.getMethod("serialize", DataObject.class);
                String text = (String)serialize.invoke(null, obj);
                return text;
            }
            catch (ClassNotFoundException e) {
                throw JSONFunctions.toTransformException(e);
            }
            catch (NoSuchMethodException e) {
                throw JSONFunctions.toTransformException(e);
            }
            catch (InvocationTargetException e) {
                throw JSONFunctions.toTransformException(e.getTargetException());
            }
            catch (IllegalAccessException e) {
                throw JSONFunctions.toTransformException(e);
            }
        }

        public static String serialize(DataObjectSection obj) throws TransformException {
            try {
                Class cls = JSONFunctions.getJSONClass();
                Method serialize = cls.getMethod("serialize", DataObjectSection.class);
                String text = (String)serialize.invoke(null, obj);
                return text;
            }
            catch (ClassNotFoundException e) {
                throw JSONFunctions.toTransformException(e);
            }
            catch (NoSuchMethodException e) {
                throw JSONFunctions.toTransformException(e);
            }
            catch (InvocationTargetException e) {
                throw JSONFunctions.toTransformException(e.getTargetException());
            }
            catch (IllegalAccessException e) {
                throw JSONFunctions.toTransformException(e);
            }
        }

        private static TransformException toTransformException(Throwable e) {
            if (e instanceof TransformException) {
                return (TransformException)e;
            }
            return new TransformException(e.getMessage(), e);
        }

        public static void parse(DataObject obj, String jsonText) throws TransformException {
            try {
                Class cls = JSONFunctions.getJSONClass();
                Method parse = cls.getMethod("parse", DataObject.class, String.class);
                parse.invoke(null, obj, jsonText);
            }
            catch (ClassNotFoundException e) {
                throw JSONFunctions.toTransformException(e);
            }
            catch (NoSuchMethodException e) {
                throw JSONFunctions.toTransformException(e);
            }
            catch (InvocationTargetException e) {
                throw JSONFunctions.toTransformException(e.getTargetException());
            }
            catch (IllegalAccessException e) {
                throw JSONFunctions.toTransformException(e);
            }
        }

        public static void parse(DataObjectSection obj, String jsonText) throws TransformException {
            try {
                Class cls = JSONFunctions.getJSONClass();
                Method parse = cls.getMethod("parse", DataObjectSection.class, String.class);
                parse.invoke(null, obj, jsonText);
            }
            catch (ClassNotFoundException e) {
                throw JSONFunctions.toTransformException(e);
            }
            catch (NoSuchMethodException e) {
                throw JSONFunctions.toTransformException(e);
            }
            catch (InvocationTargetException e) {
                throw JSONFunctions.toTransformException(e.getTargetException());
            }
            catch (IllegalAccessException e) {
                throw JSONFunctions.toTransformException(e);
            }
        }

        private static Class getJSONClass() throws ClassNotFoundException {
            if (jsonClass == null) {
                jsonClass = MessageFunctions.loadClass("com.tplus.transform.runtime.json.MessageJSONSupport");
            }
            return jsonClass;
        }
    }
}

