/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.ExternalObject;
import com.tplus.transform.runtime.FieldId;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.SectionMetaInfo;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.xml.XMLFieldType;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.xml.QName;
import java.util.ArrayList;
import java.util.List;

public class DataObjectXPathUtil {
    private static final int THROW_ERROR = 4;
    private static final int USE_NAMESPACE = 8;
    private static final int DO_INCLUDE_DATA = 2;

    public static String fieldIdToXPath(DataObject root, String fieldIdName) {
        return DataObjectXPathUtil.fieldIdToXPath(root, fieldIdName, 0);
    }

    public static String fieldIdToXPath(DataObject root, String fieldIdName, int options) {
        XPathNodes.XPathNodeInfo xpathFieldInfo;
        QName qNameShared;
        DataObject externalObject;
        FieldId fieldId = new FieldId(fieldIdName);
        ArrayList<XPathNodes.XPathNodeInfo> xPathComponents = new ArrayList<XPathNodes.XPathNodeInfo>();
        if (root instanceof ExternalObject) {
            externalObject = (ExternalObject)root;
            root = DataObjectXPathUtil.getExternalObjectComponent((ExternalObject)externalObject, fieldId);
            qNameShared = externalObject.getQNameShared();
            xpathFieldInfo = new XPathNodes.XPathNodeInfo(qNameShared, 0, false);
            xPathComponents.add(xpathFieldInfo);
            if (!DataObjectXPathUtil.isXMLMessage((ExternalObject)externalObject) && (options & 2) != 0) {
                QName dataQName = root.getXMLQName();
                xPathComponents.add(new XPathNodes.XPathNodeInfo(dataQName, 0, false));
            }
        } else if (root instanceof NormalizedObject) {
            externalObject = (NormalizedObject)root;
            qNameShared = externalObject.getXMLQName();
            xpathFieldInfo = new XPathNodes.XPathNodeInfo(qNameShared, 0, false);
            xPathComponents.add(xpathFieldInfo);
        }
        DataObjectMetaInfo currentDataObjectMetaInfo = root.getMetaInfo();
        int levels = fieldId.getFieldLevels();
        for (int i = 0; i < levels; ++i) {
            String fieldNameAt = fieldId.getFieldNameAt(i);
            int index = (options & 4) != 0 ? currentDataObjectMetaInfo.getFieldIndex(fieldNameAt) : currentDataObjectMetaInfo.getFieldIndexIfExists(fieldNameAt);
            if (index == -1) break;
            FieldMetaInfo fieldMetaInfo = currentDataObjectMetaInfo.getFieldMetaInfo(index);
            QName qNameShared2 = fieldMetaInfo.getQNameShared();
            XMLFieldType xmlTypeShared = fieldMetaInfo.getXMLTypeShared();
            int sectionIndex = fieldId.getFieldIndexAt(i);
            boolean section = fieldMetaInfo instanceof SectionMetaInfo;
            if (xmlTypeShared == XMLFieldType.ELEMENT || xmlTypeShared == XMLFieldType.ATTRIBUTE) {
                int xpathIndex = section ? sectionIndex + 1 : 0;
                XPathNodes.XPathNodeInfo xpathFieldInfo2 = new XPathNodes.XPathNodeInfo(qNameShared2, xpathIndex, xmlTypeShared == XMLFieldType.ATTRIBUTE);
                xPathComponents.add(xpathFieldInfo2);
            }
            if (fieldMetaInfo instanceof SectionMetaInfo) {
                SectionMetaInfo sectionMetaInfo = (SectionMetaInfo)fieldMetaInfo;
                currentDataObjectMetaInfo = sectionMetaInfo.getDataObjectMetaInfo();
                continue;
            }
            if (i >= levels - 1) continue;
            if ((options & 4) != 0) {
                throw new TransformRuntimeException("Unexpected path component " + fieldId.getFieldNameAt(i + 1) + " in " + fieldIdName);
            }
            return "";
        }
        return new XPathNodes(xPathComponents).getFullPath('/', options);
    }

    private static boolean isXMLMessage(ExternalObject externalObject) {
        return !externalObject.getQNameShared().equals(externalObject.getMetaInfo().getXMLQName());
    }

    private static DataObject getExternalObjectComponent(ExternalObject externalObject, FieldId fieldId) {
        DataObject data = externalObject.getData();
        String firstFieldName = fieldId.getFieldNameAt(0);
        if (data.getMetaInfo().getFieldMetaInfoOrNull(firstFieldName) != null) {
            return data;
        }
        DataObject header = externalObject.getHeader();
        if (header.getMetaInfo().getFieldMetaInfoOrNull(firstFieldName) != null) {
            return header;
        }
        DataObject trailer = externalObject.getTrailer();
        if (trailer.getMetaInfo().getFieldMetaInfoOrNull(firstFieldName) != null) {
            return trailer;
        }
        return data;
    }

    public static class XPathNodes {
        private List nodes;

        public XPathNodes(List nodes) {
            this.nodes = nodes;
        }

        public String getFullPath(char separator, int options) {
            boolean useNameSpace = (options & 8) != 0;
            StringBuffer toRet = new StringBuffer();
            for (int i = 0; i < this.nodes.size(); ++i) {
                XPathNodeInfo fieldNodeInfo = (XPathNodeInfo)this.nodes.get(i);
                QName name = fieldNodeInfo.getName();
                if (toRet.length() > 0) {
                    toRet.append(separator);
                }
                if (fieldNodeInfo.attribute) {
                    toRet.append("@");
                }
                String fullName = useNameSpace ? name.toString() : (StringUtils.isEmpty(name.getPrefix()) ? name.getLocalPart() : name.getPrefix() + ":" + name.getLocalPart());
                toRet.append(fullName);
                if (!fieldNodeInfo.isIndexSpecified()) continue;
                toRet.append('[');
                toRet.append(fieldNodeInfo.getIndexValue());
                toRet.append(']');
            }
            return toRet.toString();
        }

        public static class XPathNodeInfo {
            private QName name;
            private int indexValue;
            boolean attribute;

            public XPathNodeInfo(QName name, int indexValue) {
                this(name, indexValue, false);
            }

            public XPathNodeInfo(QName name, int indexValue, boolean attribute) {
                this.name = name;
                this.indexValue = indexValue;
                this.attribute = attribute;
            }

            public boolean isIndexSpecified() {
                return this.indexValue > 0;
            }

            public int getIndexValue() {
                return this.indexValue;
            }

            public void setIndexValue(int index) {
                this.indexValue = index;
            }

            public QName getName() {
                return this.name;
            }

            public boolean equals(Object other) {
                if (other instanceof XPathNodeInfo) {
                    XPathNodeInfo otherInfo = (XPathNodeInfo)other;
                    if (this.name.equals(otherInfo.name) && this.indexValue == otherInfo.indexValue) {
                        return true;
                    }
                }
                return false;
            }
        }
    }
}

