/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.IDisposable;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.PersistenceManager;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.formula.LookupHelper;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import java.rmi.RemoteException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;

public class DatabaseFunctions
implements IDisposable {
    private static final String DATASOURCE_NAME = "datasource.name";
    private static final String PERSISTENCE_MANAGER_SUFFIX = "PM";
    private static final String SRT_553 = "SRT553";
    private static final String SRT_554 = "SRT554";
    private static final String SRT_557 = "SRT557";
    private static final String SRT_558 = "SRT558";
    private static final String SRT_559 = "SRT559";
    private List statements = new ArrayList();
    private Connection connection;
    private ConnectionPool connectionPool;
    static int openStatements = 0;

    static void log(String str) {
    }

    protected Statement createStatement(String dataSource) throws TransformException {
        return this.createStatement(dataSource, true);
    }

    protected Statement createStatement(String dataSource, boolean scrollable) throws TransformException {
        try {
            this.getConnection(dataSource);
            Statement statement = null;
            statement = scrollable ? this.connection.createStatement(1004, 1007) : this.connection.createStatement();
            this.statements.add(statement);
            DatabaseFunctions.incrementOpenStatements();
            return statement;
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_553);
            te.setDetail(e);
            throw te;
        }
    }

    protected PreparedStatement createPreparedStatement(String dataSource, String sql, boolean scrollable) throws TransformException {
        try {
            this.getConnection(dataSource);
            PreparedStatement statement = null;
            statement = scrollable ? this.connection.prepareStatement(sql, 1004, 1007) : this.connection.prepareStatement(sql);
            this.statements.add(statement);
            DatabaseFunctions.incrementOpenStatements();
            return statement;
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_553);
            te.setDetail(e);
            throw te;
        }
    }

    protected CallableStatement createCallableStatement(String dataSource, String sql, boolean scrollable) throws TransformException {
        try {
            this.getConnection(dataSource);
            CallableStatement statement = null;
            statement = scrollable ? this.connection.prepareCall(sql, 1004, 1007) : this.connection.prepareCall(sql);
            this.statements.add(statement);
            DatabaseFunctions.incrementOpenStatements();
            return statement;
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_553);
            te.setDetail(e);
            throw te;
        }
    }

    private static void incrementOpenStatements() {
        ++openStatements;
    }

    private static void decrementOpenStatements() {
        --openStatements;
    }

    public ConnectionPool getConnectionPool(String dataSource) throws TransformException {
        try {
            return LookupHelper.getLookupContext().lookupDataSource(dataSource);
        }
        catch (Exception e) {
            TransformException te = TransformException.createFormatted("SRT565", dataSource);
            te.setDetail(e);
            throw te;
        }
    }

    public Connection getConnection(String dataSource) throws TransformException, SQLException {
        if (this.connection == null) {
            this.connectionPool = this.getConnectionPool(dataSource);
            this.connection = this.connectionPool.getConnection();
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        block11: {
            try {
                if (this.statements.size() > 0) {
                    for (int i = 0; i < this.statements.size(); ++i) {
                        Statement statement = (Statement)this.statements.get(i);
                        DatabaseFunctions.decrementOpenStatements();
                        DatabaseFunctions.log("Statement closed open = " + openStatements + " Identity = " + statement.hashCode());
                        try {
                            statement.close();
                            continue;
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
                if (this.connection == null) break block11;
                try {
                    this.connectionPool.commit(this.connection);
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    this.connectionPool.releaseConnection(this.connection);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            finally {
                this.statements.clear();
                this.connection = null;
            }
        }
    }

    protected void finalize() {
        this.dispose();
    }

    public ResultSet dbQuery(String dataSource, String sql) throws TransformException {
        Statement stmt = this.createStatement(dataSource);
        try {
            ResultSet rs = stmt.executeQuery(sql);
            return rs;
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_554, sql);
            te.setDetail(e);
            throw te;
        }
    }

    public static void dbExecute(String dataSource, String sql) throws TransformException {
        DatabaseFunctions databaseFunctions = new DatabaseFunctions();
        Statement stmt = databaseFunctions.createStatement(dataSource);
        try {
            stmt.execute(sql);
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_554, sql);
            te.setDetail(e);
            throw te;
        }
        finally {
            databaseFunctions.dispose();
        }
    }

    public static void dbExecute(String dataSource, String sql, Object[] params) throws TransformException {
        DatabaseFunctions databaseFunctions = new DatabaseFunctions();
        PreparedStatement stmt = databaseFunctions.createPreparedStatement(dataSource, sql, false);
        try {
            DatabaseFunctions.populateStatement(stmt, params);
            stmt.execute();
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_554, sql);
            te.setDetail(e);
            throw te;
        }
        finally {
            databaseFunctions.dispose();
        }
    }

    public static int dbUpdate(String dataSource, String sql, Object[] params) throws TransformException {
        DatabaseFunctions databaseFunctions = new DatabaseFunctions();
        PreparedStatement stmt = databaseFunctions.createPreparedStatement(dataSource, sql, false);
        try {
            int count;
            DatabaseFunctions.populateStatement(stmt, params);
            int n = count = stmt.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_554, sql);
            te.setDetail(e);
            throw te;
        }
        finally {
            databaseFunctions.dispose();
        }
    }

    static void populateStatement(PreparedStatement stmt, Object[] params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            Object sqlParam = DatabaseFunctions.designerToSQLType(param);
            if (sqlParam == null) continue;
            stmt.setObject(i + 1, sqlParam);
        }
    }

    public static Object designerToSQLType(Object param) {
        if (param == null) {
            return param;
        }
        if (param instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)param;
            boolean time = Parsing.hasTimePart(date);
            boolean dt = Parsing.hasDatePart(date);
            java.util.Date toRet = dt && time ? new Timestamp(date.getTime()) : (time ? new Time(date.getTime()) : new Date(date.getTime()));
            return toRet;
        }
        if (param instanceof Character) {
            Character character = (Character)param;
            return character + "";
        }
        return param;
    }

    public static int dbExecuteUpdate(String dataSource, String sql) throws TransformException {
        DatabaseFunctions databaseFunctions = new DatabaseFunctions();
        Statement stmt = databaseFunctions.createStatement(dataSource);
        try {
            int n = stmt.executeUpdate(sql);
            return n;
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_554, sql);
            te.setDetail(e);
            throw te;
        }
        finally {
            databaseFunctions.dispose();
        }
    }

    public static int dbExecuteUpdate(String dataSource, String sql, Object[] params) throws TransformException {
        DatabaseFunctions databaseFunctions = new DatabaseFunctions();
        PreparedStatement stmt = databaseFunctions.createPreparedStatement(dataSource, sql, false);
        try {
            DatabaseFunctions.populateStatement(stmt, params);
            int n = stmt.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_554, sql);
            te.setDetail(e);
            throw te;
        }
        finally {
            databaseFunctions.dispose();
        }
    }

    private static void adjustResultSet(ResultSet resultSet, boolean validate) throws TransformException, SQLException {
        if (resultSet.isBeforeFirst() && !resultSet.next()) {
            throw TransformException.createFormatted("SRT555");
        }
        if (resultSet.isAfterLast()) {
            throw TransformException.createFormatted("SRT556");
        }
    }

    public static int dbGetInt(ResultSet resultSet) throws TransformException {
        return DatabaseFunctions.dbGetInt(resultSet, 1);
    }

    public static int dbGetInt(ResultSet resultSet, int index) throws TransformException {
        try {
            DatabaseFunctions.adjustResultSet(resultSet, true);
            return resultSet.getInt(index);
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_557, String.valueOf(index));
            te.setDetail(e);
            throw te;
        }
    }

    public static int dbGetInt(ResultSet resultSet, String fieldName) throws TransformException {
        try {
            DatabaseFunctions.adjustResultSet(resultSet, true);
            return resultSet.getInt(fieldName);
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_558, fieldName);
            te.setDetail(e);
            throw te;
        }
    }

    public static double dbGetDouble(ResultSet resultSet) throws TransformException {
        return DatabaseFunctions.dbGetDouble(resultSet, 1);
    }

    public static double dbGetDouble(ResultSet resultSet, int index) throws TransformException {
        try {
            DatabaseFunctions.adjustResultSet(resultSet, true);
            return resultSet.getDouble(index);
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_557, String.valueOf(index));
            te.setDetail(e);
            throw te;
        }
    }

    public static double dbGetDouble(ResultSet resultSet, String fieldName) throws TransformException {
        try {
            DatabaseFunctions.adjustResultSet(resultSet, true);
            return resultSet.getDouble(fieldName);
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_558, fieldName);
            te.setDetail(e);
            throw te;
        }
    }

    public static String dbGetString(ResultSet resultSet) throws TransformException {
        return DatabaseFunctions.dbGetString(resultSet, 1);
    }

    public static String dbGetString(ResultSet resultSet, int index) throws TransformException {
        try {
            DatabaseFunctions.adjustResultSet(resultSet, true);
            return resultSet.getString(index);
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_557, String.valueOf(index));
            te.setDetail(e);
            throw te;
        }
    }

    public static String dbGetString(ResultSet resultSet, String fieldName) throws TransformException {
        try {
            DatabaseFunctions.adjustResultSet(resultSet, true);
            return resultSet.getString(fieldName);
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_558, fieldName);
            te.setDetail(e);
            throw te;
        }
    }

    public static java.util.Date dbGetDate(ResultSet resultSet) throws TransformException {
        return DatabaseFunctions.dbGetDate(resultSet, 1);
    }

    public static java.util.Date dbGetDate(ResultSet resultSet, int index) throws TransformException {
        try {
            DatabaseFunctions.adjustResultSet(resultSet, true);
            Date date = resultSet.getDate(index);
            if (date != null) {
                return new java.util.Date(date.getTime());
            }
            return null;
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_557, String.valueOf(index));
            te.setDetail(e);
            throw te;
        }
    }

    public static java.util.Date dbGetDate(ResultSet resultSet, String fieldName) throws TransformException {
        try {
            DatabaseFunctions.adjustResultSet(resultSet, true);
            Date date = resultSet.getDate(fieldName);
            if (date != null) {
                return new java.util.Date(date.getTime());
            }
            return null;
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_558, fieldName);
            te.setDetail(e);
            throw te;
        }
    }

    public static void dbNext(ResultSet resultSet) throws TransformException {
        try {
            DatabaseFunctions.adjustResultSet(resultSet, true);
            resultSet.next();
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_559);
            te.setDetail(e);
            throw te;
        }
    }

    public static void dbPrevious(ResultSet resultSet) throws TransformException {
        try {
            DatabaseFunctions.adjustResultSet(resultSet, false);
            resultSet.previous();
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_559);
            te.setDetail(e);
            throw te;
        }
    }

    public static void dbFirst(ResultSet resultSet) throws TransformException {
        try {
            resultSet.first();
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_559);
            te.setDetail(e);
            throw te;
        }
    }

    public static void dbLast(ResultSet resultSet) throws TransformException {
        try {
            resultSet.last();
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_559);
            te.setDetail(e);
            throw te;
        }
    }

    public static boolean dbHasNext(ResultSet resultSet) throws TransformException {
        try {
            if (resultSet.getRow() == 0) {
                if (resultSet.isBeforeFirst()) {
                    resultSet.next();
                } else {
                    return false;
                }
            }
            return !resultSet.isLast() && !resultSet.isAfterLast();
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_559);
            te.setDetail(e);
            throw te;
        }
    }

    public static int dbCountRecords(ResultSet resultSet) throws TransformException {
        try {
            int row = resultSet.getRow();
            resultSet.last();
            int maxRow = resultSet.getRow();
            resultSet.relative(row - maxRow);
            return maxRow;
        }
        catch (SQLException e) {
            TransformException te = TransformException.createFormatted(SRT_559);
            te.setDetail(e);
            throw te;
        }
    }

    private static TransformContext getTransformContext(String dataSource) throws NamingException {
        TransformContext cxt = LookupHelper.getTransformContextObject();
        if (dataSource != null) {
            cxt.setProperty(DATASOURCE_NAME, dataSource);
        }
        return cxt;
    }

    public static int dbCountSQLQueryMessage(String messageName, String sql) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbCountSQLQueryMessagePool(null, messageName, sql, new Object[0]);
    }

    public static int dbCountSQLQueryMessagePool(String dataSource, String messageName, String sql) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbCountSQLQueryMessagePool(dataSource, messageName, sql, new Object[0]);
    }

    public static int dbCountSQLQueryMessage(String messageName, String sql, Object[] params) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbCountSQLQueryMessagePool(null, messageName, sql, params);
    }

    public static int dbCountSQLQueryMessagePool(String dataSource, String messageName, String sql, Object[] params) throws TransformException, RemoteException, NamingException {
        PersistenceManager persistenceManager = LookupHelper.getLookupContext().lookupPersistenceManager(messageName + PERSISTENCE_MANAGER_SUFFIX);
        TransformContext cxt = DatabaseFunctions.getTransformContext(dataSource);
        return persistenceManager.countSQL(sql, params, cxt);
    }

    public static DataObjectSection dbSQLQueryMessage(String messageName, String sql) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbSQLQueryMessagePool(null, messageName, sql, new Object[0]);
    }

    public static DataObjectSection dbSQLQueryMessagePool(String dataSource, String messageName, String sql) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbSQLQueryMessagePool(dataSource, messageName, sql, new Object[0]);
    }

    public static DataObjectSection dbSQLQueryMessage(String messageName, String sql, Object[] params) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbSQLQueryMessagePool(null, messageName, sql, params);
    }

    public static DataObjectSection dbSQLQueryMessagePool(String dataSource, String messageName, String sql, Object[] params) throws TransformException, RemoteException, NamingException {
        PersistenceManager persistenceManager = LookupHelper.getLookupContext().lookupPersistenceManager(messageName + PERSISTENCE_MANAGER_SUFFIX);
        TransformContext cxt = DatabaseFunctions.getTransformContext(dataSource);
        return persistenceManager.findSQL(sql, params, cxt);
    }

    public static DataObjectSection dbSQLLimitQueryMessage(String messageName, String sql, int start, int count) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbSQLLimitQueryMessagePool(null, messageName, sql, start, count, new Object[0]);
    }

    public static DataObjectSection dbSQLLimitQueryMessagePool(String dataSource, String messageName, String sql, int start, int count) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbSQLLimitQueryMessagePool(dataSource, messageName, sql, start, count, new Object[0]);
    }

    public static DataObjectSection dbSQLLimitQueryMessage(String messageName, String sql, int start, int count, Object[] params) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbSQLLimitQueryMessagePool(null, messageName, sql, start, count, params);
    }

    public static DataObjectSection dbSQLLimitQueryMessagePool(String dataSource, String messageName, String sql, int start, int count, Object[] params) throws TransformException, RemoteException, NamingException {
        PersistenceManager persistenceManager = LookupHelper.getLookupContext().lookupPersistenceManager(messageName + PERSISTENCE_MANAGER_SUFFIX);
        TransformContext cxt = DatabaseFunctions.getTransformContext(dataSource);
        return persistenceManager.findSQL(sql, start, count, params, cxt);
    }

    public static DataObjectSection dbQueryMessage(String messageName, String queryName) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbQueryMessagePool(null, messageName, queryName, new Object[0]);
    }

    public static DataObjectSection dbQueryMessagePool(String dataSource, String messageName, String queryName) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbQueryMessagePool(dataSource, messageName, queryName, new Object[0]);
    }

    public static DataObjectSection dbQueryMessage(String messageName, String queryName, Object[] params) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbQueryMessagePool(null, messageName, queryName, params);
    }

    public static DataObjectSection dbQueryMessagePool(String dataSource, String messageName, String queryName, Object[] params) throws TransformException, RemoteException, NamingException {
        PersistenceManager persistenceManager = LookupHelper.getLookupContext().lookupPersistenceManager(messageName + PERSISTENCE_MANAGER_SUFFIX);
        TransformContext cxt = DatabaseFunctions.getTransformContext(dataSource);
        return persistenceManager.find(queryName, params, cxt);
    }

    public static DataObjectSection dbLimitQueryMessage(String messageName, String queryName, int start, int count) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbLimitQueryMessagePool(null, messageName, queryName, start, count, new Object[0]);
    }

    public static DataObjectSection dbLimitQueryMessagePool(String dataSource, String messageName, String queryName, int start, int count) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbLimitQueryMessagePool(dataSource, messageName, queryName, start, count, new Object[0]);
    }

    public static DataObjectSection dbLimitQueryMessage(String messageName, String queryName, int start, int count, Object[] params) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbLimitQueryMessagePool(null, messageName, queryName, start, count, params);
    }

    public static DataObjectSection dbLimitQueryMessagePool(String dataSource, String messageName, String queryName, int start, int count, Object[] params) throws TransformException, RemoteException, NamingException {
        PersistenceManager persistenceManager = LookupHelper.getLookupContext().lookupPersistenceManager(messageName + PERSISTENCE_MANAGER_SUFFIX);
        TransformContext cxt = DatabaseFunctions.getTransformContext(dataSource);
        return persistenceManager.find(queryName, params, start, count, cxt);
    }

    public static int dbCountMessage(String messageName, String queryName) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbCountMessagePool(null, messageName, queryName, new Object[0]);
    }

    public static int dbCountMessagePool(String dataSource, String messageName, String queryName) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbCountMessagePool(dataSource, messageName, queryName, new Object[0]);
    }

    public static int dbCountMessage(String messageName, String queryName, Object[] params) throws TransformException, RemoteException, NamingException {
        return DatabaseFunctions.dbCountMessagePool(null, messageName, queryName, params);
    }

    public static int dbCountMessagePool(String dataSource, String messageName, String queryName, Object[] params) throws TransformException, RemoteException, NamingException {
        PersistenceManager persistenceManager = LookupHelper.getLookupContext().lookupPersistenceManager(messageName + PERSISTENCE_MANAGER_SUFFIX);
        TransformContext cxt = DatabaseFunctions.getTransformContext(dataSource);
        return persistenceManager.count(queryName, params, cxt);
    }

    public static double dbSumDouble(String dataSourceName, String tableName, String fieldName) throws TransformException {
        return DatabaseFunctions.dbSumDouble(dataSourceName, tableName, fieldName, "");
    }

    public static double dbSumDouble(String dataSourceName, String tableName, String fieldName, String condition) throws TransformException {
        String sql = DatabaseFunctions.getAggregateSQL(tableName, fieldName, condition, "Sum");
        return DatabaseFunctions.executeSQLDouble(dataSourceName, sql);
    }

    public static int dbSum(String dataSourceName, String tableName, String fieldName) throws TransformException {
        return DatabaseFunctions.dbSum(dataSourceName, tableName, fieldName, "");
    }

    public static int dbSum(String dataSourceName, String tableName, String fieldName, String condition) throws TransformException {
        String sql = DatabaseFunctions.getAggregateSQL(tableName, fieldName, condition, "Sum");
        return DatabaseFunctions.executeSQLInt(dataSourceName, sql);
    }

    public static double dbAvg(String dataSourceName, String tableName, String fieldName) throws TransformException {
        return DatabaseFunctions.dbAvg(dataSourceName, tableName, fieldName, "");
    }

    public static double dbAvg(String dataSourceName, String tableName, String fieldName, String condition) throws TransformException {
        String sql = DatabaseFunctions.getAggregateSQL(tableName, fieldName, condition, "Avg");
        return DatabaseFunctions.executeSQLDouble(dataSourceName, sql);
    }

    public static double dbMaxDouble(String dataSourceName, String tableName, String fieldName) throws TransformException {
        return DatabaseFunctions.dbMaxDouble(dataSourceName, tableName, fieldName, "");
    }

    public static double dbMaxDouble(String dataSourceName, String tableName, String fieldName, String condition) throws TransformException {
        String sql = DatabaseFunctions.getAggregateSQL(tableName, fieldName, condition, "Max");
        return DatabaseFunctions.executeSQLDouble(dataSourceName, sql);
    }

    public static int dbMax(String dataSourceName, String tableName, String fieldName) throws TransformException {
        return DatabaseFunctions.dbMax(dataSourceName, tableName, fieldName, "");
    }

    public static int dbMax(String dataSourceName, String tableName, String fieldName, String condition) throws TransformException {
        String sql = DatabaseFunctions.getAggregateSQL(tableName, fieldName, condition, "Max");
        return DatabaseFunctions.executeSQLInt(dataSourceName, sql);
    }

    public static double dbMinDouble(String dataSourceName, String tableName, String fieldName) throws TransformException {
        return DatabaseFunctions.dbMinDouble(dataSourceName, tableName, fieldName, "");
    }

    public static double dbMinDouble(String dataSourceName, String tableName, String fieldName, String condition) throws TransformException {
        String sql = DatabaseFunctions.getAggregateSQL(tableName, fieldName, condition, "Min");
        return DatabaseFunctions.executeSQLDouble(dataSourceName, sql);
    }

    public static int dbMin(String dataSourceName, String tableName, String fieldName) throws TransformException {
        return DatabaseFunctions.dbMin(dataSourceName, tableName, fieldName, "");
    }

    public static int dbMin(String dataSourceName, String tableName, String fieldName, String condition) throws TransformException {
        String sql = DatabaseFunctions.getAggregateSQL(tableName, fieldName, condition, "Min");
        return DatabaseFunctions.executeSQLInt(dataSourceName, sql);
    }

    public static int dbCount(String dataSourceName, String tableName) throws TransformException {
        return DatabaseFunctions.dbCount(dataSourceName, tableName, "");
    }

    public static int dbCount(String dataSourceName, String tableName, String condition) throws TransformException {
        String sql = DatabaseFunctions.getAggregateSQL(tableName, "*", condition, "Count");
        return DatabaseFunctions.executeSQLInt(dataSourceName, sql);
    }

    private static int executeSQLInt(String dataSourceName, String sql) throws TransformException {
        return (int)DatabaseFunctions.executeSQLDouble(dataSourceName, sql);
    }

    private static double executeSQLDouble(String dataSourceName, String sql) throws TransformException {
        DatabaseFunctions dbFunction = new DatabaseFunctions();
        try {
            Statement stmt = dbFunction.createStatement(dataSourceName);
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                double aDouble = rs.getDouble(1);
                rs.close();
                double d = aDouble;
                return d;
            }
            try {
                throw TransformException.createFormatted("SRT560", sql);
            }
            catch (SQLException e) {
                TransformException te = TransformException.createFormatted("SRT561", sql);
                te.setDetail(e);
                throw te;
            }
        }
        finally {
            dbFunction.dispose();
        }
    }

    public static String getAggregateSQL(String tableName, String fieldName, String condition, String functionName) {
        String sql = "Select " + functionName + "(" + fieldName + ") AS RETURNVAL from " + tableName;
        if (condition != null && condition.length() > 0) {
            sql = sql + " where " + condition;
        }
        return sql;
    }
}

