/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.formula.FormatFunctions;
import com.tplus.transform.util.CalendarParser;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DateFunctions {
    private static int milliSecInDays = 86400000;
    private static int milliSecInMins = 60000;
    public static final TimeZone UTC_TIME_ZONE = new SimpleTimeZone(0, "GMT");
    private static Calendar staticCal = null;
    private static ThreadLocal perThreadCalendar = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new GregorianCalendar();
        }
    };

    private static Calendar getGregorianCalendar() {
        return Calendar.getInstance();
    }

    private static Calendar getPerThreadCalendar() {
        return (Calendar)perThreadCalendar.get();
    }

    private static Calendar getPerThreadCalendar(Date date) {
        Calendar calendar = DateFunctions.getPerThreadCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public static int day(Date date) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        return calendar.get(5);
    }

    public static int month(Date date) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        return calendar.get(2) + 1;
    }

    public static int year(Date date) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        return calendar.get(1);
    }

    public static int hour(Date date) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        return calendar.get(11);
    }

    public static int minute(Date date) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        return calendar.get(12);
    }

    public static int second(Date date) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        return calendar.get(13);
    }

    public static int millis(Date date) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        return calendar.get(14);
    }

    public static int day(Calendar calendar) {
        return calendar.get(5);
    }

    public static int month(Calendar calendar) {
        return calendar.get(2) + 1;
    }

    public static int year(Calendar calendar) {
        return calendar.get(1);
    }

    public static int hour(Calendar calendar) {
        return calendar.get(11);
    }

    public static int minute(Calendar calendar) {
        return calendar.get(12);
    }

    public static int second(Calendar calendar) {
        return calendar.get(13);
    }

    public static int millis(Calendar calendar) {
        return calendar.get(14);
    }

    public static Calendar millis(Calendar calendar, int millis) {
        Calendar newCal = (Calendar)calendar.clone();
        newCal.set(14, millis);
        return newCal;
    }

    public static long toTimestamp(Date date) {
        return date.getTime();
    }

    public static Date fromTimestamp(long time) {
        return new Date(time);
    }

    public static Date toUTC(Date date) {
        return date;
    }

    public static int weekDay(Date date) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        return calendar.get(7);
    }

    public static String weekDayName(Date date) {
        String[] dayName = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
        int day = DateFunctions.weekDay(date);
        String nameOfDay = dayName[day - 1];
        return nameOfDay;
    }

    public static Date today() {
        return DateFunctions.datePart(new Date());
    }

    public static Date datePart(Date dt) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(dt);
        return DateFunctions.datePart0(calendar).getTime();
    }

    public static Calendar datePart(Calendar dt) {
        Calendar calendar = (Calendar)dt.clone();
        return DateFunctions.datePart0(calendar);
    }

    private static Calendar datePart0(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2);
        int date = calendar.get(5);
        calendar.clear();
        calendar.set(year, month, date);
        return calendar;
    }

    public static Date timePart(Date dt) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(dt);
        DateFunctions.timePart0(calendar);
        return calendar.getTime();
    }

    public static Calendar timePart(Calendar dt) {
        Calendar calendar = (Calendar)dt.clone();
        DateFunctions.timePart0(calendar);
        return calendar;
    }

    private static void timePart0(Calendar calendar) {
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        int millis = calendar.get(14);
        calendar.clear();
        calendar.set(11, hour);
        calendar.set(12, min);
        calendar.set(13, sec);
        calendar.set(14, millis);
    }

    public static Date newDate(int year, int month, int date) {
        Calendar calendar = DateFunctions.getPerThreadCalendar();
        try {
            calendar.clear();
            calendar.setLenient(false);
            calendar.set(year, month - 1, date);
            return calendar.getTime();
        }
        catch (Exception e) {
            DateFunctions.handleCalendarException(calendar, e);
            return null;
        }
    }

    public static Date newTime(int hour, int min, int sec, int millis) {
        Calendar calendar = DateFunctions.getPerThreadCalendar();
        try {
            calendar.clear();
            calendar.setLenient(false);
            calendar.set(1970, 0, 1, hour, min, sec);
            calendar.set(14, millis);
            calendar.clear(1);
            calendar.clear(2);
            calendar.clear(5);
            return calendar.getTime();
        }
        catch (Exception e) {
            DateFunctions.handleCalendarException(calendar, e);
            return null;
        }
    }

    public static Date newDateTimeTZ(int timeZoneOffset, int year, int month, int date, int hour, int min, int sec) {
        return DateFunctions.newDateTimeTZ(timeZoneOffset, year, month, date, hour, min, sec, 0);
    }

    public static Date newDateTimeTZ(int timeZoneOffset, int year, int month, int date, int hour, int min, int sec, int millis) {
        return DateFunctions.newDateTimeWithTZ(timeZoneOffset, year, month, date, hour, min, sec, millis);
    }

    public static Calendar newISODateTimeTZ(int timeZoneOffset, int year, int month, int date, int hour, int min, int sec) {
        return DateFunctions.newISODateTimeTZ(timeZoneOffset, year, month, date, hour, min, sec, 0);
    }

    public static Calendar newISODateTimeTZ(int timeZoneOffset, int year, int month, int date, int hour, int min, int sec, int millis) {
        return DateFunctions.newISODateTimeWithTZ(timeZoneOffset, year, month, date, hour, min, sec, millis);
    }

    public static Date newTime(int hour, int min, int sec) {
        return DateFunctions.newTime(hour, min, sec, 0);
    }

    public static Date newDateTime(int year, int month, int date, int hour, int min, int sec) {
        return DateFunctions.newDateTime(year, month, date, hour, min, sec, 0);
    }

    public static Calendar newISODateTime(int year, int month, int date, int hour, int min, int sec) {
        return DateFunctions.newISODateTime(year, month, date, hour, min, sec, 0);
    }

    public static Date newDateTime(int year, int month, int date, int hour, int min, int sec, int millis) {
        return DateFunctions.newDateTimeWithTZ(null, year, month, date, hour, min, sec, millis);
    }

    public static Date newDateTimeWithTZ(Integer timeZoneOffset, int year, int month, int date, int hour, int min, int sec, int millis) {
        return DateFunctions.newISODateTimeWithTZ(timeZoneOffset, year, month, date, hour, min, sec, millis, DateFunctions.getPerThreadCalendar()).getTime();
    }

    public static Calendar newISODateTime(int year, int month, int date, int hour, int min, int sec, int millis) {
        return DateFunctions.newISODateTimeWithTZ(null, year, month, date, hour, min, sec, millis);
    }

    private static Calendar newISODateTimeWithTZ(Integer timeZoneOffset, int year, int month, int date, int hour, int min, int sec, int millis) {
        return DateFunctions.newISODateTimeWithTZ(timeZoneOffset, year, month, date, hour, min, sec, millis, new GregorianCalendar());
    }

    private static Calendar newISODateTimeWithTZ(Integer timeZoneOffset, int year, int month, int date, int hour, int min, int sec, int millis, Calendar calendar) {
        try {
            calendar.clear();
            calendar.setLenient(false);
            if (timeZoneOffset != null) {
                calendar.setTimeZone(CalendarParser.getTimeZone(timeZoneOffset));
            }
            calendar.set(year, month - 1, date);
            if (hour == 24 && (min | sec | millis) == 0) {
                calendar.get(1);
                calendar.setLenient(true);
            }
            calendar.set(11, hour);
            calendar.set(12, min);
            calendar.set(13, sec);
            calendar.set(14, millis);
            if (calendar.isLenient()) {
                calendar.get(1);
                calendar.setLenient(false);
            }
            return calendar;
        }
        catch (Exception e) {
            DateFunctions.handleCalendarException(calendar, e);
            return null;
        }
    }

    private static void handleCalendarException(Calendar calendar, Exception e) {
        throw TransformRuntimeException.createFormatted("SRT595");
    }

    public static Calendar toISODate(Date dt) {
        Calendar cal = DateFunctions.getGregorianCalendar();
        cal.setTime(dt);
        return cal;
    }

    public static Calendar toISODate(Date dt, int zoneoffset) {
        TimeZone tz = CalendarParser.getTimeZone(zoneoffset);
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.setTime(dt);
        return cal;
    }

    public static Calendar clearTimezone(Calendar calIn) {
        GregorianCalendar cal = new GregorianCalendar(CalendarParser.DEFAULT_TIMEZONE);
        cal.setTime(calIn.getTime());
        return cal;
    }

    public static Date toDate(Calendar cal) {
        return cal.getTime();
    }

    public static int getTimeZoneOffset() {
        return TimeZone.getDefault().getRawOffset() / 60000;
    }

    public static Date toUTCTime(Date dateTime) {
        return DateFunctions.convert(dateTime, new GregorianCalendar(UTC_TIME_ZONE), new GregorianCalendar(TimeZone.getDefault()));
    }

    public static Date toLocalTime(Date dateTime) {
        return DateFunctions.convert(dateTime, new GregorianCalendar(TimeZone.getDefault()), new GregorianCalendar(UTC_TIME_ZONE));
    }

    private static Date convert(Date dateTime, Calendar cal1, Calendar cal2) {
        cal1.setTime(dateTime);
        cal2.clear();
        cal2.set(cal1.get(1), cal1.get(2), cal1.get(5), cal1.get(11), cal1.get(12), cal1.get(13));
        cal2.set(14, cal1.get(14));
        return cal2.getTime();
    }

    static void dumpCal(Calendar cal) {
        System.out.println("Year  = " + cal.get(1));
        System.out.println("Month = " + cal.get(2));
        System.out.println("Date  = " + cal.get(5));
        System.out.println("Hour  = " + cal.get(11));
        System.out.println("Mins  = " + cal.get(12));
        System.out.println("Secs  = " + cal.get(13));
        System.out.println("Mill  = " + cal.get(14));
    }

    public static Date now() {
        return new Date();
    }

    public static Date nextDay(Date date) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        calendar = DateFunctions.addDays(calendar, 1);
        return calendar.getTime();
    }

    public static Date previousDay(Date date) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        calendar = DateFunctions.addDays(calendar, -1);
        return calendar.getTime();
    }

    public static Date addDays(Date date, int days) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        calendar = DateFunctions.addDays(calendar, days);
        return calendar.getTime();
    }

    private static Calendar addDays(Calendar calendar, int days) {
        calendar.add(5, days);
        return calendar;
    }

    public static Date addMonths(Date date, int months) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        calendar.add(2, months);
        return calendar.getTime();
    }

    public static Date addYears(Date date, int years) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        calendar.add(1, years);
        return calendar.getTime();
    }

    public static Date addHours(Date date, int hours) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        calendar = DateFunctions.addHours(calendar, hours);
        return calendar.getTime();
    }

    private static Calendar addHours(Calendar calendar, int hours) {
        calendar.add(11, hours);
        return calendar;
    }

    public static Date addMinutes(Date date, int minutes) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        calendar = DateFunctions.addMinutes(calendar, minutes);
        return calendar.getTime();
    }

    private static Calendar addMinutes(Calendar calendar, int minutes) {
        calendar.add(12, minutes);
        return calendar;
    }

    public static Date addSeconds(Date date, int seconds) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        calendar = DateFunctions.addSeconds(calendar, seconds);
        return calendar.getTime();
    }

    private static Calendar addSeconds(Calendar calendar, int seconds) {
        calendar.add(13, seconds);
        return calendar;
    }

    public static int getDayOfYear(Date date) {
        Calendar calendar = DateFunctions.getPerThreadCalendar(date);
        return calendar.get(6);
    }

    public static int getDayOfYear(Calendar calendar) {
        return calendar.get(6);
    }

    public static int daysBetween(Date date1, Date date2) {
        if (date1.compareTo(date2) == 0) {
            return 0;
        }
        int differenceInDays = (int)((DateFunctions.getTimeLocal(date1) - DateFunctions.getTimeLocal(date2)) / (long)milliSecInDays);
        return differenceInDays;
    }

    private static long getTimeLocal(Date date) {
        Calendar gregorianCalendar = DateFunctions.getPerThreadCalendar(date);
        int dst = gregorianCalendar.get(16);
        int offset = gregorianCalendar.get(15) + dst;
        return date.getTime() + (long)offset;
    }

    private static Date toWallTime(Date dateTime, boolean includeTime) {
        TimeZone aDefault = TimeZone.getDefault();
        if (aDefault.useDaylightTime()) {
            GregorianCalendar cal1 = new GregorianCalendar();
            cal1.setTime(dateTime);
            GregorianCalendar cal2 = new GregorianCalendar(new SimpleTimeZone(0, aDefault.getID()));
            if (includeTime) {
                cal2.set(cal1.get(1), cal1.get(2), cal1.get(5), cal1.get(11), cal1.get(12), cal1.get(13));
                cal2.set(14, cal1.get(14));
            } else {
                cal2.set(cal1.get(1), cal1.get(2), cal1.get(5));
            }
            return cal2.getTime();
        }
        return dateTime;
    }

    public static int monthsBetween(Date date1, Date date2) {
        Calendar calendar1 = DateFunctions.getGregorianCalendar();
        calendar1.setTime(date1);
        Calendar calendar2 = DateFunctions.getGregorianCalendar();
        calendar2.setTime(date2);
        if (date1.compareTo(date2) == 0) {
            return 0;
        }
        return DateFunctions.monthsBetween(calendar1, calendar2);
    }

    public static int monthsBetween(Calendar calendar1, Calendar calendar2) {
        int differenceInYears = DateFunctions.yearsBetween(calendar1, calendar2);
        int firstDateMonth = calendar1.get(2);
        int firstDate = calendar1.get(5);
        int secondDateMonth = calendar2.get(2);
        int secondDate = calendar2.get(5);
        int differenceInMonths = 0;
        if (calendar1.after(calendar2)) {
            if (firstDateMonth > secondDateMonth) {
                differenceInMonths = firstDate >= secondDate ? firstDateMonth - secondDateMonth : firstDateMonth - secondDateMonth - 1;
            } else if (firstDateMonth < secondDateMonth) {
                differenceInMonths = firstDate >= secondDate ? firstDateMonth + (12 - secondDateMonth) : firstDateMonth + (12 - secondDateMonth) - 1;
            } else if (firstDateMonth == secondDateMonth) {
                differenceInMonths = firstDate >= secondDate ? 0 : 11;
            }
        }
        if (calendar1.before(calendar2)) {
            if (firstDateMonth > secondDateMonth) {
                differenceInMonths = firstDate > secondDate ? firstDateMonth - secondDateMonth - 11 : firstDateMonth - secondDateMonth - 12;
            } else if (firstDateMonth < secondDateMonth) {
                differenceInMonths = firstDate > secondDate ? firstDateMonth - secondDateMonth + 1 : firstDateMonth - secondDateMonth;
            } else if (firstDateMonth == secondDateMonth) {
                differenceInMonths = firstDate > secondDate ? -11 : 0;
            }
        }
        if (differenceInYears != 0) {
            differenceInMonths += differenceInYears * 12;
        }
        return differenceInMonths;
    }

    public static int yearsBetween(Date date1, Date date2) {
        if (date1.compareTo(date2) == 0) {
            return 0;
        }
        Calendar calendar1 = DateFunctions.getGregorianCalendar();
        calendar1.setTime(date1);
        Calendar calendar2 = DateFunctions.getGregorianCalendar();
        calendar2.setTime(date2);
        return DateFunctions.yearsBetween(calendar1, calendar2);
    }

    public static int yearsBetween(Calendar calendar1, Calendar calendar2) {
        int noOfYears = 0;
        if (calendar1.after(calendar2)) {
            noOfYears = DateFunctions.getPostiveNumberOfYears(calendar1, calendar2);
        } else if (calendar1.before(calendar2)) {
            noOfYears = DateFunctions.getNegativeNumberOfYears(calendar1, calendar2);
        }
        return noOfYears;
    }

    public static boolean equal(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return date1 == date2;
        }
        return date1.equals(date2);
    }

    public static boolean equal(Calendar date1, Calendar date2) {
        if (date1 == null || date2 == null) {
            return date1 == date2;
        }
        return date1.equals(date2);
    }

    public static boolean notEqual(Date date1, Date date2) {
        return !DateFunctions.equal(date1, date2);
    }

    public static boolean notEqual(Calendar date1, Calendar date2) {
        return !DateFunctions.equal(date1, date2);
    }

    private static int getPostiveNumberOfYears(Calendar calendar1, Calendar calendar2) {
        int month2;
        int secondYear;
        int firstYear = calendar1.get(1);
        if (firstYear == (secondYear = calendar2.get(1))) {
            return 0;
        }
        int month1 = calendar1.get(2);
        if (month1 > (month2 = calendar2.get(2))) {
            return firstYear - secondYear;
        }
        if (month1 < month2) {
            return firstYear - secondYear - 1;
        }
        if (month1 == month2) {
            int day2;
            int day1 = calendar1.get(5);
            if (day1 >= (day2 = calendar2.get(5))) {
                return firstYear - secondYear;
            }
            if (day1 < day2) {
                return firstYear - secondYear - 1;
            }
        }
        return 0;
    }

    private static int getNegativeNumberOfYears(Calendar calendar1, Calendar calendar2) {
        int month2;
        int secondYear;
        int firstYear = calendar1.get(1);
        if (firstYear == (secondYear = calendar2.get(1))) {
            return 0;
        }
        int month1 = calendar1.get(2);
        if (month1 > (month2 = calendar2.get(2))) {
            return firstYear - secondYear + 1;
        }
        if (month1 < month2) {
            return firstYear - secondYear;
        }
        if (month1 == month2) {
            int day2;
            int day1 = calendar1.get(5);
            if (day1 > (day2 = calendar2.get(5))) {
                return firstYear - secondYear + 1;
            }
            if (day1 <= day2) {
                return firstYear - secondYear;
            }
        }
        return 0;
    }

    public static boolean less(Date date1, Date date2) {
        return DateFunctions.compare(date1, date2) < 0;
    }

    public static boolean less(Calendar date1, Calendar date2) {
        return DateFunctions.compare(date1, date2) < 0L;
    }

    public static boolean greater(Date date1, Date date2) {
        return DateFunctions.compare(date1, date2) > 0;
    }

    public static boolean greater(Calendar date1, Calendar date2) {
        return DateFunctions.compare(date1, date2) > 0L;
    }

    public static boolean lessEqual(Date date1, Date date2) {
        return DateFunctions.compare(date1, date2) <= 0;
    }

    public static boolean lessEqual(Calendar date1, Calendar date2) {
        return DateFunctions.compare(date1, date2) <= 0L;
    }

    public static boolean greaterEqual(Date date1, Date date2) {
        return DateFunctions.compare(date1, date2) >= 0;
    }

    public static boolean greaterEqual(Calendar date1, Calendar date2) {
        return DateFunctions.compare(date1, date2) >= 0L;
    }

    public static int compare(Date date1, Date date2) {
        return date1.compareTo(date2);
    }

    public static long compare(Calendar date1, Calendar date2) {
        return date1.getTimeInMillis() - date2.getTimeInMillis();
    }

    public static void cmtmain(String[] args) {
        Calendar d1 = FormatFunctions.parseISODate("2010-07-31T00:00:00", "%Y-%M-%DT%h:%m:%s%z");
        Calendar d2 = FormatFunctions.parseISODate("2010-07-02T00:00:00", "%Y-%M-%DT%h:%m:%s%z");
        System.out.println(d1);
        System.out.println(d1.getTime().getTime());
        System.out.println(d1.getTimeInMillis());
        System.out.println(d2);
        System.out.println(d2.getTime().getTime());
        System.out.println(d2.getTimeInMillis());
        System.out.println(d1.getTimeInMillis() - d2.getTimeInMillis());
        System.out.println((int)(d1.getTimeInMillis() - d2.getTimeInMillis()));
        System.out.println(DateFunctions.greaterEqual(d1, d2));
    }

    public static void pain(String[] args) {
    }

    static {
        staticCal = new GregorianCalendar();
    }
}

