/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.FieldParsingException;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.Variant;
import com.tplus.transform.runtime.collection.ValueList;
import com.tplus.transform.runtime.formula.Formatter;
import com.tplus.transform.util.CalendarFormatter;
import com.tplus.transform.util.CalendarParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class FormatFunctions {
    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        String formattedString = DateFormat.getDateInstance().format(date);
        return formattedString;
    }

    public static String formatDate(Calendar date) {
        if (date == null) {
            return null;
        }
        String formattedString = CalendarFormatter.format(Parsing.ISO_DATE_TIME_FORMAT, date);
        return formattedString;
    }

    public static String formatDate(Calendar cal, String pattern) {
        if (cal == null) {
            return null;
        }
        return Parsing.formatISODate(cal, pattern);
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        if (Parsing.isISOPattern(pattern)) {
            return CalendarFormatter.format(pattern, date);
        }
        DateFormat df = Parsing.getDateFormat(pattern);
        String formattedString = df.format(date);
        return formattedString;
    }

    public static Date parseDate(String arg) {
        try {
            if (arg == null) {
                return null;
            }
            DateFormat df = DateFormat.getDateInstance();
            Date date = df.parse(arg);
            return date;
        }
        catch (ParseException parse) {
            throw TransformRuntimeException.createFormatted("SRT562", arg);
        }
    }

    public static Calendar parseISODate(String arg, String pattern) {
        try {
            if (arg == null) {
                return null;
            }
            if (Parsing.isISOPattern(pattern)) {
                return CalendarParser.parse(pattern, arg, true);
            }
            GregorianCalendar cal = FormatFunctions.createGregorianCalendar();
            cal.setTime(FormatFunctions.parseDate(arg, pattern));
            return cal;
        }
        catch (IllegalArgumentException illArg) {
            throw TransformRuntimeException.createFormatted("SRT563", new Object[]{arg, pattern});
        }
    }

    private static GregorianCalendar createGregorianCalendar() {
        return CalendarParser.createGregorianCalendar();
    }

    public static Date parseDate(String arg, String pattern) {
        try {
            if (arg == null) {
                return null;
            }
            if (Parsing.isISOPattern(pattern)) {
                return CalendarParser.parse(pattern, arg).getTime();
            }
            ParsePosition pos = new ParsePosition(0);
            DateFormat df = Parsing.getDateFormat(pattern);
            Date date = df.parse(arg, pos);
            if (date == null) {
                throw TransformRuntimeException.createFormatted("SRT563", new Object[]{arg, pattern});
            }
            if (pos.getIndex() != arg.length()) {
                throw TransformRuntimeException.createFormatted("SRT563", new Object[]{arg, pattern});
            }
            if (pos.getIndex() == 0) {
                throw TransformRuntimeException.createFormatted("SRT563", new Object[]{arg, pattern});
            }
            return date;
        }
        catch (IllegalArgumentException illArg) {
            throw TransformRuntimeException.createFormatted("SRT563", new Object[]{arg, pattern});
        }
        catch (NullPointerException nullPtr) {
            throw TransformRuntimeException.createFormatted("SRT563", new Object[]{arg, pattern});
        }
    }

    public static boolean isDate(String arg, String pattern) {
        try {
            if (arg == null) {
                return false;
            }
            if (Parsing.isISOPattern(pattern)) {
                CalendarParser.parse(pattern, arg).getTime();
                return true;
            }
            ParsePosition pos = new ParsePosition(0);
            DateFormat df = Parsing.getDateFormat(pattern);
            Date date = df.parse(arg, pos);
            if (date == null) {
                return false;
            }
            if (pos.getIndex() != arg.length()) {
                return false;
            }
            return pos.getIndex() != 0;
        }
        catch (Exception parse) {
            return false;
        }
    }

    public static String toText(String str) {
        return str;
    }

    public static String toText(char ch) {
        return Parsing.toString(ch);
    }

    public static String toText(int val) {
        return Parsing.toString(val);
    }

    public static String toText(float val) {
        return Parsing.toString(val);
    }

    public static String toText(double val) {
        return Parsing.toString(val);
    }

    public static void cmtmain(String[] args) {
        System.out.println(FormatFunctions.parseDate("", ""));
    }

    public static String toText(boolean val) {
        return Parsing.toString(val);
    }

    public static String toText(long val) {
        return Parsing.toString(val);
    }

    public static String toText(byte[] bytes) {
        return new String(bytes);
    }

    public static String toText(Date date) {
        boolean timePart = FormatFunctions.hasTimePart(date);
        boolean datePart = FormatFunctions.hasDatePart(date);
        if (timePart && datePart) {
            return DesignerType.DESIGNER_DATE_TIME_TYPE.format(date);
        }
        if (timePart) {
            return DesignerType.DESIGNER_DATE_TIME_TYPE.format(date);
        }
        return DesignerType.DESIGNER_DATE_ONLY_TYPE.format(date);
    }

    private static boolean hasDatePart(Date date) {
        return date.getYear() != 70 || date.getMonth() != 0 || date.getDate() != 1;
    }

    private static boolean hasTimePart(Calendar date) {
        return date.get(11) != 0 || date.get(12) != 0 || date.get(13) != 0;
    }

    public static String toText(Calendar date) {
        return DesignerType.DESIGNER_ISO_DATE_TIME_TYPE.format(date);
    }

    private static boolean hasTimePart(Date date) {
        return date.getHours() != 0 || date.getMinutes() != 0 || date.getSeconds() != 0;
    }

    private static boolean hasDatePart(Calendar date) {
        return date.get(1) != 70 || date.get(2) != 0 || date.get(5) != 1;
    }

    public static boolean isInt(String str) {
        if (str != null) {
            try {
                Wrapper.parseInt(str);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isLong(String str) {
        if (str != null) {
            try {
                Wrapper.parseLong(str);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isFloat(String str) {
        if (str != null) {
            try {
                Float.parseFloat(str);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isDouble(String str) {
        if (str != null) {
            try {
                Double.parseDouble(str);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isBigDecimal(String str) {
        if (str != null) {
            try {
                BigDecimal bd = new BigDecimal(str);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isBigInteger(String str) {
        if (str != null) {
            try {
                BigInteger bd = new BigInteger(str);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int toInt(String str) {
        try {
            return Wrapper.parseInt(str);
        }
        catch (NumberFormatException ne) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT564", new Object[]{"parseInt", ne.getMessage()});
            tre.setDetail(ne);
            throw tre;
        }
    }

    public static Integer toIntNullCheck(String str) {
        try {
            if (str == null) {
                return null;
            }
            return Wrapper.box(Wrapper.parseInt(str));
        }
        catch (NumberFormatException ne) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT564", new Object[]{"parseInt", ne.getMessage()});
            tre.setDetail(ne);
            throw tre;
        }
    }

    public static int toInt(char c) {
        return c;
    }

    public static boolean toBoolean(String str) {
        if (str == null) {
            return false;
        }
        return Boolean.valueOf(str);
    }

    public static long toLong(String str) {
        try {
            return Wrapper.parseLong(str);
        }
        catch (NumberFormatException ne) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT564", new Object[]{"parseLong", ne.getMessage()});
            tre.setDetail(ne);
            throw tre;
        }
    }

    public static double toDouble(String str) {
        if (str == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException ne) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT564", new Object[]{"parseDouble", ne.getMessage()});
            tre.setDetail(ne);
            throw tre;
        }
    }

    public static float toFloat(String str) {
        if (str == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException ne) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT564", new Object[]{"parseFloat", ne.getMessage()});
            tre.setDetail(ne);
            throw tre;
        }
    }

    public static char toChar(String str) {
        if (str == null || str.length() == 0) {
            str = " ";
        }
        return str.charAt(0);
    }

    public static String format(String pattern, Object[] arguments) throws TransformRuntimeException {
        try {
            return MessageFormat.format(pattern, arguments);
        }
        catch (IllegalArgumentException ex) {
            throw TransformRuntimeException.createFormatted("SRT552", ex.getMessage());
        }
    }

    public static int toInt(BigInteger val) {
        return val.intValue();
    }

    public static long toLong(BigInteger val) {
        return val.longValue();
    }

    public static float toFloat(BigInteger val) {
        return val.floatValue();
    }

    public static double toDouble(BigInteger val) {
        return val.doubleValue();
    }

    public static BigInteger toBigInteger(String str) {
        if (str == null) {
            return null;
        }
        return Wrapper.parseBigInteger(str);
    }

    public static BigInteger toBigInteger(long value) {
        return BigInteger.valueOf(value);
    }

    public static BigInteger toBigInteger(int value) {
        return BigInteger.valueOf(value);
    }

    public static BigInteger toBigInteger(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.toBigInteger();
    }

    public static BigInteger toBigInteger(ScaledDecimal value) {
        if (value == null) {
            return null;
        }
        return value.bigDecimalValue().toBigInteger();
    }

    public static BigInteger toBigInteger(float value) {
        return new BigDecimal(value).toBigInteger();
    }

    public static BigInteger toBigInteger(double value) {
        return new BigDecimal(value).toBigInteger();
    }

    public static String toText(BigInteger val) {
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    public static BigDecimal toBigDecimal(String str) {
        if (str == null) {
            return null;
        }
        return Wrapper.parseBigDecimal(str);
    }

    public static BigDecimal toBigDecimal(int value) {
        return BigDecimal.valueOf(value);
    }

    public static BigDecimal toBigDecimal(Integer value) {
        if (value == null) {
            return null;
        }
        return FormatFunctions.toBigDecimal((int)value);
    }

    public static BigDecimal toBigDecimal(long value) {
        return BigDecimal.valueOf(value);
    }

    public static BigDecimal toBigDecimal(Long value) {
        if (value == null) {
            return null;
        }
        return FormatFunctions.toBigDecimal((long)value);
    }

    public static BigDecimal toBigDecimal(float value) {
        return new BigDecimal(value);
    }

    public static BigDecimal toBigDecimal(Float value) {
        if (value == null) {
            return null;
        }
        return FormatFunctions.toBigDecimal(value.floatValue());
    }

    public static BigDecimal toBigDecimal(double value) {
        return new BigDecimal(value);
    }

    public static BigDecimal toBigDecimal(Double value) {
        if (value == null) {
            return null;
        }
        return FormatFunctions.toBigDecimal((double)value);
    }

    public static BigDecimal toBigDecimal(BigInteger value) {
        if (value == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static BigDecimal toBigDecimal(ScaledDecimal value) {
        if (value == null) {
            return null;
        }
        return value.bigDecimalValue();
    }

    public static String toText(BigDecimal val) {
        if (val == null) {
            return null;
        }
        return Wrapper.toString(val);
    }

    public static int toInt(BigDecimal val) {
        return val.intValue();
    }

    public static long toLong(BigDecimal val) {
        return val.longValue();
    }

    public static float toFloat(BigDecimal val) {
        return val.floatValue();
    }

    public static double toDouble(BigDecimal val) {
        return val.doubleValue();
    }

    public static ScaledDecimal toScaledDecimal(String str) throws FieldParsingException {
        if (str == null) {
            return null;
        }
        return Parsing.parseScaledDecimal(str);
    }

    public static ScaledDecimal toScaledDecimal(int value) {
        return ScaledDecimal.valueOf(value);
    }

    public static ScaledDecimal toScaledDecimal(long value) {
        return ScaledDecimal.valueOf(value);
    }

    public static ScaledDecimal toScaledDecimal(float value) {
        return new ScaledDecimal(value);
    }

    public static ScaledDecimal toScaledDecimal(double value) {
        return new ScaledDecimal(value);
    }

    public static ScaledDecimal toScaledDecimal(long mantissa, int exponent) {
        return new ScaledDecimal(mantissa, exponent);
    }

    public static ScaledDecimal toScaledDecimal(BigInteger value) {
        if (value == null) {
            return null;
        }
        return ScaledDecimal.valueOf(value);
    }

    public static ScaledDecimal toScaledDecimal(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return ScaledDecimal.valueOf(value);
    }

    public static String toText(ScaledDecimal val) {
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    public static int toInt(ScaledDecimal val) {
        return val.intValue();
    }

    public static long toLong(ScaledDecimal val) {
        return val.longValue();
    }

    public static float toFloat(ScaledDecimal val) {
        return val.floatValue();
    }

    public static double toDouble(ScaledDecimal val) {
        return val.doubleValue();
    }

    public static String toText(StringBuffer buffer) {
        return buffer.toString();
    }

    public static String toText(String value, int minWidth, int maxWidth, boolean lpad, char paddingChar) throws TransformException {
        return FormatFunctions.getFormatter().stringToString(value, minWidth, maxWidth, lpad, paddingChar);
    }

    public static String toText(int value, int minWidth, int maxWidth, boolean lpad, char paddingChar, int sign) throws TransformException {
        return FormatFunctions.getFormatter().numberToString(value, minWidth, maxWidth, lpad, paddingChar, sign);
    }

    public static String toText(long value, int minWidth, int maxWidth, boolean lpad, char paddingChar, int sign) throws TransformException {
        return FormatFunctions.getFormatter().numberToString(value, minWidth, maxWidth, lpad, paddingChar, sign);
    }

    public static String toText(BigInteger value, int minWidth, int maxWidth, boolean lpad, char paddingChar, int sign) throws TransformException {
        return FormatFunctions.getFormatter().numberToString(value, minWidth, maxWidth, lpad, paddingChar, sign);
    }

    public static String toText(double value, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign) throws TransformException {
        return FormatFunctions.getFormatter().decimalToString(value, minWidth, maxWidth, lpad, paddingChar, decimalPoint, sign);
    }

    public static String toText(double value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int sign) throws TransformException {
        return FormatFunctions.getFormatter().decimalToStringFormatted(value, numberDigits, decimalDigits, paddingChar, decimalPoint, sign);
    }

    public static String toText(double value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char paddingChar, char decimalPoint, int sign) throws TransformException {
        return FormatFunctions.getFormatter().decimalToStringFormatted(value, minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, paddingChar, decimalPoint, sign);
    }

    public static String toText(float value, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign) throws TransformException {
        return FormatFunctions.getFormatter().decimalToString(value, minWidth, maxWidth, lpad, paddingChar, decimalPoint, sign);
    }

    public static String toText(float value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int sign) throws TransformException {
        return FormatFunctions.getFormatter().decimalToStringFormatted(value, numberDigits, decimalDigits, paddingChar, decimalPoint, sign);
    }

    public static String toText(float value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char paddingChar, char decimalPoint, int sign) throws TransformException {
        return FormatFunctions.getFormatter().decimalToStringFormatted(value, minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, paddingChar, decimalPoint, sign);
    }

    public static String toText(BigDecimal value, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign) throws TransformException {
        return FormatFunctions.getFormatter().decimalToString(value, minWidth, maxWidth, lpad, paddingChar, decimalPoint, sign);
    }

    public static String toText(BigDecimal value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int sign) throws TransformException {
        return FormatFunctions.getFormatter().decimalToStringFormatted(value, numberDigits, decimalDigits, paddingChar, decimalPoint, sign);
    }

    public static String toText(BigDecimal value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char paddingChar, char decimalPoint, int sign) throws TransformException {
        return FormatFunctions.getFormatter().decimalToStringFormatted(value, minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, paddingChar, decimalPoint, sign);
    }

    public static String toText(ScaledDecimal value, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign) throws TransformException {
        return FormatFunctions.getFormatter().decimalToString(value, minWidth, maxWidth, lpad, paddingChar, decimalPoint, sign);
    }

    public static String toText(ScaledDecimal value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int sign) throws TransformException {
        return FormatFunctions.getFormatter().decimalToStringFormatted(value, numberDigits, decimalDigits, paddingChar, decimalPoint, sign);
    }

    public static String toText(ScaledDecimal value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char paddingChar, char decimalPoint, int sign) throws TransformException {
        return FormatFunctions.getFormatter().decimalToStringFormatted(value, minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, paddingChar, decimalPoint, sign);
    }

    public static String toText(char value, int minWidth, int maxWidth, boolean lpad, char paddingChar) throws TransformException {
        return FormatFunctions.getFormatter().charToString(value, minWidth, maxWidth, lpad, paddingChar);
    }

    public static String toText(Date value, String format, int minWidth, int maxWidth, boolean lpad, char paddingChar) throws TransformException {
        return FormatFunctions.getFormatter().dateToString(value, format, minWidth, maxWidth, lpad, paddingChar);
    }

    public static Variant toVariant(String value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(char value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(int value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(long value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(double value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(float value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(BigInteger value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(BigDecimal value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(boolean value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(ScaledDecimal value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(Date value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(Calendar value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(Object value, DesignerType designerType) {
        return Parsing.toVariant(value, designerType);
    }

    public static Variant toVariant(Object value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(RawMessage value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(byte[] value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(DataObject value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(DataObjectSection value) {
        return Parsing.toVariant(value);
    }

    public static Variant toVariant(ValueList value) {
        return Parsing.toVariant(value);
    }

    public static String toText(Variant val) {
        if (val == null) {
            return null;
        }
        return val.toText();
    }

    public static int toInt(Variant val) {
        return val.toInt();
    }

    public static long toLong(Variant val) {
        return val.toLong();
    }

    public static char toChar(Variant val) {
        return val.toChar();
    }

    public static ScaledDecimal toScaledDecimal(Variant val) {
        return val.toScaledDecimal();
    }

    public static float toFloat(Variant val) {
        return val.toFloat();
    }

    public static double toDouble(Variant val) {
        return val.toDouble();
    }

    public static Date toDate(Variant val) {
        return val.toDate();
    }

    public static Calendar toISODate(Variant val) {
        return val.toISODate();
    }

    public static boolean toBoolean(Variant val) {
        return val.toBoolean();
    }

    public static RawMessage toRawMessage(Variant val) {
        return val.toRawMessage();
    }

    public static BigDecimal toBigDecimal(Variant val) {
        return val.toBigDecimal();
    }

    public static ScaledDecimal toScaledDecimalDecimal(Variant val) {
        return val.toScaledDecimal();
    }

    public static BigInteger toBigInteger(Variant val) {
        return val.toBigInteger();
    }

    public static byte[] toBinary(Variant val) {
        return val.toBinary();
    }

    public static DataObjectSection toSection(Variant val) {
        return val.getSection();
    }

    public static DataObject toDataObject(Variant val) {
        return val.getDataObject();
    }

    public static int toInt(Integer val) {
        return Parsing.intValue(val);
    }

    public static long toLong(Long val) {
        return Parsing.longValue(val);
    }

    public static char toChar(Character val) {
        return Parsing.charValue(val);
    }

    public static ScaledDecimal toScaledDecimal(ScaledDecimal val) {
        return Parsing.scaledDecimalValue(val);
    }

    public static float toFloat(Float val) {
        return Parsing.floatValue(val);
    }

    public static double toDouble(Double val) {
        return Parsing.doubleValue(val);
    }

    public static Date toDate(Date val) {
        return val;
    }

    public static Calendar toISODate(Calendar val) {
        return val;
    }

    public static boolean toBoolean(Boolean val) {
        return Parsing.booleanValue(val);
    }

    public static RawMessage toRawMessage(RawMessage val) {
        return val;
    }

    public static BigDecimal toBigDecimal(BigDecimal val) {
        return val;
    }

    public static BigInteger toBigInteger(BigInteger val) {
        return val;
    }

    public static byte[] toBinary(byte[] val) {
        return val;
    }

    public static DataObjectSection getSection(DataObjectSection val) {
        return val;
    }

    private static Formatter getFormatter() {
        return new Formatter();
    }
}

