/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.lang.CharBinaryBuffer;
import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.formula.BinaryFunctions;
import com.tplus.transform.runtime.formula.MathFunctions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class Formatter {
    public static int SIGN_OPTIONAL = 0;
    public static int SIGN_MANDATORY = 1;
    public static int SIGN_SEPARATE_LEADING = 2;
    public static int SIGN_SEPARATE_TRAILING = 3;
    public static final int SIGN_NEVER = 4;
    private static final char NEGATIVE_SIGN = '-';
    private static final char POSITIVE_SIGN = '+';
    public static final char ZERO_PADDING_CHAR = '0';
    public static final int QUOTE_NEVER = 0;
    public static final int QUOTE_ALWAYS = 1;
    public static final int QUOTE_DELIMITER = 2;
    public static final int QUOTE_SPECIAL_CHARACTERS = 3;
    FastStringBuffer cachedBuffer = new FastStringBuffer(100);
    private static final char DOT = '.';
    int terminator = -1;
    int oldTerminator = -1;
    ExceptionHandler exceptionHandler = ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER;
    private static final char IMPLIED_DECIMAL = '\u0000';
    public static long[] PowersOf10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setTerminator(char terminator) {
        this.terminator = terminator;
    }

    public void clearTerminator() {
        this.terminator = -1;
    }

    private void restoreTerminator() {
        this.terminator = this.oldTerminator;
        this.oldTerminator = -1;
    }

    private void saveAndClearTerminator() {
        this.oldTerminator = this.terminator;
        this.terminator = -1;
    }

    public String stringToString(String value) throws TransformException {
        return value;
    }

    public String stringToString(String value, int minWidth, int maxWidth, boolean lpad, char paddingChar) throws TransformException {
        return this.writeString(value, minWidth, maxWidth, lpad, paddingChar);
    }

    private String writeString(String value, int minWidth, int maxWidth, boolean lpad, char paddingChar) throws TransformException {
        boolean hasTerminator = this.hasTerminator();
        if (hasTerminator) {
            if (minWidth == maxWidth) {
                --minWidth;
            }
            --maxWidth;
        }
        value = this.checkMaxWidth(value.length(), maxWidth, value, false);
        if (!(minWidth != 0 && value.length() <= minWidth || hasTerminator)) {
            return value;
        }
        FastStringBuffer buffer = this.getFreeBuffer();
        if (lpad) {
            Formatter.pad(value, minWidth, paddingChar, buffer);
            buffer.append(value);
            this.appendTerminator(buffer);
        } else {
            buffer.append(value);
            this.appendTerminator(buffer);
            Formatter.pad(value, minWidth, paddingChar, buffer);
        }
        return buffer.toString();
    }

    public void stringToString(String value, int minWidth, int maxWidth, boolean lpad, char paddingChar, CharBinaryBuffer buffer) throws TransformException {
        this.writeString(value, minWidth, maxWidth, lpad, paddingChar, buffer);
    }

    private void writeString(String value, int minWidth, int maxWidth, boolean lpad, char paddingChar, CharBinaryBuffer buffer) throws TransformException {
        boolean hasTerminator = this.hasTerminator();
        if (hasTerminator) {
            if (minWidth == maxWidth) {
                --minWidth;
            }
            --maxWidth;
        }
        value = this.checkMaxWidth(value.length(), maxWidth, value, false);
        if (!(minWidth != 0 && value.length() <= minWidth || hasTerminator)) {
            buffer.append(value);
        } else if (lpad) {
            Formatter.pad(value, minWidth, paddingChar, buffer);
            buffer.append(value);
            this.appendTerminator(buffer);
        } else {
            buffer.append(value);
            this.appendTerminator(buffer);
            Formatter.pad(value, minWidth, paddingChar, buffer);
        }
    }

    private boolean hasTerminator() {
        return this.terminator != -1;
    }

    private void appendTerminator(FastStringBuffer buffer) {
        if (this.terminator != -1) {
            buffer.append((char)this.terminator);
            this.clearTerminator();
        }
    }

    private void appendTerminator(CharBinaryBuffer buffer) {
        if (this.terminator != -1) {
            buffer.append((char)this.terminator);
            this.clearTerminator();
        }
    }

    public String charToString(char value, int minWidth, int maxWidth, boolean lpad, char paddingChar) throws TransformException {
        return this.writeString(String.valueOf(value), minWidth, maxWidth, lpad, paddingChar);
    }

    public String booleanToString(boolean value, int minWidth, int maxWidth, boolean lpad, char paddingChar, String trueValue, String falseValue) throws TransformException {
        String valueStr = value ? trueValue : falseValue;
        return this.writeString(valueStr, minWidth, maxWidth, lpad, paddingChar);
    }

    public String dateToString(Date value, String format, int minWidth, int maxWidth, boolean lpad, char paddingChar) throws TransformException {
        String formattedDate = Parsing.formatDate(value, format);
        return this.writeString(formattedDate, minWidth, maxWidth, lpad, paddingChar);
    }

    public String binaryToStringBase64(byte[] value, int minWidth, int maxWidth, boolean lpad, char paddingChar) throws TransformException {
        String valueStr = BinaryFunctions.toBase64String(value);
        return this.writeString(valueStr, minWidth, maxWidth, lpad, paddingChar);
    }

    public String binaryToStringHex(byte[] value, int minWidth, int maxWidth, boolean lpad, char paddingChar) throws TransformException {
        String valueStr = BinaryFunctions.toHexString(value);
        return this.writeString(valueStr, minWidth, maxWidth, lpad, paddingChar);
    }

    public String numberToString(int value, int minWidth, int maxWidth, boolean lpad, char paddingChar, int sign) throws TransformException {
        if (this.hasTerminator()) {
            minWidth = minWidth == maxWidth ? minWidth - 1 : minWidth;
            --maxWidth;
        }
        FastStringBuffer buffer = this.getFreeBuffer();
        boolean negative = value < 0;
        int newValue = Math.abs(value);
        String valueStr = Parsing.toString(newValue);
        if (newValue < 0) {
            valueStr = valueStr.substring(1);
        }
        this.padNumberWithTerminator(valueStr, negative, minWidth, maxWidth, lpad, paddingChar, sign, buffer);
        return buffer.toString();
    }

    public String numberToString(long value, int minWidth, int maxWidth, boolean lpad, char paddingChar, int sign) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        this.numberToString(value, minWidth, maxWidth, lpad, paddingChar, sign, buffer);
        return buffer.toString();
    }

    public void numberToString(long value, int minWidth, int maxWidth, boolean lpad, char paddingChar, int sign, FastStringBuffer buffer) throws TransformException {
        if (this.hasTerminator()) {
            minWidth = minWidth == maxWidth ? minWidth - 1 : minWidth;
            --maxWidth;
        }
        boolean negative = value < 0L;
        long newValue = Math.abs(value);
        String valueStr = Parsing.toString(newValue);
        if (newValue < 0L) {
            valueStr = valueStr.substring(1);
        }
        this.padNumberWithTerminator(valueStr, negative, minWidth, maxWidth, lpad, paddingChar, sign, buffer);
    }

    public String numberToString(BigInteger value, int minWidth, int maxWidth, boolean lpad, char paddingChar, int sign) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        if (this.hasTerminator()) {
            minWidth = minWidth == maxWidth ? minWidth - 1 : minWidth;
            --maxWidth;
        }
        boolean negative = value.signum() == -1;
        String valueStr = value.abs().toString();
        this.padNumberWithTerminator(valueStr, negative, minWidth, maxWidth, lpad, paddingChar, sign, buffer);
        return buffer.toString();
    }

    public String decimalToString(double originalValue, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        this.decimalToString(originalValue, minWidth, maxWidth, lpad, paddingChar, decimalPoint, sign, buffer);
        return buffer.toString();
    }

    public void decimalToString(double originalValue, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        if (Formatter.isSignSeparate(sign)) {
            // empty if block
        }
        this.decimalToStringImpl(originalValue, minWidth, maxWidth, lpad, paddingChar, decimalPoint, sign, buffer);
    }

    private void decimalToStringImpl(double originalValue, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        int decimalIndex;
        int availableWidth;
        int maxDecimalDigits;
        double newValue;
        if (this.hasTerminator()) {
            minWidth = minWidth == maxWidth ? minWidth - 1 : minWidth;
            --maxWidth;
        }
        boolean negative = originalValue < 0.0;
        int signLength = Formatter.getSignLength(negative, sign);
        double value = Formatter.abs(originalValue);
        String valueStr = Parsing.toString(value);
        if (maxWidth > 0 && valueStr.length() + signLength > maxWidth && (valueStr = Parsing.toString(newValue = MathFunctions.round(value, maxDecimalDigits = (availableWidth = maxWidth - signLength) - (decimalIndex = this.countNumberDigits(valueStr)) - 1))).length() > availableWidth && (valueStr = this.fixMaxWidth(valueStr, availableWidth, maxWidth)).indexOf(46) == -1) {
            lpad = true;
        }
        valueStr = Formatter.fixDecimalPoint(valueStr, decimalPoint);
        int strLength = valueStr.length() + signLength;
        this.padNumberWithTerminator(valueStr, negative, minWidth, lpad, paddingChar, sign, strLength, buffer);
    }

    public String decimalToStringFormatted(double value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int signSeparate) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        this.decimalToStringFormatted(value, numberDigits, decimalDigits, paddingChar, decimalPoint, signSeparate, buffer);
        return buffer.toString();
    }

    public void decimalToStringFormatted(double value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        if (Formatter.isSignSeparate(sign)) {
            if (sign == SIGN_SEPARATE_LEADING) {
                buffer.append(this.getSign(value));
            }
            this.decimalToStringFormattedImpl(Formatter.abs(value), numberDigits, decimalDigits, paddingChar, decimalPoint, SIGN_OPTIONAL, buffer);
            if (sign == SIGN_SEPARATE_TRAILING) {
                buffer.append(this.getSign(value));
            }
        } else {
            this.decimalToStringFormattedImpl(value, numberDigits, decimalDigits, paddingChar, decimalPoint, sign, buffer);
        }
    }

    private void decimalToStringFormattedImpl(double value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        boolean negative = value < 0.0;
        long numberValue = (long)value;
        long decimalIntValue = Math.round(Formatter.abs(value - (double)numberValue) * (double)PowersOf10[decimalDigits]);
        if (decimalIntValue == PowersOf10[decimalDigits]) {
            decimalIntValue = 0L;
            numberValue += numberValue < 0L ? -1L : 1L;
        }
        this.padNumberWithOutTerminatorExcludeSignSeparate(Long.toString(Math.abs(numberValue)), negative, numberDigits, numberDigits, true, paddingChar, sign, buffer);
        if (decimalPoint != '\u0000') {
            buffer.append(decimalPoint);
        }
        this.padNumberWithOutTerminatorExcludeSignSeparate(Long.toString(decimalIntValue), false, decimalDigits, decimalDigits, true, '0', SIGN_OPTIONAL, buffer);
    }

    public String decimalToStringFormatted(double value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char paddingChar, char decimalPoint, int sign) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        this.decimalToStringFormatted(value, minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, decimalPoint, paddingChar, sign, buffer);
        return buffer.toString();
    }

    public void decimalToStringFormatted(double value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char decimalPoint, char paddingChar, int sign, FastStringBuffer buffer) throws TransformException {
        if (Formatter.isSignSeparate(sign)) {
            if (sign == SIGN_SEPARATE_LEADING) {
                buffer.append(this.getSign(value));
            }
            this.decimalToStringFormattedImpl(Formatter.abs(value), minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, decimalPoint, paddingChar, SIGN_OPTIONAL, buffer);
            if (sign == SIGN_SEPARATE_TRAILING) {
                buffer.append(this.getSign(value));
            }
        } else {
            this.decimalToStringFormattedImpl(value, minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, decimalPoint, paddingChar, sign, buffer);
        }
    }

    private void decimalToStringFormattedImpl(double value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char decimalPoint, char paddingChar, int sign, FastStringBuffer buffer) throws TransformException {
        long decimalIntValue;
        boolean negative = value < 0.0;
        long numberValue = (long)value;
        int prefDecimalDigits = maxDecimalDigits;
        if (minDecimalDigits != maxDecimalDigits) {
            prefDecimalDigits = this.computePreferredDecimalDigits(minDecimalDigits, maxDecimalDigits, Parsing.toString(value));
        }
        if ((decimalIntValue = Math.round(Formatter.abs(value - (double)numberValue) * (double)PowersOf10[prefDecimalDigits])) == PowersOf10[prefDecimalDigits]) {
            decimalIntValue = 0L;
            numberValue += numberValue < 0L ? -1L : 1L;
        }
        this.padNumberWithOutTerminatorExcludeSignSeparate(Long.toString(Math.abs(numberValue)), negative, minNumberDigits, maxNumberDigits, true, paddingChar, sign, buffer);
        if (decimalPoint != '\u0000') {
            buffer.append(decimalPoint);
        }
        this.padNumberWithTerminator(Long.toString(decimalIntValue), false, prefDecimalDigits, prefDecimalDigits, true, '0', SIGN_OPTIONAL, buffer);
    }

    private int computePreferredDecimalDigits(int minDecimalDigits, int maxDecimalDigits, String valueStr) {
        int prefDecimalDigits = this.countDecimalDigits(valueStr);
        if (maxDecimalDigits != -1) {
            prefDecimalDigits = Math.min(prefDecimalDigits, maxDecimalDigits);
        }
        prefDecimalDigits = Math.max(prefDecimalDigits, minDecimalDigits);
        return prefDecimalDigits;
    }

    public String decimalToString(float originalValue, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        this.decimalToString(originalValue, minWidth, maxWidth, lpad, paddingChar, decimalPoint, sign, buffer);
        return buffer.toString();
    }

    public void decimalToString(float originalValue, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        if (Formatter.isSignSeparate(sign)) {
            // empty if block
        }
        this.decimalToStringImpl(originalValue, minWidth, maxWidth, lpad, paddingChar, decimalPoint, sign, buffer);
    }

    private void decimalToStringImpl(float originalValue, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        int decimalIndex;
        int availableWidth;
        int maxDecimalDigits;
        double newValue;
        if (this.hasTerminator()) {
            minWidth = minWidth == maxWidth ? minWidth - 1 : minWidth;
            --maxWidth;
        }
        boolean negative = originalValue < 0.0f;
        int signLength = Formatter.getSignLength(negative, sign);
        float value = Formatter.abs(originalValue);
        String valueStr = Parsing.toString(value);
        if (maxWidth > 0 && valueStr.length() + signLength > maxWidth && (valueStr = Parsing.toString(newValue = MathFunctions.round(value, maxDecimalDigits = (availableWidth = maxWidth - signLength) - (decimalIndex = this.countNumberDigits(valueStr)) - 1))).length() > availableWidth && (valueStr = this.fixMaxWidth(valueStr, availableWidth, maxWidth)).indexOf(46) == -1) {
            lpad = true;
        }
        valueStr = Formatter.fixDecimalPoint(valueStr, decimalPoint);
        int strLength = valueStr.length() + signLength;
        this.padNumberWithTerminator(valueStr, negative, minWidth, lpad, paddingChar, sign, strLength, buffer);
    }

    public String decimalToStringFormatted(float value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int signSeparate) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        this.decimalToStringFormatted(value, numberDigits, decimalDigits, paddingChar, decimalPoint, signSeparate, buffer);
        return buffer.toString();
    }

    public void decimalToStringFormatted(float value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        if (Formatter.isSignSeparate(sign)) {
            if (sign == SIGN_SEPARATE_LEADING) {
                buffer.append(this.getSign(value));
            }
            this.decimalToStringFormattedImpl(Formatter.abs(value), numberDigits, decimalDigits, paddingChar, decimalPoint, SIGN_OPTIONAL, buffer);
            if (sign == SIGN_SEPARATE_TRAILING) {
                buffer.append(this.getSign(value));
            }
        } else {
            this.decimalToStringFormattedImpl(value, numberDigits, decimalDigits, paddingChar, decimalPoint, sign, buffer);
        }
    }

    private void decimalToStringFormattedImpl(float value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        boolean negative = value < 0.0f;
        long numberValue = (long)value;
        long decimalIntValue = Math.round(Formatter.abs(value - (float)numberValue) * (float)PowersOf10[decimalDigits]);
        if (decimalIntValue == PowersOf10[decimalDigits]) {
            decimalIntValue = 0L;
            numberValue += numberValue < 0L ? -1L : 1L;
        }
        this.padNumberWithOutTerminatorExcludeSignSeparate(Long.toString(Math.abs(numberValue)), negative, numberDigits, numberDigits, true, paddingChar, sign, buffer);
        if (decimalPoint != '\u0000') {
            buffer.append(decimalPoint);
        }
        this.padNumberWithOutTerminatorExcludeSignSeparate(Long.toString(decimalIntValue), false, decimalDigits, decimalDigits, true, '0', SIGN_OPTIONAL, buffer);
    }

    public String decimalToStringFormatted(float value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char paddingChar, char decimalPoint, int sign) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        this.decimalToStringFormatted(value, minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, decimalPoint, paddingChar, sign, buffer);
        return buffer.toString();
    }

    public void decimalToStringFormatted(float value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char decimalPoint, char paddingChar, int sign, FastStringBuffer buffer) throws TransformException {
        if (Formatter.isSignSeparate(sign)) {
            if (sign == SIGN_SEPARATE_LEADING) {
                buffer.append(this.getSign(value));
            }
            this.decimalToStringFormattedImpl(Formatter.abs(value), minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, decimalPoint, paddingChar, SIGN_OPTIONAL, buffer);
            if (sign == SIGN_SEPARATE_TRAILING) {
                buffer.append(this.getSign(value));
            }
        } else {
            this.decimalToStringFormattedImpl(value, minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, decimalPoint, paddingChar, sign, buffer);
        }
    }

    private void decimalToStringFormattedImpl(float value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char decimalPoint, char paddingChar, int sign, FastStringBuffer buffer) throws TransformException {
        long decimalIntValue;
        boolean negative = value < 0.0f;
        long numberValue = (long)value;
        int prefDecimalDigits = maxDecimalDigits;
        if (minDecimalDigits != maxDecimalDigits) {
            prefDecimalDigits = this.computePreferredDecimalDigits(minDecimalDigits, maxDecimalDigits, Parsing.toString(value));
        }
        if ((decimalIntValue = (long)Math.round(Formatter.abs(value - (float)numberValue) * (float)PowersOf10[prefDecimalDigits])) == PowersOf10[prefDecimalDigits]) {
            decimalIntValue = 0L;
            numberValue += numberValue < 0L ? -1L : 1L;
        }
        this.padNumberWithOutTerminatorExcludeSignSeparate(Long.toString(Math.abs(numberValue)), negative, minNumberDigits, maxNumberDigits, true, paddingChar, sign, buffer);
        if (decimalPoint != '\u0000') {
            buffer.append(decimalPoint);
        }
        this.padNumberWithTerminator(Long.toString(decimalIntValue), false, prefDecimalDigits, prefDecimalDigits, true, '0', SIGN_OPTIONAL, buffer);
    }

    public String decimalToString(BigDecimal originalValue, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        this.decimalToString(originalValue, minWidth, maxWidth, lpad, paddingChar, decimalPoint, sign, buffer);
        return buffer.toString();
    }

    public void decimalToString(BigDecimal originalValue, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        if (Formatter.isSignSeparate(sign)) {
            // empty if block
        }
        this.decimalToStringImpl(originalValue, minWidth, maxWidth, lpad, paddingChar, decimalPoint, sign, buffer);
    }

    private void decimalToStringImpl(BigDecimal originalValue, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        boolean negative;
        if (this.hasTerminator()) {
            minWidth = minWidth == maxWidth ? minWidth - 1 : minWidth;
            --maxWidth;
        }
        BigDecimal value = (negative = this.isNegative(originalValue)) ? Formatter.abs(originalValue) : originalValue;
        int signLength = Formatter.getSignLength(negative, sign);
        String valueStr = Parsing.toString(value);
        if (maxWidth > 0 && valueStr.length() + signLength > maxWidth) {
            int maxDecimalDigits;
            BigDecimal newValue;
            int availableWidth = maxWidth - signLength;
            int numberDigits = this.countNumberDigits(valueStr);
            if (numberDigits > availableWidth) {
                this.reportMaxWidthError(valueStr, negative, maxWidth);
            }
            if ((valueStr = Parsing.toString(newValue = MathFunctions.round(value, maxDecimalDigits = this.getDecimalDigits(availableWidth, numberDigits)))).length() > availableWidth) {
                valueStr = this.fixMaxWidth(valueStr, availableWidth, maxWidth);
            }
        }
        lpad = this.fixDecimalPadding(lpad, valueStr, paddingChar);
        valueStr = Formatter.fixDecimalPoint(valueStr, decimalPoint);
        int strLength = valueStr.length() + signLength;
        this.padNumberWithTerminator(valueStr, negative, minWidth, lpad, paddingChar, sign, strLength, buffer);
    }

    private boolean fixDecimalPadding(boolean lpad, String valueStr, char paddingChar) {
        if (paddingChar != ' ' && valueStr.indexOf(46) == -1) {
            lpad = true;
        }
        return lpad;
    }

    private int getDecimalDigits(int availableWidth, int numberDigits) {
        int maxDecimalDigits = availableWidth - numberDigits - 1;
        if (maxDecimalDigits == -1) {
            maxDecimalDigits = 0;
        }
        return maxDecimalDigits;
    }

    public String decimalToStringFormatted(BigDecimal value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int signSeparate) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        this.decimalToStringFormatted(value, numberDigits, decimalDigits, paddingChar, decimalPoint, signSeparate, buffer);
        return buffer.toString();
    }

    public void decimalToStringFormatted(BigDecimal value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        if (Formatter.isSignSeparate(sign)) {
            if (sign == SIGN_SEPARATE_LEADING) {
                buffer.append(this.getSign(value));
            }
            this.decimalToStringFormattedImpl(Formatter.abs(value), numberDigits, decimalDigits, paddingChar, decimalPoint, SIGN_OPTIONAL, buffer);
            if (sign == SIGN_SEPARATE_TRAILING) {
                buffer.append(this.getSign(value));
            }
        } else {
            this.decimalToStringFormattedImpl(value, numberDigits, decimalDigits, paddingChar, decimalPoint, sign, buffer);
        }
    }

    private void decimalToStringFormattedImpl(BigDecimal value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        String toRet;
        int dotIndex;
        BigDecimal absValue;
        boolean negative = this.isNegative(value);
        BigDecimal bigDecimal = absValue = negative ? value.abs() : value;
        if (value.compareTo(BigDecimal.valueOf(0L)) != 0) {
            absValue = absValue.setScale(decimalDigits, 4);
        }
        if ((dotIndex = (toRet = Wrapper.toString(absValue)).indexOf(46)) == -1) {
            dotIndex = toRet.length();
        }
        String numpart = toRet.substring(0, dotIndex);
        String decpart = dotIndex < toRet.length() ? toRet.substring(dotIndex + 1) : "";
        this.padNumberWithOutTerminatorExcludeSignSeparate(numpart, negative, numberDigits, numberDigits, true, paddingChar, sign, buffer);
        if (decimalPoint != '\u0000') {
            buffer.append(decimalPoint);
        }
        this.padNumberWithTerminator(decpart, false, decimalDigits, decimalDigits, false, '0', SIGN_OPTIONAL, buffer);
    }

    public String decimalToStringFormatted(BigDecimal value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char paddingChar, char decimalPoint, int sign) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        this.decimalToStringFormatted(value, minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, decimalPoint, paddingChar, sign, buffer);
        return buffer.toString();
    }

    public void decimalToStringFormatted(BigDecimal value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char decimalPoint, char paddingChar, int sign, FastStringBuffer buffer) throws TransformException {
        if (Formatter.isSignSeparate(sign)) {
            if (sign == SIGN_SEPARATE_LEADING) {
                buffer.append(this.getSign(value));
            }
            this.decimalToStringFormattedImpl(Formatter.abs(value), minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, decimalPoint, paddingChar, SIGN_OPTIONAL, buffer);
            if (sign == SIGN_SEPARATE_TRAILING) {
                buffer.append(this.getSign(value));
            }
        } else {
            this.decimalToStringFormattedImpl(value, minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, decimalPoint, paddingChar, sign, buffer);
        }
    }

    private void decimalToStringFormattedImpl(BigDecimal value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char decimalPoint, char paddingChar, int sign, FastStringBuffer buffer) throws TransformException {
        String toRet;
        int dotIndex;
        boolean negative = this.isNegative(value);
        BigDecimal absValue = negative ? value.abs() : value;
        int prefDecimalDigits = maxDecimalDigits;
        if (minDecimalDigits != maxDecimalDigits) {
            prefDecimalDigits = this.computePreferredDecimalDigits(minDecimalDigits, maxDecimalDigits, Parsing.toString(value));
        }
        if ((dotIndex = (toRet = Wrapper.toString(absValue = absValue.setScale(prefDecimalDigits, 4))).indexOf(46)) == -1) {
            dotIndex = toRet.length();
        }
        String numpart = toRet.substring(0, dotIndex);
        String decpart = dotIndex < toRet.length() ? toRet.substring(dotIndex + 1) : "";
        this.padNumberWithOutTerminatorExcludeSignSeparate(numpart, negative, minNumberDigits, maxNumberDigits, true, paddingChar, sign, buffer);
        if (decimalPoint != '\u0000') {
            buffer.append(decimalPoint);
        }
        this.padNumberWithTerminator(decpart, false, prefDecimalDigits, prefDecimalDigits, false, '0', SIGN_OPTIONAL, buffer);
    }

    public String decimalToString(ScaledDecimal originalValue, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        this.decimalToString(originalValue, minWidth, maxWidth, lpad, paddingChar, decimalPoint, sign, buffer);
        return buffer.toString();
    }

    public void decimalToString(ScaledDecimal originalValue, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        if (Formatter.isSignSeparate(sign)) {
            // empty if block
        }
        this.decimalToStringImpl(originalValue, minWidth, maxWidth, lpad, paddingChar, decimalPoint, sign, buffer);
    }

    private void decimalToStringImpl(ScaledDecimal originalValue, int minWidth, int maxWidth, boolean lpad, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        boolean negative;
        if (this.hasTerminator()) {
            minWidth = minWidth == maxWidth ? minWidth - 1 : minWidth;
            --maxWidth;
        }
        ScaledDecimal value = (negative = this.isNegative(originalValue)) ? Formatter.abs(originalValue) : originalValue;
        int signLength = Formatter.getSignLength(negative, sign);
        String valueStr = Parsing.toString(value);
        if (maxWidth > 0 && valueStr.length() + signLength > maxWidth) {
            int maxDecimalDigits;
            ScaledDecimal newValue;
            int availableWidth = maxWidth - signLength;
            int numberDigits = this.countNumberDigits(valueStr);
            if (numberDigits > availableWidth) {
                this.reportMaxWidthError(valueStr, negative, maxWidth);
            }
            if ((valueStr = Parsing.toString(newValue = MathFunctions.round(value, maxDecimalDigits = this.getDecimalDigits(availableWidth, numberDigits)))).length() > availableWidth) {
                valueStr = this.fixMaxWidth(valueStr, availableWidth, maxWidth);
            }
        }
        lpad = this.fixDecimalPadding(lpad, valueStr, paddingChar);
        valueStr = Formatter.fixDecimalPoint(valueStr, decimalPoint);
        int strLength = valueStr.length() + signLength;
        this.padNumberWithTerminator(valueStr, negative, minWidth, lpad, paddingChar, sign, strLength, buffer);
    }

    public String decimalToStringFormatted(ScaledDecimal value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int signSeparate) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        this.decimalToStringFormatted(value, numberDigits, decimalDigits, paddingChar, decimalPoint, signSeparate, buffer);
        return buffer.toString();
    }

    public void decimalToStringFormatted(ScaledDecimal value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        if (numberDigits + decimalDigits > 18) {
            this.reportMaxDigitsError(numberDigits + decimalDigits);
            return;
        }
        if (Formatter.isSignSeparate(sign)) {
            if (sign == SIGN_SEPARATE_LEADING) {
                buffer.append(this.getSign(value));
            }
            this.decimalToStringFormattedImpl(Formatter.abs(value), numberDigits, decimalDigits, paddingChar, decimalPoint, SIGN_OPTIONAL, buffer);
            if (sign == SIGN_SEPARATE_TRAILING) {
                buffer.append(this.getSign(value));
            }
        } else {
            this.decimalToStringFormattedImpl(value, numberDigits, decimalDigits, paddingChar, decimalPoint, sign, buffer);
        }
    }

    private void decimalToStringFormattedImpl(ScaledDecimal value, int numberDigits, int decimalDigits, char paddingChar, char decimalPoint, int sign, FastStringBuffer buffer) throws TransformException {
        boolean negative = this.isNegative(value);
        ScaledDecimal absValue = negative ? Formatter.abs(value) : value;
        String toRet = (absValue = absValue.setScale(decimalDigits, 4)).toString();
        int dotIndex = toRet.indexOf(46);
        if (dotIndex == -1) {
            dotIndex = toRet.length();
        }
        String numpart = toRet.substring(0, dotIndex);
        String decpart = dotIndex < toRet.length() ? toRet.substring(dotIndex + 1) : "";
        this.padNumberWithOutTerminatorExcludeSignSeparate(numpart, negative, numberDigits, numberDigits, true, paddingChar, sign, buffer);
        if (decimalPoint != '\u0000') {
            buffer.append(decimalPoint);
        }
        this.padNumberWithTerminator(decpart, false, decimalDigits, decimalDigits, false, '0', SIGN_OPTIONAL, buffer);
    }

    public String decimalToStringFormatted(ScaledDecimal value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char paddingChar, char decimalPoint, int sign) throws TransformException {
        FastStringBuffer buffer = this.getFreeBuffer();
        this.decimalToStringFormatted(value, minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, decimalPoint, paddingChar, sign, buffer);
        return buffer.toString();
    }

    public void decimalToStringFormatted(ScaledDecimal value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char decimalPoint, char paddingChar, int sign, FastStringBuffer buffer) throws TransformException {
        if (Formatter.isSignSeparate(sign)) {
            if (sign == SIGN_SEPARATE_LEADING) {
                buffer.append(this.getSign(value));
            }
            this.decimalToStringFormattedImpl(Formatter.abs(value), minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, decimalPoint, paddingChar, SIGN_OPTIONAL, buffer);
            if (sign == SIGN_SEPARATE_TRAILING) {
                buffer.append(this.getSign(value));
            }
        } else {
            this.decimalToStringFormattedImpl(value, minNumberDigits, maxNumberDigits, minDecimalDigits, maxDecimalDigits, decimalPoint, paddingChar, sign, buffer);
        }
    }

    private void decimalToStringFormattedImpl(ScaledDecimal value, int minNumberDigits, int maxNumberDigits, int minDecimalDigits, int maxDecimalDigits, char decimalPoint, char paddingChar, int sign, FastStringBuffer buffer) throws TransformException {
        String toRet;
        int dotIndex;
        boolean negative = this.isNegative(value);
        ScaledDecimal absValue = negative ? value.abs() : value;
        int prefDecimalDigits = maxDecimalDigits;
        if (minDecimalDigits != maxDecimalDigits) {
            prefDecimalDigits = this.computePreferredDecimalDigits(minDecimalDigits, maxDecimalDigits, Parsing.toString(value));
        }
        if ((dotIndex = (toRet = (absValue = absValue.setScale(prefDecimalDigits, 4)).toString()).indexOf(46)) == -1) {
            dotIndex = toRet.length();
        }
        String numpart = toRet.substring(0, dotIndex);
        String decpart = dotIndex < toRet.length() ? toRet.substring(dotIndex + 1) : "";
        this.padNumberWithOutTerminatorExcludeSignSeparate(numpart, negative, minNumberDigits, maxNumberDigits, true, paddingChar, sign, buffer);
        if (decimalPoint != '\u0000') {
            buffer.append(decimalPoint);
        }
        this.padNumberWithTerminator(decpart, false, prefDecimalDigits, prefDecimalDigits, false, '0', SIGN_OPTIONAL, buffer);
    }

    public static String quoteReleaseDelimiter(CharSequence valueSeq, String delimiter, char quoteChar, char releaseChar, int quoteOption) {
        String value = valueSeq.toString();
        if (Formatter.shouldQuote(value, delimiter, quoteOption)) {
            FastStringBuffer buffer = new FastStringBuffer();
            if (quoteChar == '\u0000') {
                if (releaseChar != '\u0000') {
                    int location;
                    int start = 0;
                    while ((location = value.indexOf(delimiter, start)) != -1) {
                        buffer.append(value.substring(start, location));
                        buffer.append(releaseChar);
                        buffer.append(delimiter);
                        start = location + delimiter.length();
                    }
                    buffer.append(value.substring(start, value.length()));
                }
            } else {
                buffer.append(quoteChar);
                buffer.append(value);
                buffer.append(quoteChar);
            }
            return buffer.toString();
        }
        return value;
    }

    private static boolean shouldQuote(String value, String delimiter, int quoteOption) {
        switch (quoteOption) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
            case 2: {
                if (delimiter.length() <= 0) break;
                return value.indexOf(delimiter) != -1;
            }
            case 3: {
                return Formatter.hasSpecialChars(value);
            }
        }
        return false;
    }

    private static boolean hasSpecialChars(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) continue;
            return true;
        }
        return false;
    }

    private int countDecimalDigits(String valueStr) {
        int dotIndex = valueStr.indexOf(46);
        if (dotIndex != -1) {
            return valueStr.length() - dotIndex - 1;
        }
        return 0;
    }

    private int countNumberDigits(String valueStr) {
        int dotIndex = valueStr.indexOf(46);
        if (dotIndex != -1) {
            return dotIndex;
        }
        return valueStr.length();
    }

    private String checkMaxWidth(int strLength, int maxWidth, String valueStr, boolean negative) throws TransformException {
        if (maxWidth >= 0 && strLength > maxWidth) {
            if (maxWidth == 0 && valueStr.equals("0")) {
                return "";
            }
            this.reportMaxWidthError(valueStr, negative, maxWidth);
            return valueStr.substring(0, maxWidth);
        }
        return valueStr;
    }

    private void reportMaxWidthError(String valueStr, int maxWidth) throws TransformException {
        if (maxWidth >= valueStr.length()) {
            valueStr = valueStr + "[+/-]" + valueStr;
        }
        TransformException srt134 = TransformException.createFormatted("SRT134", new Object[]{valueStr, String.valueOf(maxWidth)});
        this.exceptionHandler.onException(srt134);
    }

    private void reportMaxWidthError(String valueStr, boolean negative, int maxWidth) throws TransformException {
        if (maxWidth >= valueStr.length()) {
            valueStr = this.getSign(negative) + valueStr;
        }
        TransformException srt134 = TransformException.createFormatted("SRT134", new Object[]{valueStr, String.valueOf(maxWidth)});
        this.exceptionHandler.onException(srt134);
    }

    private void reportMaxDigitsError(int maxWidth) throws TransformException {
        TransformException srt134 = TransformException.createFormatted("SRT134", new Object[]{String.valueOf(maxWidth)});
        this.exceptionHandler.onException(srt134);
    }

    private void reportUnsignedSignError(String valueStr) throws TransformException {
        TransformException srt135 = TransformException.createFormatted("SRT135");
        this.exceptionHandler.onException(srt135);
    }

    private FastStringBuffer getFreeBuffer() {
        this.cachedBuffer.clear();
        return this.cachedBuffer;
    }

    private void padNumberWithTerminator(String valueStr, boolean negative, int minWidth, int maxWidth, boolean lpad, char paddingChar, int sign, FastStringBuffer buffer) throws TransformException {
        int strLength = valueStr.length() + Formatter.getSignLength(negative, sign);
        valueStr = this.checkMaxWidth(strLength, maxWidth, valueStr, negative);
        this.padNumberWithTerminator(valueStr, negative, minWidth, lpad, paddingChar, sign, strLength, buffer);
    }

    private void padNumberWithOutTerminatorExcludeSignSeparate(String valueStr, boolean negative, int minWidth, int maxWidth, boolean lpad, char paddingChar, int sign, FastStringBuffer buffer) throws TransformException {
        int strLength = valueStr.length() + Formatter.getSignLengthInValue(negative, sign);
        valueStr = this.checkMaxWidth(strLength, maxWidth, valueStr, negative);
        this.saveAndClearTerminator();
        this.padNumberWithTerminator(valueStr, negative, minWidth, lpad, paddingChar, sign, strLength, buffer);
        this.restoreTerminator();
    }

    private void padNumberWithTerminator(String valueStr, boolean negative, int minWidth, boolean lpad, char paddingChar, int sign, int strLength, FastStringBuffer buffer) throws TransformException {
        if (negative && sign == 4) {
            this.reportUnsignedSignError(valueStr);
        }
        if (Formatter.isSignSeparate(sign)) {
            if (sign == SIGN_SEPARATE_LEADING) {
                buffer.append(this.getSign(negative));
            }
            if (lpad) {
                if (strLength < minWidth) {
                    Formatter.appendPaddingChar(minWidth - strLength, paddingChar, buffer);
                }
                buffer.append(valueStr);
                if (sign == SIGN_SEPARATE_LEADING) {
                    this.appendTerminator(buffer);
                }
            } else {
                buffer.append(valueStr);
                if (sign == SIGN_SEPARATE_LEADING) {
                    this.appendTerminator(buffer);
                }
                if (strLength < minWidth) {
                    Formatter.appendPaddingChar(minWidth - strLength, paddingChar, buffer);
                }
            }
            if (sign == SIGN_SEPARATE_TRAILING) {
                buffer.append(this.getSign(negative));
                this.appendTerminator(buffer);
            }
        } else if (lpad) {
            Formatter.appendSignCharBeforePadding(negative, sign, paddingChar, buffer);
            if (strLength < minWidth) {
                Formatter.appendPaddingChar(minWidth - strLength, paddingChar, buffer);
            }
            Formatter.appendSignCharAfterPadding(negative, sign, paddingChar, buffer);
            buffer.append(valueStr);
            this.appendTerminator(buffer);
        } else {
            Formatter.appendSignCharRightPadding(negative, sign, buffer);
            buffer.append(valueStr);
            if (paddingChar != '0') {
                this.appendTerminator(buffer);
            }
            if (strLength < minWidth) {
                Formatter.appendPaddingChar(minWidth - strLength, paddingChar, buffer);
            }
            if (paddingChar == '0') {
                this.appendTerminator(buffer);
            }
        }
    }

    private static BigDecimal abs(BigDecimal value) {
        return value.abs();
    }

    private static ScaledDecimal abs(ScaledDecimal value) {
        return value.abs();
    }

    private static double abs(double value) {
        return Math.abs(value);
    }

    private static float abs(float value) {
        return Math.abs(value);
    }

    private boolean isNegative(BigDecimal originalValue) {
        return originalValue.signum() == -1;
    }

    private boolean isNegative(ScaledDecimal originalValue) {
        return originalValue.signum() == -1;
    }

    private char getSign(ScaledDecimal originalValue) {
        boolean negative = originalValue.signum() == -1;
        return negative ? (char)'-' : '+';
    }

    private char getSign(BigDecimal originalValue) {
        boolean negative = originalValue.signum() == -1;
        return negative ? (char)'-' : '+';
    }

    private char getSign(double originalValue) {
        return originalValue < 0.0 ? (char)'-' : '+';
    }

    private char getSign(boolean negative) {
        return negative ? (char)'-' : '+';
    }

    private static boolean isSignMandatory(int sign) {
        return sign == SIGN_MANDATORY;
    }

    public static boolean isSignSeparate(int sign) {
        return sign == SIGN_SEPARATE_LEADING || sign == SIGN_SEPARATE_TRAILING;
    }

    public static boolean isSignRequired(int sign) {
        return sign == SIGN_SEPARATE_LEADING || sign == SIGN_SEPARATE_TRAILING || sign == SIGN_MANDATORY;
    }

    private static void appendSignCharBeforePadding(boolean negative, int sign, char paddingChar, FastStringBuffer buffer) {
        if (paddingChar == '0') {
            if (negative) {
                buffer.append('-');
            } else if (Formatter.isSignMandatory(sign)) {
                buffer.append('+');
            }
        }
    }

    private static int getSignLengthInValue(boolean negative, int sign) {
        return Formatter.isSignSeparate(sign) ? 0 : (negative || Formatter.isSignMandatory(sign) ? 1 : 0);
    }

    private static int getSignLength(boolean negative, int sign) {
        return Formatter.isSignSeparate(sign) ? 1 : (negative || Formatter.isSignMandatory(sign) ? 1 : 0);
    }

    private static void appendSignCharRightPadding(boolean negative, int sign, FastStringBuffer buffer) {
        if (negative) {
            buffer.append('-');
        } else if (Formatter.isSignMandatory(sign)) {
            buffer.append('+');
        }
    }

    private static void appendSignCharAfterPadding(boolean negative, int sign, char paddingChar, FastStringBuffer buffer) {
        if (negative && paddingChar != '0') {
            buffer.append('-');
        } else if (Formatter.isSignMandatory(sign) && !negative && paddingChar != '0') {
            buffer.append('+');
        }
    }

    private String toSign(boolean negative) {
        return negative ? Character.toString('-') : "";
    }

    private static void appendPaddingChar(int length, char paddingChar, FastStringBuffer buffer) {
        if (length > 0) {
            Formatter.appendChar0(length, paddingChar, buffer);
        }
    }

    private static void appendPaddingChar(int length, char paddingChar, CharBinaryBuffer buffer) {
        if (length > 0) {
            Formatter.appendChar0(length, paddingChar, buffer);
        }
    }

    static void pad(String value, int width, char paddingChar, FastStringBuffer buffer) {
        int strLength = value.length();
        if (strLength > width) {
            return;
        }
        int padLength = width - strLength;
        Formatter.appendPaddingChar(padLength, paddingChar, buffer);
    }

    static void pad(String value, int width, char paddingChar, CharBinaryBuffer buffer) {
        int strLength = value.length();
        if (strLength > width) {
            return;
        }
        int padLength = width - strLength;
        Formatter.appendPaddingChar(padLength, paddingChar, buffer);
    }

    private static String fixDecimalPoint(String valueStr, char decimalPoint) {
        if (decimalPoint != '.') {
            valueStr = valueStr.replace('.', decimalPoint);
        }
        return valueStr;
    }

    private String fixMaxWidth(String valueStr, int availableWidth, int maxWidth) throws TransformException {
        int dotIndex = valueStr.indexOf(46);
        if (dotIndex > availableWidth) {
            this.reportMaxWidthError(valueStr, maxWidth);
        } else {
            valueStr = dotIndex == availableWidth ? valueStr.substring(0, availableWidth) : (dotIndex + 1 == availableWidth ? valueStr.substring(0, availableWidth - 1) : valueStr.substring(0, availableWidth));
        }
        return valueStr;
    }

    private static void appendChar0(int length, char c, FastStringBuffer buffer) {
        buffer.append(c, length);
    }

    private static void appendChar0(int length, char c, CharBinaryBuffer buffer) {
        buffer.append(c, length);
    }
}

