/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.runtime.Lookup;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import javax.naming.NamingException;

public class LookupHelper {
    public static final String LOOKUP_IMPL = "com.tplus.transform.runtime.impl.LookupImpl";
    public static final String TRANSFORM_CONTEXT_IMPL = "com.tplus.transform.runtime.TransformContextImpl";

    public static LookupContext getLookupContext() throws NamingException {
        return LookupHelper.getInstance().getLookupContext();
    }

    public static ConnectionPool getConnectionPool(String dataSource) throws TransformException {
        try {
            return LookupHelper.getLookupContext().lookupDataSource(dataSource);
        }
        catch (Exception e) {
            TransformException te = TransformException.createFormatted("SRT565", dataSource);
            te.setDetail(e);
            throw te;
        }
    }

    public static Lookup getInstance() throws NamingException {
        try {
            ClassLoader cl = LookupHelper.class.getClassLoader();
            Class<?> lookupHelperImplClass = null;
            if (cl != null) {
                try {
                    lookupHelperImplClass = Class.forName(LOOKUP_IMPL, true, cl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (lookupHelperImplClass == null) {
                cl = Thread.currentThread().getContextClassLoader();
                lookupHelperImplClass = Class.forName(LOOKUP_IMPL, true, cl);
            }
            return (Lookup)lookupHelperImplClass.newInstance();
        }
        catch (Exception e) {
            NamingException namingException = new NamingException("Error creating lookup context." + e.getMessage());
            namingException.initCause(namingException);
            throw namingException;
        }
    }

    public static TransformContext getTransformContextObject() throws NamingException {
        try {
            ClassLoader cl = LookupHelper.class.getClassLoader();
            Class<?> transformContextHelperImplClass = null;
            if (cl != null) {
                try {
                    transformContextHelperImplClass = Class.forName(TRANSFORM_CONTEXT_IMPL, true, cl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (transformContextHelperImplClass == null) {
                cl = Thread.currentThread().getContextClassLoader();
                transformContextHelperImplClass = Class.forName(TRANSFORM_CONTEXT_IMPL, true, cl);
            }
            return (TransformContext)transformContextHelperImplClass.newInstance();
        }
        catch (Exception e) {
            NamingException namingException = new NamingException("Error creating transform context." + e.getMessage());
            namingException.initCause(namingException);
            throw namingException;
        }
    }
}

