/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.runtime.TransformRuntimeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SecureRandom;

public class MathFunctions {
    private static final float FLOAT_DELTA = 1.0E-4f;
    private static final double DOUBLE_DELTA = 1.0E-4;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    private MathFunctions() {
    }

    public static boolean approxEquals(float num1, float num2) {
        return Math.abs(num1 - num2) < 1.0E-4f;
    }

    public static boolean approxEquals(double num1, double num2) {
        return Math.abs(num1 - num2) < 1.0E-4;
    }

    public static int abs(int number) {
        return Math.abs(number);
    }

    public static float abs(float number) {
        return Math.abs(number);
    }

    public static double abs(double number) {
        return Math.abs(number);
    }

    public static BigDecimal abs(BigDecimal number) {
        return number.abs();
    }

    public static ScaledDecimal abs(ScaledDecimal number) {
        return number.abs();
    }

    public static BigInteger abs(BigInteger number) {
        return number.abs();
    }

    public static double ceiling(double number, double significance) {
        if (number < 0.0 && significance > 0.0 || number > 0.0 && significance < 0.0) {
            throw TransformRuntimeException.createFormatted("SRT567");
        }
        if (significance == 0.0) {
            throw TransformRuntimeException.createFormatted("SRT568");
        }
        double modValue = number % significance;
        if (modValue == 0.0) {
            return Math.round(number);
        }
        return significance - modValue + number;
    }

    public static int ceiling(double number, int significance) {
        return (int)MathFunctions.ceiling(number, (double)significance);
    }

    public static double ceiling(int number, double significance) {
        return MathFunctions.ceiling((double)number, significance);
    }

    public static int ceiling(int number, int significance) {
        return (int)MathFunctions.ceiling((double)number, (double)significance);
    }

    public static double degrees(double angle) {
        return Math.toDegrees(angle);
    }

    public static double degrees(int angle) {
        return Math.toDegrees(angle);
    }

    public static double radians(double angle) {
        return Math.toRadians(angle);
    }

    public static double radians(int angle) {
        return Math.toRadians(angle);
    }

    public static int even(double number) {
        double modValue = number % 2.0;
        if (modValue == 0.0) {
            return (int)number;
        }
        if (number >= 0.0) {
            if (modValue == 1.0) {
                return (int)(number + modValue);
            }
            return (int)(number + (2.0 - modValue));
        }
        if (modValue == 1.0) {
            return (int)(number - modValue);
        }
        return (int)(number - (2.0 + modValue));
    }

    public static int even(int number) {
        return MathFunctions.even((double)number);
    }

    public static int odd(double number) {
        double modValue = number % 2.0;
        if (modValue == 1.0 || modValue == -1.0) {
            return (int)number;
        }
        if (number >= 0.0) {
            if (modValue == 0.0) {
                return (int)(number + 1.0);
            }
            if (modValue < 1.0) {
                return (int)(number + (1.0 - modValue));
            }
            return (int)(number + (3.0 - modValue));
        }
        if (modValue == 0.0) {
            return (int)(number - 1.0);
        }
        if (modValue < 1.0) {
            return (int)(number + (modValue - 1.0));
        }
        return (int)(number + (modValue - 3.0));
    }

    public static int odd(int number) {
        return MathFunctions.odd((double)number);
    }

    public static double exp(double number) {
        return Math.exp(number);
    }

    public static double exp(int number) {
        return Math.exp(number);
    }

    public static double log(double number, double base) {
        if (number <= 0.0 || base <= 0.0) {
            throw TransformRuntimeException.createFormatted("SRT569");
        }
        return Math.log(number) / Math.log(base);
    }

    public static double log(int number, int base) {
        if (number <= 0 || base <= 0) {
            throw TransformRuntimeException.createFormatted("SRT569");
        }
        return Math.log(number) / Math.log(base);
    }

    public static double log(int number, double base) {
        if (number <= 0 || base <= 0.0) {
            throw TransformRuntimeException.createFormatted("SRT569");
        }
        return Math.log(number) / Math.log(base);
    }

    public static double log(double number, int base) {
        if (number <= 0.0 || base <= 0) {
            throw TransformRuntimeException.createFormatted("SRT569");
        }
        return Math.log(number) / Math.log(base);
    }

    public static double log10(double number) {
        if (number <= 0.0) {
            throw TransformRuntimeException.createFormatted("SRT570");
        }
        return Math.log(number) / Math.log(10.0);
    }

    public static double log10(int number) {
        if (number <= 0) {
            throw TransformRuntimeException.createFormatted("SRT570");
        }
        return Math.log(number) / Math.log(10.0);
    }

    public static double ln(double number) {
        if (number <= 0.0) {
            throw TransformRuntimeException.createFormatted("SRT570");
        }
        return Math.log(number);
    }

    public static double ln(int number) {
        if (number <= 0) {
            throw TransformRuntimeException.createFormatted("SRT570");
        }
        return Math.log(number);
    }

    public static double fact(int number) {
        if (number < 0) {
            throw TransformRuntimeException.createFormatted("SRT571");
        }
        if (number == 0) {
            return 1.0;
        }
        double factValue = 0.0;
        return factValue += (double)number * MathFunctions.fact(number - 1);
    }

    public static double fact(double number) {
        return MathFunctions.fact((int)number);
    }

    public static double roundToInt(double number) {
        return Math.round(number);
    }

    public static int roundToInt(int number) {
        return number;
    }

    public static double pi() {
        return Math.PI;
    }

    public static double power(double number, double power) {
        return Math.pow(number, power);
    }

    public static double power(int number, int power) {
        return Math.pow(number, power);
    }

    public static double power(int number, double power) {
        return Math.pow(number, power);
    }

    public static double power(double number, int power) {
        return Math.pow(number, power);
    }

    public static double rand() {
        return SECURE_RANDOM.nextDouble();
    }

    public static BigDecimal round(BigDecimal number, int num_digits) {
        return number.setScale(num_digits, 4);
    }

    public static ScaledDecimal round(ScaledDecimal number, int num_digits) {
        return number.round(num_digits);
    }

    public static BigInteger roundToInt(BigDecimal number) {
        return number.setScale(0, 4).unscaledValue();
    }

    public static ScaledDecimal roundToInt(ScaledDecimal number) {
        return number.round(0);
    }

    public static int sign(BigDecimal number) {
        return number.signum();
    }

    public static int sign(BigInteger number) {
        return number.signum();
    }

    public static BigDecimal negate(BigDecimal number) {
        return number.negate();
    }

    public static ScaledDecimal negate(ScaledDecimal number) {
        return number.negate();
    }

    public static BigInteger negate(BigInteger number) {
        return number.negate();
    }

    public static BigInteger power(BigInteger number, int exponent) {
        return number.pow(exponent);
    }

    public static int max(int v1, int v2) {
        return v1 > v2 ? v1 : v2;
    }

    public static long max(long v1, long v2) {
        return v1 > v2 ? v1 : v2;
    }

    public static double max(double v1, double v2) {
        return v1 > v2 ? v1 : v2;
    }

    public static float max(float v1, float v2) {
        return v1 > v2 ? v1 : v2;
    }

    public static BigDecimal max(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) > 0 ? v1 : v2;
    }

    public static ScaledDecimal max(ScaledDecimal v1, ScaledDecimal v2) {
        return v1.compareTo(v2) > 0 ? v1 : v2;
    }

    public static BigInteger max(BigInteger v1, BigInteger v2) {
        return v1.compareTo(v2) > 0 ? v1 : v2;
    }

    public static int min(int v1, int v2) {
        return v1 > v2 ? v2 : v1;
    }

    public static long min(long v1, long v2) {
        return v1 > v2 ? v2 : v1;
    }

    public static double min(double v1, double v2) {
        return v1 > v2 ? v2 : v1;
    }

    public static float min(float v1, float v2) {
        return v1 > v2 ? v2 : v1;
    }

    public static BigDecimal min(BigDecimal v1, BigDecimal v2) {
        return v1.compareTo(v2) > 0 ? v2 : v1;
    }

    public static ScaledDecimal min(ScaledDecimal v1, ScaledDecimal v2) {
        return v1.compareTo(v2) > 0 ? v2 : v1;
    }

    public static BigInteger min(BigInteger v1, BigInteger v2) {
        return v1.compareTo(v2) > 0 ? v2 : v1;
    }

    public static void cmtmain(String[] args) {
        BigDecimal bigDecimal = new BigDecimal("-20.445111111111");
        BigDecimal bigDecimal2 = MathFunctions.round(bigDecimal, 2);
        System.out.println(bigDecimal2);
        BigInteger bigInt = MathFunctions.roundToInt(bigDecimal);
        System.out.println(bigInt);
    }

    public static double round(double number, int num_digits) {
        if (num_digits < 0) {
            num_digits = 0;
        }
        if (num_digits == 0) {
            return Math.floor(number + 0.5);
        }
        double mFactor = MathFunctions.computeFactor(num_digits);
        double value = Math.floor(number * mFactor + 0.5);
        return value / mFactor;
    }

    private static double computeFactor(int num_digits) {
        long mFactor = 1L;
        while (num_digits != 0) {
            mFactor *= 10L;
            --num_digits;
        }
        return mFactor;
    }

    public static int round(int number, int num_digits) {
        return (int)MathFunctions.round((double)number, num_digits);
    }

    public static int sign(double number) {
        if (number > 0.0) {
            return 1;
        }
        if (number == 0.0) {
            return 0;
        }
        return -1;
    }

    public static int sign(int number) {
        return MathFunctions.sign((double)number);
    }

    public static double sqrt(double number) {
        if (number < 0.0) {
            throw TransformRuntimeException.createFormatted("SRT571");
        }
        return Math.sqrt(number);
    }

    public static double sqrt(int number) {
        return MathFunctions.sqrt((double)number);
    }

    public static double trunc(double number, int num_digits) {
        int mFactor = 1;
        if (num_digits == 0) {
            return (int)number;
        }
        if (num_digits > 0) {
            while (num_digits != 0) {
                mFactor *= 10;
                --num_digits;
            }
            int value = (int)(number * (double)mFactor);
            return (double)value / (double)mFactor;
        }
        while (num_digits != 0) {
            mFactor *= 10;
            ++num_digits;
        }
        int value = (int)(number / (double)mFactor);
        return (double)value * (double)mFactor;
    }

    public static int trunc(int number, int num_digits) {
        return (int)MathFunctions.trunc((double)number, num_digits);
    }
}

