/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.io.FilenameUtils;
import com.tplus.transform.lang.CharBinaryBuffer;
import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.Binary;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.MemoryRawOutputMessage;
import com.tplus.transform.runtime.PropertyMap;
import com.tplus.transform.runtime.RawInputMessage;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.RawOutputMessage;
import com.tplus.transform.runtime.StringInputSource;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.Variant;
import com.tplus.transform.runtime.VariantGeneric;
import com.tplus.transform.runtime.collection.RawMessageList;
import com.tplus.transform.runtime.collection.StringList;
import com.tplus.transform.runtime.formula.BinaryFunctions;
import com.tplus.transform.runtime.formula.MessageScanner;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Set;

public class MessageFunctions {
    public static final String FILE_INPUT_SOURCE_CLASS = "com.tplus.transform.runtime.FileInputSource";
    public static final String FILE_INPUT_OUTPUT_MESSAGE_CLASS = "com.tplus.transform.runtime.FileInputOutputMessage";
    public static final String READ_FLAG = "r";
    public static final String WRITE_FLAG = "w";
    public static final String READ_WRITE_FLAG = "rw";

    public static String getPropertyType(PropertyMap message, String propertyName) {
        Object prop = message.getProperty(propertyName);
        if (prop instanceof String) {
            return DesignerTypes.STRING_TYPE.getName();
        }
        if (prop instanceof Integer) {
            return DesignerTypes.INT_TYPE.getName();
        }
        if (prop instanceof Float) {
            return DesignerTypes.FLOAT_TYPE.getName();
        }
        if (prop instanceof Double) {
            return DesignerTypes.DOUBLE_TYPE.getName();
        }
        if (prop instanceof Date) {
            return DesignerTypes.DATE_TIME_TYPE.getName();
        }
        if (prop instanceof Boolean) {
            return DesignerTypes.BOOLEAN_TYPE.getName();
        }
        return "";
    }

    public static int getProperty(PropertyMap message, String propertyName, int value) {
        value = message.getIntProperty(propertyName, value);
        return value;
    }

    public static long getProperty(PropertyMap message, String propertyName, long value) {
        value = message.getLongProperty(propertyName, value);
        return value;
    }

    public static double getProperty(PropertyMap message, String propertyName, double value) {
        value = message.getDoubleProperty(propertyName, value);
        return value;
    }

    public static float getProperty(PropertyMap message, String propertyName, float value) {
        value = (float)message.getDoubleProperty(propertyName, value);
        return value;
    }

    public static boolean getProperty(PropertyMap message, String propertyName, boolean value) {
        value = message.getBooleanProperty(propertyName, value);
        return value;
    }

    public static Date getProperty(PropertyMap message, String propertyName, Date value) {
        value = message.getDateProperty(propertyName, value);
        return value;
    }

    public static String getProperty(PropertyMap message, String propertyName, String value) {
        value = message.getStringProperty(propertyName, value);
        return value;
    }

    public static String getProperty(PropertyMap message, String propertyName) {
        String value = message.getStringProperty(propertyName, null);
        if (value != null) {
            return value;
        }
        return "";
    }

    public static Variant getObjectProperty(PropertyMap message, String propertyName) {
        Object value = message.getProperty(propertyName, null);
        if (value != null) {
            return new VariantGeneric(value);
        }
        return null;
    }

    public static PropertyMap getProperties(PropertyMap message, String propertyName) {
        return message.getProperties(propertyName);
    }

    public static void setProperty(PropertyMap message, String propertyName, String propertyValue) {
        message.setStringProperty(propertyName, propertyValue);
    }

    public static void setProperty(PropertyMap message, String propertyName, int propertyValue) {
        message.setIntProperty(propertyName, propertyValue);
    }

    public static void setProperty(PropertyMap message, String propertyName, long propertyValue) {
        message.setLongProperty(propertyName, propertyValue);
    }

    public static void setProperty(PropertyMap message, String propertyName, double propertyValue) {
        message.setDoubleProperty(propertyName, propertyValue);
    }

    public static void setProperty(PropertyMap message, String propertyName, float propertyValue) {
        message.setProperty(propertyName, Wrapper.box(propertyValue));
    }

    public static void setProperty(PropertyMap message, String propertyName, boolean propertyValue) {
        message.setBooleanProperty(propertyName, propertyValue);
    }

    public static void setProperty(PropertyMap message, String propertyName, Date propertyValue) {
        message.setDateProperty(propertyName, propertyValue);
    }

    public static void setObjectProperty(PropertyMap message, String propertyName, Variant propertyValue) {
        if (propertyValue != null) {
            message.setProperty(propertyName, propertyValue.getValue());
        } else {
            message.setProperty(propertyName, null);
        }
    }

    public static void removeProperty(PropertyMap message, String propertyName) {
        message.removeProperty(propertyName);
    }

    public static void clearProperties(PropertyMap message) {
        message.clearProperties();
    }

    public static void putProperties(PropertyMap dest, PropertyMap sec) {
        dest.putProperties(sec);
    }

    public static int getPropertyCount(PropertyMap message) {
        return message.getPropertyCount();
    }

    public static boolean hasProperty(PropertyMap message, String propertyName) {
        return message.hasProperty(propertyName);
    }

    public static StringList getPropertyNames(PropertyMap message) {
        return message.getPropertyNames();
    }

    public static StringList getPropertyNames(PropertyMap message, final String wildCard) {
        StringList names = message.getPropertyNames(new PropertyMap.PropertyNameFilter(){

            public boolean match(String name) {
                return FilenameUtils.wildcardMatch(name, wildCard);
            }
        });
        return names;
    }

    public static String getName(RawMessage message) {
        return message.getName();
    }

    public static void setName(RawMessage message, String name) {
        message.setName(name);
    }

    public static String getEncoding(RawMessage message) {
        return message.getEncoding();
    }

    public static void setEncoding(RawMessage message, String name) {
        message.setEncoding(name);
    }

    public static StringList getAttachmentNames(RawMessage message) {
        Set names = message.getAttachmentNames();
        return new StringList(names.toArray(new String[names.size()]));
    }

    public static RawMessageList getAttachments(RawMessage message) {
        return message.getAttachments();
    }

    public static RawMessage getAttachment(RawMessage message, String name) {
        RawMessage value = message.getAttachment(name);
        return value;
    }

    public static boolean hasAttachment(RawMessage message, String name) {
        return message.hasAttachment(name);
    }

    public static void setAttachment(RawMessage message, String name, RawMessage attachment) {
        message.addAttachment(name, attachment);
    }

    public static RawMessage toRawMessage(byte[] bytes) {
        return new ByteArrayInputSource(bytes);
    }

    public static RawMessage toRawMessage(byte[] bytes, String encoding) {
        ByteArrayInputSource byteArrayInputSource = new ByteArrayInputSource(bytes);
        byteArrayInputSource.setEncoding(encoding);
        return byteArrayInputSource;
    }

    public static RawMessage toRawMessage(String value) {
        return new StringInputSource(value);
    }

    public static RawMessage toRawMessage(String value, String encoding) {
        StringInputSource stringInputSource = new StringInputSource(value);
        stringInputSource.setEncoding(encoding);
        return stringInputSource;
    }

    public static RawMessage newFileMessage(String fileName) throws TransformException {
        fileName = fileName.trim();
        return (RawMessage)MessageFunctions.createInstance(FILE_INPUT_SOURCE_CLASS, new Object[]{fileName});
    }

    public static RawMessage newFileMessage(String fileName, String mode) throws TransformException {
        fileName = fileName.trim();
        if (mode.equals(READ_FLAG)) {
            return (RawMessage)MessageFunctions.createInstance(FILE_INPUT_SOURCE_CLASS, new Object[]{fileName});
        }
        if (mode.equals(WRITE_FLAG)) {
            new File(fileName).delete();
            return (RawMessage)MessageFunctions.createInstance(FILE_INPUT_OUTPUT_MESSAGE_CLASS, new Object[]{fileName});
        }
        if (mode.equals(READ_WRITE_FLAG)) {
            return (RawMessage)MessageFunctions.createInstance(FILE_INPUT_OUTPUT_MESSAGE_CLASS, new Object[]{fileName});
        }
        throw new TransformException("Unsupported file open mode " + mode);
    }

    public static RawMessage newFileMessage(String fileName, String mode, String encoding) throws TransformException {
        RawMessage rawMessage = MessageFunctions.newFileMessage(fileName, mode);
        rawMessage.setEncoding(encoding);
        return rawMessage;
    }

    public static RawMessage newCachedMessage() throws TransformException {
        return MessageFunctions.newCachedMessage(RawMessage.PLATFORM_DEFAULT_ENCODING);
    }

    public static RawMessage newCachedMessage(String encoding) throws TransformException {
        return (RawMessage)MessageFunctions.createInstance("com.tplus.transform.runtime.CachedMessage", new Object[]{encoding});
    }

    public static RawMessage newMessage() {
        return new MemoryRawOutputMessage(RawMessage.PLATFORM_DEFAULT_ENCODING);
    }

    public static RawMessage newMessage(String encoding) {
        return new MemoryRawOutputMessage(encoding);
    }

    public static void close(RawMessage message) throws TransformException {
        message.dispose();
    }

    public static void append(RawMessage message, Variant variant) throws TransformException {
        Object value = variant.getValue();
        if (value instanceof String) {
            MessageFunctions.append(message, (String)value);
        } else if (value instanceof byte[]) {
            MessageFunctions.append(message, (byte[])value);
        } else if (value instanceof RawMessage) {
            MessageFunctions.append(message, (RawMessage)value);
        } else {
            MessageFunctions.append(message, variant.getType().format(value));
        }
    }

    public static void append(RawMessage message, byte[] bytes) throws TransformException {
        MessageFunctions.toRawOutputMessage(message).append(bytes);
    }

    public static void append(RawMessage message, String bytes) throws TransformException {
        MessageFunctions.toRawOutputMessage(message).append(bytes);
    }

    public static void append(RawMessage message, RawMessage mes2) throws TransformException {
        MessageFunctions.toRawOutputMessage(message).append(mes2);
    }

    public static String toText(RawMessage message) throws TransformException {
        return MessageFunctions.toRawInputMessage(message).getAsString();
    }

    public static String toText(RawMessage message, String encoding) throws TransformException {
        return MessageFunctions.toRawInputMessage(message).getAsString(encoding);
    }

    public static byte[] toBinary(RawMessage message) throws TransformException {
        return MessageFunctions.toRawInputMessage(message).getAsBytes();
    }

    private static RawOutputMessage toRawOutputMessage(RawMessage message) throws TransformException {
        if (message instanceof RawOutputMessage) {
            return message;
        }
        throw TransformException.createFormatted("SRT588");
    }

    public static RawInputMessage toRawInputMessage(RawMessage message) throws TransformException {
        if (message instanceof RawInputMessage) {
            return message;
        }
        throw TransformException.createFormatted("SRT589");
    }

    public static int length(RawMessage v1) throws TransformException {
        return v1.getLength();
    }

    public static long longLength(RawMessage v1) throws TransformException {
        return v1.getLongLength();
    }

    public static int byteAt(RawMessage message, int index) throws TransformException {
        return message.getByte(index);
    }

    public static int byteAt(RawMessage message, long index) throws TransformException {
        return message.getByte(index);
    }

    public static byte[] left(RawMessage v1, int num_chars) throws TransformException {
        return MessageFunctions.mid(v1, 0L, num_chars);
    }

    public static byte[] right(RawMessage str, int num_chars) throws TransformException {
        return MessageFunctions.mid(str, str.getLongLength() - (long)num_chars, num_chars);
    }

    public static byte[] mid(RawMessage v1, int start_index, int num_chars) throws TransformException {
        return MessageFunctions.mid(v1, (long)start_index, num_chars);
    }

    public static byte[] mid(RawMessage v1, long start_index, int num_chars) throws TransformException {
        RawInputMessage message = MessageFunctions.toRawInputMessage(v1);
        if (start_index < 0L) {
            start_index = 0L;
        }
        if (num_chars < 0) {
            return BinaryFunctions.ZERO_BYTES;
        }
        int toRead = num_chars;
        byte[] toRet = new byte[num_chars];
        int lengthRead = message.getBytes(start_index, toRet, 0, num_chars);
        if (lengthRead < toRead) {
            byte[] newBuf = new byte[lengthRead];
            System.arraycopy(toRet, 0, newBuf, 0, lengthRead);
            toRet = newBuf;
        }
        return toRet;
    }

    public static RawMessage subMessage(RawMessage v1, int start_index) throws TransformException {
        return MessageFunctions.subMessageImpl(v1, start_index, -1);
    }

    public static RawMessage subMessage(RawMessage v1, int start_index, int num_chars) throws TransformException {
        return MessageFunctions.subMessage(v1, (long)start_index, num_chars);
    }

    public static RawMessage subMessage(RawMessage v1, long start_index, int num_chars) throws TransformException {
        if (num_chars < 0) {
            return new ByteArrayInputSource(BinaryFunctions.ZERO_BYTES);
        }
        return MessageFunctions.subMessageImpl(v1, start_index, num_chars);
    }

    private static RawMessage subMessageImpl(RawMessage v1, long start_index, int num_chars) throws TransformException {
        start_index = Math.max(start_index, 0L);
        return v1.subMessage(start_index, num_chars);
    }

    public static int findFirst(RawMessage str1, char charToFind) throws TransformException {
        return MessageFunctions.findFirst(str1, charToFind, 0);
    }

    public static int findFirst(RawMessage str1, char charToFind, int start_index) throws TransformException {
        return (int)MessageFunctions.findFirst(str1, charToFind, (long)start_index);
    }

    public static long findFirst(RawMessage str1, char charToFind, long start_index) throws TransformException {
        if (str1 == null) {
            return -1L;
        }
        start_index = Math.max(start_index, 0L);
        return MessageFunctions.indexOf(str1, charToFind, start_index);
    }

    public static int findFirst(RawMessage str1, String toFind) throws TransformException {
        return MessageFunctions.findFirst(str1, toFind, 0);
    }

    public static int findFirst(RawMessage str1, String toFind, int start_index) throws TransformException {
        return (int)MessageFunctions.findFirst(str1, toFind, (long)start_index);
    }

    public static long findFirst(RawMessage str1, String toFind, long start_index) throws TransformException {
        if (str1 == null) {
            return -1L;
        }
        start_index = Math.max(start_index, 0L);
        try {
            byte[] sequence = CharBinaryBuffer.stringToBytes(toFind, str1.getEncoding());
            return MessageFunctions.indexOf(str1, sequence, start_index);
        }
        catch (UnsupportedEncodingException e) {
            TransformException tre = TransformException.createFormatted("SRT593", str1.getEncoding());
            tre.setDetail(e);
            throw tre;
        }
    }

    public static int findFirst(RawMessage str1, StringList toFind) throws TransformException {
        return MessageFunctions.findFirst(str1, toFind, 0);
    }

    public static int findFirst(RawMessage str1, StringList toFind, int start_index) throws TransformException {
        return (int)MessageFunctions.findFirst(str1, toFind, (long)start_index);
    }

    public static long findFirst(RawMessage str1, StringList toFind, long start_index) throws TransformException {
        if (str1 == null) {
            return -1L;
        }
        start_index = Math.max(start_index, 0L);
        String encoding = str1.getEncoding();
        try {
            byte[][] sequences = MessageFunctions.prepareByteSequences(toFind, encoding);
            return MessageFunctions.indexOf(str1, sequences, start_index);
        }
        catch (UnsupportedEncodingException e) {
            TransformException tre = TransformException.createFormatted("SRT593", encoding);
            tre.setDetail(e);
            throw tre;
        }
    }

    private static byte[][] prepareByteSequences(StringList toFind, String encoding) throws UnsupportedEncodingException {
        byte[][] sequences = new byte[toFind.size()][];
        for (int i = 0; i < toFind.size(); ++i) {
            String s = toFind.getValue(i);
            byte[] sequence = CharBinaryBuffer.stringToBytes(s, encoding);
            sequences[i] = sequence;
        }
        return sequences;
    }

    private static int getLength(RawMessage str1) throws TransformException {
        return str1 == null ? 0 : str1.getLength();
    }

    private static long indexOf(RawMessage str1, byte[] sequence, long start_index) throws TransformException {
        int b;
        long i = start_index;
        while ((b = str1.getByte(i)) != -1) {
            if (sequence.length > 0 && b == Binary.getByteAt(sequence, 0) && MessageFunctions.isSequenceMatch(str1, i, sequence)) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    private static long indexOf(RawMessage str1, byte[][] sequences, long start_index) throws TransformException {
        int b;
        long i = start_index;
        while ((b = str1.getByte(i)) != -1) {
            for (int j = 0; j < sequences.length; ++j) {
                byte[] sequence = sequences[j];
                if (sequence.length <= 0 || b != Binary.getByteAt(sequence, 0) || !MessageFunctions.isSequenceMatch(str1, i, sequence)) continue;
                return i;
            }
            ++i;
        }
        return -1L;
    }

    private static boolean isSequenceMatch(RawMessage str1, long index, byte[] sequence) throws TransformException {
        for (long i = index; i < index + (long)sequence.length; ++i) {
            int byteVal = str1.getByte(i);
            if (byteVal == -1) {
                return false;
            }
            if (byteVal == Binary.getByteAt(sequence, (int)(i - index))) continue;
            return false;
        }
        return true;
    }

    private static long indexOf(RawMessage str1, char charToFind, long start_index) throws TransformException {
        try {
            String str = new String(new char[]{charToFind});
            int byteToFind = Binary.getByteAt(CharBinaryBuffer.stringToBytes(str, str1.getEncoding()), 0);
            start_index = Math.max(start_index, 0L);
            int length = MessageFunctions.getLengthOrUndefined(str1);
            for (long i = start_index; i < (long)length; ++i) {
                try {
                    int b = str1.getByte(i);
                    if (b != byteToFind) continue;
                    return i;
                }
                catch (TransformException e) {
                    if (e.getCause() instanceof EOFException) break;
                    throw e;
                }
            }
            return -1L;
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    private static int getLengthOrUndefined(RawMessage str1) {
        try {
            return MessageFunctions.getLength(str1);
        }
        catch (TransformException e) {
            return Integer.MAX_VALUE;
        }
    }

    private static int throwOutOfBounds(RawMessage message, int index) throws TransformException {
        throw TransformRuntimeException.createFormatted("SRT591", new Object[]{String.valueOf(index), String.valueOf(message.getLength())});
    }

    public static MessageScanner createScanner(RawMessage message) throws TransformException {
        return new MessageScanner(MessageFunctions.toRawInputMessage(message));
    }

    public static MessageScanner createScanner(byte[] message) throws TransformException {
        return new MessageScanner(message);
    }

    public static byte[] peek(MessageScanner scanner, int length) throws TransformException {
        return scanner.peek(length);
    }

    public static byte[] peek(MessageScanner scanner, int start, int length) throws TransformException {
        return scanner.peek(start, length);
    }

    public static byte[] read(MessageScanner scanner, int length) throws IOException {
        return scanner.read(length);
    }

    private static Object createInstance(String className, Object[] params) throws TransformException {
        Class[] classes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            classes[i] = param.getClass();
        }
        try {
            Class cls = MessageFunctions.loadClass(className);
            Constructor constructor = cls.getConstructor(classes);
            return constructor.newInstance(params);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new TransformException(targetException.getMessage(), targetException);
        }
        catch (ClassNotFoundException e) {
            throw new TransformException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new TransformException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new TransformException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        Class<?> cls;
        try {
            ClassLoader cl = MessageFunctions.class.getClassLoader();
            cls = Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException e) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            cls = Class.forName(className, true, cl);
        }
        return cls;
    }
}

