/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.runtime.RawInputMessage;
import com.tplus.transform.runtime.TransformException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class MessageScanner {
    BufferedInputStream inputStream;
    private static final int MAX_PEEK_LIMIT = 10000;

    public MessageScanner(RawInputMessage message) throws TransformException {
        this.inputStream = new BufferedInputStream(message.getAsStream());
    }

    public MessageScanner(byte[] message) throws TransformException {
        this.inputStream = new BufferedInputStream(new ByteArrayInputStream(message));
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    byte[] read(int nbytes) throws IOException {
        byte[] bytes = new byte[nbytes];
        int read = this.fill(bytes);
        if (read < nbytes) {
            bytes = MessageScanner.trimTo(bytes, read);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasMore() throws TransformException {
        try {
            try {
                this.inputStream.mark(1);
                if (this.inputStream.read() != -1) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.inputStream.reset();
            }
        }
        catch (IOException e) {
            TransformException te = TransformException.createFormatted("SRT590");
            te.setDetail(e);
            throw te;
        }
    }

    byte[] readExact(int nbytes) throws IOException {
        byte[] bytes = new byte[nbytes];
        int read = this.fill(bytes);
        if (read < nbytes) {
            // empty if block
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] peek(int nbytes) throws TransformException {
        byte[] byArray;
        this.inputStream.mark(nbytes);
        try {
            byte[] bytes = new byte[nbytes];
            this.fill(bytes);
            byArray = bytes;
        }
        catch (Throwable throwable) {
            try {
                this.inputStream.reset();
                throw throwable;
            }
            catch (IOException e) {
                TransformException te = TransformException.createFormatted("SRT590");
                te.setDetail(e);
                throw te;
            }
        }
        this.inputStream.reset();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] peek(int start, int nbytes) throws TransformException {
        byte[] byArray;
        this.inputStream.mark(start + nbytes);
        try {
            this.skipFully(start);
            byte[] bytes = new byte[nbytes];
            this.fill(bytes);
            byArray = bytes;
        }
        catch (Throwable throwable) {
            try {
                this.inputStream.reset();
                throw throwable;
            }
            catch (IOException e) {
                TransformException te = TransformException.createFormatted("SRT590");
                te.setDetail(e);
                throw te;
            }
        }
        this.inputStream.reset();
        return byArray;
    }

    private void skipFully(int start) throws IOException {
        this.inputStream.skip(start);
    }

    private static byte[] trimTo(byte[] bytes, int read) {
        if (bytes.length < read) {
            byte[] toRet = new byte[read];
            System.arraycopy(bytes, 0, toRet, 0, read);
            return toRet;
        }
        return bytes;
    }

    private int fill(byte[] bytes) throws IOException {
        int read = this.inputStream.read(bytes);
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findNext(int b) throws TransformException {
        int i = 0;
        if (i >= 100) return -1;
        try {
            this.inputStream.mark(10000 * (i + 1));
            if (i > 0) {
                this.inputStream.skip(10000 * i);
            }
            try {
                int location = this.find0(b);
                if (location == -2) return -1;
                int n = location;
                return n;
            }
            finally {
                this.inputStream.reset();
            }
        }
        catch (IOException e) {
            TransformException te = TransformException.createFormatted("SRT590");
            te.setDetail(e);
            throw te;
        }
    }

    int find0(int b) throws IOException {
        for (int i = 0; i < 10000; ++i) {
            int readByte = this.inputStream.read();
            if (readByte == b) {
                return i;
            }
            if (readByte != -1) continue;
            return -1;
        }
        return -2;
    }
}

