/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DataObjectSectionImpl;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.SectionMetaInfoImpl;
import com.tplus.transform.runtime.SimpleGenericDataObject;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.formula.UtilFunctions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class PropertyFunctions {
    public static final String VALUE = "value";
    public static final String NAME = "name";
    public static final String PROPERTY = "Property";
    public static final String PROPERTIES = "Properties";
    private static final String[] property_fields = new String[]{"name", "value"};
    private static final DesignerType[] property_types = new DesignerType[]{DesignerType.DESIGNER_STRING_TYPE, DesignerType.DESIGNER_STRING_TYPE};
    private static DataObjectMetaInfo propertyMetaInfo = new DataObjectMetaInfoImpl(property_fields, property_types);

    public static DataObject createProperties() {
        return PropertyFunctions.createPropertiesObject();
    }

    public static DataObject loadPropertiesFromResource(String resource) throws TransformException {
        PropertiesGenericDataObject propertiesObj = PropertyFunctions.createPropertiesObject();
        PropertyFunctions.loadPropertiesFromResource(resource, propertiesObj);
        return propertiesObj;
    }

    public static void loadPropertiesFromResource(String resource, DataObject propertiesObj) throws TransformException {
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        DataObjectSection propObjSection = propertiesObj.getSection(PROPERTY);
        InputStream resourceAsStream = UtilFunctions.class.getResourceAsStream(resource);
        if (resourceAsStream != null) {
            try {
                Properties properties = new Properties();
                properties.load(resourceAsStream);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    PropertyFunctions.addProperty(propObjSection, name, value);
                }
            }
            catch (IOException e) {
                throw new TransformException("Error loading resource file " + resource, e);
            }
            finally {
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void addProperty(DataObjectSection propObjSection, String name, String value) {
        DataObject propObj = propObjSection.createElement();
        propObj.setField(0, (Object)name);
        propObj.setField(1, (Object)value);
        propObjSection.addElement(propObj);
    }

    public static String getProperty(DataObject propertiesObj, String name) {
        DataObjectSectionImpl sec = (DataObjectSectionImpl)propertiesObj.getSection(PROPERTY);
        DataObject propObj = sec.findElementWithValue(NAME, name);
        if (propObj != null) {
            return (String)propObj.getField(VALUE);
        }
        return "";
    }

    public static void setProperty(DataObject propertiesObj, String name, String value) {
        DataObjectSectionImpl sec = (DataObjectSectionImpl)propertiesObj.getSection(PROPERTY);
        DataObject propObj = sec.findElementWithValue(NAME, name);
        if (propObj != null) {
            propObj.setField(VALUE, (Object)value);
        } else {
            PropertyFunctions.addProperty(sec, name, value);
        }
    }

    private static PropertiesGenericDataObject createPropertiesObject() {
        return new PropertiesGenericDataObject();
    }

    static class PropertiesGenericDataObject
    extends SimpleGenericDataObject {
        PropertiesGenericDataObject() {
            super(new DataObjectMetaInfoImpl(PropertyFunctions.PROPERTIES, new FieldMetaInfo[]{new SectionMetaInfoImpl(propertyMetaInfo, PropertyFunctions.PROPERTY)}));
            DataObjectSectionImpl section = (DataObjectSectionImpl)this.getSection(PropertyFunctions.PROPERTY);
            section.createIndex(PropertyFunctions.NAME);
        }

        public DataObject createSectionElement(int secIndex, DataObjectSection dataObjectSection) throws FieldNotFoundException {
            SimpleGenericDataObject propObj = new SimpleGenericDataObject(propertyMetaInfo);
            return propObj;
        }
    }
}

