/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.collection.StringList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegExFunctions {
    public static boolean matchesExact(String regex, String str) {
        Pattern p = RegExFunctions.getRegEx(regex);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean matches(String regex, String str) {
        Pattern p = RegExFunctions.getRegEx(regex);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean matches(String regex, String str, int index) {
        index = Math.max(index, 0);
        Pattern p = RegExFunctions.getRegEx(regex);
        Matcher m = p.matcher(str);
        return m.find(index);
    }

    public static StringList matchAll(String regex, String str) {
        Pattern p = RegExFunctions.getRegEx(regex);
        Matcher m = p.matcher(str);
        StringList toRet = new StringList();
        while (m.find()) {
            toRet.add(m.group(0));
        }
        return toRet;
    }

    public static StringList matchGroup(String regex, String str) {
        Pattern p = RegExFunctions.getRegEx(regex);
        Matcher m = p.matcher(str);
        boolean b = m.find();
        StringList toRet = new StringList();
        if (b) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                toRet.add(m.group(i));
            }
        }
        return toRet;
    }

    public static int findFirstEx(String regex, String str) {
        Pattern p = RegExFunctions.getRegEx(regex);
        Matcher m = p.matcher(str);
        boolean b = m.find();
        if (b) {
            return m.start();
        }
        return -1;
    }

    public static StringList split(String regex, String str) {
        Pattern p = RegExFunctions.getRegEx(regex);
        String[] splits = p.split(str);
        return new StringList(splits);
    }

    public static String splitFirst(String regex, String str) {
        Pattern p = RegExFunctions.getRegEx(regex);
        String[] splits = p.split(str, 2);
        if (splits != null && splits.length > 0) {
            return splits[0];
        }
        return "";
    }

    public static String splitLast(String regex, String str) {
        Pattern p = RegExFunctions.getRegEx(regex);
        String[] splits = p.split(str);
        if (splits != null && splits.length > 0) {
            return splits[splits.length - 1];
        }
        return "";
    }

    public static String subst(String regex, String str, String with) {
        Pattern p = RegExFunctions.getRegEx(regex);
        Matcher m = p.matcher(str);
        return m.replaceAll(with);
    }

    public static String substFirst(String regex, String str, String with) {
        Pattern p = RegExFunctions.getRegEx(regex);
        Matcher m = p.matcher(str);
        return m.replaceFirst(with);
    }

    private static Pattern getRegEx(String regex) {
        try {
            Pattern p = Pattern.compile(regex);
            return p;
        }
        catch (PatternSyntaxException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT572", regex);
            tre.setDetail(e);
            throw tre;
        }
    }
}

