/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectColumnProvider;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldMetaInfoImpl;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.formula.BaseSection;
import com.tplus.transform.runtime.formula.DataObjectWithNewColumn;
import com.tplus.transform.runtime.formula.SectionHelper;
import java.util.Arrays;

public class SecAddColumnSection
extends BaseSection
implements DataObjectSection {
    private static final long serialVersionUID = -7301787487113306601L;
    private DataObjectWithNewColumn[] objects;
    DataObjectMetaInfo metaInfo;
    String columnName;
    String columnType;
    DataObjectColumnProvider provider;
    private DataObjectSection section;

    public SecAddColumnSection(DataObjectSection section, String columnName, String columnType, DataObjectColumnProvider provider) throws TransformException {
        this.section = section;
        this.columnName = columnName;
        this.columnType = columnType;
        this.provider = provider;
        this.loadAll();
    }

    void loadAll() throws TransformException {
        try {
            this.initObjects();
            int count = this.section.getElementCount();
            for (int i = 0; i < count; ++i) {
                this.objects[i] = this.getElement0(i);
            }
        }
        catch (FieldNotFoundException e) {
        }
        catch (TransformException e) {
            throw e;
        }
    }

    public int size() {
        return this.getElementCount();
    }

    public boolean isEmpty() {
        return this.section.getElementCount() > 0;
    }

    public boolean removeElement(int index) throws FieldNotFoundException {
        throw TransformRuntimeException.createFormatted("SRT573");
    }

    public void addElement(DataObject elm) {
        throw TransformRuntimeException.createFormatted("SRT574");
    }

    public int getElementIndex(DataObject elm) {
        return Arrays.asList(this.objects).indexOf(elm);
    }

    public int getElementCount() {
        return this.section.getElementCount();
    }

    private void initObjects() throws FieldNotFoundException {
        if (this.objects == null) {
            this.objects = new DataObjectWithNewColumn[this.getElementCount()];
            DataObjectMetaInfo info = SectionHelper.getMetaInfo(this.section);
            int count = info.getFieldCount();
            FieldMetaInfo[] fields = new FieldMetaInfo[count + 1];
            for (int i = 0; i < count; ++i) {
                fields[i] = (FieldMetaInfo)info.getFieldMetaInfo(i).clone();
            }
            fields[count] = new FieldMetaInfoImpl(this.columnName, this.columnType, true, false);
            this.metaInfo = new DataObjectMetaInfoImpl(info.getName(), fields);
        }
    }

    private DataObjectWithNewColumn getElement0(int index) throws TransformException {
        DataObject sectionDataObject = this.section.getElement(index);
        DataObjectWithNewColumn toRet = new DataObjectWithNewColumn(sectionDataObject, this.provider.getColumn(sectionDataObject), this.metaInfo);
        return toRet;
    }

    public synchronized DataObject getElement(int index) throws FieldNotFoundException {
        if (this.getElementCount() == 0) {
            throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT575");
        }
        this.initObjects();
        DataObjectWithNewColumn toRet = this.objects[index];
        if (toRet == null) {
            try {
                this.objects[index] = toRet = this.getElement0(index);
            }
            catch (TransformException e) {
                throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT576");
            }
        }
        return toRet;
    }

    public Object clone() {
        SecAddColumnSection clonedObject = (SecAddColumnSection)super.clone();
        return clonedObject;
    }

    public Object get(int index) {
        return this.getElement(index);
    }
}

