/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectCollectionImpl;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.formula.JoinDataObject;
import java.util.Arrays;

public class SecJoinSection
extends DataObjectCollectionImpl
implements DataObjectSection {
    private static final long serialVersionUID = -7301787487423306601L;
    private JoinDataObject[] objects;
    DataObjectMetaInfo metaInfo;
    private DataObjectSection firstSection;
    private DataObjectSection secondSection;

    public SecJoinSection(DataObjectSection firstSection, DataObjectSection secondSection) {
        this.firstSection = firstSection;
        this.secondSection = secondSection;
    }

    public boolean isEmpty() {
        return this.getElementCount() > 0;
    }

    public boolean removeElement(int index) throws FieldNotFoundException {
        throw TransformRuntimeException.createFormatted("SRT573");
    }

    public void addElement(DataObject elm) {
        throw TransformRuntimeException.createFormatted("SRT574");
    }

    public int getElementIndex(DataObject elm) {
        return Arrays.asList(this.objects).indexOf(elm);
    }

    public int getElementCount() {
        return this.firstSection.getElementCount() * this.secondSection.getElementCount();
    }

    private void initObjects() throws FieldNotFoundException {
        if (this.objects == null) {
            this.objects = new JoinDataObject[this.getElementCount()];
            FieldMetaInfo[] fieldInfos = this.getFieldMetaInfos();
            this.metaInfo = new DataObjectMetaInfoImpl("", fieldInfos);
        }
    }

    public synchronized DataObject getElement(int index) throws FieldNotFoundException {
        if (this.getElementCount() == 0) {
            throw FieldNotFoundException.createFieldNotFoundExceptionFormatted("SRT575");
        }
        this.initObjects();
        JoinDataObject toRet = this.objects[index];
        if (toRet == null) {
            int firstSectionElementIndex = index / this.secondSection.getElementCount();
            int secondSectionElementIndex = index % this.secondSection.getElementCount();
            DataObject firstSectionDataObject = this.firstSection.getElement(firstSectionElementIndex);
            DataObject secondSectionDataObject = this.secondSection.getElement(secondSectionElementIndex);
            this.objects[index] = toRet = new JoinDataObject(firstSectionDataObject, secondSectionDataObject, this.metaInfo);
        }
        return toRet;
    }

    private FieldMetaInfo[] getFieldMetaInfos() throws FieldNotFoundException {
        DataObject firstSectionElement = this.firstSection.getElement(0);
        DataObject secondSectionElement = this.secondSection.getElement(0);
        int firstSectionElementFieldCount = firstSectionElement.getFieldCount();
        int secondSectionElementFieldCount = secondSectionElement.getFieldCount();
        FieldMetaInfo[] fieldInfos = new FieldMetaInfo[firstSectionElementFieldCount + secondSectionElementFieldCount];
        DataObjectMetaInfo meta1 = firstSectionElement.getMetaInfo();
        DataObjectMetaInfo meta2 = secondSectionElement.getMetaInfo();
        for (int i = 0; i < firstSectionElementFieldCount; ++i) {
            fieldInfos[i] = (FieldMetaInfo)meta1.getFieldMetaInfo(i).clone();
        }
        for (int j = 0; j < secondSectionElementFieldCount; ++j) {
            fieldInfos[firstSectionElementFieldCount + j] = (FieldMetaInfo)meta2.getFieldMetaInfo(j).clone();
        }
        return fieldInfos;
    }

    public Object clone() {
        try {
            SecJoinSection clonedObject = (SecJoinSection)super.clone();
            clonedObject.firstSection = (DataObjectSection)this.firstSection.clone();
            clonedObject.secondSection = (DataObjectSection)this.secondSection.clone();
            return clonedObject;
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }
}

