/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.FieldTypeMismatchException;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformNullValueException;
import com.tplus.transform.runtime.TransformRuntimeException;

public class SectionHelper {
    protected static int getFieldIndex(DataObject obj, String fieldName) {
        return obj.getFieldIndex(fieldName);
    }

    public static int getFieldIndex(DataObjectSection sec, String fieldName) {
        if (sec.getElementCount() > 0) {
            try {
                DataObject obj = sec.getElement(0);
                int index = obj.getFieldIndex(fieldName);
                return index;
            }
            catch (FieldNotFoundException e) {
                throw TransformRuntimeException.createFormatted("SRT577", fieldName);
            }
        }
        return -1;
    }

    public static String getFieldType(DataObjectSection sec, int fieldIndex) {
        if (sec.getElementCount() > 0) {
            try {
                DataObject obj = sec.getElement(0);
                String type = obj.getFieldType(fieldIndex);
                return type;
            }
            catch (FieldNotFoundException e) {
                throw TransformRuntimeException.createFormatted("SRT578", String.valueOf(fieldIndex));
            }
        }
        return null;
    }

    public static void handleFieldAccessException(DataObject obj, int fieldIndex, Exception e) throws TransformException {
        String fieldNameSubst = "Field at index " + fieldIndex;
        if (e instanceof TransformException) {
            throw (TransformException)e;
        }
        if (e instanceof TransformRuntimeException) {
            throw (TransformRuntimeException)e;
        }
        if (e instanceof ClassCastException) {
            FieldTypeMismatchException ftme = FieldTypeMismatchException.createFieldTypeMismatchExceptionFormatted("SRT580", fieldNameSubst);
            ftme.setDetail(e);
            throw ftme;
        }
        if (e instanceof NullPointerException) {
            throw TransformNullValueException.createTransformNullValueExceptionFormatted("SRT501", fieldNameSubst);
        }
        TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT581");
        tre.setDetail(e);
        throw tre;
    }

    public static void handleFieldAccessException(DataObject obj, String fieldName, Exception e) throws TransformException {
        SectionHelper.handleFieldAccessException(fieldName, e);
    }

    public static void handleFieldAccessException(String fieldName, Exception e) throws TransformException {
        if (e instanceof TransformException) {
            throw (TransformException)e;
        }
        if (e instanceof TransformRuntimeException) {
            throw (TransformRuntimeException)e;
        }
        if (e instanceof ClassCastException) {
            FieldTypeMismatchException ftme = FieldTypeMismatchException.createFieldTypeMismatchExceptionFormatted("SRT580", fieldName);
            ftme.setDetail(e);
            throw ftme;
        }
        if (e instanceof NullPointerException) {
            throw TransformNullValueException.createTransformNullValueExceptionFormatted("SRT501", fieldName);
        }
        TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT581");
        tre.setDetail(e);
        throw tre;
    }

    public static DataObjectMetaInfo getMetaInfo(DataObjectSection section) throws FieldNotFoundException {
        if (section.getElementCount() > 0) {
            DataObject obj = section.getElement(0);
            return obj.getMetaInfo();
        }
        return null;
    }
}

