/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectCollectionImpl;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DataObjectSectionImpl2;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldMetaInfoImpl;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.FieldTypeMismatchException;
import com.tplus.transform.runtime.SectionMetaInfoImpl;
import com.tplus.transform.runtime.SimpleGenericDataObject;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.collection.BigDecimalList;
import com.tplus.transform.runtime.collection.BigIntegerList;
import com.tplus.transform.runtime.collection.BinaryList;
import com.tplus.transform.runtime.collection.BooleanList;
import com.tplus.transform.runtime.collection.CalendarList;
import com.tplus.transform.runtime.collection.CharList;
import com.tplus.transform.runtime.collection.DateList;
import com.tplus.transform.runtime.collection.DoubleList;
import com.tplus.transform.runtime.collection.FloatList;
import com.tplus.transform.runtime.collection.IntList;
import com.tplus.transform.runtime.collection.LongList;
import com.tplus.transform.runtime.collection.ScaledDecimalList;
import com.tplus.transform.runtime.collection.StringList;
import com.tplus.transform.runtime.formula.SecJoinSection;
import com.tplus.transform.runtime.formula.SecUnionSection;
import com.tplus.transform.runtime.formula.SectionHelper;
import com.tplus.transform.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SectionTransformFunctions
extends SectionHelper {
    private static final String ALIAS_SEPARATOR = " as ";

    public static boolean hasFieldWithValue(DataObjectSection sec, String fieldName, Object fieldValue) throws TransformException {
        return SectionTransformFunctions.secFind(sec, fieldName, fieldValue).getElementCount() > 0;
    }

    public static List getAsList(DataObjectSection sec, String fieldName) throws TransformException {
        ArrayList<Object> resultCollection = new ArrayList<Object>();
        int fieldIndex = SectionTransformFunctions.getFieldIndex(sec, fieldName);
        String type = SectionTransformFunctions.getFieldType(sec, fieldIndex);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            Object value = obj.getField(fieldIndex);
            resultCollection.add(value);
        }
        return resultCollection;
    }

    public static DataObjectSection secFind(DataObjectSection sec, String fieldName, Object fieldValue) throws TransformException {
        DataObjectCollectionImpl resultCollection = new DataObjectCollectionImpl();
        int fieldIndex = SectionTransformFunctions.getFieldIndex(sec, fieldName);
        String type = SectionTransformFunctions.getFieldType(sec, fieldIndex);
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            Object value = obj.getField(fieldIndex);
            if (value == fieldValue) {
                resultCollection.add(obj);
            }
            if (value == null || fieldValue == null || !value.equals(fieldValue)) continue;
            resultCollection.add(obj);
        }
        return resultCollection;
    }

    public static DataObjectSection secGroup(DataObjectSection sec, String groupByField) throws TransformException {
        String groupName = groupByField + "Group";
        DataObjectCollectionImpl resultCollection = new DataObjectCollectionImpl();
        int fieldIndex = SectionTransformFunctions.getFieldIndex(sec, groupByField);
        String type = SectionTransformFunctions.getFieldType(sec, fieldIndex);
        FieldMetaInfo[] fieldInfos = new FieldMetaInfo[]{new FieldMetaInfoImpl(groupByField, type == null ? DesignerTypes.DESIGNER_STRING_TYPE : type, false, false), new SectionMetaInfoImpl(SectionHelper.getMetaInfo(sec), groupName, 0, -1, false)};
        DataObjectMetaInfoImpl dataObjectMetaInfo = new DataObjectMetaInfoImpl("Grouped", fieldInfos);
        HashMap<Object, DataObjectSection> groupFieldLookup = new HashMap<Object, DataObjectSection>();
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            Object value = obj.getField(fieldIndex);
            DataObjectSection groupCollection = (DataObjectSection)groupFieldLookup.get(value);
            if (groupCollection == null) {
                SimpleGenericDataObject dataObject = new SimpleGenericDataObject(null, dataObjectMetaInfo);
                dataObject.setField(0, value);
                groupCollection = new DataObjectSectionImpl2((DataObject)dataObject, groupName);
                groupFieldLookup.put(value, groupCollection);
                dataObject.setField(1, (Object)groupCollection);
                resultCollection.addElement(dataObject);
            }
            groupCollection.addElement(obj);
        }
        return resultCollection;
    }

    public static DataObjectSection secJoin(DataObjectSection sec1, DataObjectSection sec2) throws TransformException {
        return new SecJoinSection(sec1, sec2);
    }

    public static DataObjectSection secUnion(DataObjectSection sec1, DataObjectSection sec2) throws TransformException {
        DataObjectMetaInfo metaInfo = SectionHelper.getMetaInfo(sec1);
        return new SecUnionSection(sec1, sec2, metaInfo);
    }

    public static DataObjectSection secSort(DataObjectSection sec, String sortByField) throws TransformException {
        return SectionTransformFunctions.secSort(sec, sortByField, true);
    }

    public static DataObjectSection secSort(DataObjectSection sec, String sortByField, final boolean ascending) throws TransformException {
        DataObjectCollectionImpl resultCollection = SectionTransformFunctions.copySection(sec);
        final int fieldIndex = SectionTransformFunctions.getFieldIndex(sec, sortByField);
        Collections.sort(resultCollection, new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    DataObject obj1 = (DataObject)o1;
                    DataObject obj2 = (DataObject)o2;
                    Object fld1 = obj1.getField(fieldIndex);
                    Object fld2 = obj2.getField(fieldIndex);
                    int toRet = SectionTransformFunctions.compareValue(fld1, fld2);
                    return ascending ? toRet : -toRet;
                }
                catch (FieldNotFoundException e) {
                    return 0;
                }
            }
        });
        return resultCollection;
    }

    private static DataObjectCollectionImpl copySection(DataObjectSection sec) {
        DataObjectCollectionImpl resultCollection = new DataObjectCollectionImpl();
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            resultCollection.addElement(obj);
        }
        return resultCollection;
    }

    private static int compareValue(Object fld1, Object fld2) {
        int toRet = fld1 == fld2 ? 0 : (fld1 == null ? -1 : (fld2 == null ? 1 : ((Comparable)fld1).compareTo(fld2)));
        return toRet;
    }

    public static void sectionSort(DataObjectSection sec, String sortByField) throws TransformException {
        SectionTransformFunctions.sectionSort(sec, sortByField, true);
    }

    public static void sectionSort(DataObjectSection sec, String sortByField, boolean ascending) throws TransformException {
        StringList stringList = new StringList();
        stringList.add(sortByField);
        SectionTransformFunctions.sectionSort(sec, stringList, ascending);
    }

    public static void sectionSort(DataObjectSection sec, final StringList sortByField, final boolean ascending) throws TransformException {
        Collections.sort(sec, new Comparator(){

            public int compare(Object o1, Object o2) {
                DataObject obj1 = (DataObject)o1;
                DataObject obj2 = (DataObject)o2;
                for (int i = 0; i < sortByField.size(); ++i) {
                    String fieldName = (String)sortByField.get(i);
                    int toRet = SectionTransformFunctions.compareFieldValue(obj1, obj2, fieldName, ascending);
                    if (toRet == 0) continue;
                    return toRet;
                }
                return 0;
            }
        });
    }

    private static int compareFieldValue(DataObject obj1, DataObject obj2, String fieldName, boolean ascending) {
        try {
            Object fld2;
            Object fld1;
            if (fieldName.indexOf(46) != -1) {
                ArrayList list1 = new ArrayList();
                ArrayList list2 = new ArrayList();
                SectionTransformFunctions.secSelectValues0(obj1, fieldName, list1);
                fld1 = list1.size() > 0 ? list1.get(0) : null;
                SectionTransformFunctions.secSelectValues0(obj2, fieldName, list2);
                fld2 = list2.size() > 0 ? list2.get(0) : null;
            } else {
                fld1 = obj1.getField(fieldName);
                fld2 = obj2.getField(fieldName);
            }
            int toRet = SectionTransformFunctions.compareValue(fld1, fld2);
            return ascending ? toRet : -toRet;
        }
        catch (TransformException e) {
            return 0;
        }
    }

    public static DataObjectSection secSort2(DataObjectSection sec, final String sortByField, final boolean ascending) throws TransformException {
        SingleFieldInfo fieldInfo = new SingleFieldInfo(sortByField);
        DataObjectCollectionImpl resultCollection = SectionTransformFunctions.copySection(sec);
        Collections.sort(resultCollection, new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    DataObject obj1 = (DataObject)o1;
                    DataObject obj2 = (DataObject)o2;
                    try {
                        String fld1 = SectionTransformFunctions.secSelectFirst(obj1, sortByField);
                        String fld2 = SectionTransformFunctions.secSelectFirst(obj2, sortByField);
                        int toRet = SectionTransformFunctions.compareValue(fld1, fld2);
                        return ascending ? toRet : -toRet;
                    }
                    catch (TransformException e) {
                        e.printStackTrace();
                        return 0;
                    }
                }
                catch (FieldNotFoundException e) {
                    return 0;
                }
            }
        });
        return resultCollection;
    }

    public static DataObjectSection secDistinct(DataObjectSection sec) throws TransformException {
        TreeSet<DataObject> results = new TreeSet<DataObject>(new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    DataObject obj1 = (DataObject)o1;
                    DataObject obj2 = (DataObject)o2;
                    for (int i = 0; i < obj1.getFieldCount(); ++i) {
                        Object fld2;
                        Object fld1 = obj1.getField(i);
                        if (fld1 == (fld2 = obj2.getField(i)) || fld1 instanceof DataObjectSection || fld2 instanceof DataObjectSection) continue;
                        if (fld1 == null) {
                            return -1;
                        }
                        if (fld2 == null) {
                            return 1;
                        }
                        int toRet = ((Comparable)fld1).compareTo((Comparable)fld2);
                        if (toRet == 0) continue;
                        return toRet;
                    }
                    return 0;
                }
                catch (FieldNotFoundException e) {
                    return 0;
                }
            }
        });
        DataObjectCollectionImpl resultCollection = new DataObjectCollectionImpl();
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject obj = sec.getElement(i);
            if (!results.add(obj)) continue;
            resultCollection.addElement(obj);
        }
        return resultCollection;
    }

    private static void prepareOutputFields(DataObject inputDataObject, FieldInfoManager fieldInfoManager, String[] deepestField, int currentLocation, List fieldValuesList) {
        boolean lastField = currentLocation == deepestField.length - 1;
        FieldInfo[] fieldInfos = fieldInfoManager.getFieldInfos();
        int oldSize = fieldValuesList.size();
        if (!lastField) {
            String currentField = deepestField[currentLocation];
            DataObjectSection sec = inputDataObject.getSection(currentField);
            SectionTransformFunctions.prepareOutputFields(sec, fieldInfoManager, deepestField, currentLocation, fieldValuesList);
        } else {
            Object[] fieldValues = fieldInfoManager.createEmptyValueArray();
            fieldValuesList.add(fieldValues);
        }
        for (int i = 0; i < fieldInfos.length; ++i) {
            FieldInfo fieldInfo = fieldInfos[i];
            if (!fieldInfo.isLastSubField(currentLocation)) continue;
            int index = fieldInfo.getTrailingFieldIndex();
            if (index == -1) {
                String simpleFieldName = fieldInfo.getTrailingFieldName();
                index = inputDataObject.getFieldIndex(simpleFieldName);
                fieldInfo.setTrailingFieldIndex(index);
                fieldInfo.setFieldType(inputDataObject.getFieldDesignerType(index));
            }
            Object fieldValue = inputDataObject.getField(index);
            for (int j = oldSize; j < fieldValuesList.size(); ++j) {
                Object[] fieldValues = (Object[])fieldValuesList.get(j);
                fieldValues[i] = fieldValue;
            }
        }
    }

    private static void prepareOutputFields(DataObjectSection sec, FieldInfoManager fieldInfoManager, String[] deepestField, int currentLocation, List fieldValuesList) {
        for (int i = 0; i < sec.getElementCount(); ++i) {
            DataObject subDataObject = sec.getElement(i);
            SectionTransformFunctions.prepareOutputFields(subDataObject, fieldInfoManager, deepestField, currentLocation + 1, fieldValuesList);
        }
    }

    private static DataObjectSection prepareOutputCollection(FieldInfoManager fieldInfoManager, List fieldValuesList) throws FieldTypeMismatchException {
        DataObjectMetaInfo dataObjectMetaInfo = fieldInfoManager.prepareDataObjectMetaInfo();
        DataObjectCollectionImpl resultCollection = new DataObjectCollectionImpl();
        SectionTransformFunctions.prepareOutputCollection(resultCollection, fieldValuesList, dataObjectMetaInfo);
        SectionTransformFunctions.eliminateNullObjects(resultCollection);
        return resultCollection;
    }

    private static void prepareOutputCollection(DataObjectSection resultCollection, List fieldValuesList, DataObjectMetaInfo dataObjectMetaInfo) throws FieldNotFoundException, FieldTypeMismatchException {
        for (int i = 0; i < fieldValuesList.size(); ++i) {
            SimpleGenericDataObject outputDataObject = new SimpleGenericDataObject(null, dataObjectMetaInfo);
            Object[] outputFieldArray = (Object[])fieldValuesList.get(i);
            for (int j = 0; j < outputFieldArray.length; ++j) {
                outputDataObject.setField(j, outputFieldArray[j]);
            }
            resultCollection.addElement(outputDataObject);
        }
    }

    public static int secSelectFirst(DataObjectSection sec, String selectFields, int defaultValue) throws TransformRuntimeException, TransformException {
        IntList selectedValues = SectionTransformFunctions.secSelectValuesInteger(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static int secSelectFirst(DataObject sec, String selectFields, int defaultValue) throws TransformRuntimeException, TransformException {
        IntList selectedValues = SectionTransformFunctions.secSelectValuesInteger(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static float secSelectFirst(DataObjectSection sec, String selectFields, float defaultValue) throws TransformRuntimeException, TransformException {
        FloatList selectedValues = SectionTransformFunctions.secSelectValuesFloat(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static float secSelectFirst(DataObject sec, String selectFields, float defaultValue) throws TransformRuntimeException, TransformException {
        FloatList selectedValues = SectionTransformFunctions.secSelectValuesFloat(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static double secSelectFirst(DataObjectSection sec, String selectFields, double defaultValue) throws TransformRuntimeException, TransformException {
        DoubleList selectedValues = SectionTransformFunctions.secSelectValuesDouble(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static double secSelectFirst(DataObject sec, String selectFields, double defaultValue) throws TransformRuntimeException, TransformException {
        DoubleList selectedValues = SectionTransformFunctions.secSelectValuesDouble(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static long secSelectFirst(DataObjectSection sec, String selectFields, long defaultValue) throws TransformRuntimeException, TransformException {
        LongList selectedValues = SectionTransformFunctions.secSelectValuesLong(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static long secSelectFirst(DataObject sec, String selectFields, long defaultValue) throws TransformRuntimeException, TransformException {
        LongList selectedValues = SectionTransformFunctions.secSelectValuesLong(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static boolean secSelectFirst(DataObjectSection sec, String selectFields, boolean defaultValue) throws TransformRuntimeException, TransformException {
        BooleanList selectedValues = SectionTransformFunctions.secSelectValuesBoolean(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static boolean secSelectFirst(DataObject sec, String selectFields, boolean defaultValue) throws TransformRuntimeException, TransformException {
        BooleanList selectedValues = SectionTransformFunctions.secSelectValuesBoolean(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static char secSelectFirst(DataObjectSection sec, String selectFields, char defaultValue) throws TransformRuntimeException, TransformException {
        CharList selectedValues = SectionTransformFunctions.secSelectValuesCharacter(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static char secSelectFirst(DataObject sec, String selectFields, char defaultValue) throws TransformRuntimeException, TransformException {
        CharList selectedValues = SectionTransformFunctions.secSelectValuesCharacter(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static Calendar secSelectFirst(DataObjectSection sec, String selectFields, Calendar defaultValue) throws TransformRuntimeException, TransformException {
        CalendarList selectedValues = SectionTransformFunctions.secSelectValuesISODate(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static Calendar secSelectFirst(DataObject sec, String selectFields, Calendar defaultValue) throws TransformRuntimeException, TransformException {
        CalendarList selectedValues = SectionTransformFunctions.secSelectValuesISODate(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static Date secSelectFirst(DataObjectSection sec, String selectFields, Date defaultValue) throws TransformRuntimeException, TransformException {
        DateList selectedValues = SectionTransformFunctions.secSelectValuesDateTime(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static Date secSelectFirst(DataObject sec, String selectFields, Date defaultValue) throws TransformRuntimeException, TransformException {
        DateList selectedValues = SectionTransformFunctions.secSelectValuesDateTime(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static String secSelectFirst(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return SectionTransformFunctions.secSelectFirst(sec, selectFields, (String)null);
    }

    public static String secSelectFirst(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return SectionTransformFunctions.secSelectFirst(sec, selectFields, (String)null);
    }

    public static String secSelectFirst(DataObjectSection sec, String selectFields, String defaultValue) throws TransformRuntimeException, TransformException {
        StringList selectedValues = SectionTransformFunctions.secSelectValuesString(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static String secSelectFirst(DataObject sec, String selectFields, String defaultValue) throws TransformRuntimeException, TransformException {
        StringList selectedValues = SectionTransformFunctions.secSelectValuesString(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static byte[] secSelectFirst(DataObjectSection sec, String selectFields, byte[] defaultValue) throws TransformRuntimeException, TransformException {
        BinaryList selectedValues = SectionTransformFunctions.secSelectValuesBinary(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static byte[] secSelectFirst(DataObject sec, String selectFields, byte[] defaultValue) throws TransformRuntimeException, TransformException {
        BinaryList selectedValues = SectionTransformFunctions.secSelectValuesBinary(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static BigDecimal secSelectFirst(DataObjectSection sec, String selectFields, BigDecimal defaultValue) throws TransformRuntimeException, TransformException {
        BigDecimalList selectedValues = SectionTransformFunctions.secSelectValuesBigDecimal(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static BigDecimal secSelectFirst(DataObject sec, String selectFields, BigDecimal defaultValue) throws TransformRuntimeException, TransformException {
        BigDecimalList selectedValues = SectionTransformFunctions.secSelectValuesBigDecimal(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static ScaledDecimal secSelectFirst(DataObjectSection sec, String selectFields, ScaledDecimal defaultValue) throws TransformRuntimeException, TransformException {
        ScaledDecimalList selectedValues = SectionTransformFunctions.secSelectValuesScaledDecimal(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static ScaledDecimal secSelectFirst(DataObject sec, String selectFields, ScaledDecimal defaultValue) throws TransformRuntimeException, TransformException {
        ScaledDecimalList selectedValues = SectionTransformFunctions.secSelectValuesScaledDecimal(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static BigInteger secSelectFirst(DataObjectSection sec, String selectFields, BigInteger defaultValue) throws TransformRuntimeException, TransformException {
        BigIntegerList selectedValues = SectionTransformFunctions.secSelectValuesBigInteger(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static BigInteger secSelectFirst(DataObject sec, String selectFields, BigInteger defaultValue) throws TransformRuntimeException, TransformException {
        BigIntegerList selectedValues = SectionTransformFunctions.secSelectValuesBigInteger(sec, selectFields);
        return selectedValues.size() == 0 ? defaultValue : selectedValues.getValue(0);
    }

    public static IntList secSelectValuesInteger(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (IntList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new IntList());
    }

    public static IntList secSelectValuesInteger(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (IntList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new IntList());
    }

    public static FloatList secSelectValuesFloat(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (FloatList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new FloatList());
    }

    public static FloatList secSelectValuesFloat(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (FloatList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new FloatList());
    }

    public static DoubleList secSelectValuesDouble(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (DoubleList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new DoubleList());
    }

    public static DoubleList secSelectValuesDouble(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (DoubleList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new DoubleList());
    }

    public static LongList secSelectValuesLong(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (LongList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new LongList());
    }

    public static LongList secSelectValuesLong(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (LongList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new LongList());
    }

    public static BooleanList secSelectValuesBoolean(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (BooleanList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new BooleanList());
    }

    public static BooleanList secSelectValuesBoolean(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (BooleanList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new BooleanList());
    }

    public static CharList secSelectValuesCharacter(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (CharList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new CharList());
    }

    public static CharList secSelectValuesCharacter(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (CharList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new CharList());
    }

    public static StringList secSelectValuesString(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (StringList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new StringList());
    }

    public static StringList secSelectValuesString(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (StringList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new StringList());
    }

    public static DateList secSelectValuesDateTime(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (DateList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new DateList());
    }

    public static DateList secSelectValuesDateTime(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (DateList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new DateList());
    }

    public static DateList secSelectValuesTimeOnly(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (DateList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new DateList());
    }

    public static DateList secSelectValuesTimeOnly(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (DateList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new DateList());
    }

    public static CalendarList secSelectValuesISODateTime(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (CalendarList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new CalendarList());
    }

    public static CalendarList secSelectValuesISODateTime(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (CalendarList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new CalendarList());
    }

    public static CalendarList secSelectValuesISODate(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (CalendarList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new CalendarList());
    }

    public static CalendarList secSelectValuesISODate(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (CalendarList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new CalendarList());
    }

    public static CalendarList secSelectValuesISOTime(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (CalendarList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new CalendarList());
    }

    public static CalendarList secSelectValuesISOTime(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (CalendarList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new CalendarList());
    }

    public static BigIntegerList secSelectValuesBigInteger(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (BigIntegerList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new BigIntegerList());
    }

    public static BigIntegerList secSelectValuesBigInteger(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (BigIntegerList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new BigIntegerList());
    }

    public static BigDecimalList secSelectValuesBigDecimal(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (BigDecimalList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new BigDecimalList());
    }

    public static BigDecimalList secSelectValuesBigDecimal(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (BigDecimalList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new BigDecimalList());
    }

    public static ScaledDecimalList secSelectValuesScaledDecimal(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (ScaledDecimalList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new ScaledDecimalList());
    }

    public static ScaledDecimalList secSelectValuesScaledDecimal(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (ScaledDecimalList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new ScaledDecimalList());
    }

    public static BinaryList secSelectValuesBinary(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (BinaryList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new BinaryList());
    }

    public static BinaryList secSelectValuesBinary(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        return (BinaryList)SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)new BinaryList());
    }

    public static DataObjectSection secSelectValuesSection(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        DataObjectSectionImpl2 secList = new DataObjectSectionImpl2(null, "secSelectValues");
        SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)secList);
        return secList;
    }

    public static DataObjectSection secSelectValuesSection(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        DataObjectSectionImpl2 secList = new DataObjectSectionImpl2(null, "secSelectValues");
        SectionTransformFunctions.secSelectValues0(sec, selectFields, (List)secList);
        return secList;
    }

    private static List secSelectValues0(DataObjectSection sec, String selectFields, List list) throws TransformRuntimeException, TransformException {
        SingleFieldInfo fieldInfo = new SingleFieldInfo(selectFields);
        SectionTransformFunctions.secSelectValues0(sec, fieldInfo, 0, list, false);
        return list;
    }

    private static List secSelectValues0(DataObject dataObject, String selectFields, List list) throws TransformRuntimeException, TransformException {
        SingleFieldInfo fieldInfo = new SingleFieldInfo(selectFields);
        SectionTransformFunctions.secSelectValues0(dataObject, fieldInfo, 0, list, false);
        return list;
    }

    private static void secSelectValues0(DataObjectSection sec, SingleFieldInfo fieldInfo, int currentLocation, List list, boolean seenWildcard) throws TransformRuntimeException, TransformException {
        for (int i = 0; i < sec.size(); ++i) {
            DataObject dataObject = (DataObject)sec.get(i);
            SectionTransformFunctions.secSelectValues0(dataObject, fieldInfo, currentLocation, list, seenWildcard);
        }
    }

    private static void secSelectValues0(DataObject dataObject, SingleFieldInfo fieldInfo, int currentLocation, List list, boolean seenWildCard) throws TransformRuntimeException, TransformException {
        Object value;
        int subFieldIndex = fieldInfo.getSubFieldIndexAt(currentLocation);
        if (subFieldIndex == -1) {
            String subFieldName = fieldInfo.getSubFieldAt(currentLocation);
            if (subFieldName.startsWith("*")) {
                if (subFieldName.equals("*")) {
                    SectionTransformFunctions.handleWildcard(dataObject, fieldInfo, currentLocation + 1, list);
                    return;
                }
                if (subFieldName.equals("**")) {
                    SectionTransformFunctions.handleWildcard(dataObject, fieldInfo, currentLocation, list);
                    SectionTransformFunctions.secSelectValues0(dataObject, fieldInfo, currentLocation + 1, list, true);
                    return;
                }
            } else {
                DataObjectMetaInfo metaInfo = dataObject.getMetaInfo();
                subFieldIndex = metaInfo.getFieldIndexIfExists(subFieldName);
                if (subFieldIndex == -1) {
                    return;
                }
                if (!seenWildCard) {
                    fieldInfo.setSubFieldIndexAt(currentLocation, subFieldIndex);
                }
            }
        }
        if ((value = dataObject.getField(subFieldIndex)) != null) {
            DataObjectSection section;
            if (fieldInfo.isLastSubField(currentLocation)) {
                if (value instanceof DataObjectSection) {
                    section = (DataObjectSection)value;
                    for (int i = 0; i < section.size(); ++i) {
                        DataObject subDataObject = (DataObject)section.get(i);
                        SectionTransformFunctions.addToTypedList(list, subDataObject);
                    }
                } else {
                    SectionTransformFunctions.addToTypedList(list, value);
                }
            } else {
                if (value instanceof DataObjectSection) {
                    section = (DataObjectSection)value;
                    SectionTransformFunctions.secSelectValues0(section, fieldInfo, currentLocation + 1, list, seenWildCard);
                }
                if (value instanceof DataObject) {
                    DataObject subObject = (DataObject)value;
                    SectionTransformFunctions.secSelectValues0(subObject, fieldInfo, currentLocation + 1, list, seenWildCard);
                }
            }
        }
    }

    private static void addToTypedList(List list, Object value) {
        try {
            list.add(value);
        }
        catch (ClassCastException e) {
            throw new FieldTypeMismatchException("Unexpected field type", e);
        }
    }

    private static void handleWildcard(DataObject dataObject, SingleFieldInfo fieldInfo, int nextLocation, List list) throws TransformException {
        DataObjectMetaInfo metaInfo = dataObject.getMetaInfo();
        int fieldCount = metaInfo.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            if (!metaInfo.isSection(i)) continue;
            Object field = dataObject.getField(i);
            if (field instanceof DataObjectSection) {
                DataObjectSection section = (DataObjectSection)field;
                SectionTransformFunctions.secSelectValues0(section, fieldInfo, nextLocation, list, true);
                continue;
            }
            if (!(field instanceof DataObject)) continue;
            DataObject object = (DataObject)field;
            SectionTransformFunctions.secSelectValues0(object, fieldInfo, nextLocation, list, true);
        }
    }

    public static DataObjectSection secSelect(DataObject sec, String selectFields) throws TransformRuntimeException, TransformException {
        FieldInfoManager fieldInfoManager = new FieldInfoManager(selectFields);
        String[] deepestField = fieldInfoManager.getDeepestAccessedField();
        ArrayList fieldValuesList = new ArrayList();
        SectionTransformFunctions.prepareOutputFields(sec, fieldInfoManager, deepestField, 0, fieldValuesList);
        return SectionTransformFunctions.prepareOutputCollection(fieldInfoManager, fieldValuesList);
    }

    public static DataObjectSection secSelect(DataObjectSection sec, String selectFields) throws TransformRuntimeException, TransformException {
        FieldInfoManager fieldInfoManager = new FieldInfoManager(selectFields);
        String[] deepestField = fieldInfoManager.getDeepestAccessedField();
        ArrayList fieldValuesList = new ArrayList();
        SectionTransformFunctions.prepareOutputFields(sec, fieldInfoManager, deepestField, -1, fieldValuesList);
        return SectionTransformFunctions.prepareOutputCollection(fieldInfoManager, fieldValuesList);
    }

    static void eliminateNullObjects(DataObjectSection collection) {
        int count = collection.getElementCount();
        int i = 0;
        while (i < collection.getElementCount()) {
            DataObject obj = collection.getElement(i);
            if (SectionTransformFunctions.isEmpty(obj)) {
                collection.removeElement(i);
                continue;
            }
            ++i;
        }
    }

    public static boolean isEmpty(DataObject dobj) throws FieldNotFoundException {
        return dobj.isEmpty();
    }

    static class SingleFieldInfo {
        String fieldName;
        String[] subFieldNames;
        int[] indices;
        DesignerType fieldType = DesignerType.DESIGNER_STRING_TYPE;

        public SingleFieldInfo(String token) {
            this.fieldName = token.trim();
            this.subFieldNames = StringUtils.split(this.fieldName, 46);
            this.indices = new int[this.subFieldNames.length];
            for (int i = 0; i < this.indices.length; ++i) {
                this.indices[i] = -1;
            }
        }

        int getSubFieldCount() {
            return this.subFieldNames.length;
        }

        boolean isLastSubField(int index) {
            return this.subFieldNames.length - 1 == index;
        }

        public DesignerType getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(DesignerType fieldDesignerType) {
            this.fieldType = fieldDesignerType;
        }

        public String getTrailingFieldName() {
            return this.subFieldNames[this.subFieldNames.length - 1];
        }

        String getSubFieldAt(int subFieldLocation) {
            return this.subFieldNames[subFieldLocation];
        }

        public int getSubFieldIndexAt(int subFieldLocation) {
            return this.indices[subFieldLocation];
        }

        public void setSubFieldIndexAt(int subFieldLocation, int simpleFieldIndex) {
            this.indices[subFieldLocation] = simpleFieldIndex;
        }
    }

    static class FieldInfo {
        String fieldName;
        String fieldAlias;
        String[] subFieldNames;
        int trailingFieldIndex = -1;
        DesignerType fieldType = DesignerType.DESIGNER_STRING_TYPE;

        public FieldInfo(String token) {
            int asIndex = token.indexOf(SectionTransformFunctions.ALIAS_SEPARATOR);
            if (asIndex == -1) {
                this.fieldName = token.trim();
            } else {
                this.fieldName = token.substring(0, asIndex).trim();
                this.fieldAlias = token.substring(asIndex + 4).trim();
            }
            this.subFieldNames = StringUtils.split(this.fieldName, 46);
        }

        boolean isDeeper(FieldInfo that) {
            if (that == null) {
                return true;
            }
            boolean deeper = this.subFieldNames.length > that.subFieldNames.length;
            int length = Math.min(that.subFieldNames.length, this.subFieldNames.length) - 1;
            for (int j = 0; j < length; ++j) {
                if (this.subFieldNames[j].equals(that.subFieldNames[j])) continue;
                throw TransformRuntimeException.createFormatted("SRT582");
            }
            return deeper;
        }

        String getMetaFieldName() {
            String metaFieldName = this.fieldAlias == null ? this.getTrailingFieldName() : this.fieldAlias;
            return metaFieldName;
        }

        int getSubFieldCount() {
            return this.subFieldNames.length;
        }

        boolean isLastSubField(int index) {
            return this.subFieldNames.length - 1 == index;
        }

        public DesignerType getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(DesignerType fieldDesignerType) {
            this.fieldType = fieldDesignerType;
        }

        public String getTrailingFieldName() {
            return this.subFieldNames[this.subFieldNames.length - 1];
        }

        public int getTrailingFieldIndex() {
            return this.trailingFieldIndex;
        }

        public void setTrailingFieldIndex(int simpleFieldIndex) {
            this.trailingFieldIndex = simpleFieldIndex;
        }

        public static FieldInfo[] createFieldInfos(String selectFields) {
            StringTokenizer tokenizer = new StringTokenizer(selectFields, ",");
            int tokenCount = tokenizer.countTokens();
            FieldInfo[] fieldInfos = new FieldInfo[tokenCount];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                fieldInfos[i] = new FieldInfo(token);
                ++i;
            }
            return fieldInfos;
        }
    }

    static class FieldInfoManager {
        FieldInfo[] fieldInfos;

        FieldInfoManager(String selectFields) {
            this.fieldInfos = FieldInfo.createFieldInfos(selectFields);
        }

        String[] getDeepestAccessedField() {
            FieldInfo deepestFieldInfo = null;
            for (int i = 0; i < this.fieldInfos.length; ++i) {
                FieldInfo fieldInfo = this.fieldInfos[i];
                deepestFieldInfo = fieldInfo.isDeeper(deepestFieldInfo) ? fieldInfo : deepestFieldInfo;
            }
            return deepestFieldInfo.subFieldNames;
        }

        public FieldInfo[] getFieldInfos() {
            return this.fieldInfos;
        }

        public int getFieldCount() {
            return this.fieldInfos.length;
        }

        Object[] createEmptyValueArray() {
            return new Object[this.getFieldCount()];
        }

        public DataObjectMetaInfo prepareDataObjectMetaInfo() {
            String[] metaFieldNames = new String[this.fieldInfos.length];
            DesignerType[] fieldTypes = new DesignerType[this.fieldInfos.length];
            for (int i = 0; i < this.fieldInfos.length; ++i) {
                FieldInfo fieldInfo = this.fieldInfos[i];
                metaFieldNames[i] = fieldInfo.getMetaFieldName();
                fieldTypes[i] = fieldInfo.getFieldType();
            }
            DataObjectMetaInfoImpl dataObjectMetaInfo = new DataObjectMetaInfoImpl(metaFieldNames, fieldTypes);
            return dataObjectMetaInfo;
        }
    }
}

