/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecurityFunctions {
    public static byte[] md5(RawMessage rawMessage) throws TransformException {
        return SecurityFunctions.getMd5Digest().digest(rawMessage.getAsBytes());
    }

    public static byte[] md5(byte[] rawMessage) throws TransformException {
        return SecurityFunctions.getMd5Digest().digest(rawMessage);
    }

    public static byte[] sha(RawMessage rawMessage) throws TransformException {
        return SecurityFunctions.getShaDigest().digest(rawMessage.getAsBytes());
    }

    public static byte[] sha(byte[] rawMessage) throws TransformException {
        return SecurityFunctions.getShaDigest().digest(rawMessage);
    }

    public static byte[] sha256(RawMessage rawMessage) throws TransformException {
        return SecurityFunctions.getSha256Digest().digest(rawMessage.getAsBytes());
    }

    public static byte[] sha256(byte[] rawMessage) throws TransformException {
        return SecurityFunctions.getSha256Digest().digest(rawMessage);
    }

    private static byte[] AESEncrypt(byte[] raw, byte[] clear) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(raw);
        cipher.init(1, (Key)skeySpec, ivParameterSpec);
        byte[] encrypted = cipher.doFinal(clear);
        return encrypted;
    }

    private static byte[] AESDecrypt(byte[] raw, byte[] encrypted) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(raw);
        cipher.init(2, (Key)skeySpec, ivParameterSpec);
        byte[] decrypted = cipher.doFinal(encrypted);
        return decrypted;
    }

    static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static MessageDigest getMd5Digest() {
        return SecurityFunctions.getDigest("MD5");
    }

    private static MessageDigest getShaDigest() {
        return SecurityFunctions.getDigest("SHA");
    }

    private static MessageDigest getSha256Digest() {
        return SecurityFunctions.getDigest("SHA-256");
    }
}

