/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.collection.StringList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class TextFunctions {
    public static int length(String str) {
        return TextFunctions.fixNullString(str).length();
    }

    public static String left(String str, int num_chars) {
        if (str == null) {
            return "";
        }
        if (num_chars < 0) {
            return "";
        }
        int strLength = str.length();
        return str.substring(0, num_chars > strLength ? strLength : num_chars);
    }

    public static String right(String str, int num_chars) {
        if (str == null) {
            return "";
        }
        if (num_chars < 0) {
            return "";
        }
        int strLength = str.length();
        int startIndex = strLength - num_chars;
        if (startIndex <= 0) {
            return str;
        }
        return str.substring(startIndex);
    }

    public static String mid(String str, int start_index) {
        if (str == null) {
            return "";
        }
        return TextFunctions.mid(str, start_index, str.length());
    }

    public static String mid(String str, int start_index, int num_chars) {
        if (str == null) {
            return "";
        }
        if (start_index < 0) {
            start_index = 0;
        }
        if (num_chars < 0) {
            return "";
        }
        int strLength = str.length();
        if (start_index >= strLength) {
            return "";
        }
        int endIndex = start_index + num_chars;
        if (endIndex >= strLength) {
            endIndex = strLength;
        }
        return str.substring(start_index, endIndex);
    }

    public static boolean equal(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean notEqual(String str1, String str2) {
        return !TextFunctions.equal(str1, str2);
    }

    public static int findFirst(String str1, char charToFind, int start_index) {
        if (str1 == null) {
            return -1;
        }
        return str1.indexOf(charToFind, start_index);
    }

    public static int findFirst(String str1, char charToFind) {
        if (str1 == null) {
            return -1;
        }
        return str1.indexOf(charToFind);
    }

    public static int findFirst(String withinStr, String strToFind) {
        return TextFunctions.findFirst(withinStr, strToFind, 0);
    }

    public static int findFirst(String withinStr, String strToFind, int start_index) {
        if (withinStr == null) {
            return -1;
        }
        if (strToFind == null) {
            return -1;
        }
        return withinStr.indexOf(strToFind, start_index);
    }

    public static int findFirst(String withinStr, StringList strToFind) {
        return TextFunctions.findFirst(withinStr, strToFind, 0);
    }

    public static int findFirst(String withinStr, StringList strToFind, int start_index) {
        if (withinStr == null) {
            return -1;
        }
        if (strToFind == null) {
            return -1;
        }
        return TextFunctions.indexOf(withinStr, strToFind, start_index);
    }

    private static int indexOf(String str1, StringList sequences, int start_index) {
        int length = str1.length();
        for (int i = start_index = Math.max(start_index, 0); i < length; ++i) {
            char b = str1.charAt(i);
            for (int j = 0; j < sequences.size(); ++j) {
                String sequence = sequences.getValue(j);
                if (sequence == null || sequence.length() <= 0 || b != sequence.charAt(0) || !TextFunctions.isSequenceMatch(str1, i, sequence)) continue;
                return i;
            }
        }
        return -1;
    }

    private static boolean isSequenceMatch(String str1, int index, String sequence) {
        int length = str1.length();
        for (int i = index; i < index + sequence.length(); ++i) {
            if (i < length) {
                if (str1.charAt(i) == sequence.charAt(i - index)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static int findLast(String withinStr, String strToFind) {
        if (withinStr == null) {
            return -1;
        }
        if (strToFind == null) {
            return -1;
        }
        return withinStr.lastIndexOf(strToFind);
    }

    public static int findLast(String withinStr, String strToFind, int start_index) {
        if (withinStr == null) {
            return -1;
        }
        if (strToFind == null) {
            return -1;
        }
        return withinStr.lastIndexOf(strToFind, start_index);
    }

    public static int findLast(String str1, char charToFind) {
        if (str1 == null) {
            return -1;
        }
        return str1.lastIndexOf(charToFind);
    }

    public static int findLast(String str1, char charToFind, int start_index) {
        if (str1 == null) {
            return -1;
        }
        return str1.lastIndexOf(charToFind, start_index);
    }

    public static String concat(String str1, String str2) {
        return TextFunctions.fixNullString(str1) + TextFunctions.fixNullString(str2);
    }

    public static String concat(String str1, String str2, String str3) {
        return TextFunctions.fixNullString(str1) + TextFunctions.fixNullString(str2) + TextFunctions.fixNullString(str3);
    }

    public static String concat(String str1, String str2, String str3, String str4) {
        return TextFunctions.fixNullString(str1) + TextFunctions.fixNullString(str2) + TextFunctions.fixNullString(str3) + TextFunctions.fixNullString(str4);
    }

    public static String concat(String str1, String str2, String str3, String str4, String str5) {
        return TextFunctions.fixNullString(str1) + TextFunctions.fixNullString(str2) + TextFunctions.fixNullString(str3) + TextFunctions.fixNullString(str4) + TextFunctions.fixNullString(str5);
    }

    public static String concat(String str1, String str2, String str3, String str4, String str5, String str6) {
        return TextFunctions.fixNullString(str1) + TextFunctions.fixNullString(str2) + TextFunctions.fixNullString(str3) + TextFunctions.fixNullString(str4) + TextFunctions.fixNullString(str5) + TextFunctions.fixNullString(str6);
    }

    public static String concat(int val, String str) {
        return val + TextFunctions.fixNullString(str);
    }

    public static String concat(String str, int val) {
        return TextFunctions.fixNullString(str) + val;
    }

    public static String concat(float val, String str) {
        return val + TextFunctions.fixNullString(str);
    }

    public static String concat(String str, float val) {
        return TextFunctions.fixNullString(str) + val;
    }

    public static String concat(double val, String str) {
        return val + TextFunctions.fixNullString(str);
    }

    public static String concat(String str, double val) {
        return TextFunctions.fixNullString(str) + val;
    }

    public static String concat(long val, String str) {
        return val + TextFunctions.fixNullString(str);
    }

    public static String concat(String str, long val) {
        return TextFunctions.fixNullString(str) + val;
    }

    public static String concat(String str, BigDecimal val) {
        return TextFunctions.fixNullString(str) + Parsing.toString(val);
    }

    public static String concat(BigDecimal val, String str) {
        return Parsing.toString(val) + TextFunctions.fixNullString(str);
    }

    public static String concat(String str, ScaledDecimal val) {
        return TextFunctions.fixNullString(str) + Parsing.toString(val);
    }

    public static String concat(ScaledDecimal val, String str) {
        return Parsing.toString(val) + TextFunctions.fixNullString(str);
    }

    public static String concat(String str, BigInteger val) {
        return TextFunctions.fixNullString(str) + Parsing.toString(val);
    }

    public static String concat(BigInteger val, String str) {
        return Parsing.toString(val) + TextFunctions.fixNullString(str);
    }

    public static String concat(String str, Date val) {
        return TextFunctions.fixNullString(str) + (val == null ? "" : val.toString());
    }

    public static String concat(Date val, String str) {
        return (val == null ? "" : val.toString()) + TextFunctions.fixNullString(str);
    }

    public static String concat(String str, char c) {
        return TextFunctions.fixNullString(str) + c;
    }

    public static String concat(char c, String str) {
        return c + TextFunctions.fixNullString(str);
    }

    public static String concat(String str, boolean b) {
        return TextFunctions.fixNullString(str) + b;
    }

    public static String concat(boolean b, String str) {
        return b + TextFunctions.fixNullString(str);
    }

    public static char charAt(String str, int index) {
        try {
            return TextFunctions.fixNullString(str).charAt(index);
        }
        catch (IndexOutOfBoundsException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT564", new Object[]{"charAt", e.getMessage()});
            tre.setDetail(e);
            throw tre;
        }
    }

    public static String lower(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String upper(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static boolean startsWith(String str, String start_text) {
        if (str == null) {
            return start_text == null;
        }
        if (start_text == null) {
            return false;
        }
        return str.startsWith(start_text);
    }

    public static boolean startsWithIgnoreCase(String str, String start_text) {
        if (str == null) {
            return start_text == null;
        }
        if (start_text == null) {
            return false;
        }
        return str.toLowerCase().startsWith(start_text.toLowerCase());
    }

    public static boolean startsWith(String str, String start_text, int start_index) {
        if (str == null) {
            return start_text == null;
        }
        if (start_text == null) {
            return false;
        }
        int strLength = str.length();
        if (start_index < 0) {
            start_index = 0;
        }
        if (start_index >= strLength) {
            return false;
        }
        return str.startsWith(start_text, start_index);
    }

    public static boolean startsWithIgnoreCase(String str, String start_text, int start_index) {
        if (str == null) {
            return start_text == null;
        }
        if (start_text == null) {
            return false;
        }
        int strLength = str.length();
        if (start_index < 0) {
            start_index = 0;
        }
        if (start_index >= strLength) {
            return false;
        }
        return str.toLowerCase().startsWith(start_text.toLowerCase(), start_index);
    }

    public static boolean endsWith(String str, String end_text) {
        if (str == null) {
            return end_text == null;
        }
        if (end_text == null) {
            return false;
        }
        return str.endsWith(end_text);
    }

    public static boolean endsWithIgnoreCase(String str, String end_text) {
        if (str == null) {
            return end_text == null;
        }
        if (end_text == null) {
            return false;
        }
        return str.toLowerCase().endsWith(end_text.toLowerCase());
    }

    public static String replace(String str, char oldchar, char newchar) {
        if (str == null) {
            return null;
        }
        return str.replace(oldchar, newchar);
    }

    public static String replace(String str, int start_index, int num_chars, String newstr) {
        if (str == null) {
            return null;
        }
        FastStringBuffer buff = new FastStringBuffer(str);
        int strLength = buff.length();
        if (start_index < 0 || start_index >= strLength || num_chars < 0 || newstr == null) {
            return str;
        }
        int endIndex = start_index + num_chars;
        if (endIndex >= strLength) {
            endIndex = strLength;
        }
        return buff.replace(start_index, endIndex, newstr).toString();
    }

    public static String replace(String str, String oldstr, String newstr) {
        if (str == null) {
            return null;
        }
        if (oldstr == null || oldstr.length() == 0 || newstr == null) {
            return str;
        }
        int lastMatchIndex = 0;
        int index = str.indexOf(oldstr);
        if (index != -1) {
            FastStringBuffer sb = new FastStringBuffer(str.length());
            while (index != -1) {
                sb.append(str, lastMatchIndex, index - lastMatchIndex);
                sb.append(newstr);
                lastMatchIndex = index + oldstr.length();
                index = str.indexOf(oldstr, lastMatchIndex);
            }
            sb.append(str, lastMatchIndex, str.length() - lastMatchIndex);
            return sb.toString();
        }
        return str;
    }

    public static String trim(String str) {
        if (str == null) {
            return null;
        }
        return str.trim();
    }

    public static String trimLeft(String str) {
        int st;
        if (str == null) {
            return null;
        }
        int len = str.length();
        for (st = 0; st < len && str.charAt(st) <= ' '; ++st) {
        }
        return st > 0 ? str.substring(st) : str;
    }

    public static String trimRight(String str) {
        int len;
        if (str == null) {
            return null;
        }
        int st = 0;
        for (len = str.length(); st < len && str.charAt(len - 1) <= ' '; --len) {
        }
        return st > 0 || len < str.length() ? str.substring(0, len) : str;
    }

    public static boolean less(String str1, String str2) {
        return TextFunctions.compare(str1, str2) < 0;
    }

    public static boolean greater(String str1, String str2) {
        return TextFunctions.compare(str1, str2) > 0;
    }

    public static boolean lessEqual(String str1, String str2) {
        return TextFunctions.compare(str1, str2) <= 0;
    }

    public static boolean greaterEqual(String str1, String str2) {
        return TextFunctions.compare(str1, str2) >= 0;
    }

    public static int compareWhereLettersPrecedeNumbers(String str1, String str2) {
        if (str1 == null) {
            if (str2 == null) {
                return 0;
            }
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return TextFunctions.compareToWhereLettersPrecedeNumbers(str1, str2);
    }

    private static int compareToWhereLettersPrecedeNumbers(String aString, String anotherString) {
        int len1 = aString.length();
        int len2 = anotherString.length();
        int n = Math.min(len1, len2);
        char[] v1 = aString.toCharArray();
        char[] v2 = anotherString.toCharArray();
        for (int i = 0; i < n; ++i) {
            char c2;
            char c1 = TextFunctions.increaseDigitValue(v1[i]);
            if (c1 == (c2 = TextFunctions.increaseDigitValue(v2[i]))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static void cmtmain(String[] args) {
        int val = TextFunctions.compareWhereLettersPrecedeNumbers("UBSW30", "UBSWZ0");
        System.out.println(val);
    }

    private static char increaseDigitValue(char ch) {
        return (char)(ch >= 48 && ch <= 57 ? ch + 128 : ch);
    }

    public static int compare(String str1, String str2) {
        if (str1 == null) {
            if (str2 == null) {
                return 0;
            }
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    public static int compareIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            if (str2 == null) {
                return 0;
            }
            return -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareToIgnoreCase(str2);
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer(str);
        return buff.reverse().toString();
    }

    public static boolean equalIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static boolean notEqualIgnoreCase(String str1, String str2) {
        return !TextFunctions.equalIgnoreCase(str1, str2);
    }

    public static String replace(String str, int index, char newchar) {
        return TextFunctions.replace(str, index, 1, String.valueOf(newchar));
    }

    public static String replace(String str, String oldstr, char newchar) {
        return TextFunctions.replace(str, oldstr, String.valueOf(newchar));
    }

    public static String replace(String str, char oldchar, String newstr) {
        return TextFunctions.replace(str, String.valueOf(oldchar), newstr);
    }

    public static String insert(String withinStr, int index, String insert_text) {
        if (withinStr == null) {
            return null;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > withinStr.length()) {
            index = withinStr.length();
        }
        StringBuffer buff = new StringBuffer(withinStr);
        return buff.insert(index, insert_text).toString();
    }

    public static String insert(String withinStr, int index, int insert_val) {
        if (withinStr == null) {
            return null;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > withinStr.length()) {
            index = withinStr.length();
        }
        StringBuffer buff = new StringBuffer(withinStr);
        return buff.insert(index, insert_val).toString();
    }

    public static String insert(String withinStr, int index, float insert_val) {
        if (withinStr == null) {
            return null;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > withinStr.length()) {
            index = withinStr.length();
        }
        StringBuffer buff = new StringBuffer(withinStr);
        return buff.insert(index, insert_val).toString();
    }

    public static String insert(String withinStr, int index, double insert_val) {
        if (withinStr == null) {
            return null;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > withinStr.length()) {
            index = withinStr.length();
        }
        StringBuffer buff = new StringBuffer(withinStr);
        return buff.insert(index, insert_val).toString();
    }

    public static String insert(String withinStr, int index, char insert_char) {
        if (withinStr == null) {
            return null;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > withinStr.length()) {
            index = withinStr.length();
        }
        StringBuffer buff = new StringBuffer(withinStr);
        return buff.insert(index, insert_char).toString();
    }

    public static String deleteCharAt(String str, int index) {
        if (str == null) {
            return null;
        }
        if (index < 0 || index >= str.length()) {
            return str;
        }
        StringBuffer buff = new StringBuffer(str);
        return buff.deleteCharAt(index).toString();
    }

    public static String deleteStr(String str, int start_index, int num_chars) {
        if (str == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer(str);
        int strLength = buff.length();
        if (start_index < 0 || start_index >= strLength || num_chars < 0) {
            return str;
        }
        int endIndex = start_index + num_chars;
        if (endIndex >= strLength) {
            endIndex = strLength;
        }
        return buff.delete(start_index, endIndex).toString();
    }

    public static String leftStr(String str, String delimiterStr) {
        if (str == null) {
            return null;
        }
        if (delimiterStr == null) {
            return str;
        }
        int index = str.indexOf(delimiterStr);
        if (index != -1) {
            return str.substring(0, index);
        }
        return str;
    }

    public static String rightStr(String str, String delimiterStr) {
        if (str == null) {
            return null;
        }
        if (delimiterStr == null) {
            return str;
        }
        int index = str.indexOf(delimiterStr);
        if (index != -1) {
            return str.substring(index + delimiterStr.length());
        }
        return str;
    }

    public static StringList split(String delimiterStr, String str) {
        return TextFunctions.split(delimiterStr, str, Integer.MAX_VALUE);
    }

    public static StringList split(String delimiterStr, String str, int count) {
        StringList stringList = new StringList();
        if (str == null || str.length() == 0) {
            return stringList;
        }
        if (delimiterStr == null || delimiterStr.length() == 0) {
            stringList.add(str);
            return stringList;
        }
        int lastIndex = 0;
        while (lastIndex < str.length() && stringList.size() < count) {
            int index = str.indexOf(delimiterStr, lastIndex);
            if (index != -1) {
                stringList.add(str.substring(lastIndex, index));
                lastIndex = index + delimiterStr.length();
                if (lastIndex != str.length()) continue;
                stringList.add("");
                continue;
            }
            stringList.add(str.substring(lastIndex, str.length()));
            lastIndex = str.length();
        }
        return stringList;
    }

    public static void cmtmain2(String[] args) {
        System.out.println(TextFunctions.replace("ABCDEF", "DE", "X").equals("ABCXF"));
        System.out.println(TextFunctions.replace("ABCDEF", "DE", "XYZ").equals("ABCXYZF"));
        System.out.println(TextFunctions.replace("ABCDEFDEF", "DE", "X").equals("ABCXFXF"));
        System.out.println(TextFunctions.replace("ABCDEFDEF", "DE", "XYZ").equals("ABCXYZFXYZF"));
        System.out.println(TextFunctions.replace("ABCDEFDEF", "EE", "XYZ").equals("ABCDEFDEF"));
        String str = "\r\nAB\r\nBC\r\n\r\nA\r\n";
        System.out.println(TextFunctions.split("\r\n", str));
    }

    public static String repeat(String str, int count) {
        StringBuffer newstr = new StringBuffer();
        if (count <= 0 || str == null) {
            return "";
        }
        while (count > 0) {
            newstr.append(str);
            --count;
        }
        return newstr.toString();
    }

    public static String rpad(String str, char pad_char, int max_chars) {
        str = TextFunctions.fixNullString(str);
        if (max_chars < 0) {
            return str;
        }
        if (max_chars < str.length()) {
            return str.substring(0, max_chars);
        }
        if (max_chars == str.length()) {
            return str;
        }
        char[] chars = new char[max_chars - str.length()];
        Arrays.fill(chars, pad_char);
        return str + new String(chars);
    }

    public static String lpad(String str, char pad_char, int max_chars) {
        str = TextFunctions.fixNullString(str);
        if (max_chars < 0) {
            return str;
        }
        if (max_chars < str.length()) {
            return str.substring(0, max_chars);
        }
        if (max_chars == str.length()) {
            return str;
        }
        char[] chars = new char[max_chars - str.length()];
        Arrays.fill(chars, pad_char);
        return new String(chars) + str;
    }

    private static final String fixNullString(String str) {
        return str == null ? "" : str;
    }

    public static boolean isAlphaUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isAlphaUpper(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (TextFunctions.isAlphaUpper(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isAlpha(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (TextFunctions.isAlpha(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNum(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isNum(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (TextFunctions.isNum(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNum(char c) {
        return TextFunctions.isAlpha(c) || TextFunctions.isNum(c);
    }

    public static boolean isAlphaNum(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (TextFunctions.isAlphaNum(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaUpperNum(char c) {
        return TextFunctions.isAlphaUpper(c) || TextFunctions.isNum(c);
    }

    public static boolean isAlphaUpperNum(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (TextFunctions.isAlphaUpperNum(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static StringBuffer append(StringBuffer buffer, String val) {
        return buffer.append(val);
    }

    public static StringBuffer append(StringBuffer buffer, int val) {
        return buffer.append(Parsing.toString(val));
    }

    public static StringBuffer append(StringBuffer buffer, long val) {
        return buffer.append(Parsing.toString(val));
    }

    public static StringBuffer append(StringBuffer buffer, double val) {
        return buffer.append(Parsing.toString(val));
    }

    public static StringBuffer append(StringBuffer buffer, float val) {
        return buffer.append(Parsing.toString(val));
    }

    public static StringBuffer append(StringBuffer buffer, char val) {
        return buffer.append(Parsing.toString(val));
    }

    public static StringBuffer append(StringBuffer buffer, boolean val) {
        return buffer.append(Parsing.toString(val));
    }

    public static StringBuffer append(StringBuffer buffer, Date val) {
        return buffer.append(Parsing.toString(val));
    }

    public static StringBuffer append(StringBuffer buffer, Calendar val) {
        return buffer.append(Parsing.formatISODate(val));
    }

    public static StringBuffer append(StringBuffer buffer, byte[] val) {
        return buffer.append(Parsing.toString(val));
    }

    public static StringBuffer append(StringBuffer buffer, BigDecimal val) {
        return buffer.append(Parsing.toString(val));
    }

    public static StringBuffer append(StringBuffer buffer, ScaledDecimal val) {
        return buffer.append(Parsing.toString(val));
    }

    public static StringBuffer append(StringBuffer buffer, BigInteger val) {
        return buffer.append(Parsing.toString(val));
    }

    public static StringBuffer append(StringBuffer buffer, StringBuffer val) {
        return buffer.append(val.toString());
    }

    public static StringBuffer createStringBuffer(int capacity) {
        return new StringBuffer(capacity);
    }

    public static StringBuffer createStringBuffer() {
        return new StringBuffer();
    }
}

