/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.MessageFlow;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.NormalizedObjectCollection;
import com.tplus.transform.runtime.NormalizedObjectMappingFormat;
import com.tplus.transform.runtime.PersistenceManager;
import com.tplus.transform.runtime.Query;
import com.tplus.transform.runtime.QueryDef;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformContextImpl;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.formula.LookupHelper;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.NamingException;

public class TransformFunctions
implements DesignerTypes {
    public static DataObjectSection query(String internalMessageName, String queryName, String params) throws TransformException {
        try {
            PersistenceManager persistenceManager = LookupHelper.getLookupContext().lookupInternalMessage(internalMessageName).getPersistenceManager();
            if (persistenceManager != null) {
                QueryDef queryDef = persistenceManager.getQuery(queryName);
                Properties props = new Properties();
                StringTokenizer stk = new StringTokenizer(params, ";");
                while (stk.hasMoreTokens()) {
                    String token;
                    String name = token = stk.nextToken();
                    int index = token.indexOf("=");
                    if (index == -1) continue;
                    name = token.substring(0, index);
                    String value = token.substring(index + 1);
                    props.setProperty(name, value);
                }
                Query query = new Query(queryName);
                String[] queryParamNames = queryDef.getParameters();
                String[] queryParamTypes = queryDef.getParameterTypes();
                for (int i = 0; i < queryDef.getParameterCount(); ++i) {
                    String paramName = queryParamNames[i];
                    String paramValueStr = props.getProperty(paramName);
                    String paramType = queryParamTypes[i];
                    Object paramValue = TransformFunctions.stringToObject(paramValueStr, paramType);
                    query.addParameter(paramName, paramValue);
                }
                return persistenceManager.find(query);
            }
            throw TransformException.createFormatted("SRT583", internalMessageName);
        }
        catch (Exception e) {
            if (e instanceof TransformException) {
                throw (TransformException)e;
            }
            TransformException te = TransformException.createFormatted("SRT584");
            te.setDetail(e);
            throw te;
        }
    }

    public static NormalizedObject transform(NormalizedObject input, String transformationName) throws TransformException {
        try {
            NormalizedObjectMappingFormat mapper = LookupHelper.getLookupContext().lookupNormalizedObjectMappingFormat(transformationName);
            TransformContextImpl cxt = new TransformContextImpl();
            return mapper.map(input, (TransformContext)cxt);
        }
        catch (Exception e) {
            if (e instanceof TransformException) {
                throw (TransformException)e;
            }
            TransformException te = TransformException.createFormatted("SRT585");
            te.setDetail(e);
            throw te;
        }
    }

    public static DataObjectSection transformAll(DataObjectSection input, String transformationName) throws TransformException {
        try {
            NormalizedObjectMappingFormat mapper = LookupHelper.getLookupContext().lookupNormalizedObjectMappingFormat(transformationName);
            TransformContextImpl cxt = new TransformContextImpl();
            NormalizedObject[] nobjs = new NormalizedObject[input.getElementCount()];
            for (int i = 0; i < input.getElementCount(); ++i) {
                nobjs[i] = (NormalizedObject)input.getElement(i);
            }
            NormalizedObject[] nobjsOut = mapper.map(nobjs, (TransformContext)cxt);
            for (int i = 0; i < nobjsOut.length; ++i) {
                nobjs[i] = (NormalizedObject)input.getElement(i);
            }
            return new NormalizedObjectCollection(Arrays.asList(nobjsOut));
        }
        catch (Exception e) {
            if (e instanceof TransformException) {
                throw (TransformException)e;
            }
            TransformException te = TransformException.createFormatted("SRT585");
            te.setDetail(e);
            throw te;
        }
    }

    public static DataObject invokeFlow(String flowName, Object[] args) throws TransformException {
        try {
            LookupContext lookupContext = LookupHelper.getLookupContext();
            MessageFlow messageFlow = lookupContext.lookupMessageFlow(flowName);
            DataObject inObj = messageFlow.createInputDataObject();
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                inObj.setField(i, arg);
            }
            DataObject object = messageFlow.run(inObj, (TransformContext)new TransformContextImpl());
            return object;
        }
        catch (NamingException e) {
            TransformException te = TransformException.createFormatted("Error looking up flow " + flowName);
            throw te;
        }
        catch (RemoteException e) {
            TransformException te = TransformException.createFormatted("Error looking up flow " + flowName);
            throw te;
        }
        catch (TransformException e) {
            throw e;
        }
        catch (Exception e) {
            TransformException te = TransformException.createFormatted("Error invoking flow " + flowName);
            te.setDetail(e);
            throw te;
        }
    }

    static Object stringToObject(String valueStr, String type) {
        if (type.equals(DESIGNER_STRING_TYPE)) {
            return valueStr;
        }
        if (type.equals(DESIGNER_INT_TYPE)) {
            return Wrapper.box(Wrapper.parseInt(valueStr));
        }
        return valueStr;
    }
}

