/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.lang.BeanManager;
import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectBase;
import com.tplus.transform.runtime.DataObjectMetaInfoImpl;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DataObjectSectionImpl;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.InternalMessage;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.SectionMetaInfoImpl;
import com.tplus.transform.runtime.SimpleGenericDataObject;
import com.tplus.transform.runtime.StreamInputSource;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.Variant;
import com.tplus.transform.runtime.VariantGeneric;
import com.tplus.transform.runtime.formula.LookupHelper;
import com.tplus.transform.runtime.formula.MessageFunctions;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.runtime.xml.DataObjectXMLParserImpl;
import com.tplus.transform.util.UUID;
import com.tplus.transform.util.log.Log;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;

public class UtilFunctions {
    protected static Log log = LogFactory.getRuntimeLog();
    static BeanManager beanManager = new BeanManager();

    public static void info(Log log, String str) {
        if (log != null && log.isInfoEnabled()) {
            log.info(str);
        }
    }

    public static void warn(Log log, String str) {
        if (log != null && log.isWarnEnabled()) {
            log.warn(str);
        }
    }

    public static void trace(Log log, String str) {
        if (log != null && log.isTraceEnabled()) {
            log.trace(str);
        }
    }

    public static void fatal(Log log, String str) {
        if (log != null && log.isFatalEnabled()) {
            log.fatal(str);
        }
    }

    public static void error(Log log, String str) {
        boolean b;
        boolean bl = b = log != null && log.isErrorEnabled();
        if (b) {
            log.error(str);
        }
    }

    public static void debug(Log log, String str) {
        if (log != null && log.isDebugEnabled()) {
            log.debug(str);
        }
    }

    public static void info(Log log, DataObject obj) {
        if (log != null && log.isInfoEnabled()) {
            UtilFunctions.logObject(log, Log.INFO, obj);
        }
    }

    public static void warn(Log log, DataObject obj) {
        if (log != null && log.isWarnEnabled()) {
            UtilFunctions.logObject(log, Log.WARN, obj);
        }
    }

    public static void trace(Log log, DataObject obj) {
        if (log != null && log.isTraceEnabled()) {
            UtilFunctions.logObject(log, Log.TRACE, obj);
        }
    }

    public static void fatal(Log log, DataObject obj) {
        if (log != null && log.isFatalEnabled()) {
            UtilFunctions.logObject(log, Log.FATAL, obj);
        }
    }

    public static void error(Log log, DataObject obj) {
        if (log != null && log.isErrorEnabled()) {
            UtilFunctions.logObject(log, Log.ERROR, obj);
        }
    }

    public static void debug(Log log, DataObject obj) {
        if (log != null && log.isDebugEnabled()) {
            UtilFunctions.logObject(log, Log.DEBUG, obj);
        }
    }

    public static void info(DataObject str) {
        if (log.isInfoEnabled()) {
            log.info(str);
        }
    }

    public static void info(String str) {
        if (log.isInfoEnabled()) {
            log.info(str);
        }
    }

    public static void warn(DataObject str) {
        if (log != null && log.isWarnEnabled()) {
            log.warn(str);
        }
    }

    public static void warn(String str) {
        if (log != null && log.isWarnEnabled()) {
            log.warn(str);
        }
    }

    public static void trace(DataObject str) {
        if (log != null && log.isTraceEnabled()) {
            log.trace(str);
        }
    }

    public static void trace(String str) {
        if (log != null && log.isTraceEnabled()) {
            log.trace(str);
        }
    }

    public static void error(String str) {
        boolean errorEnabled;
        boolean bl = errorEnabled = log != null && log.isErrorEnabled();
        if (errorEnabled) {
            log.error(str);
        }
    }

    public static void error(DataObject str) {
        boolean errorEnabled;
        boolean bl = errorEnabled = log != null && log.isErrorEnabled();
        if (errorEnabled) {
            log.error(str);
        }
    }

    public static void debug(String str) {
        if (log != null && log.isDebugEnabled()) {
            log.debug(str);
        }
    }

    public static void debug(DataObject str) {
        if (log != null && log.isDebugEnabled()) {
            log.debug(str);
        }
    }

    public static void fatal(String str) {
        if (log != null && log.isFatalEnabled()) {
            log.fatal(str);
        }
    }

    public static void fatal(DataObject str) {
        if (log != null && log.isFatalEnabled()) {
            log.fatal(str);
        }
    }

    public static void log(Log log, String logLevel, Object obj) {
        if (log != null) {
            Log.LogLevel level = Log.LogLevel.toLogLevel(logLevel);
            if (obj instanceof DataObject) {
                UtilFunctions.logObject(log, level, (DataObject)obj);
            } else {
                log.log(obj, level, null);
            }
        }
    }

    private static void logObject(Log log, Log.LogLevel logLevel, DataObject obj) {
        if (obj != null) {
            TransformException transformException = UtilFunctions.toException(obj);
            if (transformException != null) {
                log.log(transformException.getMessage(), logLevel, transformException);
            } else {
                log.log(obj.toXMLString(), logLevel, null);
            }
        }
    }

    private static TransformException toException(DataObject obj) {
        TransformException transformException = null;
        if (obj instanceof TransformException) {
            transformException = (TransformException)obj;
        }
        return transformException;
    }

    public static int makeCopy(int val) {
        return val;
    }

    public static long makeCopy(long val) {
        return val;
    }

    public static float makeCopy(float val) {
        return val;
    }

    public static double makeCopy(double val) {
        return val;
    }

    public static boolean makeCopy(boolean val) {
        return val;
    }

    public static char makeCopy(char val) {
        return val;
    }

    public static String makeCopy(String val) {
        return val;
    }

    public static byte[] makeCopy(byte[] val) {
        return (byte[])val.clone();
    }

    public static Date makeCopy(Date val) {
        return (Date)val.clone();
    }

    public static Calendar makeCopy(Calendar val) {
        return (Calendar)val.clone();
    }

    public static BigInteger makeCopy(BigInteger val) {
        return val;
    }

    public static BigDecimal makeCopy(BigDecimal val) {
        return val;
    }

    public static ScaledDecimal makeCopy(ScaledDecimal val) {
        return val;
    }

    public static DataObjectSection makeCopy(DataObjectSection sec) throws FieldNotFoundException {
        DataObjectSection cloned = (DataObjectSection)sec.clone();
        cloned.setParent(null);
        return cloned;
    }

    public static DataObject makeCopy(DataObject obj) throws FieldNotFoundException {
        DataObject cloned = (DataObject)obj.clone();
        cloned.setParentSection(null);
        return cloned;
    }

    public static Variant getContextObjectProperty(TransformContext cxt, String propertyName) {
        if (cxt != null) {
            Object property = cxt.getProperty(propertyName);
            return new VariantGeneric(property);
        }
        return null;
    }

    public static void setContextObjectProperty(TransformContext cxt, String propertyName, Variant propertyValue) {
        if (propertyValue == null) {
            cxt.setProperty(propertyName, null);
        } else {
            cxt.setProperty(propertyName, propertyValue.getValue());
        }
    }

    public static String getContextProperty(TransformContext cxt, String propertyName, String defaultValue) {
        String toRet;
        Object value = cxt.getProperty(propertyName);
        if (value instanceof String && (toRet = (String)value).length() > 0) {
            return toRet;
        }
        return defaultValue;
    }

    public static String getContextProperty(TransformContext cxt, String propertyName) {
        Object value;
        if (cxt != null && (value = cxt.getProperty(propertyName)) instanceof String) {
            return (String)value;
        }
        return "";
    }

    public static void setContextProperty(TransformContext cxt, String propertyName, String propertyValue) {
        if (propertyValue == null || propertyValue.length() == 0) {
            cxt.setProperty(propertyName, null);
        } else {
            cxt.setProperty(propertyName, propertyValue);
        }
    }

    public static Variant getJavaProperty(Variant variant, String name) throws TransformException {
        if (variant == null) {
            return null;
        }
        Object object = variant.getValue();
        return UtilFunctions.getJavaPropertyImpl(object, name);
    }

    private static Variant getJavaPropertyImpl(Object object, String name) throws TransformException {
        if (object instanceof Map) {
            Map map = (Map)object;
            return new VariantGeneric(map.get(name));
        }
        if (object != null) {
            try {
                Object value = beanManager.getProperty(object, name);
                return new VariantGeneric(value);
            }
            catch (InvocationTargetException e) {
                throw new TransformException("Error accessing property " + name + " bean " + object.getClass(), e.getTargetException());
            }
            catch (Exception e) {
                throw new TransformException("Error accessing property " + name + " bean " + object.getClass(), e);
            }
        }
        return null;
    }

    public static void setJavaProperty(Variant variant, String name, String value) throws TransformException {
        if (variant == null) {
            return;
        }
        UtilFunctions.setJavaPropertyImpl(variant.getValue(), name, value);
    }

    public static void setJavaProperty(Variant variant, String name, int value) throws TransformException {
        if (variant == null) {
            return;
        }
        UtilFunctions.setJavaPropertyImpl(variant.getValue(), name, Wrapper.box(value));
    }

    public static void setJavaProperty(Variant variant, String name, Variant value) throws TransformException {
        if (variant == null) {
            return;
        }
        UtilFunctions.setJavaPropertyImpl(variant.getValue(), name, value.getValue());
    }

    private static void setJavaPropertyImpl(Object object, String name, Object actualValue) throws TransformException {
        if (object instanceof Map) {
            Map map = (Map)object;
            map.put(name, actualValue);
        } else if (object != null) {
            try {
                beanManager.setProperty(object, name, actualValue);
            }
            catch (InvocationTargetException e) {
                throw new TransformException("Error setting property " + name + " in bean " + object.getClass(), e.getTargetException());
            }
            catch (Exception e) {
                throw new TransformException("Error setting property " + name + " in bean " + object.getClass(), e);
            }
        }
    }

    public static String uuid() {
        String id = UUID.randomUUID().toString();
        return id;
    }

    public static void dispose(DataObject obj) {
        DataObjectBase.dispose(obj);
    }

    public static void dispose(DataObjectSection section) {
        DataObjectBase.dispose(section);
    }

    public static void copy(DataObject obj1, DataObject obj2) {
        DataObjectBase.copy(obj1, obj2);
    }

    public static void copy(DataObjectSection obj1, DataObjectSection obj2) {
        DataObjectBase.copy(obj1, obj2);
    }

    public static void copy(DataObject obj1, DataObject obj2, boolean lenientOpt) {
        if (lenientOpt) {
            DataObjectBase.copyLenient(obj1, obj2);
        } else {
            DataObjectBase.copy(obj1, obj2);
        }
    }

    public static void copy(DataObjectSection obj1, DataObjectSection obj2, boolean lenientOpt) {
        if (lenientOpt) {
            DataObjectBase.copyLenient(obj1, obj2);
        } else {
            DataObjectBase.copy(obj1, obj2);
        }
    }

    public static RawMessage createProperties() {
        return MessageFunctions.newMessage();
    }

    public static RawMessage loadPropertiesFromResource(String resource) throws TransformException {
        RawMessage properties = UtilFunctions.createProperties();
        UtilFunctions.loadPropertiesFromResource(properties, resource);
        return properties;
    }

    public static void loadPropertiesFromResource(RawMessage message, String resource) throws TransformException {
        InputStream resourceAsStream;
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        if ((resourceAsStream = UtilFunctions.class.getResourceAsStream(resource)) != null) {
            try {
                Properties properties = new Properties();
                properties.load(resourceAsStream);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    message.setProperty(name, value);
                }
            }
            catch (IOException e) {
                throw new TransformException("Error loading resource file " + resource, e);
            }
            finally {
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static DataObjectSection loadInternalMessagesXML(String configFileName, String messageName) throws TransformException {
        try {
            ClassLoader classLoader = LookupHelper.getLookupContext().getClass().getClassLoader();
            DataObjectSection toRet = new DataObjectSectionImpl();
            Enumeration<URL> resources = classLoader.getResources(configFileName);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (resource == null) continue;
                DataObjectSection dataObjectSection = UtilFunctions.toInternalObjects(messageName, classLoader, new StreamInputSource(resource.openStream()));
                if (toRet == null) {
                    toRet = dataObjectSection;
                    continue;
                }
                toRet.addAll(dataObjectSection);
            }
            return toRet;
        }
        catch (TransformException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransformException("Error parsing resource " + configFileName, e);
        }
    }

    private static DataObjectSection toInternalObjects(String messageName, ClassLoader classLoader, RawMessage data) throws Exception {
        DataObject object = UtilFunctions.createInternalMessageWrapperObject(messageName);
        DataObjectXMLParserImpl dataObjectXMLParser = new DataObjectXMLParserImpl();
        ExceptionHandler.CascadingExceptionHandler cascadingExceptionHandler = new ExceptionHandler.CascadingExceptionHandler();
        dataObjectXMLParser.parse(object, cascadingExceptionHandler, data, null);
        List exceptions = cascadingExceptionHandler.getExceptions();
        if (exceptions.size() > 0) {
            TransformException transformException = new TransformException(exceptions);
            throw transformException;
        }
        DataObjectSection dataObjectSection = object.getSection(0);
        return dataObjectSection;
    }

    private static DataObject createInternalMessageWrapperObject(String messageName) throws RemoteException, NamingException, TransformException {
        final InternalMessage internalMessage = LookupHelper.getLookupContext().lookupInternalMessage(messageName);
        NormalizedObject normalizedObject = internalMessage.createNormalizedObject();
        DataObjectMetaInfoImpl info = new DataObjectMetaInfoImpl(messageName + "List", new FieldMetaInfo[]{new SectionMetaInfoImpl(normalizedObject.getMetaInfo(), messageName)});
        SimpleGenericDataObject object = new SimpleGenericDataObject(info){

            public DataObject createSectionElement(int secIndex, DataObjectSection dataObjectSection) throws FieldNotFoundException {
                try {
                    return internalMessage.createNormalizedObject();
                }
                catch (RemoteException e1) {
                    e1.printStackTrace();
                    return null;
                }
            }
        };
        return object;
    }
}

