/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula;

import com.tplus.transform.lang.ScaledDecimal;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.Message;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformContextImpl;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.formula.BinaryFunctions;
import com.tplus.transform.runtime.formula.LookupHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import javax.naming.NamingException;

public class ValidationFunctions {
    public static boolean between(int value, int from, int to) throws TransformException {
        if (from > to) {
            int temp = from;
            from = to;
            to = temp;
        }
        return value >= from && value <= to;
    }

    public static boolean between(float value, float from, float to) throws TransformException {
        if (from > to) {
            float temp = from;
            from = to;
            to = temp;
        }
        return value >= from && value <= to;
    }

    public static boolean between(double value, double from, double to) throws TransformException {
        if (from > to) {
            double temp = from;
            from = to;
            to = temp;
        }
        return value >= from && value <= to;
    }

    public static boolean between(long value, long from, long to) throws TransformException {
        if (from > to) {
            long temp = from;
            from = to;
            to = temp;
        }
        return value >= from && value <= to;
    }

    public static boolean between(Date value, Date from, Date to) throws TransformException {
        if (from.after(to)) {
            Date temp = from;
            from = to;
            to = temp;
        }
        return value.compareTo(from) >= 0 && value.compareTo(to) <= 0;
    }

    public static boolean valueIn(Integer value, int[] allowedValues) {
        if (value == null) {
            return false;
        }
        return ValidationFunctions.valueIn((int)value, allowedValues);
    }

    public static boolean valueIn(int value, int[] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (allowedValues[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean valueIn(Float value, float[] allowedValues) {
        if (value == null) {
            return false;
        }
        return ValidationFunctions.valueIn(value.floatValue(), allowedValues);
    }

    public static boolean valueIn(float value, float[] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (allowedValues[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean valueIn(Double value, double[] allowedValues) {
        if (value == null) {
            return false;
        }
        return ValidationFunctions.valueIn((double)value, allowedValues);
    }

    public static boolean valueIn(double value, double[] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (allowedValues[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean valueIn(Long value, long[] allowedValues) {
        if (value == null) {
            return false;
        }
        return ValidationFunctions.valueIn((long)value, allowedValues);
    }

    public static boolean valueIn(long value, long[] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (allowedValues[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean valueIn(Character value, char[] allowedValues) {
        if (value == null) {
            return false;
        }
        return ValidationFunctions.valueIn(value.charValue(), allowedValues);
    }

    public static boolean valueIn(char value, char[] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (allowedValues[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean valueIn(Date value, Date[] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (!allowedValues[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean valueIn(String value, String[] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            String allowedValue = allowedValues[i];
            if (allowedValue == null || !allowedValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean valueIn(boolean value, boolean[] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (allowedValues[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean valueIn(Boolean value, boolean[] allowedValues) {
        if (value == null) {
            return false;
        }
        return ValidationFunctions.valueIn((boolean)value, allowedValues);
    }

    public static boolean valueIn(Calendar value, Calendar[] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (!allowedValues[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean valueIn(byte[] value, byte[][] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (!BinaryFunctions.byteEquals(allowedValues[i], value)) continue;
            return true;
        }
        return false;
    }

    public static boolean valueIn(BigInteger value, BigInteger[] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (!allowedValues[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean valueIn(BigDecimal value, BigDecimal[] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (!allowedValues[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean valueIn(ScaledDecimal value, ScaledDecimal[] allowedValues) {
        for (int i = 0; i < allowedValues.length; ++i) {
            if (!allowedValues[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean fieldExists(DataObject obj, int fieldIndex) {
        return obj != null && !obj.isNull(fieldIndex);
    }

    public static boolean sectionExists(DataObject obj, int fieldIndex) {
        return obj != null && obj.getSection(fieldIndex).getElementCount() > 0;
    }

    public static boolean fieldExists(DataObject obj, int secInd, int fieldIndex) {
        return ValidationFunctions.fieldExists(ValidationFunctions.getNestedSectionElement(obj, secInd), fieldIndex);
    }

    public static boolean fieldExists(DataObject obj, int secInd1, int secInd2, int fieldIndex) {
        return ValidationFunctions.fieldExists(ValidationFunctions.getNestedSectionElement(obj, secInd1, secInd2), fieldIndex);
    }

    public static boolean fieldExists(DataObject obj, int secInd1, int secInd2, int secInd3, int fieldIndex) {
        return ValidationFunctions.fieldExists(ValidationFunctions.getNestedSectionElement(obj, secInd1, secInd2, secInd3), fieldIndex);
    }

    public static boolean fieldExists(DataObject obj, int secInd1, int secInd2, int secInd3, int secInd4, int fieldIndex) {
        return ValidationFunctions.fieldExists(ValidationFunctions.getNestedSectionElement(obj, secInd1, secInd2, secInd3, secInd4), fieldIndex);
    }

    public static boolean fieldExists(DataObject obj, int secInd1, int secInd2, int secInd3, int secInd4, int secInd5, int fieldIndex) {
        return ValidationFunctions.fieldExists(ValidationFunctions.getNestedSectionElement(obj, secInd1, secInd2, secInd3, secInd4, secInd5), fieldIndex);
    }

    public static boolean fieldExists(DataObject obj, int[] secInd, int fieldIndex) {
        return ValidationFunctions.fieldExists(ValidationFunctions.getNestedSectionElement(obj, secInd), fieldIndex);
    }

    public static DataObject getNestedSectionElement(DataObject obj, int secInd) {
        DataObjectSection dataObjectSection;
        if (obj != null && (dataObjectSection = obj.getSection(secInd)).getElementCount() > 0) {
            DataObject element = dataObjectSection.getElement(0);
            return element;
        }
        return null;
    }

    public static DataObject getNestedSectionElement(DataObject obj, int secInd1, int secInd2) {
        return ValidationFunctions.getNestedSectionElement(ValidationFunctions.getNestedSectionElement(obj, secInd1), secInd2);
    }

    public static DataObject getNestedSectionElement(DataObject obj, int secInd1, int secInd2, int secInd3) {
        return ValidationFunctions.getNestedSectionElement(ValidationFunctions.getNestedSectionElement(obj, secInd1, secInd2), secInd3);
    }

    public static DataObject getNestedSectionElement(DataObject obj, int secInd1, int secInd2, int secInd3, int secInd4) {
        return ValidationFunctions.getNestedSectionElement(ValidationFunctions.getNestedSectionElement(obj, secInd1, secInd2, secInd3), secInd4);
    }

    public static DataObject getNestedSectionElement(DataObject obj, int secInd1, int secInd2, int secInd3, int secInd4, int secInd5) {
        return ValidationFunctions.getNestedSectionElement(ValidationFunctions.getNestedSectionElement(obj, secInd1, secInd2, secInd3, secInd4), secInd5);
    }

    public static DataObject getNestedSectionElement(DataObject obj, int[] secIndes) {
        int secInd;
        DataObject current = obj;
        for (int i = 0; i < secIndes.length && (current = ValidationFunctions.getNestedSectionElement(current, secInd = secIndes[i])) != null; ++i) {
        }
        return current;
    }

    public static DataObject parse(String messageName, RawMessage raw, DataObjectSection context) throws NamingException, TransformException {
        try {
            LookupContext lookupContext = LookupHelper.getLookupContext();
            Message message = lookupContext.lookupMessage(messageName);
            TransformContext cxt = ValidationFunctions.createContext(context);
            DataObject dataObject = message.parse(raw, cxt);
            return dataObject;
        }
        catch (RemoteException e) {
            throw new NamingException(e.getMessage());
        }
    }

    private static TransformContext createContext(DataObjectSection context) {
        TransformContextImpl transformContext = new TransformContextImpl();
        for (int i = 0; i < context.size(); ++i) {
            DataObject dataObject = context.getElement(i);
            String name = (String)dataObject.getField("name");
            String value = (String)dataObject.getField("value");
            transformContext.setProperty(name, value);
        }
        return transformContext;
    }
}

