/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.formula.zip;

import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.collection.RawMessageList;
import com.tplus.transform.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZIPFunctions {
    public static RawMessage gunzip(RawMessage rawMessage) throws TransformException {
        InputStream asStream = rawMessage.getAsStream();
        try {
            GZIPInputStream gzin = new GZIPInputStream(asStream);
            RawMessage rawMessage2 = ZIPFunctions.unzip(gzin);
            return rawMessage2;
        }
        catch (IOException ex) {
            throw new TransformException(ex.getMessage(), ex);
        }
        finally {
            ZIPFunctions.closeQuietly(asStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RawMessage inflate(RawMessage rawMessage) throws TransformException {
        InputStream asStream = rawMessage.getAsStream();
        try {
            InflaterInputStream gzin = new InflaterInputStream(asStream);
            RawMessage rawMessage2 = ZIPFunctions.unzip(gzin);
            return rawMessage2;
        }
        finally {
            ZIPFunctions.closeQuietly(asStream);
        }
    }

    private static RawMessage unzip(InputStream gzin) throws TransformException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtil.copyStreams(gzin, bos, false);
            bos.close();
            gzin.close();
            ByteArrayInputSource byteArrayInputSource = new ByteArrayInputSource(bos.toByteArray());
            return byteArrayInputSource;
        }
        catch (IOException ex) {
            throw new TransformException(ex.getMessage(), ex);
        }
        finally {
            ZIPFunctions.closeQuietly(gzin);
        }
    }

    public static RawMessage gzip(RawMessage rawMessage) throws TransformException {
        InputStream asStream = rawMessage.getAsStream();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream outputStream = new GZIPOutputStream(bos);
            IOUtil.copyStreams(asStream, outputStream, true);
            ByteArrayInputSource byteArrayInputSource = new ByteArrayInputSource(bos.toByteArray());
            return byteArrayInputSource;
        }
        catch (IOException ex) {
            throw new TransformException(ex.getMessage(), ex);
        }
        finally {
            ZIPFunctions.closeQuietly(asStream);
        }
    }

    public static RawMessage deflate(RawMessage rawMessage) throws TransformException {
        InputStream asStream = rawMessage.getAsStream();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DeflaterOutputStream outputStream = new DeflaterOutputStream(bos);
            IOUtil.copyStreams(asStream, outputStream, true);
            ByteArrayInputSource byteArrayInputSource = new ByteArrayInputSource(bos.toByteArray());
            return byteArrayInputSource;
        }
        catch (IOException ex) {
            throw new TransformException(ex.getMessage(), ex);
        }
        finally {
            ZIPFunctions.closeQuietly(asStream);
        }
    }

    static void closeQuietly(InputStream is) {
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static RawMessage unzip(RawMessage rawMessage, String name) throws TransformException {
        RawMessageList files = ZIPFunctions.unzip(rawMessage);
        for (int i = 0; i < files.size(); ++i) {
            RawMessage message = (RawMessage)files.get(i);
            if (!message.getName().equals(name)) continue;
            return message;
        }
        throw new TransformException("Zip does not contain file by name " + name);
    }

    public static RawMessageList unzip(RawMessage rawMessage) throws TransformException {
        InputStream asStream = rawMessage.getAsStream();
        try {
            ZipInputStream zin = new ZipInputStream(asStream);
            ZipEntry zipEntry = null;
            RawMessageList rawMessageList = new RawMessageList();
            while ((zipEntry = zin.getNextEntry()) != null) {
                ByteArrayOutputStream fout = new ByteArrayOutputStream();
                IOUtil.copyStreams(zin, fout, false);
                zin.closeEntry();
                fout.close();
                ByteArrayInputSource byteArrayInputSource = new ByteArrayInputSource(fout.toByteArray());
                String path = zipEntry.getName();
                if (zipEntry.isDirectory()) continue;
                byteArrayInputSource.setName(path);
                byteArrayInputSource.setProperty("file.name", new File(path).getName());
                byteArrayInputSource.setProperty("file.path", zipEntry.getName());
                rawMessageList.add(byteArrayInputSource);
            }
            ZIPFunctions.closeQuietly(zin);
            RawMessageList rawMessageList2 = rawMessageList;
            return rawMessageList2;
        }
        catch (IOException e) {
            throw new TransformException(e.getMessage(), e);
        }
        finally {
            ZIPFunctions.closeQuietly(asStream);
        }
    }

    public static RawMessage zip(RawMessage rawMessage) throws TransformException {
        RawMessageList rawMessages = new RawMessageList();
        rawMessages.add(rawMessage);
        return ZIPFunctions.zip(rawMessages);
    }

    public static RawMessage zip(RawMessageList rawMessages) throws TransformException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(bos);
        try {
            for (int i = 0; i < rawMessages.size(); ++i) {
                RawMessage rawMessage = (RawMessage)rawMessages.get(i);
                String name = rawMessage.getName();
                if (name == null) {
                    throw new TransformException("Name property not set for RawMessage. Zip function requires name to be set");
                }
                ZipEntry ze = new ZipEntry(name);
                InputStream asStream = rawMessage.getAsStream();
                try {
                    zout.putNextEntry(ze);
                    IOUtil.copyStreams(asStream, zout, false);
                    continue;
                }
                catch (IOException e) {
                    throw new TransformException(e.getMessage(), e);
                }
                finally {
                    ZIPFunctions.closeQuietly(asStream);
                }
            }
            zout.close();
        }
        catch (IOException e) {
            throw new TransformException(e.getMessage(), e);
        }
        return new ByteArrayInputSource(bos.toByteArray());
    }
}

