/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.impl;

import com.tplus.transform.runtime.Lookup;
import com.tplus.transform.runtime.LookupContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.formula.LookupHelper;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.NamingException;

public class LookupReflectionImpl
implements Lookup {
    private static final String LOOKUP_CONTEXT_FACTORY_CLASS_NAME = "com.tplus.transform.runtime.LookupContextFactory";

    public synchronized ConnectionPool getConnectionPool(String dataSource) throws TransformException {
        ConnectionPool pool = null;
        try {
            LookupContext cxt = this.getLookupContext();
            Method lookupDataSourceMeth = cxt.getClass().getMethod("lookupDataSource", String.class);
            Object obj = lookupDataSourceMeth.invoke((Object)cxt, dataSource);
            pool = (ConnectionPool)obj;
        }
        catch (InvocationTargetException e) {
            TransformException te = TransformException.createFormatted("SRT565", dataSource);
            te.setDetail(e.getTargetException());
            throw te;
        }
        catch (Exception e) {
            TransformException te = TransformException.createFormatted("SRT565", dataSource);
            te.setDetail(e);
            throw te;
        }
        return pool;
    }

    public LookupContext getLookupContext() throws NamingException {
        Object cxt = null;
        try {
            Class lookupCxtFactory = LookupReflectionImpl.loadContextFactoryClass();
            Method meth = lookupCxtFactory.getMethod("getLookupContext", new Class[0]);
            cxt = meth.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            if (throwable instanceof NamingException) {
                NamingException namingException = (NamingException)throwable;
                throw namingException;
            }
            throw new TransformRuntimeException(e.getMessage(), throwable);
        }
        catch (ClassNotFoundException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return (LookupContext)cxt;
    }

    static Class loadContextFactoryClass() throws ClassNotFoundException {
        ClassLoader cl = LookupHelper.class.getClassLoader();
        if (cl != null) {
            try {
                Class<?> lookupCxtFactory = Class.forName(LOOKUP_CONTEXT_FACTORY_CLASS_NAME, true, cl);
                return lookupCxtFactory;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        cl = Thread.currentThread().getContextClassLoader();
        Class<?> lookupCxtFactory = Class.forName(LOOKUP_CONTEXT_FACTORY_CLASS_NAME, true, cl);
        return lookupCxtFactory;
    }
}

