/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.io;

import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.Binary;
import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.RawOutputMessage;
import com.tplus.transform.runtime.TransformException;
import java.io.Serializable;
import org.apache.xml.utils.FastStringBuffer;

public abstract class AbstractOutputDevice
extends AbstractRawMessage
implements OutputDevice,
RawOutputMessage,
Serializable {
    String encoding;
    DeviceInfo deviceInfo;
    private boolean firstOutput = true;

    public AbstractOutputDevice(DeviceInfo deviceInfo) {
        this.encoding = deviceInfo.getEncoding();
        this.deviceInfo = deviceInfo;
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void write(Object data) throws TransformException {
        AbstractOutputDevice.writeHelper(data, this);
    }

    public static void writeHelper(Object data, RawMessage rawMessage) throws TransformException {
        if (data instanceof byte[]) {
            rawMessage.append((byte[])data);
        } else if (data instanceof Binary) {
            rawMessage.append(((Binary)data).getAsBytes());
        } else if (data instanceof RawMessage) {
            rawMessage.append((RawMessage)data);
        } else if (data instanceof char[]) {
            rawMessage.append(new String((char[])data));
        } else if (data instanceof String) {
            rawMessage.append((String)data);
        } else if (data instanceof StringBuffer || data instanceof FastStringBuffer) {
            rawMessage.append(data.toString());
        } else {
            throw TransformException.createFormatted("SRT425", data.getClass().getName());
        }
    }

    public void append(byte[] data) throws TransformException {
        this.append(data, 0, data.length);
    }

    public void append(RawMessage data) throws TransformException {
        Object asBytesOrString;
        if (this.firstOutput) {
            AbstractOutputDevice.copyProperties(data, this);
            this.firstOutput = false;
        }
        if ((asBytesOrString = AbstractOutputDevice.getAsBytesOrString(data)) instanceof String) {
            this.append((String)asBytesOrString);
        } else {
            this.append((byte[])asBytesOrString);
        }
    }

    public Object getAsObject() throws TransformException {
        throw new TransformException("RawMessage is availbale only for output. Operation Not supported");
    }

    public static Object getAsBytesOrString(RawMessage raw) throws TransformException {
        Object asObject = raw.getAsObject();
        if (asObject instanceof Binary) {
            Binary binary = (Binary)asObject;
            return binary.getAsBytes();
        }
        return asObject;
    }

    public abstract void append(String var1) throws TransformException;

    public abstract void append(byte[] var1, int var2, int var3) throws TransformException;

    public abstract void close() throws TransformException;
}

