/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.io;

import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import com.tplus.transform.runtime.io.ByteArrayOutputDeviceLocal;
import com.tplus.transform.runtime.io.OutputStreamDevice;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;

public class ByteArrayOutputStreamDevice
extends OutputStreamDevice
implements ByteArrayOutputDeviceLocal {
    private static final long serialVersionUID = 1L;

    public ByteArrayOutputStreamDevice(DeviceInfo deviceInfo) {
        super(new SerializableByteArrayOutputStream(), deviceInfo);
    }

    public byte[] getAsBytes() {
        ByteArrayOutputStream bos = (ByteArrayOutputStream)super.getOutputStream();
        return bos.toByteArray();
    }

    public String getAsString() {
        ByteArrayOutputStream bos = (ByteArrayOutputStream)super.getOutputStream();
        String encoding = this.getEncoding();
        if (encoding != null) {
            return this.toString(bos, encoding);
        }
        return bos.toString();
    }

    private String toString(ByteArrayOutputStream bos, String encoding) {
        try {
            return bos.toString(encoding);
        }
        catch (UnsupportedEncodingException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT457");
            tre.setDetail(e);
            throw tre;
        }
    }

    public String getAsString(String encoding) {
        ByteArrayOutputStream bos = (ByteArrayOutputStream)super.getOutputStream();
        return this.toString(bos, encoding);
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        ByteArrayOutputStream bos = (ByteArrayOutputStream)super.getOutputStream();
        bos.writeTo(out);
    }

    public synchronized void writeTo(OutputDevice out) throws TransformException, RemoteException {
        ByteArrayOutputStream bos = (ByteArrayOutputStream)super.getOutputStream();
        out.write(this.getAsBytes());
    }

    public static class SerializableByteArrayOutputStream
    extends ByteArrayOutputStream
    implements Serializable {
        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            int count = ois.readInt();
            byte[] buf = new byte[count];
            ois.read(buf);
            this.buf = buf;
            this.count = count;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.defaultWriteObject();
            oos.writeInt(this.count);
            oos.write(this.buf, 0, this.count);
        }
    }
}

