/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.io;

import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.Cacheble;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.TransformException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class DataObjectDataIO {
    private static final int EIGHTH_BIT_SET = 128;
    private static final int EIGHTH_BIT_CLEARED = 127;

    public static void serialize(DataObject obj, DataOutput bos) throws TransformException {
        try {
            DataObjectDataIO.write(obj, bos);
        }
        catch (IOException e) {
            throw new TransformException("Write Error", e);
        }
    }

    public static void parse(DataObject obj, DataInput bis) throws TransformException {
        try {
            DataObjectDataIO.read(obj, bis);
        }
        catch (IOException e) {
            throw new TransformException("Parse Error", e);
        }
    }

    private static void write(DataObject obj, DataOutput out) throws IOException {
        DataObjectMetaInfo metaInfo = obj.getMetaInfo();
        int fieldCount = obj.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            try {
                if (obj.isNull(i)) continue;
                FieldMetaInfo fieldMetaInfo = metaInfo.getFieldMetaInfo(i);
                Object fldVal = obj.getField(i);
                int indexToWrite = fieldMetaInfo.getIndex() + 1;
                if (fldVal instanceof DataObjectSection) {
                    int size;
                    DataObjectSection sec = (DataObjectSection)fldVal;
                    if (sec instanceof Cacheble) {
                        size = sec.getElementCount();
                        if (size <= 0) continue;
                        DataObjectDataIO.writeFastUnsignedInt(out, indexToWrite);
                        Cacheble cacheble = (Cacheble)((Object)sec);
                        cacheble.write(out);
                        continue;
                    }
                    size = sec.getElementCount();
                    if (size <= 0) continue;
                    DataObjectDataIO.writeFastUnsignedInt(out, indexToWrite);
                    DataObjectDataIO.writeFastUnsignedInt(out, size);
                    for (int j = 0; j < sec.getElementCount(); ++j) {
                        DataObject dObj = sec.getElement(j);
                        DataObjectDataIO.write(dObj, out);
                    }
                    continue;
                }
                if (fldVal instanceof DataObject) {
                    DataObjectDataIO.writeFastUnsignedInt(out, indexToWrite);
                    DataObjectDataIO.write((DataObject)fldVal, out);
                    continue;
                }
                DataObjectDataIO.writeFastUnsignedInt(out, indexToWrite);
                DesignerType type = fieldMetaInfo.getDesignerType();
                DataObjectDataIO.writeField(fldVal, type, out);
                continue;
            }
            catch (FieldNotFoundException e) {
                // empty catch block
            }
        }
        DataObjectDataIO.writeFastUnsignedInt(out, 0);
    }

    private static void writeField(Object fldVal, DesignerType type, DataOutput out) throws IOException {
        if (type == DesignerTypes.STRING_TYPE) {
            DataObjectDataIO.writeString(out, (String)fldVal);
        } else if (type == DesignerTypes.INT_TYPE) {
            DataObjectDataIO.writeIntBigEndian(out, (Integer)fldVal);
        } else if (type == DesignerTypes.LONG_TYPE) {
            DataObjectDataIO.writeLongBigEndian(out, (Long)fldVal);
        } else if (type == DesignerTypes.DOUBLE_TYPE) {
            DataObjectDataIO.writeDoubleBigEndian(out, (Double)fldVal);
        } else if (type == DesignerTypes.FLOAT_TYPE) {
            DataObjectDataIO.writeFloatBigEndian(out, ((Float)fldVal).floatValue());
        } else if (type == DesignerTypes.DATE_ONLY_TYPE) {
            DataObjectDataIO.writeCompactDateTime(out, (Date)fldVal, true, false);
        } else if (type == DesignerTypes.TIME_ONLY_TYPE) {
            DataObjectDataIO.writeCompactDateTime(out, (Date)fldVal, false, true);
        } else if (type == DesignerTypes.DATE_TIME_TYPE) {
            DataObjectDataIO.writeCompactDateTime(out, (Date)fldVal, true, true);
        } else if (type == DesignerTypes.CHAR_TYPE) {
            DataObjectDataIO.writeFastUnsignedInt(out, ((Character)fldVal).charValue());
        } else {
            String str = type.format(fldVal);
            DataObjectDataIO.writeString(out, str);
        }
    }

    private static void writeDoubleBigEndian(DataOutput out, double value) throws IOException {
        DataObjectDataIO.writeLongBigEndian(out, Double.doubleToLongBits(value));
    }

    private static void writeFloatBigEndian(DataOutput out, float value) throws IOException {
        DataObjectDataIO.writeIntBigEndian(out, Float.floatToIntBits(value));
    }

    private static void writeIntBigEndian(DataOutput out, int value) throws IOException {
        out.write(value >>> 24 & 0xFF);
        out.write(value >>> 16 & 0xFF);
        out.write(value >>> 8 & 0xFF);
        out.write(value >>> 0 & 0xFF);
    }

    private static void writeLongBigEndian(DataOutput out, long value) throws IOException {
        out.write((int)(value >>> 56) & 0xFF);
        out.write((int)(value >>> 48) & 0xFF);
        out.write((int)(value >>> 40) & 0xFF);
        out.write((int)(value >>> 32) & 0xFF);
        out.write((int)(value >>> 24) & 0xFF);
        out.write((int)(value >>> 16) & 0xFF);
        out.write((int)(value >>> 8) & 0xFF);
        out.write((int)(value >>> 0) & 0xFF);
    }

    private static Object readField(DataInput in, DesignerType type) throws IOException, TransformException {
        if (type == DesignerTypes.STRING_TYPE) {
            return DataObjectDataIO.readString(in);
        }
        if (type == DesignerTypes.INT_TYPE) {
            return Wrapper.box(DataObjectDataIO.readIntBigEndian(in));
        }
        if (type == DesignerTypes.LONG_TYPE) {
            return Wrapper.box(DataObjectDataIO.readLongBigEndian(in));
        }
        if (type == DesignerTypes.DOUBLE_TYPE) {
            return Wrapper.box(DataObjectDataIO.readDoubleBigEndian(in));
        }
        if (type == DesignerTypes.FLOAT_TYPE) {
            return Wrapper.box(DataObjectDataIO.readFloatBigEndian(in));
        }
        if (type == DesignerTypes.DATE_ONLY_TYPE) {
            return DataObjectDataIO.readCompactDateTime(in, true, false);
        }
        if (type == DesignerTypes.TIME_ONLY_TYPE) {
            return DataObjectDataIO.readCompactDateTime(in, false, true);
        }
        if (type == DesignerTypes.DATE_TIME_TYPE) {
            return DataObjectDataIO.readCompactDateTime(in, true, true);
        }
        if (type == DesignerTypes.CHAR_TYPE) {
            return Wrapper.box((char)DataObjectDataIO.readFastUnsignedInt(in));
        }
        String fldStr = DataObjectDataIO.readString(in);
        Object fldValue = type.parse(fldStr);
        return fldValue;
    }

    private static int readIntBigEndian(DataInput in) throws IOException {
        int ch1 = DataObjectDataIO.read(in) & 0xFF;
        int ch2 = DataObjectDataIO.read(in) & 0xFF;
        int ch3 = DataObjectDataIO.read(in) & 0xFF;
        int ch4 = DataObjectDataIO.read(in) & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private static byte read(DataInput in) throws IOException {
        return in.readByte();
    }

    public static long readLongBigEndian(DataInput in) throws IOException {
        int i1 = DataObjectDataIO.readIntBigEndian(in);
        int i2 = DataObjectDataIO.readIntBigEndian(in);
        return ((long)i1 << 32) + ((long)i2 & 0xFFFFFFFFL);
    }

    public static float readFloatBigEndian(DataInput in) throws IOException {
        int value = DataObjectDataIO.readIntBigEndian(in);
        return Float.intBitsToFloat(value);
    }

    public static double readDoubleBigEndian(DataInput in) throws IOException {
        long value = DataObjectDataIO.readLongBigEndian(in);
        return Double.longBitsToDouble(value);
    }

    private static void read(DataObject obj, DataInput in) throws IOException {
        DataObjectMetaInfo metaInfo = obj.getMetaInfo();
        block2: while (true) {
            try {
                int fldIndex;
                while ((fldIndex = DataObjectDataIO.readFastUnsignedInt(in)) != 0) {
                    FieldMetaInfo fieldMetaInfo;
                    DesignerType type;
                    if ((type = (fieldMetaInfo = metaInfo.getFieldMetaInfo(--fldIndex)).getDesignerType()).isSectionType()) {
                        DataObjectSection sec = obj.getSection(fieldMetaInfo.getIndex());
                        sec.clear();
                        if (sec instanceof Cacheble) {
                            Cacheble cacheble = (Cacheble)((Object)sec);
                            cacheble.read(in);
                            continue;
                        }
                        int count = DataObjectDataIO.readFastUnsignedInt(in);
                        for (int j = 0; j < count; ++j) {
                            DataObject dObj = sec.createElement();
                            DataObjectDataIO.read(dObj, in);
                            sec.addElement(dObj);
                        }
                        continue block2;
                    }
                    if (type.isMessageType()) {
                        DataObject newElement = (DataObject)obj.getField(fieldMetaInfo.getIndex());
                        if (newElement != null) {
                            newElement.reset();
                        } else {
                            newElement = obj.createSectionElement(fieldMetaInfo.getIndex(), null);
                        }
                        DataObjectDataIO.read(newElement, in);
                        continue;
                    }
                    Object fldValue = DataObjectDataIO.readField(in, type);
                    obj.setField(fieldMetaInfo.getIndex(), fldValue);
                }
            }
            catch (TransformException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void writeCompactDateTime(DataOutput dataOutput, Date date, boolean writeDate, boolean writeTime) throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (writeDate) {
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            DataObjectDataIO.writeFastUnsignedInt(dataOutput, year);
            DataObjectDataIO.writeFastUnsignedInt(dataOutput, month);
            DataObjectDataIO.writeFastUnsignedInt(dataOutput, day);
        }
        if (writeTime) {
            int hours = calendar.get(11);
            int mins = calendar.get(12);
            int secs = calendar.get(13);
            int millisecs = calendar.get(14);
            DataObjectDataIO.writeFastUnsignedInt(dataOutput, hours);
            DataObjectDataIO.writeFastUnsignedInt(dataOutput, mins);
            DataObjectDataIO.writeFastUnsignedInt(dataOutput, secs);
            DataObjectDataIO.writeFastUnsignedInt(dataOutput, millisecs);
        }
    }

    public static Date readCompactDateTime(DataInput dataInput, boolean readDate, boolean readTime) throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        if (readDate) {
            int year = DataObjectDataIO.readFastUnsignedInt(dataInput);
            int month = DataObjectDataIO.readFastUnsignedInt(dataInput);
            int day = DataObjectDataIO.readFastUnsignedInt(dataInput);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
        } else {
            calendar.set(1, 1970);
            calendar.set(2, 1);
            calendar.set(5, 1);
        }
        if (readTime) {
            int hours = DataObjectDataIO.readFastUnsignedInt(dataInput);
            int mins = DataObjectDataIO.readFastUnsignedInt(dataInput);
            int secs = DataObjectDataIO.readFastUnsignedInt(dataInput);
            int millisecs = DataObjectDataIO.readFastUnsignedInt(dataInput);
            calendar.set(11, hours);
            calendar.set(12, mins);
            calendar.set(13, secs);
            calendar.set(14, millisecs);
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        return calendar.getTime();
    }

    private static void writeString(DataOutput out, String str) throws IOException {
        int length = str.length();
        DataObjectDataIO.writeFastUnsignedInt(out, length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            DataObjectDataIO.writeFastUnsignedInt(out, c);
        }
    }

    private static String readString(DataInput in) throws IOException {
        int length = DataObjectDataIO.readFastUnsignedInt(in);
        char[] str = new char[length];
        for (int i = 0; i < length; ++i) {
            str[i] = (char)DataObjectDataIO.readFastUnsignedInt(in);
        }
        return new String(str);
    }

    private static void writeFastUnsignedInt(DataOutput out, int value) throws IOException {
        if (value < 128) {
            out.write(value);
        } else if (value < 16384) {
            int b1 = DataObjectDataIO.setHighBit(value);
            int b2 = value >>> 7 & 0xFF;
            out.write(b1);
            out.write(b2);
        } else if (value < 0x200000) {
            int b1 = DataObjectDataIO.setHighBit(value);
            int b2 = DataObjectDataIO.setHighBit(value >>> 7);
            int b3 = value >>> 14 & 0xFF;
            out.write(b1);
            out.write(b2);
            out.write(b3);
        } else if (value < 0x10000000) {
            int b1 = DataObjectDataIO.setHighBit(value);
            int b2 = DataObjectDataIO.setHighBit(value >>> 7);
            int b3 = DataObjectDataIO.setHighBit(value >>> 14);
            int b4 = value >>> 21 & 0xFF;
            out.write(b1);
            out.write(b2);
            out.write(b3);
            out.write(b4);
        } else {
            int b1 = DataObjectDataIO.setHighBit(value);
            int b2 = DataObjectDataIO.setHighBit(value >>> 7);
            int b3 = DataObjectDataIO.setHighBit(value >>> 14);
            int b4 = DataObjectDataIO.setHighBit(value >>> 21);
            int b5 = value >>> 28 & 0xFF;
            out.write(b1);
            out.write(b2);
            out.write(b3);
            out.write(b4);
            out.write(b5);
        }
    }

    private static int setHighBit(int value) {
        return value & 0xFF | 0x80;
    }

    private static int readFastUnsignedInt(DataInput in) throws IOException {
        int b1 = in.readByte() & 0xFF;
        if (b1 < 128) {
            return b1;
        }
        byte b2 = DataObjectDataIO.read(in);
        if (b2 < 128) {
            return b2 << 7 | DataObjectDataIO.clearHighBit(b1);
        }
        byte b3 = DataObjectDataIO.read(in);
        if (b3 < 128) {
            return b3 << 14 | DataObjectDataIO.clearHighBitLS(b2, 7) | DataObjectDataIO.clearHighBit(b1);
        }
        byte b4 = DataObjectDataIO.read(in);
        if (b4 < 128) {
            return b4 << 21 | DataObjectDataIO.clearHighBitLS(b3, 14) | DataObjectDataIO.clearHighBitLS(b2, 7) | DataObjectDataIO.clearHighBit(b1);
        }
        byte b5 = DataObjectDataIO.read(in);
        return b5 << 28 | DataObjectDataIO.clearHighBitLS(b4, 21) | DataObjectDataIO.clearHighBitLS(b3, 14) | DataObjectDataIO.clearHighBitLS(b2, 7) | DataObjectDataIO.clearHighBit(b1);
    }

    private static int clearHighBit(int b1) {
        return b1 & 0x7F;
    }

    private static int clearHighBitLS(int b1, int by) {
        return (b1 & 0x7F) << by;
    }

    private static int readUnsignedInt(DataInput in, int fieldIndexBytes) throws IOException {
        if (fieldIndexBytes == 1) {
            return in.readByte();
        }
        if (fieldIndexBytes == 2) {
            return in.readShort();
        }
        if (fieldIndexBytes == 4) {
            return in.readInt();
        }
        return -1;
    }
}

