/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.io;

import com.tplus.transform.lang.ByteBuffer;
import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.DesignerTypes;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.FieldNotFoundException;
import com.tplus.transform.runtime.TransformException;
import java.io.DataInput;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class DataObjectIO {
    private static final int EIGHTH_BIT_SET = 128;
    private static final int EIGHTH_BIT_CLEARED = 127;

    public static byte[] serialize(DataObject obj) throws TransformException {
        try {
            ByteBuffer bos = new ByteBuffer(50, null);
            DataObjectIO.write(obj, bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new TransformException("Write Error", e);
        }
    }

    public static void parse(DataObject obj, byte[] data) throws TransformException {
        try {
            ByteBuffer bis = new ByteBuffer(data);
            DataObjectIO.read(obj, bis);
            if (bis.hasMore()) {
                throw new TransformException("Unexpected characters at the end of serialized message");
            }
        }
        catch (IOException e) {
            throw new TransformException("Parse Error", e);
        }
    }

    private static void write(DataObject obj, ByteBuffer out) throws IOException {
        DataObjectMetaInfo metaInfo = obj.getMetaInfo();
        int fieldCount = obj.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            try {
                if (obj.isNull(i)) continue;
                FieldMetaInfo fieldMetaInfo = metaInfo.getFieldMetaInfo(i);
                Object fldVal = obj.getField(i);
                int indexToWrite = fieldMetaInfo.getIndex() + 1;
                if (fldVal instanceof DataObjectSection) {
                    DataObjectSection sec = (DataObjectSection)fldVal;
                    int size = sec.getElementCount();
                    if (size <= 0) continue;
                    DataObjectIO.writeFastUnsignedInt(out, indexToWrite);
                    DataObjectIO.writeFastUnsignedInt(out, size);
                    for (int j = 0; j < sec.getElementCount(); ++j) {
                        DataObject dObj = sec.getElement(j);
                        DataObjectIO.write(dObj, out);
                    }
                    continue;
                }
                if (fldVal instanceof DataObject) {
                    DataObjectIO.writeFastUnsignedInt(out, indexToWrite);
                    DataObjectIO.write((DataObject)fldVal, out);
                    continue;
                }
                DataObjectIO.writeFastUnsignedInt(out, indexToWrite);
                DesignerType type = fieldMetaInfo.getDesignerType();
                DataObjectIO.writeField(fldVal, type, out);
                continue;
            }
            catch (FieldNotFoundException e) {
                // empty catch block
            }
        }
        DataObjectIO.writeFastUnsignedInt(out, 0);
    }

    private static void writeField(Object fldVal, DesignerType type, ByteBuffer out) throws IOException {
        if (type == DesignerTypes.STRING_TYPE) {
            DataObjectIO.writeString(out, (String)fldVal);
        } else if (type == DesignerTypes.INT_TYPE) {
            DataObjectIO.writeIntBigEndian(out, (Integer)fldVal);
        } else if (type == DesignerTypes.LONG_TYPE) {
            DataObjectIO.writeLongBigEndian(out, (Long)fldVal);
        } else if (type == DesignerTypes.DOUBLE_TYPE) {
            DataObjectIO.writeDoubleBigEndian(out, (Double)fldVal);
        } else if (type == DesignerTypes.FLOAT_TYPE) {
            DataObjectIO.writeFloatBigEndian(out, ((Float)fldVal).floatValue());
        } else if (type == DesignerTypes.DATE_ONLY_TYPE) {
            DataObjectIO.writeCompactDateTime(out, (Date)fldVal, true, false);
        } else if (type == DesignerTypes.TIME_ONLY_TYPE) {
            DataObjectIO.writeCompactDateTime(out, (Date)fldVal, false, true);
        } else if (type == DesignerTypes.DATE_TIME_TYPE) {
            DataObjectIO.writeCompactDateTime(out, (Date)fldVal, true, true);
        } else if (type == DesignerTypes.CHAR_TYPE) {
            DataObjectIO.writeFastUnsignedInt(out, ((Character)fldVal).charValue());
        } else {
            String str = type.format(fldVal);
            DataObjectIO.writeString(out, str);
        }
    }

    private static void writeDoubleBigEndian(ByteBuffer out, double value) throws IOException {
        DataObjectIO.writeLongBigEndian(out, Double.doubleToLongBits(value));
    }

    private static void writeFloatBigEndian(ByteBuffer out, float value) throws IOException {
        DataObjectIO.writeIntBigEndian(out, Float.floatToIntBits(value));
    }

    private static void writeIntBigEndian(ByteBuffer out, int value) throws IOException {
        out.write(value >>> 24 & 0xFF);
        out.write(value >>> 16 & 0xFF);
        out.write(value >>> 8 & 0xFF);
        out.write(value >>> 0 & 0xFF);
    }

    private static void writeLongBigEndian(ByteBuffer out, long value) throws IOException {
        out.write((int)(value >>> 56) & 0xFF);
        out.write((int)(value >>> 48) & 0xFF);
        out.write((int)(value >>> 40) & 0xFF);
        out.write((int)(value >>> 32) & 0xFF);
        out.write((int)(value >>> 24) & 0xFF);
        out.write((int)(value >>> 16) & 0xFF);
        out.write((int)(value >>> 8) & 0xFF);
        out.write((int)(value >>> 0) & 0xFF);
    }

    private static Object readField(ByteBuffer in, DesignerType type) throws IOException, TransformException {
        if (type == DesignerTypes.STRING_TYPE) {
            return DataObjectIO.readString(in);
        }
        if (type == DesignerTypes.INT_TYPE) {
            return Wrapper.box(DataObjectIO.readIntBigEndian(in));
        }
        if (type == DesignerTypes.LONG_TYPE) {
            return Wrapper.box(DataObjectIO.readLongBigEndian(in));
        }
        if (type == DesignerTypes.DOUBLE_TYPE) {
            return Wrapper.box(DataObjectIO.readDoubleBigEndian(in));
        }
        if (type == DesignerTypes.FLOAT_TYPE) {
            return Wrapper.box(DataObjectIO.readFloatBigEndian(in));
        }
        if (type == DesignerTypes.DATE_ONLY_TYPE) {
            return DataObjectIO.readCompactDateTime(in, true, false);
        }
        if (type == DesignerTypes.TIME_ONLY_TYPE) {
            return DataObjectIO.readCompactDateTime(in, false, true);
        }
        if (type == DesignerTypes.DATE_TIME_TYPE) {
            return DataObjectIO.readCompactDateTime(in, true, true);
        }
        if (type == DesignerTypes.CHAR_TYPE) {
            return Wrapper.box((char)DataObjectIO.readFastUnsignedInt(in));
        }
        String fldStr = DataObjectIO.readString(in);
        Object fldValue = type.parse(fldStr);
        return fldValue;
    }

    private static int readIntBigEndian(ByteBuffer in) throws IOException {
        int ch1 = in.read() & 0xFF;
        int ch2 = in.read() & 0xFF;
        int ch3 = in.read() & 0xFF;
        int ch4 = in.read() & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static long readLongBigEndian(ByteBuffer in) throws IOException {
        int i1 = DataObjectIO.readIntBigEndian(in);
        int i2 = DataObjectIO.readIntBigEndian(in);
        return ((long)i1 << 32) + ((long)i2 & 0xFFFFFFFFL);
    }

    public static float readFloatBigEndian(ByteBuffer in) throws IOException {
        int value = DataObjectIO.readIntBigEndian(in);
        return Float.intBitsToFloat(value);
    }

    public static double readDoubleBigEndian(ByteBuffer in) throws IOException {
        long value = DataObjectIO.readLongBigEndian(in);
        return Double.longBitsToDouble(value);
    }

    private static void read(DataObject obj, ByteBuffer in) throws IOException {
        DataObjectMetaInfo metaInfo = obj.getMetaInfo();
        block2: while (true) {
            try {
                int fldIndex;
                while ((fldIndex = DataObjectIO.readFastUnsignedInt(in)) != 0) {
                    FieldMetaInfo fieldMetaInfo;
                    DesignerType type;
                    if ((type = (fieldMetaInfo = metaInfo.getFieldMetaInfo(--fldIndex)).getDesignerType()).isSectionType()) {
                        int count = DataObjectIO.readFastUnsignedInt(in);
                        DataObjectSection sec = obj.getSection(fieldMetaInfo.getIndex());
                        sec.clear();
                        for (int j = 0; j < count; ++j) {
                            DataObject dObj = sec.createElement();
                            DataObjectIO.read(dObj, in);
                            sec.addElement(dObj);
                        }
                        continue block2;
                    }
                    if (type.isMessageType()) {
                        DataObject newElement = (DataObject)obj.getField(fieldMetaInfo.getIndex());
                        if (newElement != null) {
                            newElement.reset();
                        } else {
                            newElement = obj.createSectionElement(fieldMetaInfo.getIndex(), null);
                        }
                        DataObjectIO.read(newElement, in);
                        continue;
                    }
                    Object fldValue = DataObjectIO.readField(in, type);
                    obj.setField(fieldMetaInfo.getIndex(), fldValue);
                }
            }
            catch (TransformException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void writeCompactDateTime(ByteBuffer dataOutput, Date date, boolean writeDate, boolean writeTime) throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (writeDate) {
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            DataObjectIO.writeFastUnsignedInt(dataOutput, year);
            DataObjectIO.writeFastUnsignedInt(dataOutput, month);
            DataObjectIO.writeFastUnsignedInt(dataOutput, day);
        }
        if (writeTime) {
            int hours = calendar.get(11);
            int mins = calendar.get(12);
            int secs = calendar.get(13);
            int millisecs = calendar.get(14);
            DataObjectIO.writeFastUnsignedInt(dataOutput, hours);
            DataObjectIO.writeFastUnsignedInt(dataOutput, mins);
            DataObjectIO.writeFastUnsignedInt(dataOutput, secs);
            DataObjectIO.writeFastUnsignedInt(dataOutput, millisecs);
        }
    }

    public static Date readCompactDateTime(ByteBuffer dataInput, boolean readDate, boolean readTime) throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        if (readDate) {
            int year = DataObjectIO.readFastUnsignedInt(dataInput);
            int month = DataObjectIO.readFastUnsignedInt(dataInput);
            int day = DataObjectIO.readFastUnsignedInt(dataInput);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
        } else {
            calendar.set(1, 1970);
            calendar.set(2, 1);
            calendar.set(5, 1);
        }
        if (readTime) {
            int hours = DataObjectIO.readFastUnsignedInt(dataInput);
            int mins = DataObjectIO.readFastUnsignedInt(dataInput);
            int secs = DataObjectIO.readFastUnsignedInt(dataInput);
            int millisecs = DataObjectIO.readFastUnsignedInt(dataInput);
            calendar.set(11, hours);
            calendar.set(12, mins);
            calendar.set(13, secs);
            calendar.set(14, millisecs);
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        return calendar.getTime();
    }

    private static void writeString(ByteBuffer out, String str) throws IOException {
        int length = str.length();
        DataObjectIO.writeFastUnsignedInt(out, length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            DataObjectIO.writeFastUnsignedInt(out, c);
        }
    }

    private static String readString(ByteBuffer in) throws IOException {
        int length = DataObjectIO.readFastUnsignedInt(in);
        char[] str = new char[length];
        for (int i = 0; i < length; ++i) {
            str[i] = (char)DataObjectIO.readFastUnsignedInt(in);
        }
        return new String(str);
    }

    private static void writeFastUnsignedInt(ByteBuffer out, int value) throws IOException {
        if (value < 128) {
            out.write(value);
        } else if (value < 16384) {
            int b1 = DataObjectIO.setHighBit(value);
            int b2 = value >>> 7 & 0xFF;
            out.write(b1);
            out.write(b2);
        } else if (value < 0x200000) {
            int b1 = DataObjectIO.setHighBit(value);
            int b2 = DataObjectIO.setHighBit(value >>> 7);
            int b3 = value >>> 14 & 0xFF;
            out.write(b1);
            out.write(b2);
            out.write(b3);
        } else if (value < 0x10000000) {
            int b1 = DataObjectIO.setHighBit(value);
            int b2 = DataObjectIO.setHighBit(value >>> 7);
            int b3 = DataObjectIO.setHighBit(value >>> 14);
            int b4 = value >>> 21 & 0xFF;
            out.write(b1);
            out.write(b2);
            out.write(b3);
            out.write(b4);
        } else {
            int b1 = DataObjectIO.setHighBit(value);
            int b2 = DataObjectIO.setHighBit(value >>> 7);
            int b3 = DataObjectIO.setHighBit(value >>> 14);
            int b4 = DataObjectIO.setHighBit(value >>> 21);
            int b5 = value >>> 28 & 0xFF;
            out.write(b1);
            out.write(b2);
            out.write(b3);
            out.write(b4);
            out.write(b5);
        }
    }

    private static int setHighBit(int value) {
        return value & 0xFF | 0x80;
    }

    private static int readFastUnsignedInt(ByteBuffer in) throws IOException {
        int b1 = in.readByte() & 0xFF;
        if (b1 < 128) {
            return b1;
        }
        int b2 = in.read();
        if (b2 < 128) {
            return b2 << 7 | DataObjectIO.clearHighBit(b1);
        }
        int b3 = in.read();
        if (b3 < 128) {
            return b3 << 14 | DataObjectIO.clearHighBitLS(b2, 7) | DataObjectIO.clearHighBit(b1);
        }
        int b4 = in.read();
        if (b4 < 128) {
            return b4 << 21 | DataObjectIO.clearHighBitLS(b3, 14) | DataObjectIO.clearHighBitLS(b2, 7) | DataObjectIO.clearHighBit(b1);
        }
        int b5 = in.read();
        return b5 << 28 | DataObjectIO.clearHighBitLS(b4, 21) | DataObjectIO.clearHighBitLS(b3, 14) | DataObjectIO.clearHighBitLS(b2, 7) | DataObjectIO.clearHighBit(b1);
    }

    private static int clearHighBit(int b1) {
        return b1 & 0x7F;
    }

    private static int clearHighBitLS(int b1, int by) {
        return (b1 & 0x7F) << by;
    }

    private static int readUnsignedInt(DataInput in, int fieldIndexBytes) throws IOException {
        if (fieldIndexBytes == 1) {
            return in.readByte();
        }
        if (fieldIndexBytes == 2) {
            return in.readShort();
        }
        if (fieldIndexBytes == 4) {
            return in.readInt();
        }
        return -1;
    }
}

