/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.io;

import com.tplus.transform.runtime.AbstractMessageFlow;
import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.OutputDevice;
import com.tplus.transform.runtime.OutputProtocol;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.TransformRuntimeException;
import java.rmi.RemoteException;

public class DeviceOutputMessage
extends AbstractRawMessage
implements OutputDevice {
    OutputDevice outputDevice;
    int length;
    private boolean deviceInitialized;
    private OutputProtocol protocol;
    private TransformContext cxt;
    String deviceName;

    public DeviceOutputMessage(OutputProtocol protocol, String deviceName, TransformContext cxt) {
        this.deviceName = deviceName;
        this.cxt = cxt;
        this.protocol = protocol;
    }

    public Object getAsObject() throws TransformException {
        return this.streamContentError();
    }

    private Object streamContentError() {
        throw new UnsupportedOperationException("Attempt to extract content from a streaming device. The content has been stream out and cannot be extracted");
    }

    public int getLength() throws TransformException {
        return this.length;
    }

    public void append(byte[] bytes) throws TransformException {
        try {
            this.checkDevice(null);
            this.outputDevice.write(bytes);
            this.length += bytes.length;
        }
        catch (RemoteException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT217", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
    }

    private void checkDevice(String encoding) throws TransformException, RemoteException {
        if (!this.deviceInitialized) {
            if (encoding == null) {
                encoding = (String)this.cxt.getProperty("encoding");
            }
            DeviceInfo deviceInfo = AbstractMessageFlow.createDeviceInfo(this.deviceName, encoding, this.cxt);
            this.outputDevice = this.protocol.createDevice(deviceInfo, this.cxt);
            this.deviceInitialized = true;
        }
        if (this.outputDevice == null) {
            throw TransformException.createFormatted("SRT428");
        }
    }

    public void append(String bytes) throws TransformException {
        try {
            this.checkDevice(null);
            this.outputDevice.write(bytes);
            this.length += bytes.length();
        }
        catch (RemoteException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT217", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
    }

    public void append(RawMessage message) throws TransformException {
        try {
            this.checkDevice(message.getEncoding());
            this.outputDevice.write(message);
            this.length += message.getLength();
        }
        catch (RemoteException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT217", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
    }

    public void dispose() throws TransformException {
        try {
            if (this.deviceInitialized && this.outputDevice != null) {
                this.outputDevice.close();
                this.outputDevice = null;
            }
        }
        catch (RemoteException e) {
            TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT217", e.getMessage());
            tre.setDetail(e);
            throw tre;
        }
    }
}

