/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.io;

import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.io.ByteArrayOutputContextDevice;
import com.tplus.transform.runtime.io.ByteArrayOutputDevice;
import com.tplus.transform.runtime.io.ByteArrayOutputDeviceLocal;
import com.tplus.transform.runtime.io.OutputContextRemote;
import com.tplus.transform.runtime.io.OutputMessageDevice;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class OutputContextHelper
implements Serializable {
    List outputDevices = new ArrayList();
    int currentID = 1;

    ByteArrayOutputDeviceLocal locateDeviceById(int id) {
        return (ByteArrayOutputDeviceLocal)this.outputDevices.get(id);
    }

    ByteArrayOutputDeviceLocal locateDeviceByName(String name) {
        for (ByteArrayOutputDeviceLocal outputDevice : this.outputDevices) {
            DeviceInfo info = outputDevice.getDeviceInfo();
            if (!info.getDeviceFactoryName().equals(name)) continue;
            return outputDevice;
        }
        return null;
    }

    public ByteArrayOutputDevice createOutputDevice(DeviceInfo deviceInfo, OutputContextRemote owner) {
        int id = this.outputDevices.size();
        OutputMessageDevice localOutputDevice = new OutputMessageDevice(deviceInfo);
        this.outputDevices.add(localOutputDevice);
        ByteArrayOutputContextDevice remoteOutputDevice = new ByteArrayOutputContextDevice(id, owner);
        return remoteOutputDevice;
    }

    public void writeTo(int id, Object data) throws TransformException {
        this.locateDeviceById(id).write(data);
    }

    public void close(int id) throws TransformException {
        this.locateDeviceById(id).close();
    }

    public DeviceInfo getDeviceInfo(int id) {
        return this.locateDeviceById(id).getDeviceInfo();
    }

    public byte[] getAsBytes(int id) {
        ByteArrayOutputDeviceLocal outputDevice = this.locateDeviceById(id);
        if (outputDevice != null) {
            return outputDevice.getAsBytes();
        }
        return new byte[0];
    }

    public String getAsString(int id) {
        ByteArrayOutputDeviceLocal outputDevice = this.locateDeviceById(id);
        if (outputDevice != null) {
            return outputDevice.getAsString();
        }
        return "";
    }

    public String getAsString(int id, String encoding) throws UnsupportedEncodingException {
        ByteArrayOutputDeviceLocal outputDevice = this.locateDeviceById(id);
        if (outputDevice != null) {
            return outputDevice.getAsString(encoding);
        }
        return "";
    }

    public ByteArrayOutputDevice getOutputDevice(String name) {
        return this.locateDeviceByName(name);
    }

    public List getOutputDevices() {
        return this.outputDevices;
    }

    public int getOutputCount() {
        return this.outputDevices.size();
    }

    public List getOutputNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (ByteArrayOutputDeviceLocal outputDevice : this.outputDevices) {
            DeviceInfo info = outputDevice.getDeviceInfo();
            names.add(info.getDeviceFactoryName());
        }
        return names;
    }

    public void clear() {
        this.outputDevices.clear();
    }
}

