/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.io;

import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.MemoryRawOutputMessage;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.io.ByteArrayOutputDeviceLocal;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class OutputMessageDevice
implements ByteArrayOutputDeviceLocal,
Serializable {
    DeviceInfo deviceInfo;
    MemoryRawOutputMessage outputMessage;
    private static final DeviceInfo DEFAULT_DEVICE_INFO = new DeviceInfo("", "", "", null);
    static final long serialVersionUID = 1L;

    public OutputMessageDevice(DeviceInfo deviceInfo) {
        if (deviceInfo == null) {
            deviceInfo = DEFAULT_DEVICE_INFO;
        }
        this.deviceInfo = deviceInfo;
    }

    public OutputMessageDevice() {
        this(DEFAULT_DEVICE_INFO);
    }

    public void write(Object data) throws TransformException {
        this.createMessage();
        this.outputMessage.write(data);
    }

    private void createMessage() {
        if (this.outputMessage == null) {
            this.outputMessage = new MemoryRawOutputMessage(this.deviceInfo.getEncoding());
        }
    }

    public void close() throws TransformException {
    }

    public void clear() {
        if (this.outputMessage != null) {
            this.outputMessage.clear();
        }
    }

    public byte[] getAsBytes() {
        this.createMessage();
        return this.outputMessage.getAsBytes0();
    }

    public String getAsString() {
        this.createMessage();
        return this.outputMessage.getAsString0();
    }

    public String getAsString(String encoding) throws UnsupportedEncodingException {
        this.createMessage();
        try {
            return this.outputMessage.getAsString(encoding);
        }
        catch (TransformException e) {
            throw new UnsupportedEncodingException(encoding);
        }
    }

    public Object getOutput() {
        this.createMessage();
        return this.outputMessage.getAsObject();
    }

    public MemoryRawOutputMessage getMessage() {
        return this.outputMessage;
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public boolean isBinaryData() {
        this.createMessage();
        return this.outputMessage.isBinaryData();
    }
}

