/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.io;

import com.tplus.transform.runtime.DeviceInfo;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.io.AbstractOutputDevice;
import com.tplus.transform.runtime.io.OutputWriterStream;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamDevice
extends AbstractOutputDevice {
    OutputStream os;
    OutputWriterStream outputWriterStream;

    public OutputStreamDevice(OutputStream os, DeviceInfo deviceInfo) {
        super(deviceInfo);
        this.encoding = deviceInfo.getEncoding();
        this.outputWriterStream = new OutputWriterStream(os, this.encoding);
        this.os = os;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    private void throwIOError(IOException e) throws TransformException {
        TransformException te = TransformException.createFormatted("SRT426");
        te.setDetail(e);
        throw te;
    }

    public void append(byte[] data, int off, int len) throws TransformException {
        try {
            this.outputWriterStream.write(data, off, len);
        }
        catch (IOException e) {
            this.throwIOError(e);
        }
    }

    public void append(String data) throws TransformException {
        try {
            this.outputWriterStream.write(data);
        }
        catch (IOException e) {
            this.throwIOError(e);
        }
    }

    public void close() throws TransformException {
        try {
            this.outputWriterStream.close();
        }
        catch (IOException e) {
            TransformException te = TransformException.createFormatted("SRT427");
            te.setDetail(e);
            throw te;
        }
    }

    public void flush() throws IOException {
        this.outputWriterStream.flush();
    }
}

