/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.io;

import com.tplus.transform.runtime.TransformRuntimeException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class OutputWriterStream
extends Writer {
    private OutputStream os;
    private String encoding;
    transient Writer writer;
    boolean writerUsed;

    public OutputWriterStream(OutputStream os, String encoding) {
        this.os = os;
        this.encoding = encoding;
    }

    public void write(int c) throws IOException {
        this.getWriter().write(c);
    }

    private Writer getWriter() {
        if (this.writer == null) {
            try {
                this.writer = this.encoding != null ? new OutputStreamWriter(this.os, this.encoding) : new OutputStreamWriter(this.os);
            }
            catch (UnsupportedEncodingException e) {
                TransformRuntimeException tre = TransformRuntimeException.createFormatted("SRT456");
                tre.setDetail(e);
                throw tre;
            }
        }
        this.writerUsed = true;
        return this.writer;
    }

    public void write(char c) throws IOException {
        this.getWriter().write(c);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.getWriter().write(cbuf, off, len);
    }

    public void write(char[] cbuf) throws IOException {
        this.getWriter().write(cbuf);
    }

    public void write(String s, int off, int len) throws IOException {
        this.getWriter().write(s, off, len);
    }

    public void write(String s) throws IOException {
        this.getWriter().write(s, 0, s.length());
    }

    public void write(byte b) throws IOException {
        this.flushWriter();
        this.os.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.flushWriter();
        this.os.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.flushWriter();
        this.os.write(b, off, len);
    }

    public void flush() throws IOException {
        this.flushWriter();
        this.os.flush();
    }

    public void close() throws IOException {
        this.flushWriter();
        this.os.close();
    }

    private void flushWriter() throws IOException {
        if (this.writerUsed) {
            this.writer.flush();
            this.writerUsed = false;
        }
    }

    private void writeObject(ObjectOutputStream ois) throws IOException {
        this.flushWriter();
        ois.defaultWriteObject();
    }
}

