/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.jms;

import com.tplus.transform.runtime.AbstractRawMessage;
import com.tplus.transform.runtime.ByteArrayInputSource;
import com.tplus.transform.runtime.MessageTransformer;
import com.tplus.transform.runtime.PropertyMap;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StringInputSource;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class JMSMessageTransformer
implements MessageTransformer {
    protected static Log log = LogFactory.getLog(JMSMessageTransformer.class);
    public static final String JMS_CORRELATION_ID = "CorrelationID";
    public static final String JMS_DELIVERY_MODE = "DeliveryMode";
    public static final String JMS_DESTINATION = "Destination";
    public static final String JMS_EXPIRATION = "Expiration";
    public static final String JMS_MESSAGE_ID = "MessageID";
    public static final String JMS_PRIORITY = "Priority";
    public static final String JMS_REDELIVERED = "Redelivered";
    public static final String JMS_REPLY_TO = "ReplyTo";
    public static final String JMS_TIMESTAMP = "Timestamp";
    public static final String JMS_TYPE = "Type";
    public static final String JMS_HEADER_PREFIX = "jmsHeader";
    private static final String JMS_PREFIX = "jms";

    public RawMessage createRawMessage(Object messageObj) throws JMSException {
        AbstractRawMessage rawMessage;
        Message message = (Message)messageObj;
        String inputSourceName = "Message" + System.currentTimeMillis();
        if (message instanceof TextMessage) {
            TextMessage text = (TextMessage)message;
            String messageText = text.getText();
            rawMessage = new StringInputSource(messageText, inputSourceName);
        } else if (message instanceof BytesMessage) {
            BytesMessage bytesMes = (BytesMessage)message;
            byte[] bytes = JMSMessageTransformer.readBytes(bytesMes);
            rawMessage = new ByteArrayInputSource(bytes, inputSourceName);
        } else {
            throw new JMSException("Received unrecognized message of type " + message.getClass().getName());
        }
        JMSMessageTransformer.readProperties(message, rawMessage);
        return rawMessage;
    }

    public static Message createJMSMessage(Session session, Object value) throws JMSException, TransformException {
        TextMessage message;
        Object messageValue = null;
        if (value instanceof byte[]) {
            messageValue = new String((byte[])value);
        } else if (value instanceof RawMessage) {
            RawMessage rawMessage = (RawMessage)value;
            String contentType = rawMessage.getStringProperty("contentType", "text");
            messageValue = contentType.startsWith("text") ? rawMessage.getAsString() : (Object)rawMessage.getAsBytes();
        } else if (value instanceof String) {
            messageValue = value;
        }
        if (messageValue instanceof String) {
            message = session.createTextMessage();
            message.setText((String)messageValue);
            if (value instanceof RawMessage) {
                JMSMessageTransformer.writeProperties((Message)message, (RawMessage)value);
                JMSMessageTransformer.writeProperties((Message)message, session, (RawMessage)value);
            }
            return message;
        }
        if (messageValue instanceof byte[]) {
            message = session.createBytesMessage();
            message.writeBytes((byte[])messageValue);
            if (value instanceof RawMessage) {
                JMSMessageTransformer.writeProperties((Message)message, (RawMessage)value);
                JMSMessageTransformer.writeProperties((Message)message, session, (RawMessage)value);
            }
            return message;
        }
        throw new JMSException("Unrecognized type " + value.getClass().getName());
    }

    private static void writeProperties(Message message, Session session, RawMessage rawMessage) {
        PropertyMap headerProperties = rawMessage.getProperties(JMS_HEADER_PREFIX);
        Object replyToQueueObject = headerProperties.getProperty(JMS_REPLY_TO);
        if (replyToQueueObject != null) {
            try {
                if (replyToQueueObject instanceof Destination) {
                    message.setJMSReplyTo((Destination)replyToQueueObject);
                } else {
                    Queue replyToQueue = session.createQueue((String)replyToQueueObject);
                    message.setJMSReplyTo((Destination)replyToQueue);
                }
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
    }

    public static void writeProperties(Message message, RawMessage rawMessage) {
        int priority;
        if (rawMessage.getPropertyCount() == 0) {
            return;
        }
        PropertyMap headerProperties = rawMessage.getProperties(JMS_HEADER_PREFIX);
        String value = headerProperties.getStringProperty(JMS_CORRELATION_ID, null);
        if (value != null) {
            try {
                message.setJMSCorrelationID(value);
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        if ((value = headerProperties.getStringProperty(JMS_MESSAGE_ID, null)) != null) {
            try {
                message.setJMSMessageID(value);
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        if ((priority = headerProperties.getIntProperty(JMS_PRIORITY, -1)) != -1) {
            try {
                message.setJMSPriority(priority);
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        PropertyMap jmsProperties = rawMessage.getProperties(JMS_PREFIX);
        for (String name : jmsProperties.getPropertyNames()) {
            Object propValue = jmsProperties.getProperty(name, null);
            try {
                message.setObjectProperty(name, propValue);
            }
            catch (JMSException e) {}
        }
    }

    public static void readProperties(Message message, RawMessage rawMessage) {
        PropertyMap headerProperties = rawMessage.getProperties(JMS_HEADER_PREFIX);
        try {
            String value = message.getJMSCorrelationID();
            if (value != null) {
                headerProperties.setProperty(JMS_CORRELATION_ID, value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            int value = message.getJMSDeliveryMode();
            headerProperties.setProperty(JMS_DELIVERY_MODE, new Integer(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            Destination value = message.getJMSDestination();
            if (value != null) {
                headerProperties.setProperty(JMS_DESTINATION, value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            long value = message.getJMSExpiration();
            headerProperties.setProperty(JMS_EXPIRATION, new Long(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            String value = message.getJMSMessageID();
            if (value != null) {
                headerProperties.setProperty(JMS_MESSAGE_ID, value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            int value = message.getJMSPriority();
            headerProperties.setProperty(JMS_PRIORITY, new Integer(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            boolean value = message.getJMSRedelivered();
            headerProperties.setProperty(JMS_REDELIVERED, value ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            Queue queue;
            Destination value = message.getJMSReplyTo();
            if (value instanceof Queue) {
                queue = (Queue)value;
                headerProperties.setProperty(JMS_REPLY_TO, queue.getQueueName());
            }
            if (value instanceof Topic) {
                queue = (Topic)value;
                headerProperties.setProperty(JMS_REPLY_TO, queue.getTopicName());
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            long value = message.getJMSTimestamp();
            headerProperties.setProperty(JMS_TIMESTAMP, new Long(value));
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            String value = message.getJMSType();
            if (value != null) {
                headerProperties.setProperty(JMS_TYPE, value);
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            Enumeration propertyNames = message.getPropertyNames();
            PropertyMap jmsProperties = rawMessage.getProperties(JMS_PREFIX);
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                Object value = message.getObjectProperty(name);
                if (value == null) continue;
                jmsProperties.setProperty(name, value);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private static byte[] readBytes(BytesMessage bytesMes) throws JMSException {
        long bodyLength = bytesMes.getBodyLength();
        byte[] bytes = new byte[(int)bodyLength];
        int read = bytesMes.readBytes(bytes);
        if ((long)read != bodyLength) {
            throw new JMSException("Inconsistent body length");
        }
        return bytes;
    }
}

