/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.json;

import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.FieldMetaInfo;
import com.tplus.transform.runtime.NormalizedObject;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.json.JSONListener;
import com.tplus.transform.runtime.json.JSONParsingException;
import com.tplus.transform.runtime.json.JSONTokenizer;
import java.util.Stack;
import org.xml.sax.Locator;

public class JSONDataObjectBuilder
implements JSONListener {
    Object root;
    Object currentObject;
    Stack stack = new Stack();
    private ExceptionHandler exceptionHandler;
    private Locator locator;
    boolean isCollection = false;
    long jsonTypeStack = 0L;
    private static final String SECTION_STRING = "Section";
    private static final String FIELD_STRING = "Field";
    private static final String OBJECT_STRING = "Object";
    private static final String EXPECTED_OBJECT_START = "Expected Object start '{' but found Array start '['";
    private static final String EXPECTED_ARRAY_START = "Expected Array start '[' but found Object start '{'";

    public JSONDataObjectBuilder(DataObject root) {
        this.root = root;
    }

    public JSONDataObjectBuilder(DataObjectSection root) {
        this.root = root;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    void onDocumentStart() {
        this.currentObject = this.root;
    }

    public void onElementValue(String name, Object valueStr) throws JSONParsingException {
        if (this.currentObject instanceof DataObject) {
            DataObject dataObject = (DataObject)this.currentObject;
            FieldMetaInfo fieldMetaInfo = this.getFieldMetaInfoOrNull(dataObject, name);
            if (fieldMetaInfo != null && valueStr != null) {
                if (fieldMetaInfo.isSection()) {
                    if (!valueStr.equals(JSONTokenizer.NULL)) {
                        this.onError(new JSONParsingException("Expected a " + (fieldMetaInfo.isRepeating() ? "'['" : "'{'") + ", but found a '\"'."));
                    }
                    return;
                }
                try {
                    Object value = null;
                    if (dataObject.getField(fieldMetaInfo.getIndex()) != null) {
                        this.onError(this.createJSONDuplicateException(FIELD_STRING, name));
                        return;
                    }
                    if (!valueStr.equals(JSONTokenizer.NULL)) {
                        value = fieldMetaInfo.getDesignerType().parse(valueStr.toString());
                    }
                    dataObject.setField(fieldMetaInfo.getIndex(), value);
                }
                catch (TransformException e) {
                    e.setField(dataObject, fieldMetaInfo.getIndex(), valueStr);
                    this.onError(e);
                }
            }
        } else if (this.currentObject instanceof DataObjectSection) {
            DataObjectSection dataObjectSection = (DataObjectSection)this.currentObject;
            if (valueStr.equals(JSONTokenizer.NULL)) {
                return;
            }
            DataObject element = dataObjectSection.createElement();
            dataObjectSection.addElement(element);
            this.currentObject = element;
            this.stack.push(element);
            this.onElementValue(name, valueStr);
            this.stack.pop();
            this.currentObject = dataObjectSection;
        } else {
            int lineNumber = ((JSONTokenizer)this.locator).getLastChar() != '\n' ? this.locator.getLineNumber() : this.locator.getLineNumber() - 1;
            JSONParsingException jsonParsingException = new JSONParsingException("Error parsing JSON : Unrecognized content at line " + lineNumber);
            this.updateLocation(jsonParsingException, lineNumber + "");
            throw jsonParsingException;
        }
    }

    public void onJSONObjectStart(String name) throws JSONParsingException {
        if (this.currentObject == null) {
            if (this.root instanceof DataObjectSection) {
                this.onError(new JSONParsingException(EXPECTED_ARRAY_START));
            }
            this.currentObject = this.root;
        } else if (this.currentObject instanceof DataObject) {
            DataObject dataObject = (DataObject)this.currentObject;
            FieldMetaInfo fieldMetaInfo = this.getFieldMetaInfoOrNull(dataObject, name);
            if (fieldMetaInfo != null) {
                Object objOrSection = dataObject.getField(fieldMetaInfo.getIndex());
                if (objOrSection instanceof DataObject) {
                    DataObjectSection objOrSection1 = ((DataObject)objOrSection).getParentSection();
                    if (objOrSection1 != null) {
                        int size = objOrSection1.size();
                        if (size > 0 && !this.isCollection) {
                            this.onError(this.createJSONDuplicateException(SECTION_STRING, name));
                        }
                        DataObject newElement = objOrSection1.createElement();
                        objOrSection1.addElement(newElement);
                        this.currentObject = newElement;
                    } else {
                        this.currentObject = objOrSection;
                    }
                } else if (objOrSection instanceof DataObjectSection) {
                    DataObjectSection dataObjectSection = (DataObjectSection)objOrSection;
                    int size = dataObjectSection.size();
                    if (size == 0 && dataObjectSection.getMaxOccurs() != 1 && dataObjectSection.getMaxOccurs() != 0 && !this.isCollection) {
                        this.onError(new JSONParsingException(EXPECTED_ARRAY_START));
                    }
                    if (size > 0 && !this.isCollection) {
                        this.onError(this.createJSONDuplicateException(OBJECT_STRING, name));
                    }
                    DataObject element = dataObjectSection.createElement();
                    dataObjectSection.addElement(element);
                    this.currentObject = element;
                }
            }
        } else if (this.currentObject instanceof DataObjectSection) {
            DataObjectSection dataObjectSection = (DataObjectSection)this.currentObject;
            int size = dataObjectSection.size();
            if (size > 0 && !this.isCollection) {
                this.onError(this.createJSONDuplicateException(SECTION_STRING, name));
            }
            DataObject element = dataObjectSection.createElement();
            dataObjectSection.addElement(element);
            this.currentObject = element;
        }
        this.isCollection = false;
        this.pushJSONTypeStack(this.isCollection);
        this.stack.push(this.currentObject);
    }

    private FieldMetaInfo getFieldMetaInfoOrNull(DataObject dataObject, String name) throws JSONParsingException {
        FieldMetaInfo fieldMetaInfo = name == null ? dataObject.getMetaInfo().getFieldMetaInfo(0) : dataObject.getMetaInfo().getFieldMetaInfoOrNull(name);
        if (fieldMetaInfo == null) {
            JSONParsingException e = new JSONParsingException("Missing field " + name + " in " + dataObject.getQualifiedName());
            e.setErrorObject(dataObject, null);
            this.onError(e);
        }
        return fieldMetaInfo;
    }

    void onError(JSONParsingException e) throws JSONParsingException {
        try {
            this.updateLocation(e, this.locator.getLineNumber() + "");
            this.exceptionHandler.onException(e);
        }
        catch (TransformException e1) {
            throw (JSONParsingException)e1;
        }
    }

    private void updateLocation(JSONParsingException e, String value) {
        if (this.locator != null) {
            e.setContextProperty("line", value);
            e.setContextProperty("column", this.locator.getColumnNumber() + "");
        }
    }

    private void pushJSONTypeStack(boolean flag) {
        long val2 = this.jsonTypeStack << 1;
        if (flag) {
            val2 |= 1L;
        }
        this.jsonTypeStack = val2;
    }

    private boolean popJSONTypeStack() {
        long val1 = this.jsonTypeStack >>> 1;
        long val2 = val1 << 1;
        boolean retVal = (this.jsonTypeStack ^ val2) == 1L;
        this.jsonTypeStack = val1;
        return retVal;
    }

    private boolean peekJSONTypeStack() {
        long val1 = this.jsonTypeStack >>> 1;
        long val2 = val1 << 1;
        return (this.jsonTypeStack ^ val2) == 1L;
    }

    private void onError(TransformException e) throws JSONParsingException {
        this.onError(new JSONParsingException(e));
    }

    public void onJSONObjectEnd(String name) {
        this.popJSONTypeStack();
        this.isCollection = this.peekJSONTypeStack();
        this.stack.pop();
        this.peekStack();
    }

    private void peekStack() {
        this.currentObject = this.stack.size() == 0 ? this.root : this.stack.peek();
    }

    public void onJSONArrayStart(String name) throws JSONParsingException {
        if (this.currentObject == null) {
            if (this.root instanceof DataObject) {
                this.onError(new JSONParsingException(EXPECTED_OBJECT_START));
            }
            this.currentObject = this.root;
        } else if (this.currentObject instanceof DataObject) {
            if (this.isCollection) {
                DataObjectSection dataObjectSection = ((DataObject)this.currentObject).getParentSection();
                if (dataObjectSection == null) {
                    throw new JSONParsingException("Required Object but found Array.");
                }
                this.currentObject = dataObjectSection;
                this.updateCurrentObjectForArray(dataObjectSection, name);
            } else {
                DataObject dataObject = (DataObject)this.currentObject;
                DataObjectSection dataObjectSection = name == null ? dataObject.getSection(0) : dataObject.getSection(name);
                int size = dataObjectSection.size();
                if (size > 0) {
                    this.onError(this.createJSONDuplicateException(SECTION_STRING, name));
                }
                this.currentObject = dataObjectSection;
            }
        } else if (this.currentObject instanceof DataObjectSection) {
            this.updateCurrentObjectForArray((DataObjectSection)this.currentObject, name);
        }
        this.isCollection = true;
        this.pushJSONTypeStack(this.isCollection);
        this.stack.push(this.currentObject);
    }

    public void updateCurrentObjectForArray(DataObjectSection dataObjectSection, String name) throws JSONParsingException {
        DataObject element = dataObjectSection.createElement();
        dataObjectSection.addElement(element);
        this.stack.pop();
        this.stack.push(element);
        FieldMetaInfo fieldMetaInfo = this.getFieldMetaInfoOrNull(element, name);
        if (fieldMetaInfo != null) {
            Object objOrSection = element.getField(fieldMetaInfo.getIndex());
            if (objOrSection instanceof DataObject) {
                DataObjectSection objOrSection1 = ((DataObject)objOrSection).getParentSection();
                this.currentObject = objOrSection1;
            } else if (objOrSection instanceof DataObjectSection) {
                this.currentObject = objOrSection;
            } else {
                JSONParsingException e = new JSONParsingException("Unexpected array start in " + element.getQualifiedName());
                e.setErrorObject(element, null);
                this.onError(e);
            }
        }
    }

    public void onJSONArrayEnd(String name) {
        this.popJSONTypeStack();
        this.isCollection = this.peekJSONTypeStack();
        this.stack.pop();
        this.peekStack();
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    private JSONParsingException createJSONDuplicateException(String type, String name) {
        return new JSONParsingException("SyntaxError: Duplicate " + type + " " + name);
    }

    public void validate() throws JSONParsingException {
        if (this.currentObject instanceof NormalizedObject) {
            return;
        }
        if (this.currentObject instanceof DataObject) {
            DataObject obj = (DataObject)this.currentObject;
            for (int i = 0; i < obj.getMetaInfo().getFieldCount(); ++i) {
                if (obj.getField(i) instanceof DataObjectSection) {
                    DataObjectSection dataObjectSection = (DataObjectSection)obj.getField(i);
                    this.validateDataObjectSection(dataObjectSection);
                    continue;
                }
                FieldMetaInfo fieldMetaInfo = obj.getMetaInfo().getFieldMetaInfoOrNull(obj.getFieldName(i));
                this.validateField(fieldMetaInfo, obj, i);
            }
        }
    }

    void validateDataObjectSection(DataObjectSection dataObjectSection) throws JSONParsingException {
        int size = dataObjectSection.size();
        if (size < dataObjectSection.getMinOccurs()) {
            if (dataObjectSection.getMinOccurs() == 1 && size == 0) {
                this.onError(new JSONParsingException("Mandatory section '" + dataObjectSection.getQualifiedName() + "' cannot be null"));
            } else {
                this.onError(new JSONParsingException("The number of elements in section '" + dataObjectSection.getQualifiedName() + "' should not be less than '" + dataObjectSection.getMinOccurs() + "'"));
            }
        } else if (dataObjectSection.getMaxOccurs() > 0 && size > dataObjectSection.getMaxOccurs()) {
            this.onError(new JSONParsingException("The number of elements in section '" + dataObjectSection.getQualifiedName() + "' should not be greater than '" + dataObjectSection.getMaxOccurs() + "'"));
        }
    }

    void validateField(FieldMetaInfo fieldMetaInfo, DataObject obj, int index) throws JSONParsingException {
        if (fieldMetaInfo != null && !fieldMetaInfo.isOptional() && obj.getField(index) == null) {
            this.onError(new JSONParsingException("Mandatory Field '" + fieldMetaInfo.getQualifiedName() + "' cannot be null"));
        }
    }
}

