/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.json;

import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectMetaInfo;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.DesignerType;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.ExceptionObject;
import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.json.JSONWriterException;
import com.tplus.transform.util.StringUtils;
import java.math.BigDecimal;
import java.util.Map;

public class JSONSerializer {
    public static final String IGNORE_SYNTHESIZED_FIELDS_PROPERTY = "ignoreAdditionalFields";
    public static final char LF = '\n';
    StringBuilder sb = new StringBuilder(100);
    private ExceptionHandler exceptionHandler;
    int indentFactor = 4;

    public String serialize(DataObject data) throws JSONWriterException {
        this.sb.setLength(0);
        this.valueToString(data, 0);
        return this.sb.toString();
    }

    public String serialize(DataObjectSection data) throws JSONWriterException {
        this.sb.setLength(0);
        this.valueToString(data, 0);
        return this.sb.toString();
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    void valueToString(DataObject value, int indent) throws JSONWriterException {
        this.valueToString(value, null, indent);
    }

    void valueToString(DataObjectSection value, int indent) throws JSONWriterException {
        this.valueToString(value, null, indent);
    }

    void valueToString(Object value, DesignerType type, int indent) throws JSONWriterException {
        if (value == null) {
            this.sb.append("null");
            return;
        }
        if (value instanceof String) {
            this.sb.append(JSONSerializer.quote((String)value));
            return;
        }
        if (value instanceof Number) {
            this.sb.append(JSONSerializer.numberToString((Number)value));
            return;
        }
        if (value instanceof Boolean) {
            this.sb.append(value.toString());
            return;
        }
        if (value instanceof DataObject) {
            DataObject dataObject = (DataObject)value;
            if (dataObject instanceof TransformException) {
                DataObjectSection exceptions = ((TransformException)dataObject).getExceptions();
                for (int i = 0; i < exceptions.getElementCount(); ++i) {
                    ExceptionObject exceptionDataObject = (ExceptionObject)exceptions.getElement(i);
                    this.toString(exceptionDataObject, indent);
                    this.sb.append("\n");
                }
            } else {
                this.toString(dataObject, indent);
            }
            return;
        }
        if (value instanceof DataObjectSection) {
            DataObjectSection dataObjectSection = (DataObjectSection)value;
            this.toString(dataObjectSection, indent);
            return;
        }
        if (type != null) {
            this.sb.append(JSONSerializer.quote(type.format(value)));
            return;
        }
        this.sb.append(JSONSerializer.quote(value.toString()));
    }

    public static String numberToString(Number n) throws JSONWriterException {
        if (n == null) {
            throw new JSONWriterException("Null pointer");
        }
        if (n instanceof BigDecimal) {
            return Wrapper.toString((BigDecimal)n);
        }
        if (n instanceof Double) {
            return Parsing.toString((Double)n);
        }
        if (n instanceof Float) {
            return Parsing.toString(((Float)n).floatValue());
        }
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    private void toString(DataObject obj, int indent) throws JSONWriterException {
        this.sb.append("{");
        DataObjectMetaInfo dataObjectMetaInfo = obj.getMetaInfo();
        int newindent = indent + this.indentFactor;
        boolean first = true;
        int fieldCount = dataObjectMetaInfo.getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            DataObjectSection dataObjectSection;
            if (obj.isNull(i) || dataObjectMetaInfo.isSynthesized(i) && this.isIgnoreSynthesizedFields(obj)) continue;
            Object value = obj.getField(i);
            DesignerType type = dataObjectMetaInfo.getFieldDesignerType(i);
            if (value instanceof DataObjectSection && (dataObjectSection = (DataObjectSection)value).size() == 0) continue;
            String fieldName = dataObjectMetaInfo.getFieldName(i);
            first = this.formatJsonField(newindent, first, fieldName);
            this.valueToString(value, type, newindent);
        }
        this.writeExceptionContext(obj, newindent, first);
        if (obj.getFieldCount() > 0) {
            this.sb.append("\n");
        }
        JSONSerializer.indent(this.sb, indent);
        this.sb.append('}');
    }

    private void writeExceptionContext(DataObject obj, int indent, boolean isFirstField) throws JSONWriterException {
        if (obj instanceof ExceptionObject) {
            Map exceptionContext = ((ExceptionObject)obj).getExceptionContext();
            for (Map.Entry entry : exceptionContext.entrySet()) {
                String fieldName = (String)entry.getKey();
                String fieldValue = (String)entry.getValue();
                isFirstField = this.formatJsonField(indent, isFirstField, fieldName);
                if (this.isTransformExpNumericTypeField(fieldName)) {
                    try {
                        Integer intValue = Integer.valueOf(fieldValue);
                        this.valueToString(intValue, DesignerType.DESIGNER_INT_TYPE, indent);
                    }
                    catch (Exception e) {
                        this.valueToString(fieldValue, DesignerType.DESIGNER_STRING_TYPE, indent);
                    }
                    continue;
                }
                this.valueToString(fieldValue, DesignerType.DESIGNER_STRING_TYPE, indent);
            }
        }
    }

    private boolean formatJsonField(int indent, boolean isFirstField, String fieldName) {
        if (!isFirstField) {
            this.sb.append(",");
        } else {
            isFirstField = false;
        }
        this.sb.append("\n");
        JSONSerializer.indent(this.sb, indent);
        this.sb.append(JSONSerializer.quote(fieldName));
        this.sb.append(':');
        return isFirstField;
    }

    private boolean isTransformExpNumericTypeField(String fieldName) {
        return StringUtils.equals(fieldName, "Error-Record-Index") || StringUtils.equals(fieldName, "column") || StringUtils.equals(fieldName, "Index") || StringUtils.equals(fieldName, "line");
    }

    private static void indent(StringBuilder sb, int newindent) {
        for (int j = 0; j < newindent; ++j) {
            sb.append(' ');
        }
    }

    public void toString(DataObjectSection arraySection) throws JSONWriterException {
        this.toString(arraySection, 0);
    }

    void toString(DataObjectSection arraySection, int indent) throws JSONWriterException {
        int len = arraySection.size();
        if (arraySection.getMaxOccurs() == 1) {
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.sb.append(",\n");
                }
                this.valueToString(arraySection.getElement(i), indent);
            }
            return;
        }
        if (len == 0) {
            this.sb.append("[]");
        }
        if (len > 0) {
            this.sb.append('[');
            this.sb.append('\n');
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.sb.append(",\n");
                }
                DataObject dataObject = arraySection.getElement(i);
                DataObjectMetaInfo dataObjectMetaInfo = dataObject.getMetaInfo();
                int fieldCount = dataObjectMetaInfo.getFieldCount();
                int newindent = indent + this.indentFactor;
                JSONSerializer.indent(this.sb, newindent);
                if (fieldCount == 1) {
                    if (dataObjectMetaInfo.isSection(0)) {
                        Object object = dataObject.getField(0);
                        if (object instanceof DataObjectSection) {
                            DataObjectSection dataObjectSection = (DataObjectSection)object;
                            if (dataObjectSection.getMaxOccurs() == 1) {
                                this.sb.append("{");
                                this.sb.append("\n");
                                JSONSerializer.indent(this.sb, newindent);
                                String fieldName = dataObjectSection.getName();
                                this.sb.append(JSONSerializer.quote(fieldName));
                                this.sb.append(':');
                                this.toString(dataObjectSection, newindent);
                                this.sb.append("\n");
                                JSONSerializer.indent(this.sb, indent);
                                this.sb.append('}');
                                continue;
                            }
                            this.toString(dataObjectSection, newindent);
                            continue;
                        }
                        this.valueToString(object, dataObject.getFieldDesignerType(0), newindent);
                        continue;
                    }
                    if (dataObjectMetaInfo.getFieldName(0).equals("Value")) {
                        this.valueToString(dataObject.getField(0), dataObject.getFieldDesignerType(0), newindent);
                        continue;
                    }
                    this.valueToString(dataObject, newindent);
                    continue;
                }
                this.valueToString(dataObject, newindent);
            }
            this.sb.append('\n');
            JSONSerializer.indent(this.sb, indent);
            this.sb.append(']');
        }
    }

    public static String getSpecifiedEncoding(TransformContext tcxt, String defaultVaue) {
        String encoding;
        String string = encoding = tcxt != null ? (String)tcxt.getProperty("encoding") : null;
        if (encoding == null) {
            encoding = defaultVaue;
        }
        return encoding;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public boolean isIgnoreSynthesizedFields(DataObject dataObject) {
        Boolean value = (Boolean)dataObject.getProperty(IGNORE_SYNTHESIZED_FIELDS_PROPERTY, Boolean.FALSE);
        return value;
    }
}

