/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.json;

import com.tplus.transform.runtime.Parsing;
import com.tplus.transform.runtime.json.JSONListener;
import com.tplus.transform.runtime.json.JSONParsingException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import org.xml.sax.Locator;

public class JSONTokenizer
implements Locator {
    private int index;
    private LineNumberReader reader;
    private char lastChar;
    private boolean useLastChar;
    JSONListener jsonListener;
    public static final Object NULL = new Null();

    public JSONTokenizer(Reader reader) {
        this.reader = new LineNumberReader(reader);
        this.useLastChar = false;
        this.index = 0;
    }

    public JSONTokenizer(String s) {
        this(new StringReader(s));
    }

    public void back() throws JSONParsingException {
        if (this.useLastChar || this.index <= 0) {
            throw new JSONParsingException("Stepping back two steps is not supported");
        }
        --this.index;
        this.useLastChar = true;
    }

    public static int dehexchar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }

    public boolean more() throws JSONParsingException {
        char nextChar = this.next();
        if (nextChar == '\u0000') {
            return false;
        }
        this.back();
        return true;
    }

    public char next() throws JSONParsingException {
        int c;
        if (this.useLastChar) {
            this.useLastChar = false;
            if (this.lastChar != '\u0000') {
                ++this.index;
            }
            return this.lastChar;
        }
        try {
            c = this.reader.read();
        }
        catch (IOException exc) {
            throw new JSONParsingException(exc);
        }
        if (c <= 0) {
            this.lastChar = '\u0000';
            return '\u0000';
        }
        ++this.index;
        this.lastChar = (char)c;
        return this.lastChar;
    }

    public char next(char c) throws JSONParsingException {
        char n = this.next();
        if (n != c) {
            throw this.syntaxError("Expected '" + c + "' and instead saw '" + n + "'");
        }
        return n;
    }

    public String next(int n) throws JSONParsingException {
        if (n == 0) {
            return "";
        }
        char[] buffer = new char[n];
        int pos = 0;
        if (this.useLastChar) {
            this.useLastChar = false;
            buffer[0] = this.lastChar;
            pos = 1;
        }
        try {
            int len;
            while (pos < n && (len = this.reader.read(buffer, pos, n - pos)) != -1) {
                pos += len;
            }
        }
        catch (IOException exc) {
            throw new JSONParsingException(exc);
        }
        this.index += pos;
        if (pos < n) {
            throw this.syntaxError("Substring bounds error");
        }
        this.lastChar = buffer[n - 1];
        return new String(buffer);
    }

    public char nextClean() throws JSONParsingException {
        char c;
        while ((c = this.next()) != '\u0000' && c <= ' ') {
        }
        return c;
    }

    public String nextString(char quote) throws JSONParsingException {
        StringBuffer sb = new StringBuffer();
        block13: while (true) {
            char c = this.next();
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c = this.next();
                    switch (c) {
                        case 'b': {
                            sb.append('\b');
                            continue block13;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            sb.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            sb.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case 'x': {
                            sb.append((char)Integer.parseInt(this.next(2), 16));
                            continue block13;
                        }
                    }
                    sb.append(c);
                    continue block13;
                }
            }
            if (c == quote) {
                return sb.toString();
            }
            sb.append(c);
        }
    }

    public String nextTo(char d) throws JSONParsingException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            char c;
            if ((c = this.next()) == d || c == '\u0000' || c == '\n' || c == '\r') {
                if (c != '\u0000') {
                    this.back();
                }
                return sb.toString().trim();
            }
            sb.append(c);
        }
    }

    public String nextTo(String delimiters) throws JSONParsingException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            char c;
            if (delimiters.indexOf(c = this.next()) >= 0 || c == '\u0000' || c == '\n' || c == '\r') {
                if (c != '\u0000') {
                    this.back();
                }
                return sb.toString().trim();
            }
            sb.append(c);
        }
    }

    public void nextValue(String name) throws JSONParsingException {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                String value = this.nextString(c);
                this.jsonListener.onElementValue(name, value);
                return;
            }
            case '{': {
                this.back();
                this.jsonListener.onJSONObjectStart(name);
                this.parseJSONObject();
                this.jsonListener.onJSONObjectEnd(name);
                return;
            }
            case '(': 
            case '[': {
                this.back();
                this.jsonListener.onJSONArrayStart(name);
                this.parseJSONArray();
                this.jsonListener.onJSONArrayEnd(name);
                return;
            }
        }
        Object value = this.parseLiteral(c);
        this.jsonListener.onElementValue(name, value);
    }

    public Object nextLiteral() throws JSONParsingException {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return this.nextString(c);
            }
            case '(': 
            case '[': 
            case '{': {
                throw new JSONParsingException("Unexpected character " + c);
            }
        }
        return this.parseLiteral(c);
    }

    private Object parseLiteral(char c) throws JSONParsingException {
        StringBuffer sb = new StringBuffer();
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            sb.append(c);
            c = this.next();
        }
        this.back();
        String s = sb.toString().trim();
        if (s.equals("")) {
            throw this.syntaxError("Missing value");
        }
        return JSONTokenizer.stringToValue(s);
    }

    public char skipTo(char to) throws JSONParsingException {
        char c;
        try {
            int startIndex = this.index;
            this.reader.mark(Integer.MAX_VALUE);
            do {
                if ((c = this.next()) != '\u0000') continue;
                this.reader.reset();
                this.index = startIndex;
                return c;
            } while (c != to);
        }
        catch (IOException exc) {
            throw new JSONParsingException(exc);
        }
        this.back();
        return c;
    }

    public JSONParsingException syntaxError(String message) {
        JSONParsingException parsingException = new JSONParsingException(message + " at character " + this.index);
        int lineNumber = this.getLineNumber();
        parsingException.setContextProperty("Index", Parsing.toString(this.index));
        parsingException.setContextProperty("line", lineNumber + "");
        return parsingException;
    }

    public int getLineNumber() {
        return this.reader.getLineNumber() + 1;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    public char getLastChar() {
        return this.lastChar;
    }

    public int getColumnNumber() {
        return 0;
    }

    public String toString() {
        return " at character " + this.index;
    }

    public void parseJSONObject() throws JSONParsingException {
        char c1;
        JSONTokenizer x = this;
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    this.jsonListener.validate();
                    return;
                }
            }
            x.back();
            String key = x.nextLiteral().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            x.nextValue(key);
            c1 = x.nextClean();
            switch (c1) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        this.jsonListener.validate();
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    this.jsonListener.validate();
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}' found '" + c1 + "'");
    }

    private void putOnce(String key, Object value) {
    }

    public void parseJSONArray() throws JSONParsingException {
        char q;
        JSONTokenizer x = this;
        char c = x.nextClean();
        if (c == '[') {
            q = ']';
        } else if (c == '(') {
            q = ')';
        } else {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() == ']') {
            return;
        }
        x.back();
        block4: while (true) {
            if (x.nextClean() == ',') {
                x.back();
                this.addToArray(null);
            } else {
                x.back();
                x.nextValue(null);
            }
            c = x.nextClean();
            switch (c) {
                case ',': 
                case ';': {
                    if (x.nextClean() == ']') {
                        return;
                    }
                    x.back();
                    continue block4;
                }
                case ')': 
                case ']': {
                    if (q != c) {
                        throw x.syntaxError("Expected a '" + new Character(q) + "'");
                    }
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or ']'");
    }

    private void addToArray(Object o) {
    }

    public static Object stringToValue(String s) {
        if (s.equals("")) {
            return s;
        }
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (s.equalsIgnoreCase("null")) {
            return NULL;
        }
        char b = s.charAt(0);
        if ((b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') && b == '0') {
            if (s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                try {
                    return new Integer(Integer.parseInt(s.substring(2), 16));
                }
                catch (Exception e) {
                }
            } else {
                try {
                    return new Integer(Integer.parseInt(s, 8));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return s;
    }

    public JSONListener getJsonListener() {
        return this.jsonListener;
    }

    public void setJsonListener(JSONListener jsonListener) {
        this.jsonListener = jsonListener;
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

