/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.json;

import com.tplus.transform.runtime.AbstractServiceElement;
import com.tplus.transform.runtime.DataObject;
import com.tplus.transform.runtime.DataObjectSection;
import com.tplus.transform.runtime.ExceptionHandler;
import com.tplus.transform.runtime.InputSource;
import com.tplus.transform.runtime.RawMessage;
import com.tplus.transform.runtime.StringInputSource;
import com.tplus.transform.runtime.TransformContext;
import com.tplus.transform.runtime.TransformException;
import com.tplus.transform.runtime.json.JSONDataObjectBuilder;
import com.tplus.transform.runtime.json.JSONParsingException;
import com.tplus.transform.runtime.json.JSONSerializer;
import com.tplus.transform.runtime.json.JSONTokenizer;
import com.tplus.transform.runtime.json.JSONWriterException;

public class MessageJSONSupport {
    public MessageJSONSupport(AbstractServiceElement elm) {
    }

    public void parse(DataObject nObj, ExceptionHandler exceptionHandler, InputSource source, TransformContext cxt) throws TransformException {
        RawMessage rawMessage = (RawMessage)source;
        String jsonText = rawMessage.getAsString();
        MessageJSONSupport.parse(nObj, exceptionHandler, jsonText);
    }

    public void parse(DataObjectSection nObj, ExceptionHandler exceptionHandler, InputSource source, TransformContext cxt) throws TransformException {
        RawMessage rawMessage = (RawMessage)source;
        String jsonText = rawMessage.getAsString();
        MessageJSONSupport.parse(nObj, exceptionHandler, jsonText);
    }

    public RawMessage write(DataObject obj, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        String jsonText = MessageJSONSupport.serialize(obj, exceptionHandler);
        StringInputSource stringInputSource = new StringInputSource(jsonText);
        this.applyEncoding(cxt, stringInputSource);
        return stringInputSource;
    }

    public void write(DataObject obj, RawMessage rawMessage, ExceptionHandler exceptionHandler, TransformContext cxt) throws TransformException {
        String jsonText = MessageJSONSupport.serialize(obj, exceptionHandler);
        rawMessage.append(jsonText);
        this.applyEncoding(cxt, rawMessage);
    }

    public static String serialize(DataObject obj) throws JSONWriterException {
        return MessageJSONSupport.serialize(obj, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER);
    }

    public static String serialize(DataObjectSection obj) throws JSONWriterException {
        return MessageJSONSupport.serialize(obj, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER);
    }

    public static String serialize(DataObject obj, ExceptionHandler exceptionHandler) throws JSONWriterException {
        JSONSerializer serializer = new JSONSerializer();
        serializer.setExceptionHandler(exceptionHandler);
        String jsonText = serializer.serialize(obj);
        return jsonText;
    }

    public static String serialize(DataObjectSection obj, ExceptionHandler exceptionHandler) throws JSONWriterException {
        JSONSerializer serializer = new JSONSerializer();
        serializer.setExceptionHandler(exceptionHandler);
        String jsonText = serializer.serialize(obj);
        return jsonText;
    }

    public static void parse(DataObject obj, String jsonText) throws JSONParsingException {
        MessageJSONSupport.parse(obj, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, jsonText);
    }

    public static void parse(DataObjectSection obj, String jsonText) throws JSONParsingException {
        MessageJSONSupport.parse(obj, ExceptionHandler.DRACONIAN_EXCEPTION_HANDLER, jsonText);
    }

    public static void parse(DataObject obj, ExceptionHandler exceptionHandler, String jsonText) throws JSONParsingException {
        JSONTokenizer jsonTokenizer = new JSONTokenizer(jsonText);
        JSONDataObjectBuilder jsonListener = new JSONDataObjectBuilder(obj);
        jsonListener.setExceptionHandler(exceptionHandler);
        jsonTokenizer.setJsonListener(jsonListener);
        jsonListener.setDocumentLocator(jsonTokenizer);
        jsonTokenizer.nextValue(null);
        MessageJSONSupport.checkEndOfMessage(jsonListener, jsonTokenizer);
    }

    public static void parse(DataObjectSection obj, ExceptionHandler exceptionHandler, String jsonText) throws JSONParsingException {
        JSONTokenizer jsonTokenizer = new JSONTokenizer(jsonText);
        JSONDataObjectBuilder jsonListener = new JSONDataObjectBuilder(obj);
        jsonListener.setExceptionHandler(exceptionHandler);
        jsonTokenizer.setJsonListener(jsonListener);
        jsonListener.setDocumentLocator(jsonTokenizer);
        jsonTokenizer.nextValue(null);
        MessageJSONSupport.checkEndOfMessage(jsonListener, jsonTokenizer);
    }

    private static void checkEndOfMessage(JSONDataObjectBuilder jsonListener, JSONTokenizer jsonTokenizer) throws JSONParsingException {
        if (jsonTokenizer.nextClean() != '\u0000') {
            jsonListener.onError(new JSONParsingException("Unexpected characters at the end of message."));
        }
    }

    private void applyEncoding(TransformContext cxt, RawMessage rawMessage) {
        String specifiedEncoding = JSONSerializer.getSpecifiedEncoding(cxt, null);
        if (specifiedEncoding != null) {
            rawMessage.setEncoding(specifiedEncoding);
        }
    }
}

