/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.keygen;

import com.tplus.transform.runtime.keygen.KeyGenerationException;
import com.tplus.transform.runtime.keygen.KeyGenerator;
import com.tplus.transform.runtime.keygen.KeyGeneratorInfo;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MasterTableKeyGenerator
implements KeyGenerator {
    static final String UNIQUE_KEY_GEN_MASTER = "UniqueKeyGenMasterTable";
    static final String NAME = "Name";
    static final String KEY_VALUE = "KeyValue";
    static final int START_KEY_VALUE = 1;
    static final String insertNewKeyRow = "insert into UniqueKeyGenMasterTable(Name, KeyValue) values(?, ?)";
    ConnectionPool connectionPool;

    public MasterTableKeyGenerator(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public String getNextString(KeyGeneratorInfo info) throws KeyGenerationException {
        return String.valueOf(this.getNextLong(info));
    }

    public int getNextInt(KeyGeneratorInfo info) throws KeyGenerationException {
        return (int)this.getNextLong(info);
    }

    public boolean hasFreeKeys(KeyGeneratorInfo keyGeneratorInfo) {
        return false;
    }

    public long getNextLong(KeyGeneratorInfo info) throws KeyGenerationException {
        String rowIdentifier = info.tableName + "." + info.columnName;
        String selectCurrentKeyValue = "select KeyValue from UniqueKeyGenMasterTable where Name = '" + rowIdentifier + "'";
        String updateCurrentKeyValue = "update UniqueKeyGenMasterTable set KeyValue = ? where Name = '" + rowIdentifier + "'";
        try {
            long keyValue = this.getNextKeyValue(selectCurrentKeyValue, updateCurrentKeyValue, rowIdentifier);
            return keyValue;
        }
        catch (SQLException e) {
            throw KeyGenerationException.createKeyGenerationExceptionFormatted("SRT631", new Object[]{e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextKeyValue(String selectCurrentKeyValue, String updateCurrentKeyValue, String rowIdentifier) throws SQLException {
        Connection con = this.connectionPool.getConnection();
        try {
            long currentKeyValue = this.getCurrentKeyValue(con, selectCurrentKeyValue);
            this.modifyCurrentKeyValue(currentKeyValue + 1L, con, updateCurrentKeyValue);
            this.connectionPool.commit(con);
            long l = currentKeyValue;
            return l;
        }
        catch (SQLException e) {
            this.connectionPool.rollback(con);
            this.addNewKeyRow(con, rowIdentifier);
            this.connectionPool.commit(con);
            long l = 1L;
            return l;
        }
        finally {
            this.connectionPool.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNewKeyRow(Connection con, String rowIdentifier) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(insertNewKeyRow);
        try {
            stmt.setString(1, rowIdentifier);
            stmt.setLong(2, 2L);
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }

    public long getCurrentKeyValue(Connection con, String selectCurrentKeyValue) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(selectCurrentKeyValue);
        try {
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
            throw new SQLException("SQL error while executing statement [" + selectCurrentKeyValue + "]");
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyCurrentKeyValue(long newKeyValue, Connection con, String updateCurrentKeyValue) throws SQLException {
        PreparedStatement stmt = con.prepareStatement(updateCurrentKeyValue);
        try {
            stmt.setLong(1, newKeyValue);
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }
}

