/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.keygen;

import com.tplus.transform.runtime.keygen.KeyGenerationException;
import com.tplus.transform.runtime.keygen.KeyGenerator;
import com.tplus.transform.runtime.keygen.KeyGeneratorInfo;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MonotonicKeyGenerator
implements KeyGenerator {
    static final int START_KEY_VALUE = 1;
    ConnectionPool connectionPool;

    public MonotonicKeyGenerator(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public String getNextString(KeyGeneratorInfo info) throws KeyGenerationException {
        return String.valueOf(this.getNextLong(info));
    }

    public int getNextInt(KeyGeneratorInfo info) throws KeyGenerationException {
        return (int)this.getNextLong(info);
    }

    public boolean hasFreeKeys(KeyGeneratorInfo keyGeneratorInfo) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextLong(KeyGeneratorInfo info) throws KeyGenerationException {
        long l;
        Connection con = this.connectionPool.getConnection();
        try {
            long currentMaxKey = this.getCurrentMaxKey(con, info.tableName, info.columnName);
            l = currentMaxKey + 1L;
        }
        catch (SQLException e) {
            long l2;
            try {
                l2 = 1L;
            }
            catch (Throwable throwable) {
                try {
                    this.connectionPool.releaseConnection(con);
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw KeyGenerationException.createKeyGenerationExceptionFormatted("SRT631", new Object[]{e2});
                }
            }
            this.connectionPool.releaseConnection(con);
            return l2;
        }
        this.connectionPool.releaseConnection(con);
        return l;
    }

    private long getCurrentMaxKey(Connection con, String tableName, String columnName) throws SQLException {
        String selectCurrentMaxKey = "select max(" + columnName + ") from " + tableName;
        PreparedStatement stmt = con.prepareStatement(selectCurrentMaxKey);
        try {
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
            throw new SQLException("SQL error while executing statement [" + selectCurrentMaxKey + "]");
        }
        finally {
            stmt.close();
        }
    }
}

