/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.keygen;

import com.tplus.transform.runtime.keygen.KeyGenerationException;
import com.tplus.transform.runtime.keygen.KeyGenerator;
import com.tplus.transform.runtime.keygen.KeyGeneratorInfo;
import com.tplus.transform.runtime.log.LogFactory;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.sql.connection.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TableKeyGenerator
implements KeyGenerator {
    static final int BLOCK_SIZE = 20;
    String tableName = "UniqueKeyGenTable";
    long currentKey = 0L;
    long blockedTill = 0L;
    ConnectionPool connectionPool;
    boolean tableAddAttempted = false;
    private final String updateCurrentKey;
    private final String selectCurrentKey;
    protected Log log;

    public TableKeyGenerator(ConnectionPool connectionPool, String tableName) {
        this.tableName = tableName;
        this.connectionPool = connectionPool;
        this.updateCurrentKey = "update " + tableName + " set CurrentKey = ? where CurrentKey = ?";
        this.selectCurrentKey = "select CurrentKey from " + tableName;
        this.log = LogFactory.getRuntimeLog("KeyGenerator");
    }

    public String getNextString(KeyGeneratorInfo info) throws KeyGenerationException {
        return String.valueOf(this.getNextLong(info));
    }

    public long getNextLong(KeyGeneratorInfo info) throws KeyGenerationException {
        try {
            if (!this.isKeysAvailable()) {
                this.block(20);
            }
            ++this.currentKey;
            return this.currentKey;
        }
        catch (SQLException e) {
            KeyGenerationException generationException = KeyGenerationException.createKeyGenerationExceptionFormatted("SRT631", new Object[]{e});
            generationException.setDetail(e);
            throw generationException;
        }
    }

    private boolean isKeysAvailable() {
        return this.currentKey + 1L <= this.blockedTill;
    }

    public int getNextInt(KeyGeneratorInfo info) throws KeyGenerationException {
        return (int)this.getNextLong(info);
    }

    public boolean hasFreeKeys(KeyGeneratorInfo keyGeneratorInfo) {
        return this.isKeysAvailable();
    }

    private void block(int keys) throws SQLException {
        for (int i = 0; i < 10; ++i) {
            if (this.block0(keys)) {
                return;
            }
            try {
                Thread.sleep(i * i * 100);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new SQLException("Error allocating Unique Key");
    }

    private boolean block0(int keys) throws SQLException {
        Connection con = this.connectionPool.getConnection();
        try {
            this.blockedTill = this.currentKey = this.getCurrentKey(con);
            long tryBlockTill = this.currentKey + (long)keys;
            if (!this.modifyCurrentKey(tryBlockTill, this.currentKey, con)) {
                boolean bl = false;
                return bl;
            }
            this.blockedTill = tryBlockTill;
            this.connectionPool.commit(con);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.connectionPool.rollback(con);
            throw e;
        }
        finally {
            this.connectionPool.releaseConnection(con);
        }
    }

    public long getCurrentKey(Connection con) throws SQLException {
        PreparedStatement stmt = this.prepareStatement(con, this.selectCurrentKey);
        try {
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
            throw new SQLException("SQL error while executing statement [" + this.selectCurrentKey + "]");
        }
        finally {
            stmt.close();
        }
    }

    private PreparedStatement prepareStatement(Connection con, String stmt) throws SQLException {
        this.log.trace("Executing " + stmt);
        return con.prepareStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyCurrentKey(long newKeyValue, long oldKeyValue, Connection con) throws SQLException {
        PreparedStatement stmt = this.prepareStatement(con, this.updateCurrentKey);
        try {
            stmt.setLong(1, newKeyValue);
            stmt.setLong(2, oldKeyValue);
            int ret = stmt.executeUpdate();
            boolean bl = ret == 1;
            return bl;
        }
        finally {
            stmt.close();
        }
    }
}

