/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.runtime.log;

import com.tplus.transform.util.log.Log;

public abstract class LogFactory {
    public static final String ROOT_CATEGORY = "volante.runtime";
    public static final String MESSAGE_FLOW_CATEGORY = "volante.runtime.messageflow";
    public static final String MESSAGE_CATEGORY = "volante.runtime.message";
    public static final String VALIDATION_CATEGORY = "volante.runtime.validation";
    public static final String PROCESSING_CATEGORY = "volante.runtime.processing";
    public static final String MAPPING_CATEGORY = "volante.runtime.mapping";
    public static final Log log = LogFactory.getRuntimeLog();

    public static Log getMessageFlowLog(String messageFlowName) {
        return LogFactory.createLog("volante.runtime.messageflow." + messageFlowName);
    }

    public static Log getMessageFlowLog(Object serviceElement, String messageFlowName) {
        return LogFactory.createLog(serviceElement, "volante.runtime.messageflow." + messageFlowName);
    }

    public static Log getMessageLog(Object serviceElement, String messageName) {
        return LogFactory.createLog(serviceElement, "volante.runtime.message." + messageName);
    }

    public static Log getMessageLog(String messageName) {
        return LogFactory.createLog("volante.runtime.message." + messageName);
    }

    public static Log getMappingLog(Object serviceElement, String mappingName) {
        return LogFactory.createLog(serviceElement, "volante.runtime.mapping." + mappingName);
    }

    public static Log getMappingLog(String mappingName) {
        return LogFactory.createLog("volante.runtime.mapping." + mappingName);
    }

    public static Log getValidationLog(Object serviceElement, String messageName) {
        return LogFactory.createLog(serviceElement, "volante.runtime.validation." + messageName);
    }

    public static Log getProcessingLog(String messageName) {
        return LogFactory.createLog("volante.runtime.processing." + messageName);
    }

    public static Log getRuntimeLog() {
        if (log == null) {
            return LogFactory.createLog(ROOT_CATEGORY);
        }
        return log;
    }

    public static Log getRuntimeLog(String name) {
        return LogFactory.createLog("volante.runtime." + name);
    }

    public static Log getRuntimeLog(Object serviceElement, String name) {
        return LogFactory.createLog(serviceElement, "volante.runtime." + name);
    }

    public static Log getParserLog(String entityName) {
        return LogFactory.getMessageLog(entityName);
    }

    public static Log getSerializerLog(String entityName) {
        return LogFactory.getMessageLog(entityName);
    }

    static Log createLog(String name) {
        return com.tplus.transform.util.log.LogFactory.getLog(name);
    }

    static Log createLog(Object serviceElement, String name) {
        if (serviceElement != null) {
            return com.tplus.transform.util.log.LogFactory.getLog(serviceElement.getClass(), name);
        }
        return com.tplus.transform.util.log.LogFactory.getLog(name);
    }
}

